/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Vector3D;
import ru.woesss.j2me.micro3d.MathUtil;

public class Light {
    public static final int MAX_AMBIENT_LIGHT_INTENSITY = 4096;
    public static final int MAX_DIRECTIONAL_LIGHT_INTENSITY = 16384;
    public static final int MIN_AMBIENT_LIGHT_INTENSITY = 0;
    public static final int MIN_DIRECTIONAL_LIGHT_INTENSITY = 0;
    int ambientIntensity;
    Vector3D direction;
    int directionalIntensity;

    public Light(int n2, Vector3D vector3D, int n3) {
        this.setDirectionVector(vector3D);
        this.setAmbientIntensity(n2);
        this.setDirectionalIntensity(n3);
    }

    Light(Light light) {
        this.ambientIntensity = light.ambientIntensity;
        this.directionalIntensity = light.directionalIntensity;
        if (light.direction != null) {
            this.direction = new Vector3D(light.direction);
        }
    }

    public int getAmbientIntensity() {
        return this.ambientIntensity;
    }

    public int getDirectionalIntensity() {
        return this.directionalIntensity;
    }

    public Vector3D getDirectionVector() {
        return this.direction;
    }

    public void setAmbientIntensity(int n2) {
        this.ambientIntensity = MathUtil.clamp(n2, 0, 4096);
    }

    public void setDirectionalIntensity(int n2) {
        this.directionalIntensity = MathUtil.clamp(n2, 0, 16384);
    }

    public void setDirectionVector(Vector3D vector3D) {
        if (vector3D != null && vector3D.isZero()) {
            throw new IllegalArgumentException();
        }
        this.direction = vector3D;
    }
}

