/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.CoreFoundation$CFBooleanRef;
import com.sun.jna.platform.mac.CoreFoundation$CFDataRef;
import com.sun.jna.platform.mac.CoreFoundation$CFMutableDictionaryRef;
import com.sun.jna.platform.mac.CoreFoundation$CFNumberRef;
import com.sun.jna.platform.mac.CoreFoundation$CFStringRef;
import com.sun.jna.platform.mac.CoreFoundation$CFTypeRef;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKit$IOIterator;
import com.sun.jna.platform.mac.IOKit$IOObject;
import com.sun.jna.platform.mac.IOReturnException;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;

public class IOKit$IORegistryEntry
extends IOKit$IOObject {
    public IOKit$IORegistryEntry() {
    }

    public IOKit$IORegistryEntry(Pointer pointer) {
        super(pointer);
    }

    public long getRegistryEntryID() {
        LongByReference longByReference = new LongByReference();
        int n2 = IOKit.INSTANCE.IORegistryEntryGetRegistryEntryID(this, longByReference);
        if (n2 != 0) {
            throw new IOReturnException(n2);
        }
        return longByReference.getValue();
    }

    public String getName() {
        Memory memory = new Memory(128L);
        int n2 = IOKit.INSTANCE.IORegistryEntryGetName(this, memory);
        if (n2 != 0) {
            throw new IOReturnException(n2);
        }
        return memory.getString(0L);
    }

    public IOKit$IOIterator getChildIterator(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        int n2 = IOKit.INSTANCE.IORegistryEntryGetChildIterator(this, string, pointerByReference);
        if (n2 != 0) {
            throw new IOReturnException(n2);
        }
        return new IOKit$IOIterator(pointerByReference.getValue());
    }

    public IOKit$IORegistryEntry getChildEntry(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        int n2 = IOKit.INSTANCE.IORegistryEntryGetChildEntry(this, string, pointerByReference);
        if (n2 == -536870208) {
            return null;
        }
        if (n2 != 0) {
            throw new IOReturnException(n2);
        }
        return new IOKit$IORegistryEntry(pointerByReference.getValue());
    }

    public IOKit$IORegistryEntry getParentEntry(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        int n2 = IOKit.INSTANCE.IORegistryEntryGetParentEntry(this, string, pointerByReference);
        if (n2 == -536870208) {
            return null;
        }
        if (n2 != 0) {
            throw new IOReturnException(n2);
        }
        return new IOKit$IORegistryEntry(pointerByReference.getValue());
    }

    public CoreFoundation$CFTypeRef createCFProperty(CoreFoundation$CFStringRef coreFoundation$CFStringRef) {
        return IOKit.INSTANCE.IORegistryEntryCreateCFProperty(this, coreFoundation$CFStringRef, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
    }

    public CoreFoundation$CFMutableDictionaryRef createCFProperties() {
        PointerByReference pointerByReference = new PointerByReference();
        int n2 = IOKit.INSTANCE.IORegistryEntryCreateCFProperties(this, pointerByReference, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
        if (n2 != 0) {
            throw new IOReturnException(n2);
        }
        return new CoreFoundation$CFMutableDictionaryRef(pointerByReference.getValue());
    }

    CoreFoundation$CFTypeRef searchCFProperty(String string, CoreFoundation$CFStringRef coreFoundation$CFStringRef, int n2) {
        return IOKit.INSTANCE.IORegistryEntrySearchCFProperty(this, string, coreFoundation$CFStringRef, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), n2);
    }

    public String getStringProperty(String string) {
        String string2 = null;
        CoreFoundation$CFStringRef coreFoundation$CFStringRef = CoreFoundation$CFStringRef.createCFString(string);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty(coreFoundation$CFStringRef);
        coreFoundation$CFStringRef.release();
        if (coreFoundation$CFTypeRef != null) {
            CoreFoundation$CFStringRef coreFoundation$CFStringRef2 = new CoreFoundation$CFStringRef(coreFoundation$CFTypeRef.getPointer());
            string2 = coreFoundation$CFStringRef2.stringValue();
            coreFoundation$CFTypeRef.release();
        }
        return string2;
    }

    public Long getLongProperty(String string) {
        Long l2 = null;
        CoreFoundation$CFStringRef coreFoundation$CFStringRef = CoreFoundation$CFStringRef.createCFString(string);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty(coreFoundation$CFStringRef);
        coreFoundation$CFStringRef.release();
        if (coreFoundation$CFTypeRef != null) {
            CoreFoundation$CFNumberRef coreFoundation$CFNumberRef = new CoreFoundation$CFNumberRef(coreFoundation$CFTypeRef.getPointer());
            l2 = coreFoundation$CFNumberRef.longValue();
            coreFoundation$CFTypeRef.release();
        }
        return l2;
    }

    public Integer getIntegerProperty(String string) {
        Integer n2 = null;
        CoreFoundation$CFStringRef coreFoundation$CFStringRef = CoreFoundation$CFStringRef.createCFString(string);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty(coreFoundation$CFStringRef);
        coreFoundation$CFStringRef.release();
        if (coreFoundation$CFTypeRef != null) {
            CoreFoundation$CFNumberRef coreFoundation$CFNumberRef = new CoreFoundation$CFNumberRef(coreFoundation$CFTypeRef.getPointer());
            n2 = coreFoundation$CFNumberRef.intValue();
            coreFoundation$CFTypeRef.release();
        }
        return n2;
    }

    public Double getDoubleProperty(String string) {
        Double d2 = null;
        CoreFoundation$CFStringRef coreFoundation$CFStringRef = CoreFoundation$CFStringRef.createCFString(string);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty(coreFoundation$CFStringRef);
        coreFoundation$CFStringRef.release();
        if (coreFoundation$CFTypeRef != null) {
            CoreFoundation$CFNumberRef coreFoundation$CFNumberRef = new CoreFoundation$CFNumberRef(coreFoundation$CFTypeRef.getPointer());
            d2 = coreFoundation$CFNumberRef.doubleValue();
            coreFoundation$CFTypeRef.release();
        }
        return d2;
    }

    public Boolean getBooleanProperty(String string) {
        Boolean bl2 = null;
        CoreFoundation$CFStringRef coreFoundation$CFStringRef = CoreFoundation$CFStringRef.createCFString(string);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty(coreFoundation$CFStringRef);
        coreFoundation$CFStringRef.release();
        if (coreFoundation$CFTypeRef != null) {
            CoreFoundation$CFBooleanRef coreFoundation$CFBooleanRef = new CoreFoundation$CFBooleanRef(coreFoundation$CFTypeRef.getPointer());
            bl2 = coreFoundation$CFBooleanRef.booleanValue();
            coreFoundation$CFTypeRef.release();
        }
        return bl2;
    }

    public byte[] getByteArrayProperty(String string) {
        byte[] byArray = null;
        CoreFoundation$CFStringRef coreFoundation$CFStringRef = CoreFoundation$CFStringRef.createCFString(string);
        CoreFoundation$CFTypeRef coreFoundation$CFTypeRef = this.createCFProperty(coreFoundation$CFStringRef);
        coreFoundation$CFStringRef.release();
        if (coreFoundation$CFTypeRef != null) {
            CoreFoundation$CFDataRef coreFoundation$CFDataRef = new CoreFoundation$CFDataRef(coreFoundation$CFTypeRef.getPointer());
            int n2 = coreFoundation$CFDataRef.getLength();
            Pointer pointer = coreFoundation$CFDataRef.getBytePtr();
            byArray = pointer.getByteArray(0L, n2);
            coreFoundation$CFTypeRef.release();
        }
        return byArray;
    }
}

