/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.io.UnsupportedEncodingException;

public class WTypes$BSTR
extends PointerType {
    public WTypes$BSTR() {
        super(Pointer.NULL);
    }

    public WTypes$BSTR(Pointer pointer) {
        super(pointer);
    }

    public WTypes$BSTR(String string) {
        this.setValue(string);
    }

    public void setValue(String string) {
        if (string == null) {
            string = "";
        }
        try {
            byte[] byArray = string.getBytes("UTF-16LE");
            Memory memory = new Memory(4 + byArray.length + 2);
            memory.clear();
            memory.setInt(0L, byArray.length);
            memory.write(4L, byArray, 0, byArray.length);
            this.setPointer(memory.share(4L));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-16LE charset is not supported", unsupportedEncodingException);
        }
    }

    public String getValue() {
        try {
            Pointer pointer = this.getPointer();
            if (pointer == null) {
                return "";
            }
            int n2 = pointer.getInt(-4L);
            return new String(pointer.getByteArray(0L, n2), "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-16LE charset is not supported", unsupportedEncodingException);
        }
    }

    @Override
    public String toString() {
        return this.getValue();
    }
}

