/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import emulator.Emulator;
import emulator.Settings;
import emulator.Utils;
import emulator.b;
import emulator.c;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AppSettings {
    public static String iniSection;
    public static String jarHash;
    private static final Map a;
    public static boolean softbankApi;
    public static boolean blackberryApi;
    public static String customTitle;
    public static boolean uei;
    public static boolean asmSkipDebug;
    public static int speedModifier;
    public static int steps;
    public static boolean xrayView;
    public static boolean xrayBuffer;
    public static String devicePreset;
    public static int screenWidth;
    public static int screenHeight;
    public static int leftSoftKey;
    public static int rightSoftKey;
    public static int fireKey;
    public static int upKey;
    public static int downKey;
    public static int leftKey;
    public static int rightKey;
    public static int fontSmallSize;
    public static int fontMediumSize;
    public static int fontLargeSize;
    public static String locale;
    public static String fileEncoding;
    public static String microeditionPlatform;
    public static int frameRate;
    public static boolean enableKeyRepeat;
    public static boolean hasPointerEvents;
    public static boolean ignoreFullScreen;
    public static boolean asyncFlush;
    public static boolean startAppOnResume;
    public static boolean j2lStyleFpsLimit;
    public static boolean motorolaSoftKeyFix;
    public static boolean keyPressOnRepeat;
    public static boolean synchronizeKeyEvents;
    public static boolean patchYield;
    public static boolean ignoreGc;
    public static boolean ignoreSleep;
    public static boolean applySpeedToSleep;
    public static boolean m3gIgnoreOverwrite;
    public static boolean m3gForcePerspectiveCorrection;
    public static boolean m3gDisableLightClamp;
    public static boolean m3gFlushImmediately;
    public static boolean m3gThread;
    public static int m3gAA;
    public static int m3gTexFilter;
    public static int m3gMipmapping;
    public static final int APP_CONTROLLED = 0;
    public static final int AA_OFF = 1;
    public static final int AA_ON = 2;
    public static final int TEX_FILTER_NEAREST = 1;
    public static final int TEX_FILTER_LINEAR = 2;
    public static final int MIP_OFF = 1;
    public static final int MIP_LINEAR = 2;
    public static final int MIP_TRILINEAR = 3;
    public static final int MIP_ANISO_2 = 4;
    public static final int MIP_ANISO_4 = 5;
    public static final int MIP_ANISO_8 = 6;
    public static final int MIP_ANISO_16 = 7;
    public static boolean mascotNo2DMixing;
    public static boolean mascotIgnoreBackground;
    public static boolean mascotTextureFilter;
    public static boolean mascotBackgroundFilter;
    public static final Map systemProperties;

    public static void init() {
        devicePreset = c.a();
        if (!AppSettings.applyPreset(devicePreset, true)) {
            screenWidth = 240;
            screenHeight = 320;
            leftSoftKey = -6;
            rightSoftKey = -7;
            fireKey = -5;
            upKey = -1;
            downKey = -2;
            leftKey = -3;
            rightKey = -4;
        }
        fontSmallSize = 12;
        fontMediumSize = 14;
        fontLargeSize = 16;
        locale = "en-US";
        fileEncoding = "ISO-8859-1";
        microeditionPlatform = "Nokia6700c-1/13.10";
        frameRate = 30;
        enableKeyRepeat = true;
        hasPointerEvents = true;
        ignoreFullScreen = false;
        asyncFlush = true;
        startAppOnResume = true;
        j2lStyleFpsLimit = false;
        motorolaSoftKeyFix = false;
        keyPressOnRepeat = false;
        synchronizeKeyEvents = false;
        patchYield = false;
        ignoreGc = true;
        ignoreSleep = false;
        applySpeedToSleep = false;
        m3gIgnoreOverwrite = false;
        m3gForcePerspectiveCorrection = false;
        m3gDisableLightClamp = false;
        m3gFlushImmediately = false;
        m3gThread = false;
        m3gAA = 0;
        m3gTexFilter = 0;
        m3gMipmapping = 0;
        mascotNo2DMixing = false;
        mascotIgnoreBackground = false;
        mascotTextureFilter = false;
        mascotBackgroundFilter = false;
    }

    public static void clear() {
        a.clear();
    }

    /*
     * Unable to fully structure code
     */
    public static int load(boolean var0) {
        block93: {
            block92: {
                block94: {
                    var1_1 = AppSettings.a;
                    var2_2 = Emulator.getEmulator();
                    var3_3 = true;
                    var4_4 = Emulator.midletJar;
                    if (var4_4 != null) {
                        var4_4 = new File(var4_4).getName();
                    }
                    if (Emulator.a == 0) break block94;
                    AppSettings.screenWidth = Emulator.a;
                    AppSettings.screenHeight = Emulator.b;
                    break block93;
                }
                try {
                    var5_5 = var2_2.getAppProperty("MIDxlet-ScreenSize");
                    if (var5_5 == null) {
                        var5_5 = var2_2.getAppProperty("SEMC-Screen-Size");
                    }
                    if (var5_5 == null) {
                        var5_5 = var2_2.getAppProperty("Nokia-MIDlet-Original-Display-Size");
                    }
                    if (var5_5 == null) break block92;
                    if ((var5_5 = var5_5.trim()).indexOf(var6_7 = 44) == -1) {
                        var6_7 = 120;
                    }
                    if (var5_5.indexOf(var6_7) == -1) break block92;
                    var7_9 = Integer.parseInt(var5_5.substring(0, var5_5.indexOf(var6_7)).trim());
                    var8_11 = Integer.parseInt(var5_5.substring(var5_5.indexOf(var6_7) + 1).trim());
                    if (var7_9 <= 0 || var8_11 <= 0) break block92;
                    if ("Y".equals(var2_2.getAppProperty("MIDxlet-WideScreen"))) {
                        AppSettings.screenWidth = var8_11;
                        AppSettings.screenHeight = var7_9;
                    } else {
                        AppSettings.screenWidth = var7_9;
                        AppSettings.screenHeight = var8_11;
                    }
                    break block93;
                }
                catch (Exception var5_6) {
                    // empty catch block
                }
            }
            if (var4_4 == null) ** GOTO lbl-1000
            if (var4_4.contains("128x128")) {
                AppSettings.screenWidth = 128;
                AppSettings.screenHeight = 128;
            } else if (var4_4.contains("128x160")) {
                AppSettings.screenWidth = 128;
                AppSettings.screenHeight = 160;
            } else if (var4_4.contains("130x130")) {
                AppSettings.applyPreset("Siemens", false);
                AppSettings.screenWidth = 130;
                AppSettings.screenHeight = 130;
            } else if (var4_4.contains("132x176")) {
                AppSettings.applyPreset("Siemens", false);
                AppSettings.screenWidth = 132;
                AppSettings.screenHeight = 176;
            } else if (var4_4.contains("176x208")) {
                AppSettings.screenWidth = 176;
                AppSettings.screenHeight = 208;
            } else if (var4_4.contains("176x220")) {
                AppSettings.screenWidth = 176;
                AppSettings.screenHeight = 220;
            } else if (var4_4.contains("240x320")) {
                AppSettings.screenWidth = 240;
                AppSettings.screenHeight = 320;
            } else if (var4_4.contains("320x240")) {
                AppSettings.screenWidth = 320;
                AppSettings.screenHeight = 240;
            } else if (var4_4.contains("240x400")) {
                AppSettings.screenWidth = 240;
                AppSettings.screenHeight = 400;
            } else if (var4_4.contains("360x640")) {
                AppSettings.screenWidth = 360;
                AppSettings.screenHeight = 640;
            } else if (var4_4.contains("640x360")) {
                AppSettings.screenWidth = 640;
                AppSettings.screenHeight = 360;
            } else lbl-1000:
            // 2 sources

            {
                var3_3 = false;
            }
        }
        if (Emulator.doja) {
            if (var3_3) {
                AppSettings.applyPreset("Sharp", false);
            } else {
                AppSettings.devicePreset = "120x160 (Sharp/DoCoMo - full screen)";
                AppSettings.applyPreset("120x160 (Sharp/DoCoMo - full screen)", true);
            }
            AppSettings.fileEncoding = "Shift_JIS";
            AppSettings.locale = "ja-JP";
            AppSettings.m3gThread = true;
        } else if (AppSettings.softbankApi) {
            AppSettings.applyPreset("Motorola", false);
            AppSettings.fileEncoding = "Shift_JIS";
            AppSettings.locale = "ja-JP";
            AppSettings.m3gThread = true;
        }
        var5_5 = var2_2.getAppProperty("MIDlet-Name");
        if (var5_5 != null) {
            if (var5_5.contains("Angry Birds")) {
                AppSettings.m3gFlushImmediately = true;
            } else if (var5_5.contains("\u52c7\u95ef\u6076\u9b54\u57ce-Konami\u6b63\u7248")) {
                AppSettings.j2lStyleFpsLimit = true;
            }
        }
        if (AppSettings.uei) {
            var6_8 = "UEI";
        } else if (Settings.globalSettings) {
            var6_8 = "All";
        } else if (Emulator.midletJar == null) {
            var6_8 = "Classpath";
        } else {
            AppSettings.jarHash = AppSettings.c(Emulator.midletJar);
            var6_8 = AppSettings.jarHash + ':' + Emulator.midletJar;
        }
        AppSettings.iniSection = var6_8;
        if (var0) {
            return 0;
        }
        if (!AppSettings.a(false)) {
            return AppSettings.uei != false || Settings.showAppSettingsOnStart == false ? 1 : 0;
        }
        if (var1_1.containsKey("DevicePreset")) {
            AppSettings.devicePreset = (String)var1_1.get("DevicePreset");
        }
        if (Emulator.a == 0) {
            if (var1_1.containsKey("ScreenWidth")) {
                AppSettings.screenWidth = Integer.parseInt((String)var1_1.get("ScreenWidth"));
            }
            if (var1_1.containsKey("ScreenHeight")) {
                AppSettings.screenHeight = Integer.parseInt((String)var1_1.get("ScreenHeight"));
            }
        }
        if (var1_1.containsKey("KeyLeftSoft")) {
            AppSettings.leftSoftKey = Integer.parseInt((String)var1_1.get("KeyLeftSoft"));
        }
        if (var1_1.containsKey("KeyRightSoft")) {
            AppSettings.rightSoftKey = Integer.parseInt((String)var1_1.get("KeyRightSoft"));
        }
        if (var1_1.containsKey("KeyFire")) {
            AppSettings.fireKey = Integer.parseInt((String)var1_1.get("KeyFire"));
        }
        if (var1_1.containsKey("KeyUp")) {
            AppSettings.upKey = Integer.parseInt((String)var1_1.get("KeyUp"));
        }
        if (var1_1.containsKey("KeyDown")) {
            AppSettings.downKey = Integer.parseInt((String)var1_1.get("KeyDown"));
        }
        if (var1_1.containsKey("KeyLeft")) {
            AppSettings.leftKey = Integer.parseInt((String)var1_1.get("KeyLeft"));
        }
        if (var1_1.containsKey("KeyFire")) {
            AppSettings.rightKey = Integer.parseInt((String)var1_1.get("KeyRight"));
        }
        if (var1_1.containsKey("FontSmallSize")) {
            AppSettings.fontSmallSize = Integer.parseInt((String)var1_1.get("FontSmallSize"));
        }
        if (var1_1.containsKey("FontMediumSize")) {
            AppSettings.fontMediumSize = Integer.parseInt((String)var1_1.get("FontMediumSize"));
        }
        if (var1_1.containsKey("FontLargeSize")) {
            AppSettings.fontLargeSize = Integer.parseInt((String)var1_1.get("FontLargeSize"));
        }
        if (var1_1.containsKey("MIDPLocale")) {
            AppSettings.locale = (String)var1_1.get("MIDPLocale");
        }
        if (var1_1.containsKey("FileEncoding")) {
            AppSettings.fileEncoding = (String)var1_1.get("FileEncoding");
        }
        if (var1_1.containsKey("MIDPPlatform")) {
            AppSettings.microeditionPlatform = (String)var1_1.get("MIDPPlatform");
        }
        if (var1_1.containsKey("FrameRate")) {
            AppSettings.frameRate = Integer.parseInt((String)var1_1.get("FrameRate"));
        }
        if (var1_1.containsKey("EnableKeyRepeat")) {
            AppSettings.enableKeyRepeat = Boolean.parseBoolean((String)var1_1.get("EnableKeyRepeat"));
        }
        if (var1_1.containsKey("HasPointerEvents")) {
            AppSettings.hasPointerEvents = Boolean.parseBoolean((String)var1_1.get("HasPointerEvents"));
        }
        if (var1_1.containsKey("IgnoreFullScreenMode")) {
            AppSettings.ignoreFullScreen = Boolean.parseBoolean((String)var1_1.get("IgnoreFullScreenMode"));
        }
        if (var1_1.containsKey("AsyncFlush")) {
            AppSettings.asyncFlush = Boolean.parseBoolean((String)var1_1.get("AsyncFlush"));
        }
        if (var1_1.containsKey("StartAppOnResume")) {
            AppSettings.startAppOnResume = Boolean.parseBoolean((String)var1_1.get("StartAppOnResume"));
        }
        if (var1_1.containsKey("FPSLimitJLStyle")) {
            AppSettings.j2lStyleFpsLimit = Boolean.parseBoolean((String)var1_1.get("FPSLimitJLStyle"));
        }
        if (var1_1.containsKey("MotorolaSoftKeyFix")) {
            AppSettings.motorolaSoftKeyFix = Boolean.parseBoolean((String)var1_1.get("MotorolaSoftKeyFix"));
        }
        if (var1_1.containsKey("KeyPressOnRepeat")) {
            AppSettings.keyPressOnRepeat = Boolean.parseBoolean((String)var1_1.get("KeyPressOnRepeat"));
        }
        if (var1_1.containsKey("SynchronizeKeyEvents")) {
            AppSettings.synchronizeKeyEvents = Boolean.parseBoolean((String)var1_1.get("SynchronizeKeyEvents"));
        }
        if (var1_1.containsKey("PatchYield")) {
            AppSettings.patchYield = Boolean.parseBoolean((String)var1_1.get("PatchYield"));
        }
        if (var1_1.containsKey("IgnoreGC")) {
            AppSettings.ignoreGc = Boolean.parseBoolean((String)var1_1.get("IgnoreGC"));
        }
        if (var1_1.containsKey("IgnoreSleep")) {
            AppSettings.ignoreSleep = Boolean.parseBoolean((String)var1_1.get("IgnoreSleep"));
        }
        if (var1_1.containsKey("ApplySpeedToSleep")) {
            AppSettings.applySpeedToSleep = Boolean.parseBoolean((String)var1_1.get("ApplySpeedToSleep"));
        }
        if (var1_1.containsKey("M3GIgnoreOverwrite")) {
            AppSettings.m3gIgnoreOverwrite = Boolean.parseBoolean((String)var1_1.get("M3GIgnoreOverwrite"));
        }
        if (var1_1.containsKey("M3GForcePerspectiveCorrection")) {
            AppSettings.m3gForcePerspectiveCorrection = Boolean.parseBoolean((String)var1_1.get("M3GForcePerspectiveCorrection"));
        }
        if (var1_1.containsKey("M3GDisableLightClamp")) {
            AppSettings.m3gDisableLightClamp = Boolean.parseBoolean((String)var1_1.get("M3GDisableLightClamp"));
        }
        if (var1_1.containsKey("M3GFlushImmediately")) {
            AppSettings.m3gFlushImmediately = Boolean.parseBoolean((String)var1_1.get("M3GFlushImmediately"));
        }
        if (var1_1.containsKey("M3GThread")) {
            AppSettings.m3gThread = Boolean.parseBoolean((String)var1_1.get("M3GThread"));
        }
        if (var1_1.containsKey("M3GAA")) {
            AppSettings.m3gAA = Integer.parseInt((String)var1_1.get("M3GAA"));
        }
        if (var1_1.containsKey("M3GTexFilter")) {
            AppSettings.m3gTexFilter = Integer.parseInt((String)var1_1.get("M3GTexFilter"));
        }
        if (var1_1.containsKey("M3GMipmapping")) {
            AppSettings.m3gMipmapping = Integer.parseInt((String)var1_1.get("M3GMipmapping"));
        }
        if (var1_1.containsKey("MascotNo2DMixing")) {
            AppSettings.mascotNo2DMixing = Boolean.parseBoolean((String)var1_1.get("MascotNo2DMixing"));
        }
        if (var1_1.containsKey("MascotIgnoreBackground")) {
            AppSettings.mascotIgnoreBackground = Boolean.parseBoolean((String)var1_1.get("MascotIgnoreBackground"));
        }
        if (var1_1.containsKey("MascotTextureFilter")) {
            AppSettings.mascotTextureFilter = Boolean.parseBoolean((String)var1_1.get("MascotTextureFilter"));
        }
        if (var1_1.containsKey("MascotBackgroundFilter")) {
            AppSettings.mascotBackgroundFilter = Boolean.parseBoolean((String)var1_1.get("MascotBackgroundFilter"));
        }
        if (var1_1.containsKey("SystemProperties")) {
            for (String var11_15 : var7_10 = ((String)var1_1.get("SystemProperties")).split("\n")) {
                if ((var11_15 = var11_15.trim()).isEmpty() || (var12_16 = var11_15.indexOf(58)) == -1) continue;
                var13_17 = var11_15.substring(0, var12_16).trim();
                var14_18 = var11_15.substring(var12_16 + 1).trim();
                AppSettings.systemProperties.put(var13_17, var14_18);
            }
        }
        return 1;
    }

    public static void set(String string, String string2) {
        a.put(string, string2);
    }

    public static void set(String string, boolean bl2) {
        a.put(string, Boolean.toString(bl2));
    }

    public static void set(String string, int n2) {
        a.put(string, Integer.toString(n2));
    }

    public static void save() {
        if (iniSection == null) {
            return;
        }
        AppSettings.set("FileEncoding", fileEncoding);
        AppSettings.set("DevicePreset", devicePreset);
        AppSettings.set("MIDPPlatform", microeditionPlatform);
        AppSettings.set("MIDPLocale", locale);
        AppSettings.set("ScreenWidth", screenWidth);
        AppSettings.set("ScreenHeight", screenHeight);
        AppSettings.set("KeyLeftSoft", leftSoftKey);
        AppSettings.set("KeyRightSoft", rightSoftKey);
        AppSettings.set("KeyUp", upKey);
        AppSettings.set("KeyDown", downKey);
        AppSettings.set("KeyLeft", leftKey);
        AppSettings.set("KeyRight", rightKey);
        AppSettings.set("FontLargeSize", fontLargeSize);
        AppSettings.set("FontMediumSize", fontMediumSize);
        AppSettings.set("FontSmallSize", fontSmallSize);
        AppSettings.set("EnableKeyRepeat", enableKeyRepeat);
        AppSettings.set("HasPointerEvents", hasPointerEvents);
        AppSettings.set("IgnoreFullScreenMode", ignoreFullScreen);
        AppSettings.set("FPSLimitJLStyle", j2lStyleFpsLimit);
        AppSettings.set("MotorolaSoftKeyFix", motorolaSoftKeyFix);
        AppSettings.set("KeyPressOnRepeat", keyPressOnRepeat);
        AppSettings.set("SynchronizeKeyEvents", synchronizeKeyEvents);
        AppSettings.set("AsyncFlush", asyncFlush);
        AppSettings.set("StartAppOnResume", startAppOnResume);
        AppSettings.set("M3GIgnoreOverwrite", m3gIgnoreOverwrite);
        AppSettings.set("M3GForcePerspectiveCorrection", m3gForcePerspectiveCorrection);
        AppSettings.set("M3GDisableLightClamp", m3gDisableLightClamp);
        AppSettings.set("M3GFlushImmediately", m3gFlushImmediately);
        AppSettings.set("M3GThread", m3gThread);
        AppSettings.set("M3GAA", m3gAA);
        AppSettings.set("M3GTexFilter", m3gTexFilter);
        AppSettings.set("M3GMipmapping", m3gMipmapping);
        AppSettings.set("MascotNo2DMixing", mascotNo2DMixing);
        AppSettings.set("MascotIgnoreBackground", mascotIgnoreBackground);
        AppSettings.set("MascotTextureFilter", mascotTextureFilter);
        AppSettings.set("MascotBackgroundFilter", mascotBackgroundFilter);
        StringBuilder stringBuilder = new StringBuilder();
        if (!systemProperties.isEmpty()) {
            for (String string : systemProperties.keySet()) {
                stringBuilder.append(string).append(':').append((String)systemProperties.get(string)).append('\n');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            AppSettings.set("SystemProperties", stringBuilder.toString());
        }
        AppSettings.a(true);
    }

    public static boolean applyPreset(String string, boolean bl2) {
        if (string == null) {
            return false;
        }
        b b2 = c.a(string);
        if (b2 == null) {
            return false;
        }
        if (bl2 && b2.a("SCREEN_WIDTH")) {
            screenWidth = Integer.parseInt(b2.a("SCREEN_WIDTH"));
            screenHeight = Integer.parseInt(b2.a("SCREEN_HEIGHT"));
        }
        if (b2.a("PLATFORM")) {
            microeditionPlatform = b2.a("PLATFORM");
        }
        if (b2.a("ENCODING")) {
            fileEncoding = b2.a("ENCODING");
        }
        if (b2.a("FONT_SMALL_SIZE")) {
            fontSmallSize = Integer.parseInt(b2.a("FONT_SMALL_SIZE"));
        }
        if (b2.a("FONT_MEDIUM_SIZE")) {
            fontMediumSize = Integer.parseInt(b2.a("FONT_MEDIUM_SIZE"));
        }
        if (b2.a("FONT_LARGE_SIZE")) {
            fontLargeSize = Integer.parseInt(b2.a("FONT_LARGE_SIZE"));
        }
        if (b2.a("FORCE_FULLSCREEN")) {
            ignoreFullScreen = Boolean.parseBoolean(b2.a("FORCE_FULLSCREEN"));
        }
        leftSoftKey = Integer.parseInt(b2.a("KEY_S1"));
        rightSoftKey = Integer.parseInt(b2.a("KEY_S2"));
        fireKey = Integer.parseInt(b2.a("KEY_FIRE"));
        upKey = Integer.parseInt(b2.a("KEY_UP"));
        downKey = Integer.parseInt(b2.a("KEY_DOWN"));
        leftKey = Integer.parseInt(b2.a("KEY_LEFT"));
        rightKey = Integer.parseInt(b2.a("KEY_RIGHT"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(boolean bl2) {
        String string;
        Object object;
        Object object2;
        Object object3;
        BufferedWriter bufferedWriter;
        boolean bl3;
        boolean bl4;
        String string2;
        Path path;
        block47: {
            path = AppSettings.a();
            string2 = '[' + iniSection + ']';
            bl4 = false;
            bl3 = false;
            if (!bl2 && Files.notExists(path, new LinkOption[0])) {
                return false;
            }
            try {
                bufferedWriter = null;
                object3 = null;
                if (bl2) {
                    object3 = path.getParent().resolve("midlets.ini.tmp");
                    bufferedWriter = Files.newBufferedWriter((Path)object3, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
                }
                try {
                    object2 = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                    object = null;
                    try {
                        String string3 = "[" + jarHash + ":";
                        String string4 = ":" + Emulator.midletJar + "]";
                        while ((string = ((BufferedReader)object2).readLine()) != null) {
                            int n2;
                            bl3 = true;
                            if (!string.isEmpty() && string.charAt(0) == '[' && !bl4) {
                                if (string.equals(string2)) {
                                    bl4 = true;
                                } else if (!uei && Emulator.midletJar != null && (string.startsWith(string3) || string.endsWith(string4))) {
                                    bl4 = true;
                                }
                                if (bl4) {
                                    if (!bl2) continue;
                                    bufferedWriter.write(string);
                                    bufferedWriter.newLine();
                                    ArrayList arrayList = new ArrayList(a.keySet());
                                    Collections.sort(arrayList);
                                    for (String string5 : arrayList) {
                                        bufferedWriter.write(string5);
                                        bufferedWriter.write(61);
                                        bufferedWriter.write(AppSettings.a((String)a.get(string5)));
                                        bufferedWriter.newLine();
                                    }
                                    continue;
                                }
                            }
                            if (bl2 && !bl4) {
                                bufferedWriter.write(string);
                                bufferedWriter.newLine();
                            }
                            if (!bl4) continue;
                            if (string.startsWith("[")) {
                                if (bl2) {
                                    bufferedWriter.newLine();
                                    bufferedWriter.write(string);
                                    bufferedWriter.newLine();
                                    while ((string = ((BufferedReader)object2).readLine()) != null) {
                                        bufferedWriter.write(string);
                                        bufferedWriter.newLine();
                                    }
                                }
                                break;
                            }
                            if (bl2 || (n2 = string.indexOf(61)) == -1) continue;
                            a.put(string.substring(0, n2), AppSettings.b(string.substring(n2 + 1)));
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    ((BufferedReader)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedReader)object2).close();
                            }
                        }
                    }
                    if (bufferedWriter == null) break block47;
                }
                catch (Throwable throwable) {
                    if (bufferedWriter == null) throw throwable;
                    bufferedWriter.close();
                    Files.move((Path)object3, path, StandardCopyOption.REPLACE_EXISTING);
                    throw throwable;
                }
                bufferedWriter.close();
                Files.move((Path)object3, path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl4 || !bl2) return bl4;
        try {
            bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            object3 = null;
            try {
                if (bl3) {
                    bufferedWriter.newLine();
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                object2 = new ArrayList(a.keySet());
                Collections.sort(object2);
                object = object2.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    bufferedWriter.write(string);
                    bufferedWriter.write(61);
                    bufferedWriter.write(AppSettings.a((String)a.get(string)));
                    bufferedWriter.newLine();
                }
                return true;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (bufferedWriter != null) {
                    if (object3 != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        bufferedWriter.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static String a(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block6;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String b(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\\\", "\\");
    }

    private static Path a() {
        return Paths.get(Emulator.getUserPath(), "midlets.ini");
    }

    private static String c(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                int n2;
                byte[] byArray = new byte[8192];
                while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    messageDigest.update(byArray, 0, n2);
                }
            }
            return Utils.a(messageDigest);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        a = new HashMap();
        blackberryApi = false;
        speedModifier = 1;
        steps = -1;
        systemProperties = new HashMap();
    }
}

