/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D;

import emulator.graphics2D.f;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class a {
    private static final PaletteData a = new PaletteData(65280, 0xFF0000, -16777216);
    private static int[] a;
    private static BufferedImage a;
    private static ImageData a;

    public static BufferedImage a(ImageData imageData) {
        Object object;
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            DirectColorModel directColorModel = new DirectColorModel(imageData.depth, paletteData.redMask, paletteData.greenMask, paletteData.blueMask);
            BufferedImage bufferedImage = new BufferedImage(directColorModel, directColorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[3];
            for (int i2 = 0; i2 < imageData.height; ++i2) {
                for (int i3 = 0; i3 < imageData.width; ++i3) {
                    RGB rGB = paletteData.getRGB(imageData.getPixel(i3, i2));
                    nArray[0] = rGB.red;
                    nArray[1] = rGB.green;
                    nArray[2] = rGB.blue;
                    writableRaster.setPixels(i3, i2, 1, 1, nArray);
                }
            }
            return bufferedImage;
        }
        RGB[] rGBArray = paletteData.getRGBs();
        byte[] byArray = new byte[rGBArray.length];
        byte[] byArray2 = new byte[rGBArray.length];
        byte[] byArray3 = new byte[rGBArray.length];
        for (int i4 = 0; i4 < rGBArray.length; ++i4) {
            object = rGBArray[i4];
            byArray[i4] = (byte)object.red;
            byArray2[i4] = (byte)object.green;
            byArray3[i4] = (byte)object.blue;
        }
        IndexColorModel indexColorModel = imageData.transparentPixel != -1 ? new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3, imageData.transparentPixel) : new IndexColorModel(imageData.depth, rGBArray.length, byArray, byArray2, byArray3);
        object = new BufferedImage(indexColorModel, indexColorModel.createCompatibleWritableRaster(imageData.width, imageData.height), false, null);
        WritableRaster writableRaster = object.getRaster();
        int[] nArray = new int[]{0};
        for (int i5 = 0; i5 < imageData.height; ++i5) {
            for (int i6 = 0; i6 < imageData.width; ++i6) {
                nArray[0] = imageData.getPixel(i6, i5);
                writableRaster.setPixel(i6, i5, nArray);
            }
        }
        return object;
    }

    public static BufferedImage b(ImageData imageData) {
        BufferedImage bufferedImage = new BufferedImage(imageData.width, imageData.height, 2);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n2 = imageData.width * imageData.height;
        imageData.getPixels(0, 0, n2, nArray, 0);
        if (imageData.alphaData != null) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                RGB rGB = imageData.palette.getRGB(nArray[i2]);
                nArray[i2] = (imageData.alphaData[i2] << 24) + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
            }
        } else if (imageData.transparentPixel != -1 && !imageData.palette.isDirect) {
            RGB[] rGBArray = imageData.palette.colors;
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                int n3;
                int n4;
                int[] nArray2;
                if (nArray[i3] == imageData.transparentPixel) {
                    nArray2 = nArray;
                    n4 = i3;
                    n3 = 0;
                } else {
                    RGB rGB = rGBArray[nArray[i3] % rGBArray.length];
                    nArray2 = nArray;
                    n4 = i3;
                    n3 = -16777216 + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
                }
                nArray2[n4] = n3;
            }
        } else if (!imageData.palette.isDirect) {
            RGB[] rGBArray = imageData.palette.colors;
            for (int i4 = n2 - 1; i4 >= 0; --i4) {
                RGB rGB = imageData.palette.getRGB(nArray[i4] % rGBArray.length);
                nArray[i4] = -16777216 + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
            }
        } else {
            for (int i5 = n2 - 1; i5 >= 0; --i5) {
                RGB rGB = imageData.palette.getRGB(nArray[i5]);
                nArray[i5] = -16777216 + ((rGB.red & 0xFF) << 16) + ((rGB.green & 0xFF) << 8) + (rGB.blue & 0xFF);
            }
        }
        nArray = null;
        System.gc();
        return bufferedImage;
    }

    public static ImageData a(BufferedImage bufferedImage) {
        if (bufferedImage.getType() == 1 || bufferedImage.getType() == 2 || bufferedImage.getType() == 4) {
            return emulator.graphics2D.a.b(bufferedImage);
        }
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            return emulator.graphics2D.a.c(bufferedImage);
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            return emulator.graphics2D.a.d(bufferedImage);
        }
        return null;
    }

    private static ImageData b(BufferedImage bufferedImage) {
        if (a == null || bufferedImage != a) {
            a = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 32, a);
            a = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            a = bufferedImage;
        }
        ImageData imageData = a;
        int[] nArray = a;
        byte[] byArray = imageData.data;
        int n2 = byArray.length - 1;
        switch (bufferedImage.getType()) {
            case 4: {
                for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                    byArray[n2--] = -1;
                    byArray[n2--] = (byte)(nArray[i2] & 0xFF);
                    byArray[n2--] = (byte)(nArray[i2] >> 8 & 0xFF);
                    byArray[n2--] = (byte)(nArray[i2] >> 16 & 0xFF);
                }
                break;
            }
            case 1: {
                for (int i3 = nArray.length - 1; i3 >= 0; --i3) {
                    byArray[n2--] = -1;
                    byArray[n2--] = (byte)(nArray[i3] >> 16 & 0xFF);
                    byArray[n2--] = (byte)(nArray[i3] >> 8 & 0xFF);
                    byArray[n2--] = (byte)(nArray[i3] & 0xFF);
                }
                break;
            }
            case 2: {
                imageData.alphaData = new byte[nArray.length];
                for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
                    byte by2 = (byte)(nArray[i4] >> 24 & 0xFF);
                    byArray[n2--] = by2;
                    imageData.alphaData[i4] = by2;
                    byArray[n2--] = (byte)(nArray[i4] >> 16 & 0xFF);
                    byArray[n2--] = (byte)(nArray[i4] >> 8 & 0xFF);
                    byArray[n2--] = (byte)(nArray[i4] & 0xFF);
                }
                break;
            }
        }
        return imageData;
    }

    private static ImageData c(BufferedImage bufferedImage) {
        DirectColorModel directColorModel = (DirectColorModel)bufferedImage.getColorModel();
        PaletteData paletteData = new PaletteData(directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
        ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), directColorModel.getPixelSize(), paletteData);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = imageData.width;
        int[] nArray = new int[4 * n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < imageData.height; ++i2) {
            int n3;
            writableRaster.getPixels(0, i2, n2, 1, nArray);
            for (n3 = 0; n3 < n2; ++n3) {
                RGB rGB = new RGB(nArray[n3 * 4 + 0], nArray[n3 * 4 + 1], nArray[n3 * 4 + 2]);
                nArray2[n3] = paletteData.getPixel(rGB);
            }
            imageData.setPixels(0, i2, n2, nArray2, 0);
            if (!directColorModel.hasAlpha()) continue;
            for (n3 = 0; n3 < n2; ++n3) {
                imageData.setAlpha(n3, i2, nArray[n3 * 4 + 3]);
            }
        }
        return imageData;
    }

    private static ImageData d(BufferedImage bufferedImage) {
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        int n2 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        RGB[] rGBArray = new RGB[n2];
        for (int i2 = 0; i2 < rGBArray.length; ++i2) {
            rGBArray[i2] = new RGB(byArray[i2] & 0xFF, byArray2[i2] & 0xFF, byArray3[i2] & 0xFF);
        }
        ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), new PaletteData(rGBArray));
        new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), new PaletteData(rGBArray)).transparentPixel = indexColorModel.getTransparentPixel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[]{0};
        for (int i3 = 0; i3 < imageData.height; ++i3) {
            for (int i4 = 0; i4 < imageData.width; ++i4) {
                writableRaster.getPixel(i4, i3, nArray);
                imageData.setPixel(i4, i3, nArray[0]);
            }
        }
        return imageData;
    }

    public static void a(BufferedImage bufferedImage) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new f(bufferedImage), null);
    }
}

