/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.lwjgl;

import emulator.AppSettings;
import emulator.Emulator;
import emulator.Settings;
import emulator.Utils;
import emulator.debug.Profiler3D;
import emulator.graphics2D.awt.Graphics2DAWT;
import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.IGraphics3D;
import emulator.graphics3D.Transform3D;
import emulator.graphics3D.Vector4f;
import emulator.graphics3D.egl.GLConfiguration;
import emulator.graphics3D.lwjgl.Emulator3D$1;
import emulator.graphics3D.lwjgl.Emulator3D$M3GException;
import emulator.graphics3D.lwjgl.GLCanvasUtil;
import emulator.graphics3D.lwjgl.LWJGLUtil;
import emulator.graphics3D.m3g.CameraCache;
import emulator.graphics3D.m3g.LightsCache;
import emulator.graphics3D.m3g.MeshMorph;
import emulator.graphics3D.m3g.RenderObject;
import emulator.graphics3D.m3g.RenderPipe;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;
import kemnn.b;
import kemnn.cu;
import kemnn.eJ;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.opengl.ARBColorBufferFloat;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLCapabilities;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Emulator3D
implements IGraphics3D {
    private static Emulator3D a;
    private final LWJGLUtil a;
    private final RenderPipe a;
    private Object a;
    private boolean a;
    private int a;
    private static int b;
    private static int c;
    private static ByteBuffer a;
    private static BufferedImage a;
    private static ImageData a;
    public static final PaletteData swtPalleteData;
    private static final Hashtable a;
    private float a;
    private float b;
    private int d;
    private int e;
    private int f;
    private int g;
    private static final Vector a;
    private static final Vector b;
    public static final int MaxViewportWidth = 2048;
    public static final int MaxViewportHeight = 2048;
    public static final int MaxViewportDimension = 2048;
    public static final int NumTextureUnits = 10;
    public static final int MaxTextureDimension = 2048;
    public static final int MaxSpriteCropDimension = 1024;
    public static final int MaxLights = 8;
    public static final int MaxTransformsPerVertex = 4;
    private boolean b;
    private final Map a;
    private boolean c;
    private static Canvas a;
    private static GLCapabilities a;
    private static long a;
    private boolean d;
    private boolean e;
    private static boolean f;
    private ExecutorService a;
    private Thread a = new WeakHashMap();

    private Emulator3D() {
        a = this;
        a.put("supportAntialiasing", Boolean.TRUE);
        a.put("supportTrueColor", Boolean.TRUE);
        a.put("supportDithering", Boolean.TRUE);
        a.put("supportMipmapping", Boolean.TRUE);
        a.put("supportPerspectiveCorrection", Boolean.TRUE);
        a.put("supportLocalCameraLighting", Boolean.TRUE);
        a.put("maxLights", new Integer(8));
        a.put("maxViewportWidth", new Integer(2048));
        a.put("maxViewportHeight", new Integer(2048));
        a.put("maxViewportDimension", new Integer(Math.min(2048, 2048)));
        a.put("maxTextureDimension", new Integer(2048));
        a.put("maxSpriteCropDimension", new Integer(1024));
        a.put("maxTransformsPerVertex", new Integer(4));
        a.put("numTextureUnits", new Integer(10));
        a.put("coreID", "@KEmulator LWJ-OpenGL-M3G @liang.wu");
        a.put("version", "nnmod " + Emulator.version + (Emulator.revision.length() > 0 ? " (git: " + Emulator.revision + ")" : ""));
        this.a = new LWJGLUtil();
        this.a = new RenderPipe();
    }

    public static Emulator3D getInstance() {
        if (a == null) {
            a = new Emulator3D();
        }
        return a;
    }

    public void start() {
        if (this.a != null) {
            return;
        }
        this.a = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable, "KEmulator-M3G");
            thread.setPriority(5);
            this.a = thread;
            return this.a;
        });
    }

    @Override
    public void bindTarget(Object object) {
        this.bindTarget(object, false);
    }

    @Override
    public final synchronized void bindTarget(Object object, boolean bl2) {
        int n2;
        int n3;
        if (this.b) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IllegalStateException("exiting");
        }
        this.e = bl2;
        ++Profiler3D.bindTargetCallCount;
        if (object instanceof Graphics) {
            this.a = object;
            n3 = ((Graphics)this.a).getImage().getWidth();
            n2 = ((Graphics)this.a).getImage().getHeight();
        } else {
            if (!(object instanceof Image2D)) {
                throw new IllegalArgumentException();
            }
            this.a = object;
            n3 = ((Image2D)this.a).getWidth();
            n2 = ((Image2D)this.a).getHeight();
        }
        this.start();
        if (!f || !AppSettings.m3gThread) {
            f = true;
            this.sync(() -> {
                try {
                    this.a(n3, n2, this.e);
                }
                catch (Exception exception) {
                    throw new Emulator3D$M3GException(exception);
                }
            });
        }
        try {
            if (b != n3 || c != n2) {
                if (a != null) {
                    a.getDisplay().asyncExec(() -> {
                        a.setSize(n3, n2);
                        a.setVisible(false);
                    });
                } else {
                    this.async(() -> GLFW.glfwSetWindowSize(a, n3, n2));
                }
                a = Settings.g2d == 1 ? new BufferedImage(n3, n2, 4) : new ImageData(n3, n2, 32, swtPalleteData);
                a = BufferUtils.createByteBuffer(n3 * n2 * 4);
                b = n3;
                c = n2;
            }
            this.async(() -> {
                GL11.glEnable(3089);
                GL11.glEnable(2977);
                GL11.glPixelStorei(3317, 1);
                if (AppSettings.m3gFlushImmediately) {
                    this.swapBuffers();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.a = null;
            throw new IllegalArgumentException();
        }
    }

    private void a() {
        if (a == null) {
            a = GL.createCapabilities();
            GLConfiguration.OES_blend_subtract = Emulator3D.a.OpenGL14;
            GLConfiguration.OES_blend_func_separate = Emulator3D.a.OpenGL14;
            GLConfiguration.OES_blend_equations_separate = Emulator3D.a.OpenGL20;
            GLConfiguration.OES_framebuffer_object = Emulator3D.a.OpenGL30;
            return;
        }
        try {
            a = GL.getCapabilities();
        }
        catch (Exception exception) {
            a = GL.createCapabilities();
        }
    }

    @Override
    public synchronized void releaseTarget() {
        ++Profiler3D.releaseTargetCallCount;
        if (!this.e) {
            this.sync(() -> {
                GL11.glFinish();
                if (!AppSettings.m3gFlushImmediately) {
                    this.swapBuffers();
                }
                while (!b.isEmpty()) {
                    this.a((Integer)b.get(0));
                }
                if (this.b) {
                    while (!a.isEmpty()) {
                        this.a((Integer)a.get(0));
                    }
                    return;
                }
            });
        }
        if (!AppSettings.m3gThread) {
            this.b();
        }
        this.a = null;
    }

    public static boolean useGL11() {
        return !Emulator3D.a.OpenGL12;
    }

    private void b() {
        if (a != 0L) {
            GLFW.glfwMakeContextCurrent(0L);
            return;
        }
        try {
            GLCanvasUtil.releaseContext(a);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void swapBuffers() {
        this.swapBuffers(this.c, 0, 0, b, c);
    }

    public final void swapBuffers(boolean bl2, int n2, int n3, int n4, int n5) {
        this.sync(() -> {
            ++Profiler3D.LWJGL_buffersSwapCount;
            if (this.a != null) {
                if (this.a instanceof Image2D) {
                    Image2D image2D = (Image2D)this.a;
                    a.rewind();
                    GL11.glReadPixels(n2, n3, n4, n5, 6408, 5121, a);
                    byte[] byArray = new byte[n4 * n5 * 4];
                    int n6 = n4 << 2;
                    int n7 = byArray.length - n6;
                    for (int i2 = n5; i2 > 0; --i2) {
                        a.get(byArray, n7, n6);
                        n7 -= n6;
                    }
                    if (image2D.getFormat() == 100) {
                        image2D.set(n2, n3, image2D.getWidth(), image2D.getHeight(), byArray);
                    } else {
                        byte[] byArray2 = new byte[image2D.getWidth() * image2D.getHeight() * 3];
                        int n8 = byArray.length - 1;
                        int n9 = byArray2.length - 1;
                        while (n9 >= 0) {
                            int n10 = n9--;
                            int n11 = --n8;
                            byArray2[n10] = byArray[n11];
                            int n12 = n9--;
                            int n13 = --n8;
                            byArray2[n12] = byArray[n13];
                            int n14 = n9--;
                            int n15 = --n8;
                            --n8;
                            byArray2[n14] = byArray[n15];
                        }
                        image2D.set(n2, n3, image2D.getWidth(), image2D.getHeight(), byArray2);
                    }
                } else if (Settings.g2d == 0) {
                    a.rewind();
                    GL11.glReadPixels(n2, n3, n4, n5, 6408, 5121, a);
                    for (int i3 = 0; i3 < n5; ++i3) {
                        int n16 = Emulator3D.a.height - 1 - i3;
                        int n17 = n16 * Emulator3D.a.width * 4;
                        int n18 = i3 * n4 * 4;
                        a.position(n18);
                        a.get(Emulator3D.a.data, n17, n4 * 4);
                    }
                    Image image = new Image(null, a);
                    ((b)((Graphics)this.a).getImpl()).a().drawImage(image, 0, 0, n4, n5, n2, n3, n4, n5);
                    image.dispose();
                } else {
                    a.rewind();
                    GL11.glReadPixels(n2, n3, n4, n5, 6408, 5121, a);
                    int[] nArray = ((DataBufferInt)a.getRaster().getDataBuffer()).getData();
                    IntBuffer intBuffer = a.asIntBuffer();
                    for (int i4 = 0; i4 < n5; ++i4) {
                        int n19 = i4;
                        if (!bl2) {
                            n19 = a.getHeight() - 1 - n19;
                        }
                        int n20 = n19 * a.getWidth();
                        int n21 = i4 * n4;
                        intBuffer.position(n21);
                        intBuffer.get(nArray, n20, n4);
                    }
                    ((Graphics2DAWT)((Graphics)this.a).getImpl()).g().drawImage(a, n2, n3, n2 + n4, n3 + n5, 0, 0, n4, n5, null);
                }
            }
        });
    }

    @Override
    public final void enableDepthBuffer(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public final boolean isDepthBufferEnabled() {
        return this.a;
    }

    @Override
    public final void setHints(int n2) {
        this.a = n2;
        if (this.a != null) {
            this.async(this::c);
        }
    }

    private void c() {
        boolean bl2;
        boolean bl3 = bl2 = (this.a & 2) != 0;
        if (AppSettings.m3gAA == 1) {
            bl2 = false;
        } else if (AppSettings.m3gAA == 2) {
            bl2 = true;
        }
        if (bl2) {
            GL11.glEnable(2832);
            GL11.glEnable(2848);
            GL11.glEnable(2881);
            if (!Emulator3D.useGL11()) {
                GL11.glEnable(32925);
            }
        } else {
            GL11.glDisable(2832);
            GL11.glDisable(2848);
            GL11.glDisable(2881);
            if (!Emulator3D.useGL11()) {
                GL11.glDisable(32925);
            }
        }
        if ((this.a & 4) != 0) {
            GL11.glEnable(3024);
        } else {
            GL11.glDisable(3024);
        }
    }

    @Override
    public final int getHints() {
        return this.a;
    }

    @Override
    public final Hashtable getProperties() {
        return a;
    }

    @Override
    public final void setDepthRange(float f2, float f3) {
        this.a = f2;
        this.b = f3;
    }

    private void d() {
        this.async(() -> GL11.glDepthRange(this.a, this.b));
    }

    @Override
    public final void setViewport(int n2, int n3, int n4, int n5) {
        this.d = n2;
        this.e = n3;
        this.f = n4;
        this.g = n5;
    }

    private void e() {
        this.async(() -> {
            GL11.glViewport(this.d, c - this.e - this.g, this.f, this.g);
            GL11.glScissor(this.d, c - this.e - this.g, this.f, this.g);
        });
    }

    @Override
    public final void clearBackgound(Object object) {
        this.sync(() -> {
            Background background = (Background)object;
            this.e();
            this.d();
            GL11.glClearDepth(1.0);
            GL11.glDepthMask(true);
            GL11.glColorMask(true, true, true, true);
            int n2 = background != null && !AppSettings.xrayView ? background.getColor() : 0;
            GL11.glClearColor(G3DUtils.getFloatColor(n2, 16), G3DUtils.getFloatColor(n2, 8), G3DUtils.getFloatColor(n2, 0), G3DUtils.getFloatColor(n2, 24));
            if (background != null && !AppSettings.xrayView) {
                int n3 = background.isColorClearEnabled() ? 16384 : 0;
                int n4 = this.a && background.isDepthClearEnabled() ? 256 : 0;
                GL11.glClear(n3 | n4);
                this.a(background);
            } else {
                GL11.glClear(0x4000 | (this.a ? 256 : 0));
            }
            if (AppSettings.m3gFlushImmediately) {
                this.swapBuffers();
            }
        });
    }

    private void a(Background background) {
        if (background == null || background.getImage() == null || background.getCropWidth() <= 0 || background.getCropHeight() <= 0) {
            return;
        }
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        GL11.glDisable(3008);
        GL11.glDisable(3042);
        GL11.glDepthFunc(519);
        GL11.glDepthMask(false);
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int n2 = background.getImage().getFormat() == 99 ? 6407 : 6408;
        int n3 = background.getImage().getWidth();
        int n4 = background.getImage().getHeight();
        float f2 = this.f;
        float f3 = this.g;
        float f4 = f2 / (float)background.getCropWidth();
        float f5 = f3 / (float)background.getCropHeight();
        float f6 = -f2 * (float)background.getCropX() / (float)background.getCropWidth() - f2 / 2.0f;
        float f7 = f3 * (float)background.getCropY() / (float)background.getCropHeight() + f3 / 2.0f;
        float f8 = f4 * (float)n3;
        float f9 = f5 * (float)n4;
        int n5 = 1;
        if (background.getImageModeX() == 33) {
            float f10;
            f6 %= f8;
            if (f10 > 0.0f) {
                f6 -= f8;
            }
            n5 = (int)(2.5f + f2 / f8);
            f6 -= (float)n5 / 2.0f * f8;
        }
        int n6 = 1;
        if (background.getImageModeY() == 33) {
            f7 %= f9;
            n6 = (int)(2.5f + f3 / f9);
            f7 += (float)n6 / 2.0f * f9;
        }
        GL11.glPixelStorei(3314, n3);
        GL11.glPixelStorei(3315, 0);
        GL11.glPixelStorei(3316, 0);
        GL11.glPixelZoom(f4, -f5);
        ByteBuffer byteBuffer = this.a.getImageBuffer(background.getImage().getImageData());
        for (int i2 = 0; i2 < n6; ++i2) {
            for (int i3 = 0; i3 < n5; ++i3) {
                GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glBitmap(0, 0, 0.0f, 0.0f, f6 + (float)i3 * f8, f7 - (float)i2 * f9, byteBuffer);
                GL11.glDrawPixels(n3, n4, n2, 5121, byteBuffer);
            }
        }
        GL11.glPixelStorei(3314, 0);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
    }

    private void f() {
        if (CameraCache.camera != null) {
            Transform transform = new Transform();
            CameraCache.camera.getProjection(transform);
            transform.transpose();
            GL11.glMatrixMode(5889);
            GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
            transform.set(CameraCache.invCam);
            transform.transpose();
            GL11.glMatrixMode(5888);
            GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
        }
    }

    private void a(Vector vector2, Vector vector3, int n2) {
        int n3;
        for (n3 = 0; n3 < 8; ++n3) {
            GL11.glDisable(16384 + n3);
        }
        if (!Emulator3D.useGL11() && Emulator3D.a.GL_ARB_color_buffer_float) {
            ARBColorBufferFloat.glClampColorARB(35098, AppSettings.m3gDisableLightClamp ? 0 : 1);
        }
        n3 = 0;
        Transform transform = new Transform();
        for (int i2 = 0; i2 < vector2.size() && n3 < 8; ++i2) {
            Light light = (Light)vector2.get(i2);
            if (light == null || (light.getScope() & n2) == 0 || !this.a.isVisible(light)) continue;
            Transform transform2 = (Transform)vector3.get(i2);
            if (transform2 != null) {
                transform.set(transform2);
            } else {
                transform.setIdentity();
            }
            transform.transpose();
            GL11.glPushMatrix();
            GL11.glMatrixMode(5888);
            GL11.glMultMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
            int n4 = 16384 + n3;
            ++n3;
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            GL11.glLightfv(n4, 4608, this.a.getFloatBuffer(fArray));
            GL11.glLightfv(n4, 4609, this.a.getFloatBuffer(fArray));
            GL11.glLightfv(n4, 4610, this.a.getFloatBuffer(fArray));
            GL11.glLightf(n4, 4615, 1.0f);
            GL11.glLightf(n4, 4616, 0.0f);
            GL11.glLightf(n4, 4617, 0.0f);
            GL11.glLightf(n4, 4614, 180.0f);
            GL11.glLightf(n4, 4613, 0.0f);
            float[] fArray2 = light.getMode() == 129 ? LightsCache.POSITIVE_Z_AXIS : LightsCache.LOCAL_ORIGIN;
            GL11.glLightfv(n4, 4611, this.a.getFloatBuffer(fArray2));
            G3DUtils.fillFloatColor(fArray, light.getColor());
            float f2 = light.getIntensity();
            fArray[0] = fArray[0] * f2;
            fArray[1] = fArray[1] * f2;
            fArray[2] = fArray[2] * f2;
            fArray[3] = 1.0f;
            int n5 = light.getMode();
            if (n5 == 128) {
                GL11.glLightfv(n4, 4608, this.a.getFloatBuffer(fArray));
            } else {
                GL11.glLightfv(n4, 4609, this.a.getFloatBuffer(fArray));
                GL11.glLightfv(n4, 4610, this.a.getFloatBuffer(fArray));
            }
            if (n5 == 131) {
                GL11.glLightfv(n4, 4612, this.a.getFloatBuffer(LightsCache.NEGATIVE_Z_AXIS));
                GL11.glLightf(n4, 4614, light.getSpotAngle());
                GL11.glLightf(n4, 4613, light.getSpotExponent());
            }
            if (n5 == 131 || n5 == 130) {
                GL11.glLightf(n4, 4615, light.getConstantAttenuation());
                GL11.glLightf(n4, 4616, light.getLinearAttenuation());
                GL11.glLightf(n4, 4617, light.getQuadraticAttenuation());
            }
            GL11.glEnable(n4);
            GL11.glPopMatrix();
        }
    }

    @Override
    public final void render(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Transform transform, int n2) {
        this.sync(() -> this.a(vertexBuffer, indexBuffer, appearance, transform, n2, 1.0f));
    }

    private void a(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Transform transform, int n2, float f2) {
        if ((CameraCache.camera.getScope() & n2) != 0) {
            this.e();
            this.d();
            this.f();
            this.a(LightsCache.m_lights, LightsCache.m_lightsTransform, n2);
            if (transform != null) {
                Transform transform2 = new Transform();
                transform2.set(transform);
                transform2.transpose();
                GL11.glMultMatrixf(this.a.getFloatBuffer(((Transform3D)transform2.getImpl()).m_matrix));
            }
            this.a(appearance, false);
            this.a(vertexBuffer, indexBuffer, appearance, f2);
        }
    }

    private void a(Appearance appearance, boolean bl2) {
        if (!bl2) {
            Emulator3D.a(appearance.getPolygonMode());
        }
        this.a(appearance.getCompositingMode());
        if (!bl2) {
            this.a(appearance.getMaterial());
        }
        this.a(appearance.getFog());
    }

    private static void a(PolygonMode polygonMode) {
        if (polygonMode == null) {
            polygonMode = new PolygonMode();
        }
        GL11.glPolygonMode(1032, AppSettings.xrayView ? 6913 : 6914);
        int n2 = polygonMode.getCulling();
        if (n2 == 162) {
            GL11.glDisable(2884);
        } else {
            GL11.glEnable(2884);
            GL11.glCullFace(n2 == 161 ? 1028 : 1029);
        }
        GL11.glShadeModel(polygonMode.getShading() == 164 ? 7424 : 7425);
        GL11.glFrontFace(polygonMode.getWinding() == 169 ? 2304 : 2305);
        GL11.glLightModelf(2898, polygonMode.isTwoSidedLightingEnabled() ? 1.0f : 0.0f);
        GL11.glLightModelf(2897, polygonMode.isLocalCameraLightingEnabled() ? 1.0f : 0.0f);
        boolean bl2 = polygonMode.isPerspectiveCorrectionEnabled();
        if (AppSettings.m3gForcePerspectiveCorrection) {
            bl2 = true;
        }
        GL11.glHint(3152, bl2 ? 4354 : 4353);
    }

    private void a(CompositingMode compositingMode) {
        if (compositingMode == null) {
            compositingMode = new CompositingMode();
        }
        if (this.a) {
            GL11.glEnable(2929);
        } else {
            GL11.glDisable(2929);
        }
        GL11.glDepthMask(compositingMode.isDepthWriteEnabled());
        GL11.glDepthFunc(compositingMode.isDepthTestEnabled() ? 515 : 519);
        GL11.glColorMask(compositingMode.isColorWriteEnabled(), compositingMode.isColorWriteEnabled(), compositingMode.isColorWriteEnabled(), compositingMode.isAlphaWriteEnabled());
        GL11.glAlphaFunc(518, compositingMode.getAlphaThreshold());
        if (compositingMode.getAlphaThreshold() == 0.0f) {
            GL11.glDisable(3008);
        } else {
            GL11.glEnable(3008);
        }
        if (compositingMode.getBlending() == 68) {
            GL11.glDisable(3042);
        } else {
            GL11.glEnable(3042);
        }
        switch (compositingMode.getBlending()) {
            case 64: {
                GL11.glBlendFunc(770, 771);
                break;
            }
            case 65: {
                GL11.glBlendFunc(770, 1);
                break;
            }
            case 66: {
                GL11.glBlendFunc(774, 0);
                break;
            }
            case 67: {
                GL11.glBlendFunc(774, 768);
                break;
            }
            case 68: {
                GL11.glBlendFunc(1, 0);
                break;
            }
        }
        GL11.glPolygonOffset(compositingMode.getDepthOffsetFactor(), compositingMode.getDepthOffsetUnits());
        if (compositingMode.getDepthOffsetFactor() == 0.0f && compositingMode.getDepthOffsetUnits() == 0.0f) {
            GL11.glDisable(AppSettings.xrayView ? 10754 : 32823);
        } else {
            GL11.glEnable(AppSettings.xrayView ? 10754 : 32823);
        }
    }

    private void a(Material material) {
        if (material != null) {
            GL11.glEnable(2896);
            float[] fArray = new float[4];
            G3DUtils.fillFloatColor(fArray, material.getColor(1024));
            GL11.glMaterialfv(1032, 4608, this.a.getFloatBuffer(fArray));
            G3DUtils.fillFloatColor(fArray, material.getColor(2048));
            GL11.glMaterialfv(1032, 4609, this.a.getFloatBuffer(fArray));
            G3DUtils.fillFloatColor(fArray, material.getColor(4096));
            GL11.glMaterialfv(1032, 5632, this.a.getFloatBuffer(fArray));
            G3DUtils.fillFloatColor(fArray, material.getColor(8192));
            GL11.glMaterialfv(1032, 4610, this.a.getFloatBuffer(fArray));
            GL11.glMaterialf(1032, 5633, material.getShininess());
            if (material.isVertexColorTrackingEnabled()) {
                GL11.glEnable(2903);
                GL11.glColorMaterial(1032, 5634);
            } else {
                GL11.glDisable(2903);
            }
        } else {
            GL11.glDisable(2896);
            GL11.glDisable(2903);
        }
    }

    private void a(Fog fog) {
        if (fog != null && !AppSettings.xrayView) {
            GL11.glEnable(2912);
            GL11.glFogi(2917, fog.getMode() == 81 ? 9729 : 2048);
            float[] fArray = new float[4];
            G3DUtils.fillFloatColor(fArray, fog.getColor());
            fArray[3] = 1.0f;
            GL11.glFogfv(2918, this.a.getFloatBuffer(fArray));
            GL11.glFogf(2915, fog.getNearDistance());
            GL11.glFogf(2916, fog.getFarDistance());
            GL11.glFogf(2914, fog.getDensity());
        } else {
            GL11.glDisable(2912);
        }
    }

    private void a(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, float f2) {
        int n2;
        Object object;
        if (this.b) {
            return;
        }
        ++Profiler3D.LWJGL_drawCallCount;
        VertexArray vertexArray = vertexBuffer.getColors();
        if (vertexArray == null) {
            int n3 = vertexBuffer.getDefaultColor();
            GL11.glColor4ub((byte)(n3 >> 16 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)((float)(n3 >> 24 & 0xFF) * f2));
            GL11.glDisableClientState(32886);
        } else {
            GL11.glEnableClientState(32886);
            if (vertexArray.getComponentType() == 1) {
                byte[] byArray = vertexArray.getByteValues();
                GL11.glColorPointer(f2 == 1.0f ? vertexArray.getComponentCount() : 4, 5121, 0, this.a.getColorBuffer(byArray, f2, vertexArray.getVertexCount()));
            }
        }
        VertexArray vertexArray2 = vertexBuffer.getNormals();
        if (vertexArray2 != null && appearance.getMaterial() != null) {
            GL11.glEnableClientState(32885);
            if (vertexArray2.getComponentType() == 1) {
                GL11.glNormalPointer(5120, 0, this.a.getNormalBuffer(vertexArray2.getByteValues()));
            } else {
                GL11.glNormalPointer(5122, 0, this.a.getNormalBuffer(vertexArray2.getShortValues()));
            }
        } else {
            GL11.glDisableClientState(32885);
        }
        float[] fArray = new float[4];
        VertexArray vertexArray3 = vertexBuffer.getPositions(fArray);
        GL11.glEnableClientState(32884);
        if (vertexArray3.getComponentType() == 1) {
            object = vertexArray3.getByteValues();
            GL11.glVertexPointer(vertexArray3.getComponentCount(), 5122, 0, this.a.getVertexBuffer((byte[])object));
        } else {
            object = vertexArray3.getShortValues();
            GL11.glVertexPointer(vertexArray3.getComponentCount(), 5122, 0, this.a.getVertexBuffer((short[])object));
        }
        GL11.glMatrixMode(5888);
        GL11.glTranslatef(fArray[1], fArray[2], fArray[3]);
        GL11.glScalef(fArray[0], fArray[0], fArray[0]);
        object = (TriangleStripArray)indexBuffer;
        int n4 = ((TriangleStripArray)object).getStripCount();
        if (appearance != null && !AppSettings.xrayView) {
            Object3D object3D;
            Texture2D texture2D;
            for (n2 = 0; n2 < 10; ++n2) {
                int n5;
                int n6;
                texture2D = appearance.getTexture(n2);
                fArray[3] = 0.0f;
                object3D = vertexBuffer.getTexCoords(n2, fArray);
                if (texture2D == null || object3D == null) continue;
                Image2D image2D = texture2D.getImage();
                if (!Emulator3D.useGL11()) {
                    GL13.glActiveTexture(33984 + n2);
                    GL13.glClientActiveTexture(33984 + n2);
                }
                if ((n6 = image2D.getId()) == 0) {
                    n6 = GL11.glGenTextures();
                    image2D.setId(n6);
                    image2D.setLoaded(false);
                    if (!a.contains(n6)) {
                        a.add(n6);
                    }
                    this.a.put(n6, image2D);
                }
                GL11.glEnable(3553);
                GL11.glBindTexture(3553, n6);
                int n7 = 0;
                switch (texture2D.getBlending()) {
                    case 224: {
                        n7 = 260;
                        break;
                    }
                    case 225: {
                        n7 = 3042;
                        break;
                    }
                    case 226: {
                        n7 = 8449;
                        break;
                    }
                    case 227: {
                        n7 = 8448;
                        break;
                    }
                    case 228: {
                        n7 = 7681;
                        break;
                    }
                }
                GL11.glTexEnvi(8960, 8704, n7);
                float[] fArray2 = new float[4];
                G3DUtils.fillFloatColor(fArray2, texture2D.getBlendColor());
                fArray2[3] = 1.0f;
                GL11.glTexEnvfv(8960, 8705, this.a.getFloatBuffer(fArray2));
                if (!image2D.isLoaded()) {
                    image2D.setLoaded(true);
                    ++Profiler3D.LWJGL_glTexImage2DCount;
                    n5 = 6407;
                    switch (image2D.getFormat()) {
                        case 96: {
                            n5 = 6406;
                            break;
                        }
                        case 97: {
                            n5 = 6409;
                            break;
                        }
                        case 98: {
                            n5 = 6410;
                            break;
                        }
                        case 99: {
                            n5 = 6407;
                            break;
                        }
                        case 100: {
                            n5 = 6408;
                        }
                    }
                    if (!Emulator3D.useGL11() && Emulator3D.a.OpenGL14) {
                        GL11.glTexParameteri(3553, 33169, 1);
                    }
                    GL11.glTexImage2D(3553, 0, n5, image2D.getWidth(), image2D.getHeight(), 0, n5, 5121, this.a.getImageBuffer(image2D.getImageData()));
                }
                GL11.glTexParameterf(3553, 10242, texture2D.getWrappingS() == 240 && !Emulator3D.useGL11() ? 33071.0f : 10497.0f);
                GL11.glTexParameterf(3553, 10243, texture2D.getWrappingT() == 240 && !Emulator3D.useGL11() ? 33071.0f : 10497.0f);
                n5 = texture2D.getLevelFilter();
                int n8 = texture2D.getImageFilter();
                if (Emulator3D.useGL11() || AppSettings.m3gMipmapping == 1) {
                    n5 = 208;
                    if (!Emulator3D.useGL11()) {
                        GL11.glTexParameteri(3553, 34046, 1);
                    }
                } else if (AppSettings.m3gMipmapping == 2) {
                    n5 = 210;
                    GL11.glTexParameteri(3553, 34046, 1);
                } else if (AppSettings.m3gMipmapping == 3) {
                    n5 = 209;
                    GL11.glTexParameteri(3553, 34046, 1);
                } else if (AppSettings.m3gMipmapping >= 4) {
                    n5 = 209;
                    GL11.glTexParameteri(3553, 34046, 2 << AppSettings.m3gMipmapping - 4);
                }
                if (AppSettings.m3gTexFilter == 1) {
                    n8 = 210;
                } else if (AppSettings.m3gTexFilter == 2) {
                    n8 = 209;
                }
                int n9 = 0;
                int n10 = 0;
                if (n8 == 210) {
                    n9 = 9728;
                    n10 = 9728;
                    if (n5 == 210) {
                        n10 = 9984;
                    } else if (n5 == 209) {
                        n10 = 9986;
                    }
                } else if (n8 == 209) {
                    n9 = 9729;
                    n10 = 9729;
                    if (n5 == 210) {
                        n10 = 9985;
                    } else if (n5 == 209) {
                        n10 = 9987;
                    }
                }
                GL11.glTexParameteri(3553, 10241, n10);
                GL11.glTexParameteri(3553, 10240, n9);
                GL11.glEnableClientState(32888);
                ShortBuffer shortBuffer = ((VertexArray)object3D).getComponentType() == 1 ? this.a.getTexCoordBuffer(((VertexArray)object3D).getByteValues(), n2) : this.a.getTexCoordBuffer(((VertexArray)object3D).getShortValues(), n2);
                GL11.glTexCoordPointer(((VertexArray)object3D).getComponentCount(), 5122, 0, shortBuffer);
                Transform transform = new Transform();
                texture2D.getCompositeTransform(transform);
                transform.transpose();
                GL11.glMatrixMode(5890);
                GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform.getImpl()).m_matrix));
                GL11.glTranslatef(fArray[1], fArray[2], fArray[3]);
                GL11.glScalef(fArray[0], fArray[0], fArray[0]);
            }
            Profiler3D.LWJGL_trianglesCount += ((TriangleStripArray)object).profilerCount();
            GL11.glDrawElements(5, ((TriangleStripArray)object).getBuffer());
            for (n2 = 0; n2 < 10; ++n2) {
                texture2D = appearance.getTexture(n2);
                if (texture2D == null || ((Image2D)(object3D = texture2D.getImage())).getId() == 0) continue;
                if (!Emulator3D.useGL11()) {
                    GL13.glActiveTexture(33984 + n2);
                    GL13.glClientActiveTexture(33984 + n2);
                }
                GL11.glBindTexture(3553, 0);
            }
        } else {
            n2 = ((TriangleStripArray)object).getStripCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                GL11.glDrawElements(5, this.a.getElementsBuffer(((TriangleStripArray)object).getIndexStrip(i2)));
            }
        }
        if ((n2 = GL11.glGetError()) != 0) {
            Emulator.getEmulator().getLogStream().println("GL Error: " + n2);
        }
    }

    @Override
    public synchronized void render(World world) {
        this.sync(() -> {
            Transform transform = new Transform();
            world.getActiveCamera().getTransformTo(world, transform);
            CameraCache.setCamera(world.getActiveCamera(), transform);
            this.clearBackgound(world.getBackground());
            LightsCache.addLightsFromWorld(world);
            this.a.pushRenderNode(world, null);
            this.g();
        });
    }

    @Override
    public synchronized void render(Node node, Transform transform) {
        this.sync(() -> {
            this.a.pushRenderNode(node, transform);
            this.g();
        });
    }

    private void g() {
        this.a.sortNodes();
        for (int i2 = 0; i2 < this.a.getSize(); ++i2) {
            RenderObject renderObject = this.a.getRenderObj(i2);
            if (renderObject.node instanceof Mesh) {
                Mesh mesh = (Mesh)renderObject.node;
                IndexBuffer indexBuffer = mesh.getIndexBuffer(renderObject.submeshIndex);
                Appearance appearance = mesh.getAppearance(renderObject.submeshIndex);
                if (indexBuffer == null || appearance == null) continue;
                VertexBuffer vertexBuffer = MeshMorph.getInstance().getMorphedVertexBuffer(mesh);
                this.a(vertexBuffer, indexBuffer, appearance, renderObject.trans, mesh.getScope(), renderObject.alphaFactor);
                continue;
            }
            this.a((Sprite3D)renderObject.node, renderObject.trans, renderObject.alphaFactor);
        }
        this.a.clear();
        MeshMorph.getInstance().clearCache();
        if (AppSettings.m3gFlushImmediately) {
            this.swapBuffers();
        }
    }

    private void a(Sprite3D sprite3D, Transform transform, float f2) {
        block19: {
            int n2;
            ByteBuffer byteBuffer;
            int[] nArray;
            block26: {
                int n3;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                Transform transform2;
                Transform transform3;
                block25: {
                    float f9;
                    block24: {
                        int[] nArray2;
                        block23: {
                            boolean bl2;
                            block22: {
                                block21: {
                                    block20: {
                                        ++Profiler3D.LWJGL_renderSpriteCount;
                                        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                                        float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
                                        float[] fArray3 = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
                                        transform3 = new Transform(CameraCache.invCam);
                                        transform3.postMultiply(transform);
                                        Transform3D transform3D = (Transform3D)transform3.getImpl();
                                        transform3D.transform(fArray);
                                        transform3D.transform(fArray2);
                                        transform3D.transform(fArray3);
                                        float[] fArray4 = new float[]{fArray[0], fArray[1], fArray[2], fArray[3]};
                                        Vector4f.mul(fArray, 1.0f / fArray[3]);
                                        Vector4f.mul(fArray2, 1.0f / fArray2[3]);
                                        Vector4f.mul(fArray3, 1.0f / fArray3[3]);
                                        Vector4f.sub(fArray2, fArray);
                                        Vector4f.sub(fArray3, fArray);
                                        float[] fArray5 = new float[]{Vector4f.length(fArray2), 0.0f, 0.0f, 0.0f};
                                        float[] fArray6 = new float[]{0.0f, Vector4f.length(fArray3), 0.0f, 0.0f};
                                        Vector4f.add(fArray5, fArray4);
                                        Vector4f.add(fArray6, fArray4);
                                        transform2 = new Transform();
                                        CameraCache.camera.getProjection(transform2);
                                        transform3D = (Transform3D)transform2.getImpl();
                                        transform3D.transform(fArray4);
                                        transform3D.transform(fArray5);
                                        transform3D.transform(fArray6);
                                        if (!(fArray4[3] > 0.0f) || !(-fArray4[3] < fArray4[2]) || !(fArray4[2] <= fArray4[3])) break block19;
                                        Vector4f.mul(fArray4, 1.0f / fArray4[3]);
                                        Vector4f.mul(fArray5, 1.0f / fArray5[3]);
                                        Vector4f.mul(fArray6, 1.0f / fArray6[3]);
                                        Vector4f.sub(fArray5, fArray4);
                                        Vector4f.sub(fArray6, fArray4);
                                        boolean bl3 = sprite3D.isScaled();
                                        nArray2 = new int[]{sprite3D.getCropX(), sprite3D.getCropY(), sprite3D.getCropWidth(), sprite3D.getCropHeight()};
                                        boolean bl4 = nArray2[2] < 0;
                                        bl2 = nArray2[3] < 0;
                                        nArray2[2] = Math.abs(nArray2[2]);
                                        nArray2[3] = Math.abs(nArray2[3]);
                                        f8 = 1.0f;
                                        f7 = 1.0f;
                                        f6 = (bl4 ? nArray2[2] : -nArray2[2]) / 2;
                                        f5 = (bl2 ? -nArray2[3] : nArray2[3]) / 2;
                                        if (!bl3) {
                                            if (bl4) {
                                                f8 = -1.0f;
                                            }
                                            if (bl2) {
                                                f7 = -1.0f;
                                            }
                                            f4 = nArray2[2];
                                            f3 = nArray2[3];
                                        } else {
                                            f8 = Vector4f.length(fArray5) * (float)this.f * 0.5f;
                                            f7 = Vector4f.length(fArray6) * (float)this.g * 0.5f;
                                            f4 = f8;
                                            f3 = f7;
                                            f6 = -f8 / 2.0f;
                                            f5 = f7 / 2.0f;
                                            if (bl4) {
                                                f6 += f8;
                                            }
                                            if (bl2) {
                                                f5 -= f7;
                                            }
                                            f8 /= bl4 ? -((float)nArray2[2]) : (float)nArray2[2];
                                            f7 /= bl2 ? -((float)nArray2[3]) : (float)nArray2[3];
                                        }
                                        nArray = new int[4];
                                        if (!G3DUtils.intersectRectangle(nArray2[0], nArray2[1], nArray2[2], nArray2[3], 0, 0, sprite3D.getImage().getWidth(), sprite3D.getImage().getHeight(), nArray)) break block19;
                                        if (bl4) break block20;
                                        f9 = f6 - f8 * (float)(nArray2[0] - nArray[0]);
                                        break block21;
                                    }
                                    if (nArray2[0] <= 0) break block22;
                                    f9 = f6 + f8 * (float)(nArray2[0] - nArray[0]);
                                }
                                f6 = f9;
                            }
                            if (bl2) break block23;
                            f9 = f5 + f7 * (float)(nArray2[1] - nArray[1]);
                            break block24;
                        }
                        if (nArray2[1] <= 0) break block25;
                        f9 = f5 - f7 * (float)(nArray2[1] - nArray[1]);
                    }
                    f5 = f9;
                }
                Transform transform4 = new Transform();
                transform4.postScale((float)this.f / ((float)this.f + f4), (float)this.g / ((float)this.g + f3), 1.0f);
                transform4.postMultiply(transform2);
                transform2.set(transform4);
                int n4 = (int)((float)this.d - f4 / 2.0f);
                int n5 = (int)((float)this.e - f3 / 2.0f);
                int n6 = (int)((float)this.f + f4);
                int n7 = (int)((float)this.g + f3);
                transform2.transpose();
                transform3.transpose();
                GL11.glViewport(n4, c - n5 - n7, n6, n7);
                GL11.glMatrixMode(5889);
                GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform2.getImpl()).m_matrix));
                GL11.glMatrixMode(5888);
                GL11.glLoadMatrixf(this.a.getFloatBuffer(((Transform3D)transform3.getImpl()).m_matrix));
                GL11.glDisable(2896);
                byteBuffer = this.a.getImageBuffer(sprite3D.getImage().getImageData());
                GL11.glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glPixelStorei(3314, sprite3D.getImage().getWidth());
                GL11.glPixelStorei(3315, nArray[1]);
                GL11.glPixelStorei(3316, nArray[0]);
                GL11.glBitmap(0, 0, 0.0f, 0.0f, f6, f5, byteBuffer);
                GL11.glPixelZoom(f8, -f7);
                n2 = 6407;
                switch (sprite3D.getImage().getFormat()) {
                    case 96: {
                        n3 = 6406;
                        break;
                    }
                    case 97: {
                        n3 = 6409;
                        break;
                    }
                    case 98: {
                        n3 = 6410;
                        break;
                    }
                    case 99: {
                        n3 = 6407;
                        break;
                    }
                    case 100: {
                        n3 = 6408;
                        break;
                    }
                    default: {
                        break block26;
                    }
                }
                n2 = n3;
            }
            this.a(sprite3D.getAppearance(), true);
            GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)(255.0f * f2));
            GL11.glDisableClientState(32886);
            GL11.glDrawPixels(nArray[2], nArray[3], n2, 5121, byteBuffer);
            GL11.glPixelStorei(3314, 0);
            GL11.glPixelStorei(3315, 0);
            GL11.glPixelStorei(3316, 0);
        }
    }

    public final void v3bind(Graphics graphics) {
    }

    public final void v3release(Graphics graphics) {
    }

    public final void v3flush() {
    }

    public void finalizeTexture(Image2D image2D) {
        if (a.contains(image2D.getId())) {
            a.removeElement(image2D.getId());
        }
        if (!b.contains(image2D.getId())) {
            b.add(image2D.getId());
        }
        image2D.setId(0);
    }

    public void releaseTextures() {
        while (!a.isEmpty()) {
            this.a((Integer)a.get(0));
        }
        while (!b.isEmpty()) {
            this.a((Integer)b.get(0));
        }
    }

    public static void exit() {
        if (a == null) {
            return;
        }
        a.i();
    }

    private void h() {
        if (a == null) {
            return;
        }
        a.getDisplay().syncExec(() -> {
            a.dispose();
            a = null;
        });
    }

    private void i() {
        this.b = true;
        if (this.d && AppSettings.m3gThread) {
            this.sync(() -> {
                this.releaseTextures();
                this.b();
            });
        }
        this.h();
        if (a != 0L) {
            GLFW.glfwDestroyWindow(a);
        }
    }

    public void invalidateTexture(Image2D image2D) {
        image2D.setLoaded(false);
    }

    private void a(int n2) {
        Image2D image2D;
        GL11.glDeleteTextures(n2);
        a.removeElement(n2);
        b.removeElement(n2);
        if (this.a.containsKey(n2) && (image2D = (Image2D)this.a.get(n2)) != null) {
            image2D.setId(0);
        }
        this.a.remove(n2);
    }

    public void setFlipImage(boolean bl2) {
        this.c = bl2;
    }

    private void a(int n2, int n3, boolean bl2) throws Exception {
        if (!this.d) {
            block18: {
                int n4;
                if (a != null) {
                    this.h();
                }
                if (a != 0L) {
                    GLFW.glfwDestroyWindow(a);
                    a = 0L;
                }
                if (this.b) {
                    return;
                }
                int n5 = n4 = Settings.m3gContextMode == 0 && (Utils.win || Utils.termux) ? 2 : Settings.m3gContextMode;
                if (!bl2 && Settings.m3gContextMode != 3 && Emulator.getEmulator() instanceof eJ) {
                    try {
                        eJ.a(() -> {
                            try {
                                Composite composite = ((cu)Emulator.getEmulator().getScreen()).a();
                                a = GLCanvasUtil.initGLCanvas(composite, 0, n4);
                                a.setSize(1, 1);
                                a.setVisible(true);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                a = null;
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        a = null;
                    }
                }
                if (a != null) {
                    try {
                        GLCanvasUtil.makeCurrent(a);
                        this.a();
                        a.getDisplay().syncExec(() -> a.addControlListener((ControlListener)new Emulator3D$1(this)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (a == null) break block18;
                        this.h();
                        a = null;
                    }
                }
            }
            if (a == null) {
                if (a == 0L) {
                    Emulator.getEmulator().getLogStream().println("Creating invisible glfw window");
                    if (!GLFW.glfwInit()) {
                        throw new Exception("glfwInit");
                    }
                    GLFWErrorCallback.createPrint(System.err).set();
                    GLFW.glfwDefaultWindowHints();
                    GLFW.glfwWindowHint(131076, 0);
                    GLFW.glfwWindowHint(131075, 1);
                    a = GLFW.glfwCreateWindow(n2, n3, "M3G", 0L, 0L);
                    if (a == 0L) {
                        throw new Exception("Window creation failed (GLFW Error: " + GLFW.glfwGetError(null) + ")");
                    }
                }
                GLFW.glfwMakeContextCurrent(a);
                int n6 = GLFW.glfwGetError(null);
                if (n6 != 0) {
                    Emulator.getEmulator().getLogStream().println("GLFW Error: " + n6);
                }
                this.a();
            }
            Emulator.getEmulator().getLogStream().println("GL Renderer: " + GL11.glGetString(7937) + " (" + GL11.glGetString(7936) + ")");
            this.d = true;
        } else {
            if (a != 0L) {
                GLFW.glfwMakeContextCurrent(a);
            } else {
                GLCanvasUtil.makeCurrent(a);
            }
            this.a();
        }
    }

    public void sync(Runnable runnable) throws Emulator3D$M3GException {
        if (Thread.currentThread() == this.a || !AppSettings.m3gThread) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new Emulator3D$M3GException(exception);
            }
            return;
        }
        try {
            this.a.submit(runnable).get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new Emulator3D$M3GException(throwable);
        }
    }

    public void async(Runnable runnable) {
        if (Thread.currentThread() == this.a || !AppSettings.m3gThread) {
            runnable.run();
            return;
        }
        this.a.execute(runnable);
    }

    static /* synthetic */ int a() {
        return b;
    }

    static /* synthetic */ int b() {
        return c;
    }

    static /* synthetic */ Canvas a() {
        return a;
    }

    static {
        swtPalleteData = new PaletteData(-16777216, 0xFF0000, 65280);
        a = new Hashtable();
        a = new Vector();
        b = new Vector();
    }
}

