/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.nokia.mid.ui.CanvasGraphicsItem;
import com.nokia.mid.ui.CanvasItem;
import com.nokia.mid.ui.TextEditor;
import emulator.AppSettings;
import emulator.Emulator;
import emulator.Settings;
import emulator.graphics2D.IImage;
import emulator.n;
import emulator.ui.IScreen;
import java.util.ArrayList;
import java.util.Comparator;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Screen;
import kemnn.S;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    protected int m_keyStates;
    private Graphics graphics;
    private int vKeyStates;
    private final ArrayList nokiaCanvasItems;
    private CanvasItem tappedCanvasItem;

    protected Canvas() {
        this.setFullScreenMode(false);
        this.nokiaCanvasItems = new ArrayList();
    }

    public void _invokePaint(IImage iImage, IImage iImage2) {
        if (!AppSettings.xrayView) {
            iImage2 = null;
        }
        if (this.graphics == null) {
            this.graphics = new Graphics(iImage, iImage2);
        }
        this.graphics._reset(iImage, iImage2);
        this.paint(this.graphics);
        this.graphics._reset(iImage, iImage2);
        this._paintOverlay(this.graphics);
    }

    public void _invokePaint(IImage iImage, IImage iImage2, int n2, int n3, int n4, int n5) {
        if (!AppSettings.xrayView) {
            iImage2 = null;
        }
        if (this.graphics == null) {
            this.graphics = new Graphics(iImage, iImage2);
        }
        this.graphics._reset(iImage, iImage2);
        this.graphics.setClip(n2, n3, n4, n5);
        this.paint(this.graphics);
        this.graphics._reset(iImage, iImage2);
        this._paintOverlay(this.graphics);
    }

    protected void _paintOverlay(Graphics graphics) {
        super._paintTicker(graphics);
        super._paintSoftMenu(graphics);
        ArrayList<CanvasItem> arrayList = new ArrayList<CanvasItem>(this.nokiaCanvasItems);
        arrayList.sort(Comparator.comparingInt(CanvasItem::getZPosition));
        for (CanvasItem canvasItem : arrayList) {
            if (!canvasItem.isVisible()) continue;
            if (canvasItem instanceof CanvasGraphicsItem) {
                graphics.setClip(canvasItem.getPositionX(), canvasItem.getPositionY(), canvasItem.getWidth(), canvasItem.getHeight());
                graphics.translate(-canvasItem.getPositionX(), -canvasItem.getPositionY());
                ((CanvasGraphicsItem)canvasItem)._invokePaint(graphics);
                graphics.c();
                continue;
            }
            if (!(canvasItem instanceof TextEditor)) continue;
            ((TextEditor)canvasItem)._invokePaint(graphics);
        }
        if (!this.fullScreen) {
            int n2 = this.getWidth();
            int n3 = this.getActualHeight();
            int n4 = Screen.fontHeight4;
            graphics.setClip(0, 0, n2, Emulator.getEmulator().getScreen().getHeight());
            graphics.setColor(S.a);
            graphics.fillRect(0, n3, n2, n4);
            graphics.setFont(Font.getFont(0, 0, 8));
            graphics.setColor(S.b);
            graphics.drawString("Fake soft bar", n2 >> 1, n3 + 2, 17);
        }
    }

    public void _invokeKeyReleased(int n2) {
        int n3 = 1 << this.getGameAction(n2);
        if ((this.m_keyStates & n3) != 0) {
            this.m_keyStates &= ~n3;
        }
        if ((this.vKeyStates & (n3 = this.getKeyBit(n2))) != 0) {
            this.vKeyStates &= ~n3;
        }
        this.keyReleased(n2);
    }

    public void _invokeKeyPressed(int n2) {
        this.m_keyStates |= 1 << this.getGameAction(n2);
        this.vKeyStates |= this.getKeyBit(n2);
        this.keyPressed(n2);
    }

    public void _invokeKeyRepeated(int n2) {
        this.keyRepeated(n2);
    }

    public void _invokeHideNotify() {
        this.hideNotify();
    }

    public void _invokeShowNotify() {
        this.showNotify();
        IScreen iScreen = Emulator.getEmulator().getScreen();
        if (this.w != iScreen.getWidth() || this.h != this.getActualHeight()) {
            this._invokeSizeChanged(iScreen.getWidth(), iScreen.getHeight());
        }
    }

    int getActualHeight() {
        int n2 = Emulator.getEmulator().getScreen().getHeight();
        if (!this.fullScreen) {
            n2 -= this.ticker == null ? Screen.fontHeight4 : Screen.fontHeight4 * 2;
        }
        return n2;
    }

    @Override
    public void _invokeSizeChanged(int n2, int n3) {
        if (!this.fullScreen) {
            n3 -= this.ticker == null ? Screen.fontHeight4 : Screen.fontHeight4 * 2;
        }
        if (this.w != n2 || this.h != n3 || this.forceUpdateSize) {
            this.w = this.bounds[2] = n2;
            this.h = this.bounds[3] = n3;
            this.sizeChanged(n2, n3);
            if (!Settings.dontRepaintOnSetCurrent) {
                this.repaint();
            }
        }
    }

    protected abstract void paint(Graphics var1);

    protected void keyReleased(int n2) {
    }

    protected void keyPressed(int n2) {
    }

    protected void keyRepeated(int n2) {
    }

    public void repaint() {
        this.repaint(0, 0, this.w, this.h);
    }

    public void repaint(int n2, int n3, int n4, int n5) {
        if (this != Emulator.getCurrentDisplay().getCurrent()) {
            return;
        }
        Emulator.getEventQueue().a(n2, n3, n4, n5);
    }

    public void serviceRepaints() {
        if (this != Emulator.getCurrentDisplay().getCurrent()) {
            return;
        }
        Emulator.getEventQueue().d();
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    public void setFullScreenMode(boolean bl2) {
        if (!AppSettings.ignoreFullScreen) {
            if (bl2 == this.fullScreen) {
                return;
            }
            this.fullScreen = bl2;
            this.updateSize(true);
        } else if (!this.fullScreen) {
            this.fullScreen = true;
            this.updateSize(true);
        }
    }

    @Override
    protected void sizeChanged(int n2, int n3) {
    }

    protected void pointerPressed(int n2, int n3) {
    }

    protected void pointerReleased(int n2, int n3) {
    }

    protected void pointerDragged(int n2, int n3) {
    }

    public void invokePointerPressed(int n2, int n3) {
        CanvasItem canvasItem = this.getCanvasItemAt(n2, n3);
        if (canvasItem != null) {
            this.tappedCanvasItem = canvasItem;
            if (canvasItem instanceof TextEditor) {
                ((TextEditor)canvasItem).setFocus(true);
            }
            return;
        }
        this.pointerPressed(n2, n3);
    }

    public void invokePointerReleased(int n2, int n3) {
        if (this.tappedCanvasItem != null) {
            this.tappedCanvasItem = null;
            return;
        }
        this.pointerReleased(n2, n3);
    }

    public void invokePointerDragged(int n2, int n3) {
        if (this.tappedCanvasItem != null) {
            return;
        }
        this.pointerDragged(n2, n3);
    }

    public int getGameAction(int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (n2) {
            case 49: {
                n4 = 9;
                break;
            }
            case 51: {
                n4 = 10;
                break;
            }
            case 55: {
                n4 = 11;
                break;
            }
            case 57: {
                n4 = 12;
                break;
            }
            default: {
                if (n2 == n.a(1) || n2 == 50) {
                    n4 = 1;
                    break;
                }
                if (n2 == n.a(6) || n2 == 56) {
                    n4 = 6;
                    break;
                }
                if (n2 == n.a(2) || n2 == 52) {
                    n4 = 2;
                    break;
                }
                if (n2 == n.a(5) || n2 == 54) {
                    n4 = 5;
                    break;
                }
                if (n2 == n.a(8) || n2 == 53) {
                    n4 = 8;
                    break;
                }
                return n3;
            }
        }
        n3 = n4;
        return n3;
    }

    public int getKeyCode(int n2) {
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = n.a(1);
                break;
            }
            case 6: {
                n3 = n.a(6);
                break;
            }
            case 2: {
                n3 = n.a(2);
                break;
            }
            case 5: {
                n3 = n.a(5);
                break;
            }
            case 8: {
                n3 = n.a(8);
                break;
            }
            case 9: {
                n3 = 49;
                break;
            }
            case 10: {
                n3 = 51;
                break;
            }
            case 11: {
                n3 = 55;
                break;
            }
            case 12: {
                n3 = 57;
                break;
            }
        }
        return n3;
    }

    public String getKeyName(int n2) {
        if (n2 == 8) {
            return "Backspace";
        }
        if (n2 == 32) {
            return "Space";
        }
        if (n2 >= 32 && n2 <= 126) {
            return String.valueOf((char)n2);
        }
        String string = "";
        switch (n2) {
            case 48: {
                string = "0";
                break;
            }
            case 49: {
                string = "1";
                break;
            }
            case 50: {
                string = "2";
                break;
            }
            case 51: {
                string = "3";
                break;
            }
            case 52: {
                string = "4";
                break;
            }
            case 53: {
                string = "5";
                break;
            }
            case 54: {
                string = "6";
                break;
            }
            case 55: {
                string = "7";
                break;
            }
            case 56: {
                string = "8";
                break;
            }
            case 57: {
                string = "9";
                break;
            }
            case 42: {
                string = "*";
                break;
            }
            case 35: {
                string = "#";
                break;
            }
            default: {
                if (n2 == n.a(1)) {
                    string = "Up";
                    break;
                }
                if (n2 == n.a(6)) {
                    string = "Down";
                    break;
                }
                if (n2 == n.a(2)) {
                    string = "Left";
                    break;
                }
                if (n2 == n.a(5)) {
                    string = "Right";
                    break;
                }
                if (n2 == n.a(8)) {
                    string = "Select";
                    break;
                }
                return string;
            }
        }
        return string;
    }

    public boolean hasPointerEvents() {
        return AppSettings.hasPointerEvents;
    }

    public boolean hasPointerMotionEvents() {
        return AppSettings.hasPointerEvents;
    }

    public boolean hasRepeatEvents() {
        return AppSettings.enableKeyRepeat;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    private int getKeyBit(int n2) {
        switch (this.getGameAction(n2)) {
            case 1: {
                return 4096;
            }
            case 2: {
                return 8192;
            }
            case 5: {
                return 16384;
            }
            case 6: {
                return 32768;
            }
            case 8: {
                return 65536;
            }
            case 11: {
                return 524288;
            }
        }
        switch (n2) {
            case 48: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 42: {
                return 1024;
            }
            case 35: {
                return 2048;
            }
        }
        if (n.a(n2)) {
            return 131072;
        }
        if (n.b(n2)) {
            return 262144;
        }
        return 0;
    }

    public int _getKeyStatesVodafone() {
        return this.vKeyStates;
    }

    public void _removeNokiaCanvasItem(CanvasItem canvasItem) {
        this.nokiaCanvasItems.remove(canvasItem);
    }

    public void _addNokiaCanvasItem(CanvasItem canvasItem) {
        this.nokiaCanvasItems.add(canvasItem);
    }

    private CanvasItem getCanvasItemAt(int n2, int n3) {
        if (this.nokiaCanvasItems.isEmpty()) {
            return null;
        }
        for (CanvasItem canvasItem : this.nokiaCanvasItems) {
            if (!canvasItem.isVisible()) continue;
            int n4 = canvasItem.getPositionX();
            int n5 = canvasItem.getPositionY();
            if (n2 < n4 || n2 > n4 + canvasItem.getWidth() || n3 < n5 || n3 > n5 + canvasItem.getHeight()) continue;
            return canvasItem;
        }
        return null;
    }

    @Override
    void _defocus() {
        super._defocus();
        if (this.nokiaCanvasItems.isEmpty()) {
            return;
        }
        for (CanvasItem canvasItem : this.nokiaCanvasItems) {
            if (!canvasItem.isVisible() || !(canvasItem instanceof TextEditor)) continue;
            ((TextEditor)canvasItem).setFocus(false);
        }
    }
}

