/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.AppSettings;
import emulator.Emulator;
import emulator.Settings;
import emulator.debug.Profiler;
import emulator.n;
import emulator.s;
import emulator.ui.CommandsMenuPosition;
import emulator.ui.IScreen;
import emulator.ui.TargetedCommand;
import java.util.Arrays;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Ticker;
import kemnn.S;
import kemnn.aC;

public class Displayable {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int W = 2;
    public static final int H = 3;
    String title;
    Vector commands;
    CommandListener cmdListener = null;
    Item focusedItem = null;
    int w;
    int h;
    int[] bounds;
    Ticker ticker;
    int tickerX;
    private static long lastFrameTime;
    private static long lastFpsUpdateTime;
    private static int framesCount;
    boolean fullScreen;
    private static final long MILLI_TO_NANO = 1000000L;
    boolean forceUpdateSize;
    private Command leftCommand;
    private Command rightCommand;
    private final Vector menuCommands = new Vector();
    final Object lock = new Object();

    public Displayable() {
        this.commands = new Vector();
        IScreen iScreen = Emulator.getEmulator().getScreen();
        this.w = iScreen.getWidth();
        this.h = iScreen.getHeight();
        this.bounds = this instanceof Canvas ? new int[]{0, 0, this.w, this.h - Screen.fontHeight4} : new int[]{0, Screen.fontHeight4, this.w - 4, this.h - Screen.fontHeight4};
    }

    public int getWidth() {
        return this.bounds[2];
    }

    public int getHeight() {
        return this.bounds[3];
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isShown() {
        return Display.a == this && (!Settings.hideDisplayableOnMinimize || Emulator.getEmulator().getScreen().isShown());
    }

    void _defocus() {
        if (this.focusedItem != null) {
            this.focusedItem.b();
            this.focusedItem = null;
        }
    }

    void setItemCommands(Item item) {
        this.focusedItem = item;
        this.updateCommands();
    }

    void removeItemCommands(Item item) {
        if (item == null || item != this.focusedItem) {
            return;
        }
        this.focusedItem = null;
        this.updateCommands();
    }

    void updateCommands() {
        this.leftCommand = null;
        this.rightCommand = null;
        Object object = null;
        this.menuCommands.clear();
        Object[] objectArray = this.commands.toArray(new Command[0]);
        Arrays.sort(objectArray);
        this.menuCommands.addAll(Arrays.asList(objectArray));
        Object object2 = objectArray;
        int n2 = ((Object[])object2).length;
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            Object object3 = object2[i2];
            int n3 = ((Command)object3).getCommandType();
            switch (n3) {
                case 4: {
                    if (object != null) continue block4;
                    object = object3;
                    this.menuCommands.remove(object3);
                    this.menuCommands.insertElementAt(object3, 0);
                    continue block4;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    if (this.rightCommand != null) continue block4;
                    this.rightCommand = object3;
                    this.menuCommands.remove(object3);
                }
            }
        }
        if (this.rightCommand == null && this.menuCommands.size() > 1) {
            this.rightCommand = object2 = (Command)this.menuCommands.lastElement();
            this.menuCommands.remove(object2);
        }
        object2 = "";
        String string = "";
        if (this.hasMenuOnLeft()) {
            object2 = s.a("LCDUI_MENU_COMMAND", "Menu");
        } else if (!this.menuCommands.isEmpty()) {
            object2 = ((Command)this.menuCommands.get(0)).getLabel();
        } else if (this.leftCommand != null) {
            object2 = this.leftCommand.getLabel();
        }
        if (this.rightCommand != null) {
            string = this.rightCommand.getLabel();
        }
        Emulator.getEmulator().getScreen().setLeftSoftLabel((String)object2);
        Emulator.getEmulator().getScreen().setRightSoftLabel(string);
    }

    private boolean hasMenuOnLeft() {
        int n2 = this.menuCommands.size();
        if (this.focusedItem != null && !this.focusedItem.commands.isEmpty()) {
            n2 += this.focusedItem.commands.size();
        }
        return n2 > 1;
    }

    boolean isCommandsEmpty() {
        return this.commands.isEmpty();
    }

    public void addCommand(Command command) {
        if (command == null || this.commands.contains(command)) {
            return;
        }
        this.commands.add(command);
        if (this.isShown()) {
            this.updateCommands();
        }
    }

    public void removeCommand(Command command) {
        if (this.commands.contains(command)) {
            this.commands.remove(command);
            if (this.isShown()) {
                this.updateCommands();
            }
        }
    }

    Command getLeftSoftCommand() {
        if (this.focusedItem != null && !this.focusedItem.commands.isEmpty()) {
            return (Command)this.focusedItem.commands.get(0);
        }
        if (!this.menuCommands.isEmpty()) {
            return (Command)this.menuCommands.get(0);
        }
        return this.leftCommand;
    }

    Command getRightSoftCommand() {
        return this.rightCommand;
    }

    public boolean handleSoftKeyAction(int n2, boolean bl2) {
        boolean bl3;
        if (this.cmdListener == null && this instanceof Canvas) {
            return false;
        }
        boolean bl4 = bl3 = AppSettings.motorolaSoftKeyFix || AppSettings.softbankApi;
        if (n.a(n2)) {
            if (this.hasMenuOnLeft()) {
                if (bl2) {
                    Vector vector2 = this.buildAllCommands();
                    Emulator.getEmulator().getScreen().showCommandsList(vector2, CommandsMenuPosition.CommandsButton, 0, 0);
                }
                return !bl3;
            }
            Command command = this.getLeftSoftCommand();
            if (bl2 && command != null) {
                Emulator.getEmulator().getLogStream().println("Left command: " + command);
                if (this instanceof Alert && command == Alert.DISMISS_COMMAND) {
                    if (this.cmdListener != null) {
                        Emulator.getEventQueue().a(command, this);
                    } else {
                        ((Alert)this).close();
                    }
                } else if (this.focusedItem != null && this.focusedItem.commands.contains(command)) {
                    Emulator.getEventQueue().a(command, this.focusedItem);
                } else if (this.cmdListener != null) {
                    Emulator.getEventQueue().a(command, this);
                }
            }
            return command != null && !bl3;
        }
        if (n.b(n2)) {
            Command command = this.getRightSoftCommand();
            if (bl2 && command != null) {
                Emulator.getEmulator().getLogStream().println("Right command: " + command);
                if (this instanceof Alert && command == Alert.DISMISS_COMMAND) {
                    if (this.cmdListener != null) {
                        Emulator.getEventQueue().a(command, this);
                    } else {
                        ((Alert)this).close();
                    }
                } else if (this.focusedItem != null && this.focusedItem.commands.contains(command)) {
                    Emulator.getEventQueue().a(command, this.focusedItem);
                } else if (this.cmdListener != null) {
                    Emulator.getEventQueue().a(command, this);
                }
            }
            return command != null && !bl3;
        }
        return false;
    }

    public void _callCommandAction(Command command) {
        if (this.cmdListener != null && command != null) {
            this.cmdListener.commandAction(command, this);
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.cmdListener = commandListener;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.isShown()) {
            Emulator.getEmulator().getScreen().updateTitle();
        }
    }

    protected void sizeChanged(int n2, int n3) {
    }

    public void _invokeSizeChanged(int n2, int n3) {
        this._invokeSizeChanged(n2, n3, true);
    }

    void _invokeSizeChanged(int n2, int n3, boolean bl2) {
        if (this.w != n2 || this.h != n3 || this.forceUpdateSize) {
            this.forceUpdateSize = false;
            this.w = n2;
            this.h = n3;
            if (!this.fullScreen) {
                n3 -= this.ticker == null ? Screen.fontHeight4 : Screen.fontHeight4 * 2;
            }
            if (!(this instanceof Canvas)) {
                n2 -= 4;
            }
            this.bounds[2] = n2;
            this.bounds[3] = n3;
            if (bl2) {
                this.sizeChanged(n2, n3);
            }
        }
        this.repaintScreen();
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicker(Ticker ticker) {
        Object object = this.lock;
        synchronized (object) {
            this.ticker = ticker;
            this.tickerX = this.w;
            this.updateSize(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _paintTicker(Graphics graphics) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ticker == null) {
                if (!this.fullScreen && this instanceof Canvas) {
                    graphics.setColor(-1);
                    graphics.fillRect(0, this.bounds[3], this.w, Screen.fontHeight4);
                }
                return;
            }
            S.b(graphics, 0, Screen.fontHeight4 + this.bounds[3] - 1, this.w, Screen.fontHeight4);
            String string = this.ticker.getString();
            if (string == null) {
                return;
            }
            graphics.setFont(Screen.font);
            graphics.drawString(string, this.tickerX, Screen.fontHeight4 + this.bounds[3] - 1 + 2, 0);
            this.tickerX -= 5;
            if (this.tickerX < -Screen.font.stringWidth(string)) {
                this.tickerX = this.w;
            }
        }
    }

    void repaintScreen() {
        int n2;
        if (!this.isShown()) {
            return;
        }
        if (this instanceof Canvas) {
            n2 = 1;
        } else {
            if (!(this instanceof Screen)) {
                return;
            }
            n2 = 4;
        }
        try {
            Emulator.getEventQueue().d(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void repaintScreen(Item item) {
        this.repaintScreen();
    }

    void _paintSoftMenu(Graphics graphics) {
        aC.a(graphics, Emulator.getCurrentDisplay().getCurrent());
    }

    public static synchronized void _fpsLimiter(boolean bl2) {
        long l2;
        long l3;
        long l4;
        if (bl2 && (AppSettings.speedModifier == 1 || AppSettings.applySpeedToSleep) && AppSettings.frameRate <= 120 && (l4 = (l3 = 1000000000L / (long)AppSettings.frameRate) - (l2 = System.nanoTime() - lastFrameTime)) > 0L) {
            try {
                Thread.sleep(l4 / 1000000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        lastFrameTime = System.nanoTime();
        if (bl2) {
            ++framesCount;
        }
        if ((l2 = lastFrameTime - lastFpsUpdateTime) >= 2000000000L) {
            Profiler.FPS = (int)(((long)framesCount * 1000L + 500L) * 1000000L / l2);
            lastFpsUpdateTime = lastFrameTime;
            framesCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void _checkForSteps(Object object) {
        if (AppSettings.steps >= 0) {
            if (AppSettings.steps == 0) {
                long l2 = System.currentTimeMillis();
                try {
                    while (AppSettings.steps == 0) {
                        if (object == null) {
                            Thread.sleep(50L);
                            continue;
                        }
                        Object object2 = object;
                        synchronized (object2) {
                            object.wait(50L);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Settings.aLong1235 += System.currentTimeMillis() - l2;
            }
            --AppSettings.steps;
        }
    }

    public static void _resetXRayGraphics() {
        Graphics.b();
    }

    void _shown() {
        this.updateSize(false);
    }

    Vector buildAllCommands() {
        Vector vector2 = new Vector();
        Displayable.buildItemCommands(vector2, this.focusedItem);
        if (!vector2.isEmpty()) {
            vector2.add(null);
        }
        this.buildScreenCommands(vector2);
        return vector2;
    }

    static void buildItemCommands(Vector vector2, Item item) {
        if (item == null) {
            return;
        }
        Vector vector3 = item.commands;
        for (Command command : vector3) {
            vector2.add(new TargetedCommand(command, item));
        }
    }

    void buildScreenCommands(Vector vector2) {
        for (Command command : this.menuCommands) {
            vector2.add(new TargetedCommand(command, this));
        }
    }

    void updateSize(boolean bl2) {
        IScreen iScreen = Emulator.getEmulator().getScreen();
        if (bl2) {
            this.forceUpdateSize = true;
            this._invokeSizeChanged(iScreen.getWidth(), iScreen.getHeight(), false);
            this.forceUpdateSize = true;
        }
        if (Emulator.getCurrentDisplay().getCurrent() != this) {
            return;
        }
        Emulator.getEventQueue().a(iScreen.getWidth(), iScreen.getHeight());
    }

    static {
        lastFpsUpdateTime = lastFrameTime = System.nanoTime();
        framesCount = 0;
    }
}

