/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class LayerManager {
    private int size;
    private Layer[] layers = new Layer[4];
    private int x;
    private int y;
    private int width;
    private int height;

    public LayerManager() {
        this.setViewWindow(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void append(Layer layer) {
        this.insert(layer, this.size);
    }

    public void insert(Layer layer, int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.remove(layer);
        if (this.size == this.layers.length) {
            Layer[] layerArray = new Layer[this.size + 4];
            System.arraycopy(this.layers, 0, layerArray, 0, this.size);
            System.arraycopy(this.layers, n2, layerArray, n2 + 1, this.size - n2);
            this.layers = layerArray;
        } else {
            System.arraycopy(this.layers, n2, this.layers, n2 + 1, this.size - n2);
        }
        this.layers[n2] = layer;
        ++this.size;
    }

    public Layer getLayerAt(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.layers[n2];
    }

    public int getSize() {
        return this.size;
    }

    public void remove(Layer layer) {
        if (layer == null) {
            throw new NullPointerException();
        }
        int n2 = this.size;
        while (--n2 >= 0) {
            if (this.layers[n2] != layer) continue;
            System.arraycopy(this.layers, n2 + 1, this.layers, n2, this.size - n2 - 1);
            this.layers[--this.size] = null;
            break;
        }
    }

    public void paint(Graphics graphics, int n2, int n3) {
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.translate(n2 - this.x, n3 - this.y);
        graphics.clipRect(this.x, this.y, this.width, this.height);
        int n8 = this.size;
        while (--n8 >= 0) {
            Layer layer = this.layers[n8];
            if (!layer.visible) continue;
            layer.paint(graphics);
        }
        graphics.translate(-n2 + this.x, -n3 + this.y);
        graphics.setClip(n4, n5, n6, n7);
    }

    public void setViewWindow(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    private void method213(Layer layer, int n2) {
        if (this.size == this.layers.length) {
            Layer[] layerArray = new Layer[this.size + 4];
            System.arraycopy(this.layers, 0, layerArray, 0, this.size);
            System.arraycopy(this.layers, n2, layerArray, n2 + 1, this.size - n2);
            this.layers = layerArray;
        } else {
            System.arraycopy(this.layers, n2, this.layers, n2 + 1, this.size - n2);
        }
        this.layers[n2] = layer;
        ++this.size;
    }
}

