/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Object3D;

public class Material
extends Object3D {
    public static final int AMBIENT = 1024;
    public static final int DIFFUSE = 2048;
    public static final int EMISSIVE = 4096;
    public static final int SPECULAR = 8192;
    private boolean vertexColorTracking = false;
    private int ambientColor = 0x333333;
    private int diffuseColor = -3355444;
    private int emissiveColor = 0;
    private int specularColor = 0;
    private float shininess = 0.0f;

    public void setColor(int n2, int n3) {
        if ((n2 & 0x400) == 0 && (n2 & 0x800) == 0 && (n2 & 0x1000) == 0 && (n2 & 0x2000) == 0) {
            throw new IllegalArgumentException();
        }
        if ((n2 & 0x400) != 0) {
            this.ambientColor = n3;
        }
        if ((n2 & 0x800) != 0) {
            this.diffuseColor = n3;
        }
        if ((n2 & 0x1000) != 0) {
            this.emissiveColor = n3;
        }
        if ((n2 & 0x2000) != 0) {
            this.specularColor = n3;
        }
    }

    public int getColor(int n2) {
        if (n2 != 1024 && n2 != 2048 && n2 != 4096 && n2 != 8192) {
            throw new IllegalArgumentException();
        }
        return n2 == 1024 ? this.ambientColor : (n2 == 2048 ? this.diffuseColor : (n2 == 4096 ? this.emissiveColor : (n2 == 8192 ? this.specularColor : 0)));
    }

    public void setShininess(float f2) {
        if (!(f2 >= 0.0f) || !(f2 <= 128.0f)) {
            throw new IllegalArgumentException();
        }
        this.shininess = f2;
    }

    public float getShininess() {
        return this.shininess;
    }

    public void setVertexColorTrackingEnable(boolean bl2) {
        this.vertexColorTracking = bl2;
    }

    public boolean isVertexColorTrackingEnabled() {
        return this.vertexColorTracking;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 256: {
                this.diffuseColor = this.diffuseColor & 0xFFFFFF | G3DUtils.getIntColor(fArray) & 0xFF000000;
                return;
            }
            case 257: {
                this.ambientColor = G3DUtils.getIntColor(fArray);
                return;
            }
            default: {
                super.updateProperty(n2, fArray);
                return;
            }
            case 261: {
                this.diffuseColor = this.diffuseColor & 0xFF000000 | G3DUtils.getIntColor(fArray) & 0xFFFFFF;
                return;
            }
            case 262: {
                this.emissiveColor = G3DUtils.getIntColor(fArray);
                return;
            }
            case 271: {
                this.shininess = G3DUtils.limit(fArray[0], 0.0f, 128.0f);
                return;
            }
            case 272: 
        }
        this.specularColor = G3DUtils.getIntColor(fArray);
    }
}

