/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.m3g.MeshMorph;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;

public class MorphingMesh
extends Mesh {
    private VertexBuffer[] aVertexBufferArray937;
    private float[] weights;
    public float m_baseWeight;

    public MorphingMesh(VertexBuffer vertexBuffer, VertexBuffer[] vertexBufferArray, IndexBuffer indexBuffer, Appearance appearance) {
        super(vertexBuffer, indexBuffer, appearance);
        if (vertexBufferArray == null) {
            throw new NullPointerException();
        }
        this.aVertexBufferArray937 = new VertexBuffer[vertexBufferArray.length];
        for (int i2 = vertexBufferArray.length - 1; i2 >= 0; --i2) {
            if (vertexBufferArray[i2] == null) {
                throw new NullPointerException();
            }
            if (vertexBufferArray[i2].getVertexCount() == 0) {
                throw new IllegalArgumentException("targets is empty");
            }
            this.aVertexBufferArray937[i2] = vertexBufferArray[i2];
            this.addReference(this.aVertexBufferArray937[i2]);
        }
        this.weights = new float[this.aVertexBufferArray937.length];
        this.m_baseWeight = 1.0f;
    }

    public MorphingMesh(VertexBuffer vertexBuffer, VertexBuffer[] vertexBufferArray, IndexBuffer[] indexBufferArray, Appearance[] appearanceArray) {
        super(vertexBuffer, indexBufferArray, appearanceArray);
        this.aVertexBufferArray937 = new VertexBuffer[vertexBufferArray.length];
        for (int i2 = vertexBufferArray.length - 1; i2 >= 0; --i2) {
            if (vertexBufferArray[i2] == null) {
                throw new NullPointerException();
            }
            if (vertexBufferArray[i2].getVertexCount() == 0) {
                throw new IllegalArgumentException("targets is empty");
            }
            this.aVertexBufferArray937[i2] = vertexBufferArray[i2];
            this.addReference(this.aVertexBufferArray937[i2]);
        }
        this.weights = new float[this.aVertexBufferArray937.length];
        this.m_baseWeight = 1.0f;
    }

    @Override
    protected Object3D duplicateObject() {
        MorphingMesh morphingMesh = (MorphingMesh)super.duplicateObject();
        ((MorphingMesh)super.duplicateObject()).weights = (float[])this.weights.clone();
        morphingMesh.aVertexBufferArray937 = (VertexBuffer[])this.aVertexBufferArray937.clone();
        return morphingMesh;
    }

    public VertexBuffer getMorphTarget(int n2) {
        if (n2 >= 0 && n2 < this.aVertexBufferArray937.length) {
            return this.aVertexBufferArray937[n2];
        }
        throw new IndexOutOfBoundsException();
    }

    public int getMorphTargetCount() {
        return this.aVertexBufferArray937.length;
    }

    public void setWeights(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < this.weights.length) {
            throw new IllegalArgumentException();
        }
        this.m_baseWeight = 1.0f;
        for (int i2 = 0; i2 < this.weights.length; ++i2) {
            this.weights[i2] = fArray[i2];
            this.m_baseWeight -= fArray[i2];
        }
    }

    public void getWeights(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < this.weights.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.weights, 0, fArray, 0, this.weights.length);
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 266: {
                this.m_baseWeight = 1.0f;
                for (int i2 = 0; i2 < this.weights.length; ++i2) {
                    if (i2 < fArray.length) {
                        this.weights[i2] = fArray[i2];
                        this.m_baseWeight -= fArray[i2];
                        continue;
                    }
                    this.weights[i2] = 0.0f;
                }
                return;
            }
        }
        super.updateProperty(n2, fArray);
    }

    @Override
    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform) {
        MeshMorph.getInstance().getMorphedVertexBuffer(this);
        MeshMorph.getInstance().clearCache();
        return super.rayIntersect(n2, fArray, rayIntersection, transform, MeshMorph.getInstance().morphed);
    }

    public float getBaseWeight() {
        return this.m_baseWeight;
    }
}

