/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.util.Vector;
import javax.microedition.m3g.AnimationTrack;
import javax.microedition.m3g.Node;

public abstract class Object3D
implements Cloneable {
    int userID = 0;
    Object userObject = null;
    Vector animationTracks = new Vector();
    Vector references = new Vector();

    public final int animate(int n2) {
        int n3 = this.animation(n2);
        for (Object e2 : this.references) {
            n3 = Math.min(n3, ((Object3D)e2).animate(n2));
        }
        return n3;
    }

    protected final int animation(int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < this.animationTracks.size()) {
            AnimationTrack animationTrack = (AnimationTrack)this.animationTracks.elementAt(n4);
            int n5 = animationTrack.getTargetProperty();
            float[] fArray = new float[animationTrack.getKeyframeSequence().getComponentCount()];
            float[] fArray2 = new float[2];
            float f2 = 0.0f;
            do {
                animationTrack.getContribution(n2, fArray, fArray2);
                f2 += fArray2[0];
                n3 = Math.min(n3, (int)fArray2[1]);
            } while (++n4 != this.animationTracks.size() && (animationTrack = (AnimationTrack)this.animationTracks.elementAt(n4)).getTargetProperty() == n5);
            if (!(f2 > 0.0f)) continue;
            this.updateProperty(n5, fArray);
        }
        return n3;
    }

    protected void updateProperty(int n2, float[] fArray) {
        throw new Error("Invalid animation target property!");
    }

    public final Object3D duplicate() {
        Object3D object3D = this.duplicateObject();
        if (this instanceof Node) {
            Node node = (Node)this;
            node.updateAlignReferences();
            node.clearAlignReferences();
        }
        return object3D;
    }

    protected Object3D duplicateObject() {
        Object3D object3D = null;
        try {
            object3D = (Object3D)this.clone();
            ((Object3D)this.clone()).references = (Vector)this.references.clone();
            object3D.animationTracks = (Vector)this.animationTracks.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object3D;
    }

    public Object3D find(int n2) {
        if (this.userID == n2) {
            return this;
        }
        Object3D object3D = null;
        for (int i2 = 0; i2 < this.references.size() && (object3D = ((Object3D)this.references.get(i2)).find(n2)) == null; ++i2) {
        }
        return object3D;
    }

    public int getReferences(Object3D[] object3DArray) {
        if (object3DArray != null && object3DArray.length < this.getReferences(null)) {
            throw new IllegalArgumentException();
        }
        if (object3DArray != null) {
            for (int i2 = 0; i2 < this.references.size(); ++i2) {
                object3DArray[i2] = (Object3D)this.references.get(i2);
            }
        }
        return this.references.size();
    }

    public void setUserID(int n2) {
        this.userID = n2;
    }

    public int getUserID() {
        return this.userID;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void addAnimationTrack(AnimationTrack animationTrack) {
        if (animationTrack == null) {
            throw new NullPointerException();
        }
        if (!this.animationTracks.contains(animationTrack) && animationTrack.checkCompatible(this)) {
            int n2 = animationTrack.getKeyframeSequence().getComponentCount();
            int n3 = animationTrack.getTargetProperty();
            for (int i2 = 0; i2 < this.animationTracks.size(); ++i2) {
                AnimationTrack animationTrack2 = (AnimationTrack)this.animationTracks.get(i2);
                if (animationTrack2.getTargetProperty() > n3) {
                    this.animationTracks.insertElementAt(animationTrack, i2);
                    this.addReference(animationTrack);
                    return;
                }
                if (animationTrack2.getTargetProperty() != n3 || animationTrack2.getKeyframeSequence().getComponentCount() == n2) continue;
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.animationTracks.addElement(animationTrack);
        this.addReference(animationTrack);
    }

    public AnimationTrack getAnimationTrack(int n2) {
        if (n2 >= 0 && n2 < this.animationTracks.size()) {
            return (AnimationTrack)this.animationTracks.elementAt(n2);
        }
        throw new IndexOutOfBoundsException();
    }

    public void removeAnimationTrack(AnimationTrack animationTrack) {
        if (this.animationTracks.contains(animationTrack)) {
            this.animationTracks.remove(animationTrack);
            this.removeReference(animationTrack);
        }
    }

    public int getAnimationTrackCount() {
        return this.animationTracks.size();
    }

    protected void addReference(Object3D object3D) {
        if (object3D != null) {
            this.references.add(object3D);
        }
    }

    protected void removeReference(Object3D object3D) {
        if (object3D != null) {
            this.references.remove(object3D);
        }
    }
}

