/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Transformable;

public class Texture2D
extends Transformable {
    public static final int FILTER_BASE_LEVEL = 208;
    public static final int FILTER_LINEAR = 209;
    public static final int FILTER_NEAREST = 210;
    public static final int FUNC_ADD = 224;
    public static final int FUNC_BLEND = 225;
    public static final int FUNC_DECAL = 226;
    public static final int FUNC_MODULATE = 227;
    public static final int FUNC_REPLACE = 228;
    public static final int WRAP_CLAMP = 240;
    public static final int WRAP_REPEAT = 241;
    private Image2D image;
    private int wrappingS;
    private int wrappingT;
    private int levelFilter;
    private int imageFilter;
    private int blending;
    private int blendColor;

    public Texture2D(Image2D image2D) {
        this.setImage(image2D);
        this.wrappingS = 241;
        this.wrappingT = 241;
        this.levelFilter = 208;
        this.imageFilter = 210;
        this.blending = 227;
        this.blendColor = 0;
    }

    private static boolean isPow2(int n2) {
        return (n2 & n2 - 1) == 0;
    }

    public void setImage(Image2D image2D) {
        if (image2D == null) {
            throw new NullPointerException();
        }
        int n2 = image2D.getWidth();
        int n3 = image2D.getHeight();
        if (Texture2D.isPow2(n2) && Texture2D.isPow2(n3)) {
            if (n2 > 2048 || n3 > 2048) {
                throw new IllegalArgumentException("the width or height of image exceeds the MaxTextureDimension :2048");
            }
        } else {
            throw new IllegalArgumentException("the width or height of image is not a positive power of two");
        }
        this.removeReference(this.image);
        this.image = image2D;
        this.addReference(this.image);
    }

    public Image2D getImage() {
        return this.image;
    }

    public void setFiltering(int n2, int n3) {
        if (n2 != 208 && n2 != 209 && n2 != 210) {
            throw new IllegalArgumentException();
        }
        if (n3 != 209 && n3 != 210) {
            throw new IllegalArgumentException();
        }
        this.levelFilter = n2;
        this.imageFilter = n3;
    }

    public int getLevelFilter() {
        return this.levelFilter;
    }

    public int getImageFilter() {
        return this.imageFilter;
    }

    public void setWrapping(int n2, int n3) {
        if (n2 != 240 && n2 != 241) {
            throw new IllegalArgumentException();
        }
        if (n3 != 240 && n3 != 241) {
            throw new IllegalArgumentException();
        }
        this.wrappingS = n2;
        this.wrappingT = n3;
    }

    public int getWrappingS() {
        return this.wrappingS;
    }

    public int getWrappingT() {
        return this.wrappingT;
    }

    public void setBlending(int n2) {
        if (n2 < 224 || n2 > 228) {
            throw new IllegalArgumentException();
        }
        this.blending = n2;
    }

    public int getBlending() {
        return this.blending;
    }

    public void setBlendColor(int n2) {
        this.blendColor = n2;
    }

    public int getBlendColor() {
        return this.blendColor;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 258: {
                this.blendColor = G3DUtils.getIntColor(fArray);
                return;
            }
        }
        super.updateProperty(n2, fArray);
    }
}

