/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Transform3D;
import javax.microedition.m3g.VertexArray;

public class Transform {
    private Transform3D impl;

    public Transform() {
        this.impl = new Transform3D();
    }

    public Transform(Transform transform) {
        if (transform == null) {
            throw new NullPointerException();
        }
        this.impl = new Transform3D();
        this.impl.set(transform.impl);
    }

    Transform3D getImpl_() {
        return this.impl;
    }

    public Object getImpl() {
        return this.impl;
    }

    public void setIdentity() {
        this.impl.setIdentity();
    }

    public void set(Transform transform) {
        if (transform == null) {
            throw new NullPointerException();
        }
        this.impl.set(transform.impl);
    }

    public void set(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < 16) {
            throw new IllegalArgumentException();
        }
        this.impl.set(fArray);
    }

    public void get(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < 16) {
            throw new IllegalArgumentException();
        }
        this.impl.get(fArray);
    }

    public void invert() {
        this.impl.invert();
    }

    public void transpose() {
        this.impl.transpose();
    }

    public void postMultiply(Transform transform) {
        if (transform == null) {
            throw new NullPointerException();
        }
        this.impl.postMultiply(transform.impl, false);
    }

    public void preMultiply(Transform transform) {
        this.impl.postMultiply(transform.impl, true);
    }

    public void postScale(float f2, float f3, float f4) {
        this.impl.postScale(f2, f3, f4);
    }

    public void postRotate(float f2, float f3, float f4, float f5) {
        if (f3 == 0.0f && f4 == 0.0f && f5 == 0.0f && f2 != 0.0f) {
            throw new IllegalArgumentException();
        }
        this.impl.postRotate(f2, f3, f4, f5);
    }

    public void postRotateQuat(float f2, float f3, float f4, float f5) {
        if (f2 == 0.0f && f3 == 0.0f && f4 == 0.0f && f5 == 0.0f) {
            throw new IllegalArgumentException();
        }
        this.impl.postRotateQuat(f2, f3, f4, f5);
    }

    public void postTranslate(float f2, float f3, float f4) {
        this.impl.postTranslate(f2, f3, f4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(VertexArray vertexArray, float[] fArray, boolean bl2) {
        if (vertexArray == null || fArray == null) throw new NullPointerException();
        if (vertexArray.getComponentCount() == 4 || fArray.length < 4 * vertexArray.getVertexCount()) throw new IllegalArgumentException();
        boolean bl3 = bl2;
        int n2 = vertexArray.getVertexCount();
        int n3 = vertexArray.getComponentCount();
        int n4 = n2 * 4;
        int n5 = 0;
        int n6 = 0;
        if (vertexArray.getComponentType() == 1) {
            byte[] byArray = new byte[n2 * n3];
            vertexArray.get(0, n2, byArray);
            while (n5 < n4) {
                if (n5 % 4 < n3) {
                    fArray[n5++] = byArray[n6++];
                    continue;
                }
                fArray[n5++] = (float)bl3;
            }
        } else {
            short[] sArray = new short[n2 * n3];
            vertexArray.get(0, n2, sArray);
            while (n5 < n4) {
                if (n5 % 4 < n3) {
                    fArray[n5++] = sArray[n6++];
                    continue;
                }
                fArray[n5++] = (float)bl3;
            }
        }
        this.impl.transform(fArray);
    }

    public void transform(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length % 4 != 0) {
            throw new IllegalArgumentException();
        }
        this.impl.transform(fArray);
    }
}

