/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Object3D;

public class VertexArray
extends Object3D {
    private int componentType;
    private int vertexCount;
    private int componentCount;
    private byte[] byteValues;
    private short[] shortValues;

    public VertexArray(int n2, int n3, int n4) {
        if (!(n2 < 1 || n2 > 65535 || n3 < 2 && n3 > 4 || n4 < 1 && n4 > 2)) {
            this.vertexCount = n2;
            this.componentCount = n3;
            this.componentType = n4;
            if (this.componentType == 1) {
                this.byteValues = new byte[n2 * n3];
            } else {
                this.shortValues = new short[n2 * n3];
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected Object3D duplicateObject() {
        VertexArray vertexArray = (VertexArray)super.duplicateObject();
        if (this.componentType == 1) {
            vertexArray.byteValues = (byte[])this.byteValues.clone();
        } else {
            vertexArray.shortValues = (short[])this.shortValues.clone();
        }
        return vertexArray;
    }

    public void set(int n2, int n3, short[] sArray) {
        if (sArray == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 2) {
            throw new IllegalStateException();
        }
        if (n3 < 0 || sArray.length < n3 * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 + n3 > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(sArray, 0, this.shortValues, n2 * this.componentCount, n3 * this.componentCount);
    }

    public void set(int n2, int n3, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 1) {
            throw new IllegalStateException();
        }
        if (n3 < 0 || byArray.length < n3 * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 + n3 > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(byArray, 0, this.byteValues, n2 * this.componentCount, n3 * this.componentCount);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public void get(int n2, int n3, short[] sArray) {
        if (sArray == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 2) {
            throw new IllegalStateException();
        }
        if (n3 < 0 || sArray.length < n3 * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 + n3 > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.shortValues, n2 * this.componentCount, sArray, 0, n3 * this.componentCount);
    }

    public void get(int n2, int n3, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 1) {
            throw new IllegalStateException();
        }
        if (n3 < 0 || byArray.length < n3 * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 + n3 > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.byteValues, n2 * this.componentCount, byArray, 0, n3 * this.componentCount);
    }

    public byte[] getByteValues() {
        return this.byteValues;
    }

    public short[] getShortValues() {
        return this.shortValues;
    }

    private boolean equals_(VertexArray vertexArray) {
        return vertexArray != null && this.componentType == vertexArray.componentType && this.componentCount == vertexArray.componentCount && this.vertexCount == vertexArray.vertexCount;
    }

    public void morph(VertexArray[] vertexArrayArray, VertexArray vertexArray, float[] fArray, float f2) {
        int n2;
        VertexArray[] vertexArrayArray2 = vertexArrayArray;
        int n3 = vertexArrayArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            VertexArray vertexArray2 = vertexArrayArray2[n2];
            if (this.equals_(vertexArray2)) continue;
            throw new IllegalStateException();
        }
        if (this.componentType == 1) {
            for (int i2 = 0; i2 < this.byteValues.length; ++i2) {
                float f3 = 0.0f;
                for (n2 = 0; n2 < vertexArrayArray.length; ++n2) {
                    f3 += (float)vertexArrayArray[n2].byteValues[i2] * fArray[n2];
                }
                this.byteValues[i2] = (byte)G3DUtils.round(f3 += (float)vertexArray.byteValues[i2] * f2);
            }
        } else {
            for (int i3 = 0; i3 < this.shortValues.length; ++i3) {
                float f4 = 0.0f;
                for (n2 = 0; n2 < vertexArrayArray.length; ++n2) {
                    f4 += (float)vertexArrayArray[n2].shortValues[i3] * fArray[n2];
                }
                this.shortValues[i3] = (short)G3DUtils.round(f4 += (float)vertexArray.shortValues[i3] * f2);
            }
        }
    }

    public void morphColors(VertexArray[] vertexArrayArray, VertexArray vertexArray, float[] fArray, float f2) {
        int n2;
        VertexArray[] vertexArrayArray2 = vertexArrayArray;
        int n3 = vertexArrayArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            VertexArray vertexArray2 = vertexArrayArray2[n2];
            if (this.equals_(vertexArray2)) continue;
            throw new IllegalStateException();
        }
        if (this.componentType == 1) {
            for (int i2 = 0; i2 < this.byteValues.length; ++i2) {
                float f3 = 0.0f;
                for (n2 = 0; n2 < vertexArrayArray.length; ++n2) {
                    f3 += (float)(vertexArrayArray[n2].byteValues[i2] & 0xFF) * fArray[n2];
                }
                this.byteValues[i2] = (byte)G3DUtils.limit(G3DUtils.round(f3 += (float)(vertexArray.byteValues[i2] & 0xFF) * f2), 0, 255);
            }
        }
    }
}

