/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.VertexArray;

public class VertexBuffer
extends Object3D {
    private int vertexCount = 0;
    private VertexArray positions = null;
    private VertexArray normals = null;
    private VertexArray[] uvms = new VertexArray[10];
    private VertexArray colors = null;
    private int defaultColor = -1;
    private float[] posScaleBias = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    private float[][] uvScaleBias = new float[10][4];
    private int arraysCount = 0;

    @Override
    protected Object3D duplicateObject() {
        VertexBuffer vertexBuffer = (VertexBuffer)super.duplicateObject();
        vertexBuffer.uvms = (VertexArray[])this.uvms.clone();
        vertexBuffer.posScaleBias = (float[])this.posScaleBias.clone();
        vertexBuffer.uvScaleBias = new float[10][4];
        for (int i2 = 0; i2 < 10; ++i2) {
            vertexBuffer.uvScaleBias[i2] = (float[])this.uvScaleBias[i2].clone();
        }
        return vertexBuffer;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public void setPositions(VertexArray vertexArray, float f2, float[] fArray) {
        if (vertexArray != null && vertexArray.getComponentCount() != 3) {
            throw new IllegalArgumentException();
        }
        if (vertexArray != null && fArray != null && fArray.length < 3) {
            throw new IllegalArgumentException();
        }
        if (vertexArray != null && this.vertexCount != 0 && vertexArray.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        this.removeReference(this.positions);
        if (vertexArray != null) {
            if (this.positions == null) {
                ++this.arraysCount;
            }
            this.vertexCount = vertexArray.getVertexCount();
            this.positions = vertexArray;
            this.posScaleBias[0] = f2;
            if (fArray != null) {
                System.arraycopy(fArray, 0, this.posScaleBias, 1, 3);
            } else {
                this.posScaleBias[1] = 0.0f;
                this.posScaleBias[2] = 0.0f;
                this.posScaleBias[3] = 0.0f;
            }
        } else if (this.positions != null) {
            this.positions = null;
            --this.arraysCount;
            this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
        }
        this.addReference(this.positions);
    }

    public void setTexCoords(int n2, VertexArray vertexArray, float f2, float[] fArray) {
        if (vertexArray != null && vertexArray.getComponentCount() != 2 && vertexArray.getComponentCount() != 3) {
            throw new IllegalArgumentException();
        }
        if (vertexArray != null && this.vertexCount != 0 && vertexArray.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        if (vertexArray != null && fArray != null && fArray.length < vertexArray.getComponentCount()) {
            throw new IllegalArgumentException();
        }
        if (n2 >= 0 && n2 < 10) {
            this.removeReference(this.uvms[n2]);
            if (vertexArray != null) {
                if (this.uvms[n2] == null) {
                    ++this.arraysCount;
                }
                this.vertexCount = vertexArray.getVertexCount();
                this.uvms[n2] = vertexArray;
                this.uvScaleBias[n2][0] = f2;
                this.uvScaleBias[n2][1] = 0.0f;
                this.uvScaleBias[n2][2] = 0.0f;
                this.uvScaleBias[n2][3] = 0.0f;
                if (fArray != null) {
                    System.arraycopy(fArray, 0, this.uvScaleBias[n2], 1, vertexArray.getComponentCount());
                }
            } else if (this.uvms[n2] != null) {
                this.uvms[n2] = null;
                --this.arraysCount;
                this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.addReference(this.uvms[n2]);
    }

    public void setNormals(VertexArray vertexArray) {
        if (vertexArray != null && vertexArray.getComponentCount() != 3) {
            throw new IllegalArgumentException();
        }
        if (vertexArray != null && this.vertexCount != 0 && vertexArray.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        this.removeReference(this.normals);
        if (vertexArray != null) {
            if (this.normals == null) {
                ++this.arraysCount;
            }
            this.vertexCount = vertexArray.getVertexCount();
            this.normals = vertexArray;
        } else if (this.normals != null) {
            this.normals = null;
            --this.arraysCount;
            this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
        }
        this.addReference(this.normals);
    }

    public void setColors(VertexArray vertexArray) {
        if (vertexArray != null && vertexArray.getComponentType() != 1) {
            throw new IllegalArgumentException();
        }
        if (vertexArray != null && vertexArray.getComponentCount() != 3 && vertexArray.getComponentCount() != 4) {
            throw new IllegalArgumentException();
        }
        if (vertexArray != null && this.vertexCount != 0 && vertexArray.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        this.removeReference(this.colors);
        if (vertexArray != null) {
            if (this.colors == null) {
                ++this.arraysCount;
            }
            this.vertexCount = vertexArray.getVertexCount();
            this.colors = vertexArray;
        } else if (this.colors != null) {
            this.colors = null;
            --this.arraysCount;
            this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
        }
        this.addReference(this.colors);
    }

    public VertexArray getPositions(float[] fArray) {
        if (fArray != null && fArray.length < 4) {
            throw new IllegalArgumentException();
        }
        if (this.positions != null && fArray != null) {
            System.arraycopy(this.posScaleBias, 0, fArray, 0, 4);
        }
        return this.positions;
    }

    public VertexArray getTexCoords(int n2, float[] fArray) {
        if (n2 >= 0 && n2 < 10) {
            if (this.uvms[n2] != null && fArray != null) {
                if (fArray.length < this.uvms[n2].getComponentCount() + 1) {
                    throw new IllegalArgumentException();
                }
                System.arraycopy(this.uvScaleBias[n2], 0, fArray, 0, this.uvms[n2].getComponentCount() + 1);
            }
            return this.uvms[n2];
        }
        throw new IndexOutOfBoundsException();
    }

    public VertexArray getNormals() {
        return this.normals;
    }

    public VertexArray getColors() {
        return this.colors;
    }

    public void setDefaultColor(int n2) {
        this.defaultColor = n2;
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 256: {
                this.defaultColor &= 0xFFFFFF;
                this.defaultColor |= G3DUtils.getIntColor(fArray) & 0xFF000000;
                return;
            }
            case 258: {
                this.defaultColor &= 0xFF000000;
                this.defaultColor |= G3DUtils.getIntColor(fArray) & 0xFFFFFF;
                return;
            }
        }
        super.updateProperty(n2, fArray);
    }

    protected boolean getNormalVertex(int n2, Vector4f vector4f) {
        float f2;
        float f3;
        float f4;
        if (this.normals == null) {
            return false;
        }
        if (this.normals.getComponentType() == 1) {
            byte[] byArray = new byte[3];
            this.normals.get(n2, 1, byArray);
            f4 = byArray[0];
            f3 = byArray[1];
            f2 = byArray[2];
        } else {
            short[] sArray = new short[3];
            this.normals.get(n2, 1, sArray);
            f4 = sArray[0];
            f3 = sArray[1];
            f2 = sArray[2];
        }
        vector4f.set(f4, f3, f2, 1.0f);
        return true;
    }

    protected void getVertex(int n2, Vector4f vector4f) {
        float f2;
        float f3;
        float f4;
        if (this.positions.getComponentType() == 1) {
            byte[] byArray = new byte[3];
            this.positions.get(n2, 1, byArray);
            f4 = byArray[0];
            f3 = byArray[1];
            f2 = byArray[2];
        } else {
            short[] sArray = new short[3];
            this.positions.get(n2, 1, sArray);
            f4 = sArray[0];
            f3 = sArray[1];
            f2 = sArray[2];
        }
        f4 *= this.posScaleBias[0];
        f3 *= this.posScaleBias[0];
        f2 *= this.posScaleBias[0];
        vector4f.set(f4 += this.posScaleBias[1], f3 += this.posScaleBias[2], f2 += this.posScaleBias[3], 1.0f);
    }

    protected boolean getTexVertex(int n2, int n3, Vector4f vector4f) {
        float f2;
        float f3;
        float f4;
        if (this.uvms[n3] == null) {
            return false;
        }
        int n4 = this.uvms[n3].getComponentCount();
        if (this.uvms[n3].getComponentType() == 1) {
            byte[] byArray = new byte[n4];
            this.uvms[n3].get(n2, 1, byArray);
            f4 = byArray[0];
            f3 = byArray[1];
            f2 = n4 == 3 ? (float)byArray[2] : 0.0f;
        } else {
            short[] sArray = new short[n4];
            this.uvms[n3].get(n2, 1, sArray);
            f4 = sArray[0];
            f3 = sArray[1];
            f2 = n4 == 3 ? (float)sArray[2] : 0.0f;
        }
        f4 *= this.uvScaleBias[n3][0];
        f3 *= this.uvScaleBias[n3][0];
        f2 *= this.uvScaleBias[n3][0];
        vector4f.set(f4 += this.uvScaleBias[n3][1], f3 += this.uvScaleBias[n3][2], f2 += this.uvScaleBias[n3][3], 1.0f);
        return true;
    }
}

