/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component$Identifier;
import net.java.games.input.Component$Identifier$Axis;
import net.java.games.input.Component$Identifier$Button;
import net.java.games.input.Event;
import net.java.games.input.WinTabButtonComponent;
import net.java.games.input.WinTabContext;
import net.java.games.input.WinTabCursorComponent;
import net.java.games.input.WinTabPacket;

public class WinTabComponent
extends AbstractComponent {
    public static final int XAxis = 1;
    public static final int YAxis = 2;
    public static final int ZAxis = 3;
    public static final int NPressureAxis = 4;
    public static final int TPressureAxis = 5;
    public static final int OrientationAxis = 6;
    public static final int RotationAxis = 7;
    private int min;
    private int max;
    protected float lastKnownValue;
    private boolean analog;
    static Class class$net$java$games$input$Component$Identifier$Button;

    protected WinTabComponent(WinTabContext winTabContext, int n2, String string, Component$Identifier component$Identifier, int n3, int n4) {
        super(string, component$Identifier);
        this.min = n3;
        this.max = n4;
        this.analog = true;
    }

    protected WinTabComponent(WinTabContext winTabContext, int n2, String string, Component$Identifier component$Identifier) {
        super(string, component$Identifier);
        this.min = 0;
        this.max = 1;
        this.analog = false;
    }

    @Override
    protected float poll() throws IOException {
        return this.lastKnownValue;
    }

    @Override
    public boolean isAnalog() {
        return this.analog;
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    public static List createComponents(WinTabContext winTabContext, int n2, int n3, int[] nArray) {
        ArrayList<WinTabComponent> arrayList = new ArrayList<WinTabComponent>();
        switch (n3) {
            case 1: {
                Component$Identifier$Axis component$Identifier$Axis = Component$Identifier$Axis.X;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[0], nArray[1]));
                break;
            }
            case 2: {
                Component$Identifier$Axis component$Identifier$Axis = Component$Identifier$Axis.Y;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[0], nArray[1]));
                break;
            }
            case 3: {
                Component$Identifier$Axis component$Identifier$Axis = Component$Identifier$Axis.Z;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[0], nArray[1]));
                break;
            }
            case 4: {
                Component$Identifier$Axis component$Identifier$Axis = Component$Identifier$Axis.X_FORCE;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[0], nArray[1]));
                break;
            }
            case 5: {
                Component$Identifier$Axis component$Identifier$Axis = Component$Identifier$Axis.Y_FORCE;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[0], nArray[1]));
                break;
            }
            case 6: {
                Component$Identifier$Axis component$Identifier$Axis = Component$Identifier$Axis.RX;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[0], nArray[1]));
                component$Identifier$Axis = Component$Identifier$Axis.RY;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[2], nArray[3]));
                component$Identifier$Axis = Component$Identifier$Axis.RZ;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[4], nArray[5]));
                break;
            }
            case 7: {
                Component$Identifier$Axis component$Identifier$Axis = Component$Identifier$Axis.RX;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[0], nArray[1]));
                component$Identifier$Axis = Component$Identifier$Axis.RY;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[2], nArray[3]));
                component$Identifier$Axis = Component$Identifier$Axis.RZ;
                arrayList.add(new WinTabComponent(winTabContext, n2, component$Identifier$Axis.getName(), component$Identifier$Axis, nArray[4], nArray[5]));
            }
        }
        return arrayList;
    }

    public static Collection createButtons(WinTabContext winTabContext, int n2, int n3) {
        ArrayList<WinTabButtonComponent> arrayList = new ArrayList<WinTabButtonComponent>();
        for (int i2 = 0; i2 < n3; ++i2) {
            try {
                Class clazz = class$net$java$games$input$Component$Identifier$Button == null ? WinTabComponent.class$("net.java.games.input.Component$Identifier$Button") : class$net$java$games$input$Component$Identifier$Button;
                Field field = clazz.getField(new StringBuffer().append("_").append(i2).toString());
                Component$Identifier component$Identifier = (Component$Identifier)field.get(null);
                arrayList.add(new WinTabButtonComponent(winTabContext, n2, component$Identifier.getName(), component$Identifier, i2));
                continue;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return arrayList;
    }

    public Event processPacket(WinTabPacket winTabPacket) {
        float f2 = this.lastKnownValue;
        if (this.getIdentifier() == Component$Identifier$Axis.X) {
            f2 = this.normalise(winTabPacket.PK_X);
        }
        if (this.getIdentifier() == Component$Identifier$Axis.Y) {
            f2 = this.normalise(winTabPacket.PK_Y);
        }
        if (this.getIdentifier() == Component$Identifier$Axis.Z) {
            f2 = this.normalise(winTabPacket.PK_Z);
        }
        if (this.getIdentifier() == Component$Identifier$Axis.X_FORCE) {
            f2 = this.normalise(winTabPacket.PK_NORMAL_PRESSURE);
        }
        if (this.getIdentifier() == Component$Identifier$Axis.Y_FORCE) {
            f2 = this.normalise(winTabPacket.PK_TANGENT_PRESSURE);
        }
        if (this.getIdentifier() == Component$Identifier$Axis.RX) {
            f2 = this.normalise(winTabPacket.PK_ORIENTATION_ALT);
        }
        if (this.getIdentifier() == Component$Identifier$Axis.RY) {
            f2 = this.normalise(winTabPacket.PK_ORIENTATION_AZ);
        }
        if (this.getIdentifier() == Component$Identifier$Axis.RZ) {
            f2 = this.normalise(winTabPacket.PK_ORIENTATION_TWIST);
        }
        if (f2 != this.getPollData()) {
            this.lastKnownValue = f2;
            Event event = new Event();
            event.set(this, f2, winTabPacket.PK_TIME * 1000L);
            return event;
        }
        return null;
    }

    private float normalise(float f2) {
        if (this.max == this.min) {
            return f2;
        }
        float f3 = this.max - this.min;
        return (f2 - (float)this.min) / f3;
    }

    public static Collection createCursors(WinTabContext winTabContext, int n2, String[] stringArray) {
        ArrayList<WinTabCursorComponent> arrayList = new ArrayList<WinTabCursorComponent>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Component$Identifier$Button component$Identifier$Button = stringArray[i2].matches("Puck") ? Component$Identifier$Button.TOOL_FINGER : (stringArray[i2].matches("Eraser.*") ? Component$Identifier$Button.TOOL_RUBBER : Component$Identifier$Button.TOOL_PEN);
            arrayList.add(new WinTabCursorComponent(winTabContext, n2, component$Identifier$Button.getName(), component$Identifier$Button, i2));
        }
        return arrayList;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

