/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridj.CLong;
import org.bridj.NativeLibrary;
import org.bridj.demangling.Demangler;
import org.bridj.demangling.Demangler$ClassRef;
import org.bridj.demangling.Demangler$Constant;
import org.bridj.demangling.Demangler$DemanglingException;
import org.bridj.demangling.Demangler$FunctionTypeRef;
import org.bridj.demangling.Demangler$Ident;
import org.bridj.demangling.Demangler$IdentLike;
import org.bridj.demangling.Demangler$MemberRef;
import org.bridj.demangling.Demangler$NamespaceRef;
import org.bridj.demangling.Demangler$SpecialName;
import org.bridj.demangling.Demangler$TemplateArg;
import org.bridj.demangling.Demangler$TypeRef;
import org.bridj.demangling.GCC4Demangler$1;

public class GCC4Demangler
extends Demangler {
    private Map prefixShortcuts = new GCC4Demangler$1(this);
    private Set shouldContinueAfterPrefix = new HashSet<String>(Arrays.asList("t"));
    private Map typeShortcuts = new HashMap();
    int nextShortcutId = -1;

    public GCC4Demangler(NativeLibrary nativeLibrary, String string) {
        super(nativeLibrary, string);
    }

    private Object ensureOfType(Object object, Class clazz) throws Demangler$DemanglingException {
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw new Demangler$DemanglingException(this, "Internal error in demangler: trying to cast to " + clazz.getCanonicalName() + " the object '" + object.toString() + "'");
    }

    private String nextShortcutId() {
        int n2;
        return (n2 = this.nextShortcutId++) == -1 ? "_" : Integer.toString(n2, 36).toUpperCase() + "_";
    }

    private Demangler$TypeRef parsePointerType(boolean bl2, boolean bl3, boolean bl4) throws Demangler$DemanglingException {
        String string = bl2 ? this.nextShortcutId() : null;
        Demangler$TypeRef demangler$TypeRef = this.parseType();
        if (bl2) {
            this.typeShortcuts.put(string, demangler$TypeRef);
        }
        Demangler$TypeRef demangler$TypeRef2 = GCC4Demangler.pointerType(demangler$TypeRef, bl3, bl4);
        String string2 = this.nextShortcutId();
        this.typeShortcuts.put(string2, demangler$TypeRef2);
        return demangler$TypeRef2;
    }

    public Demangler$TemplateArg parseTemplateArg() throws Demangler$DemanglingException {
        if (this.consumeCharIf('L')) {
            char c2;
            Demangler$TypeRef demangler$TypeRef = this.parseType();
            StringBuffer stringBuffer = new StringBuffer();
            while (Character.isDigit(c2 = this.peekChar())) {
                this.consumeChar();
                stringBuffer.append(c2);
            }
            this.expectChars('E');
            return new Demangler$Constant(Integer.parseInt(stringBuffer.toString()));
        }
        return this.parseType();
    }

    public Demangler$TypeRef parseType() throws Demangler$DemanglingException {
        if (Character.isDigit(this.peekChar())) {
            Demangler$Ident demangler$Ident = (Demangler$Ident)this.ensureOfType(this.parseNonCompoundIdent(), Demangler$Ident.class);
            String string = this.nextShortcutId();
            Demangler$TypeRef demangler$TypeRef = GCC4Demangler.simpleType(demangler$Ident);
            this.typeShortcuts.put(string, demangler$TypeRef);
            return demangler$TypeRef;
        }
        char c2 = this.consumeChar();
        switch (c2) {
            case 'S': {
                Object object;
                char c3 = this.peekChar();
                int n2 = 0;
                if (Character.isDigit(c3) || Character.isUpperCase(c3) || c3 == '_') {
                    object = "";
                    while ((c2 = this.peekChar()) != '_' && c2 != '\u0000') {
                        object = (String)object + this.consumeChar();
                        ++n2;
                    }
                    if (this.peekChar() == '\u0000') {
                        throw new Demangler$DemanglingException(this, "Encountered a unexpected end in gcc mangler shortcut '" + (String)object + "' " + this.prefixShortcuts.keySet());
                    }
                    object = (String)object + this.consumeChar();
                    ++n2;
                    if (this.typeShortcuts.containsKey(object)) {
                        if (this.peekChar() != 'I') {
                            return (Demangler$TypeRef)this.typeShortcuts.get(object);
                        }
                        ArrayList arrayList = new ArrayList((Collection)this.prefixShortcuts.get(object));
                        String string = this.parsePossibleTemplateArguments(arrayList);
                        if (string != null) {
                            return (Demangler$TypeRef)this.typeShortcuts.get(string);
                        }
                    }
                    this.position -= n2;
                }
            }
            case 'N': {
                --this.position;
                ArrayList arrayList = new ArrayList();
                String string = this.parseSimpleOrComplexIdentInto(arrayList, false);
                Object object = new Demangler$ClassRef((Demangler$Ident)this.ensureOfType(arrayList.remove(arrayList.size() - 1), Demangler$Ident.class));
                if (!arrayList.isEmpty()) {
                    ((Demangler$ClassRef)object).setEnclosingType(new Demangler$NamespaceRef(arrayList.toArray()));
                }
                if (string != null) {
                    this.typeShortcuts.put(string, object);
                }
                return object;
            }
            case 'P': 
            case 'R': {
                char c4 = this.peekChar();
                boolean bl2 = c2 == 'R';
                boolean bl3 = c4 == 'K';
                return this.parsePointerType(bl3 || c4 == 'N', bl3, bl2);
            }
            case 'F': {
                Demangler$MemberRef demangler$MemberRef = new Demangler$MemberRef();
                demangler$MemberRef.setValueType(this.parseType());
                ArrayList<Demangler$TypeRef> arrayList = new ArrayList<Demangler$TypeRef>();
                while (this.peekChar() != 'E') {
                    arrayList.add(this.parseType());
                }
                demangler$MemberRef.paramTypes = arrayList.toArray(new Demangler$TypeRef[arrayList.size()]);
                this.expectChars('E');
                return new Demangler$FunctionTypeRef(demangler$MemberRef);
            }
            case 'K': {
                return this.parseType();
            }
            case 'v': {
                return GCC4Demangler.classType(Void.TYPE, new Class[0]);
            }
            case 'a': 
            case 'c': 
            case 'h': {
                return GCC4Demangler.classType(Byte.TYPE, new Class[0]);
            }
            case 'b': {
                return GCC4Demangler.classType(Boolean.TYPE, new Class[0]);
            }
            case 'l': 
            case 'm': {
                return GCC4Demangler.classType(CLong.class, new Class[0]);
            }
            case 'x': 
            case 'y': {
                return GCC4Demangler.classType(Long.TYPE, new Class[0]);
            }
            case 'i': 
            case 'j': {
                return GCC4Demangler.classType(Integer.TYPE, new Class[0]);
            }
            case 's': 
            case 't': {
                return GCC4Demangler.classType(Short.TYPE, new Class[0]);
            }
            case 'f': {
                return GCC4Demangler.classType(Float.TYPE, new Class[0]);
            }
            case 'd': {
                return GCC4Demangler.classType(Double.TYPE, new Class[0]);
            }
            case 'z': {
                return GCC4Demangler.classType(Object[].class, new Class[0]);
            }
        }
        throw this.error("Unexpected type char '" + c2 + "'", -1);
    }

    String parseName() throws Demangler$DemanglingException {
        int n2;
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        while (Character.isDigit(c2 = this.peekChar())) {
            this.consumeChar();
            stringBuilder.append(c2);
        }
        try {
            n2 = Integer.parseInt(stringBuilder.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.error("Expected a number", 0);
        }
        stringBuilder.setLength(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.consumeChar());
        }
        return stringBuilder.toString();
    }

    private String parseSimpleOrComplexIdentInto(List list2, boolean bl2) throws Demangler$DemanglingException {
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.consumeCharIf('N')) {
            if (this.consumeCharIf('S')) {
                this.parseShortcutInto(list2);
            }
            bl3 = true;
            bl4 = true;
        } else if (this.consumeCharIf('S')) {
            bl3 = this.parseShortcutInto(list2);
        } else {
            list2.add(this.parseNonCompoundIdent());
        }
        if (bl3) {
            int n2 = this.nextShortcutId;
            do {
                String string2;
                string = string2 = this.nextShortcutId();
                Demangler$IdentLike demangler$IdentLike = this.parseNonCompoundIdent();
                list2.add(demangler$IdentLike);
                this.prefixShortcuts.put(string2, new ArrayList(list2));
                this.parsePossibleTemplateArguments(list2);
            } while (Character.isDigit(this.peekChar()) || this.peekChar() == 'C' || this.peekChar() == 'D');
            if (bl2) {
                this.nextShortcutId = n2;
            }
        }
        this.parsePossibleTemplateArguments(list2);
        if (bl4) {
            this.expectAnyChar('E');
        }
        return string;
    }

    private String parsePossibleTemplateArguments(List list2) throws Demangler$DemanglingException {
        if (this.consumeCharIf('I')) {
            ArrayList<Demangler$TemplateArg> arrayList = new ArrayList<Demangler$TemplateArg>();
            while (!this.consumeCharIf('E')) {
                arrayList.add(this.parseTemplateArg());
            }
            String string = this.nextShortcutId();
            Demangler$Ident demangler$Ident = new Demangler$Ident(((Demangler$Ident)this.ensureOfType(list2.remove(list2.size() - 1), Demangler$Ident.class)).toString(), arrayList.toArray(new Demangler$TemplateArg[arrayList.size()]));
            list2.add(demangler$Ident);
            this.prefixShortcuts.put(string, new ArrayList(list2));
            ArrayList arrayList2 = new ArrayList(list2);
            Demangler$ClassRef demangler$ClassRef = new Demangler$ClassRef((Demangler$Ident)this.ensureOfType(arrayList2.remove(arrayList2.size() - 1), Demangler$Ident.class));
            if (!arrayList2.isEmpty()) {
                demangler$ClassRef.setEnclosingType(new Demangler$NamespaceRef(arrayList2.toArray()));
            }
            this.typeShortcuts.put(string, demangler$ClassRef);
            return string;
        }
        return null;
    }

    private boolean parseShortcutInto(List list2) throws Demangler$DemanglingException {
        char c2 = this.peekChar();
        if (c2 == '_') {
            List list3 = (List)this.prefixShortcuts.get(Character.toString(this.consumeChar()));
            if (list3 == null) {
                throw new Demangler$DemanglingException(this, "Encountered a yet undefined gcc mangler shortcut S_ (first one), i.e. '_' " + this.prefixShortcuts.keySet());
            }
            list2.addAll(list3);
            return false;
        }
        if (Character.isDigit(c2) || Character.isUpperCase(c2)) {
            String string = "";
            while ((c2 = this.peekChar()) != '_' && c2 != '\u0000') {
                string = string + this.consumeChar();
            }
            if (this.peekChar() == '\u0000') {
                throw new Demangler$DemanglingException(this, "Encountered a unexpected end in gcc mangler shortcut '" + string + "' " + this.prefixShortcuts.keySet());
            }
            List list4 = (List)this.prefixShortcuts.get(string = string + this.consumeChar());
            if (list4 == null) {
                throw new Demangler$DemanglingException(this, "Encountered a unexpected gcc mangler shortcut '" + string + "' " + this.prefixShortcuts.keySet());
            }
            list2.addAll(list4);
            return false;
        }
        if (Character.isLowerCase(c2)) {
            String string = Character.toString(this.consumeChar());
            List list5 = (List)this.prefixShortcuts.get(string);
            if (list5 == null) {
                throw new Demangler$DemanglingException(this, "Encountered a unexpected gcc mangler built-in shortcut '" + string + "' " + this.prefixShortcuts.keySet());
            }
            list2.addAll(list5);
            return this.shouldContinueAfterPrefix.contains(string);
        }
        throw new Demangler$DemanglingException(this, "Encountered a unexpected gcc unknown shortcut '" + c2 + "' " + this.prefixShortcuts.keySet());
    }

    Demangler$IdentLike parseNonCompoundIdent() throws Demangler$DemanglingException {
        if (this.consumeCharIf('C')) {
            if (this.consumeCharIf('1')) {
                return Demangler$SpecialName.Constructor;
            }
            if (this.consumeCharIf('2')) {
                return Demangler$SpecialName.SpecialConstructor;
            }
            throw this.error("Unknown constructor type 'C" + this.peekChar() + "'");
        }
        if (this.consumeCharIf('D')) {
            if (this.consumeCharIf('0')) {
                return Demangler$SpecialName.DeletingDestructor;
            }
            if (this.consumeCharIf('1')) {
                return Demangler$SpecialName.Destructor;
            }
            if (this.consumeCharIf('2')) {
                return Demangler$SpecialName.SelfishDestructor;
            }
            throw this.error("Unknown destructor type 'D" + this.peekChar() + "'");
        }
        String string = this.parseName();
        return new Demangler$Ident(string, new Demangler$TemplateArg[0]);
    }

    @Override
    public Demangler$MemberRef parseSymbol() throws Demangler$DemanglingException {
        Demangler$MemberRef demangler$MemberRef = new Demangler$MemberRef();
        if (!this.consumeCharIf('_')) {
            demangler$MemberRef.setMemberName(new Demangler$Ident(this.str, new Demangler$TemplateArg[0]));
            return demangler$MemberRef;
        }
        this.consumeCharIf('_');
        if (!this.consumeCharIf('Z')) {
            return null;
        }
        if (this.consumeCharIf('T')) {
            if (this.consumeCharIf('V')) {
                demangler$MemberRef.setEnclosingType((Demangler$TypeRef)this.ensureOfType(this.parseType(), Demangler$ClassRef.class));
                demangler$MemberRef.setMemberName(Demangler$SpecialName.VFTable);
                return demangler$MemberRef;
            }
            return null;
        }
        if (this.consumeCharsIf('d', 'l', 'P', 'v')) {
            demangler$MemberRef.setMemberName(Demangler$SpecialName.Delete);
            return demangler$MemberRef;
        }
        if (this.consumeCharsIf('d', 'a', 'P', 'v')) {
            demangler$MemberRef.setMemberName(Demangler$SpecialName.DeleteArray);
            return demangler$MemberRef;
        }
        if (this.consumeCharsIf('n', 'w', 'm')) {
            demangler$MemberRef.setMemberName(Demangler$SpecialName.New);
            return demangler$MemberRef;
        }
        if (this.consumeCharsIf('n', 'a', 'm')) {
            demangler$MemberRef.setMemberName(Demangler$SpecialName.NewArray);
            return demangler$MemberRef;
        }
        ArrayList<Demangler$TypeRef> arrayList = new ArrayList<Demangler$TypeRef>();
        this.parseSimpleOrComplexIdentInto(arrayList, true);
        demangler$MemberRef.setMemberName((Demangler$IdentLike)arrayList.remove(arrayList.size() - 1));
        if (!arrayList.isEmpty()) {
            Demangler$ClassRef demangler$ClassRef = new Demangler$ClassRef((Demangler$Ident)this.ensureOfType(arrayList.remove(arrayList.size() - 1), Demangler$Ident.class));
            if (demangler$MemberRef.getMemberName() == Demangler$SpecialName.Constructor || demangler$MemberRef.getMemberName() == Demangler$SpecialName.SpecialConstructor) {
                this.typeShortcuts.put(this.nextShortcutId(), demangler$ClassRef);
            }
            if (!arrayList.isEmpty()) {
                demangler$ClassRef.setEnclosingType(new Demangler$NamespaceRef(arrayList.toArray()));
            }
            demangler$MemberRef.setEnclosingType(demangler$ClassRef);
        }
        if (this.consumeCharIf('v')) {
            if (this.position < this.length) {
                this.error("Expected end of symbol", 0);
            }
            demangler$MemberRef.paramTypes = new Demangler$TypeRef[0];
        } else {
            arrayList = new ArrayList();
            while (this.position < this.length) {
                arrayList.add(this.parseType());
            }
            demangler$MemberRef.paramTypes = arrayList.toArray(new Demangler$TypeRef[arrayList.size()]);
        }
        return demangler$MemberRef;
    }
}

