/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Stat {
    protected Stat() {
        throw new UnsupportedOperationException();
    }

    public static native int nstat(long var0, long var2, long var4);

    public static int stat(IntBuffer intBuffer, ByteBuffer byteBuffer, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.checkNT1(byteBuffer);
            Checks.check(l2);
        }
        return Stat.nstat(MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer), l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stat(IntBuffer intBuffer, CharSequence charSequence, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check(l2);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            int n3 = Stat.nstat(MemoryUtil.memAddressSafe(intBuffer), l3, l2);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nfstat(long var0, int var2, long var3);

    public static int fstat(IntBuffer intBuffer, int n2, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check(l2);
        }
        return Stat.nfstat(MemoryUtil.memAddressSafe(intBuffer), n2, l2);
    }

    static {
        Library.initialize();
    }
}

