/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XMapRequestEvent$Buffer;

public class XMapRequestEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int PARENT;
    public static final int WINDOW;

    protected XMapRequestEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XMapRequestEvent create(long l2, ByteBuffer byteBuffer) {
        return new XMapRequestEvent(l2, byteBuffer);
    }

    public XMapRequestEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XMapRequestEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XMapRequestEvent.ntype(this.address());
    }

    public long serial() {
        return XMapRequestEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XMapRequestEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XMapRequestEvent.ndisplay(this.address());
    }

    public long parent() {
        return XMapRequestEvent.nparent(this.address());
    }

    public long window() {
        return XMapRequestEvent.nwindow(this.address());
    }

    public XMapRequestEvent type(int n2) {
        XMapRequestEvent.ntype(this.address(), n2);
        return this;
    }

    public XMapRequestEvent serial(long l2) {
        XMapRequestEvent.nserial(this.address(), l2);
        return this;
    }

    public XMapRequestEvent send_event(boolean bl2) {
        XMapRequestEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XMapRequestEvent display(long l2) {
        XMapRequestEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XMapRequestEvent parent(long l2) {
        XMapRequestEvent.nparent(this.address(), l2);
        return this;
    }

    public XMapRequestEvent window(long l2) {
        XMapRequestEvent.nwindow(this.address(), l2);
        return this;
    }

    public XMapRequestEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.parent(l4);
        this.window(l5);
        return this;
    }

    public XMapRequestEvent set(XMapRequestEvent xMapRequestEvent) {
        MemoryUtil.memCopy(xMapRequestEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XMapRequestEvent malloc() {
        return new XMapRequestEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XMapRequestEvent calloc() {
        return new XMapRequestEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XMapRequestEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XMapRequestEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XMapRequestEvent create(long l2) {
        return new XMapRequestEvent(l2, null);
    }

    public static XMapRequestEvent createSafe(long l2) {
        return l2 == 0L ? null : new XMapRequestEvent(l2, null);
    }

    public static XMapRequestEvent$Buffer malloc(int n2) {
        return new XMapRequestEvent$Buffer(MemoryUtil.nmemAllocChecked(XMapRequestEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XMapRequestEvent$Buffer calloc(int n2) {
        return new XMapRequestEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XMapRequestEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XMapRequestEvent.__create(n2, SIZEOF);
        return new XMapRequestEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XMapRequestEvent$Buffer create(long l2, int n2) {
        return new XMapRequestEvent$Buffer(l2, n2);
    }

    public static XMapRequestEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XMapRequestEvent$Buffer(l2, n2);
    }

    public static XMapRequestEvent mallocStack() {
        return XMapRequestEvent.malloc(MemoryStack.stackGet());
    }

    public static XMapRequestEvent callocStack() {
        return XMapRequestEvent.calloc(MemoryStack.stackGet());
    }

    public static XMapRequestEvent mallocStack(MemoryStack memoryStack) {
        return XMapRequestEvent.malloc(memoryStack);
    }

    public static XMapRequestEvent callocStack(MemoryStack memoryStack) {
        return XMapRequestEvent.calloc(memoryStack);
    }

    public static XMapRequestEvent$Buffer mallocStack(int n2) {
        return XMapRequestEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XMapRequestEvent$Buffer callocStack(int n2) {
        return XMapRequestEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XMapRequestEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XMapRequestEvent.malloc(n2, memoryStack);
    }

    public static XMapRequestEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XMapRequestEvent.calloc(n2, memoryStack);
    }

    public static XMapRequestEvent malloc(MemoryStack memoryStack) {
        return new XMapRequestEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XMapRequestEvent calloc(MemoryStack memoryStack) {
        return new XMapRequestEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XMapRequestEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XMapRequestEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XMapRequestEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XMapRequestEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nparent(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)PARENT);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nparent(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)PARENT, l3);
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XMapRequestEvent.__struct(XMapRequestEvent.__member(4), XMapRequestEvent.__member(CLONG_SIZE), XMapRequestEvent.__member(4), XMapRequestEvent.__member(POINTER_SIZE), XMapRequestEvent.__member(CLONG_SIZE), XMapRequestEvent.__member(CLONG_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        PARENT = struct$Layout.offsetof(4);
        WINDOW = struct$Layout.offsetof(5);
    }
}

