/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.DATA_BLOB$Buffer;

public class DATA_BLOB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CBDATA;
    public static final int PBDATA;

    protected DATA_BLOB(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected DATA_BLOB create(long l2, ByteBuffer byteBuffer) {
        return new DATA_BLOB(l2, byteBuffer);
    }

    public DATA_BLOB(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), DATA_BLOB.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int cbData() {
        return DATA_BLOB.ncbData(this.address());
    }

    public ByteBuffer pbData() {
        return DATA_BLOB.npbData(this.address());
    }

    public DATA_BLOB pbData(ByteBuffer byteBuffer) {
        DATA_BLOB.npbData(this.address(), byteBuffer);
        return this;
    }

    public DATA_BLOB set(DATA_BLOB dATA_BLOB) {
        MemoryUtil.memCopy(dATA_BLOB.address(), this.address(), SIZEOF);
        return this;
    }

    public static DATA_BLOB malloc() {
        return new DATA_BLOB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static DATA_BLOB calloc() {
        return new DATA_BLOB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static DATA_BLOB create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new DATA_BLOB(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static DATA_BLOB create(long l2) {
        return new DATA_BLOB(l2, null);
    }

    public static DATA_BLOB createSafe(long l2) {
        return l2 == 0L ? null : new DATA_BLOB(l2, null);
    }

    public static DATA_BLOB$Buffer malloc(int n2) {
        return new DATA_BLOB$Buffer(MemoryUtil.nmemAllocChecked(DATA_BLOB.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static DATA_BLOB$Buffer calloc(int n2) {
        return new DATA_BLOB$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static DATA_BLOB$Buffer create(int n2) {
        ByteBuffer byteBuffer = DATA_BLOB.__create(n2, SIZEOF);
        return new DATA_BLOB$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static DATA_BLOB$Buffer create(long l2, int n2) {
        return new DATA_BLOB$Buffer(l2, n2);
    }

    public static DATA_BLOB$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new DATA_BLOB$Buffer(l2, n2);
    }

    public static DATA_BLOB malloc(MemoryStack memoryStack) {
        return new DATA_BLOB(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static DATA_BLOB calloc(MemoryStack memoryStack) {
        return new DATA_BLOB(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static DATA_BLOB$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new DATA_BLOB$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static DATA_BLOB$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new DATA_BLOB$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ncbData(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CBDATA);
    }

    public static ByteBuffer npbData(long l2) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(l2 + (long)PBDATA), DATA_BLOB.ncbData(l2));
    }

    public static void ncbData(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CBDATA, n2);
    }

    public static void npbData(long l2, ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)PBDATA, MemoryUtil.memAddress(byteBuffer));
        DATA_BLOB.ncbData(l2, byteBuffer.remaining());
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)PBDATA));
    }

    static {
        Struct$Layout struct$Layout = DATA_BLOB.__struct(DATA_BLOB.__member(4), DATA_BLOB.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        CBDATA = struct$Layout.offsetof(0);
        PBDATA = struct$Layout.offsetof(1);
    }
}

