/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WinBase {
    public static final int FALSE = 0;
    public static final int TRUE = 1;

    protected WinBase() {
        throw new UnsupportedOperationException();
    }

    public static native long nLocalFree(long var0, long var2);

    public static long LocalFree(IntBuffer intBuffer, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check(l2);
        }
        return WinBase.nLocalFree(MemoryUtil.memAddressSafe(intBuffer), l2);
    }

    public static native int GetLastError();

    public static native long nGetModuleHandle(long var0, long var2);

    public static long GetModuleHandle(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.checkNT2Safe(byteBuffer);
        }
        return WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddressSafe(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetModuleHandle(IntBuffer intBuffer, CharSequence charSequence) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF16Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            long l3 = WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(intBuffer), l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nGetModuleFileName(long var0, long var2, long var4, int var6);

    public static int GetModuleFileName(IntBuffer intBuffer, long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        return WinBase.nGetModuleFileName(MemoryUtil.memAddressSafe(intBuffer), l2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining() >> 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetModuleFileName(IntBuffer intBuffer, long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc(n2 << 1);
            int n4 = WinBase.nGetModuleFileName(MemoryUtil.memAddressSafe(intBuffer), l2, MemoryUtil.memAddress(byteBuffer), n2);
            String string = MemoryUtil.memUTF16(byteBuffer, n4);
            return string;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nLoadLibrary(long var0, long var2);

    public static long LoadLibrary(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.checkNT2(byteBuffer);
        }
        return WinBase.nLoadLibrary(MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long LoadLibrary(IntBuffer intBuffer, CharSequence charSequence) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF16(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = WinBase.nLoadLibrary(MemoryUtil.memAddressSafe(intBuffer), l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native long nGetProcAddress(long var0, long var2, long var4);

    public static long GetProcAddress(IntBuffer intBuffer, long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check(l2);
            Checks.checkNT1(byteBuffer);
        }
        return WinBase.nGetProcAddress(MemoryUtil.memAddressSafe(intBuffer), l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetProcAddress(IntBuffer intBuffer, long l2, CharSequence charSequence) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check(l2);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = WinBase.nGetProcAddress(MemoryUtil.memAddressSafe(intBuffer), l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nFreeLibrary(long var0, long var2);

    public static boolean FreeLibrary(IntBuffer intBuffer, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check(l2);
        }
        return WinBase.nFreeLibrary(MemoryUtil.memAddressSafe(intBuffer), l2) != 0;
    }

    static {
        Library.initialize();
    }
}

