/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

public class MathUtil {
    public static final float TO_FLOAT = 2.4414062E-4f;
    static final float TO_RADIANS = 0.0015339808f;
    static final float[] IDENTITY_AFFINE = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};

    public static int uSqrt(int n2) {
        double d2;
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0) {
            if (n2 > -196606) {
                return 65535;
            }
            d2 = (long)n2 & 0xFFFFFFFFL;
        } else {
            d2 = n2;
        }
        return (int)Math.round(Math.sqrt(d2));
    }

    public static int iSin(int n2) {
        double d2 = (double)n2 * Math.PI / 2048.0;
        return (int)Math.round(Math.sin(d2) * 4096.0);
    }

    public static int iCos(int n2) {
        return MathUtil.iSin(n2 + 1024);
    }

    public static int iSqrt(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative arg=" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        return (int)Math.round(Math.sqrt(n2));
    }

    public static int iAtan2(int n2, int n3) {
        return (int)Math.round(Math.atan2((double)n2 / 4096.0, (double)n3 / 4096.0) * 4096.0);
    }

    static void multiplyMM(float[] fArray, float[] fArray2, float[] fArray3) {
        float f2 = fArray2[0];
        float f3 = fArray2[4];
        float f4 = fArray2[8];
        float f5 = fArray2[12];
        float f6 = fArray2[1];
        float f7 = fArray2[5];
        float f8 = fArray2[9];
        float f9 = fArray2[13];
        float f10 = fArray2[2];
        float f11 = fArray2[6];
        float f12 = fArray2[10];
        float f13 = fArray2[14];
        float f14 = fArray2[3];
        float f15 = fArray2[7];
        float f16 = fArray2[11];
        float f17 = fArray2[15];
        float f18 = fArray3[0];
        float f19 = fArray3[3];
        float f20 = fArray3[6];
        float f21 = fArray3[9];
        float f22 = fArray3[1];
        float f23 = fArray3[4];
        float f24 = fArray3[7];
        float f25 = fArray3[10];
        float f26 = fArray3[2];
        float f27 = fArray3[5];
        float f28 = fArray3[8];
        float f29 = fArray3[11];
        fArray[0] = f2 * f18 + f3 * f22 + f4 * f26;
        fArray[1] = f6 * f18 + f7 * f22 + f8 * f26;
        fArray[2] = f10 * f18 + f11 * f22 + f12 * f26;
        fArray[3] = f14 * f18 + f15 * f22 + f16 * f26;
        fArray[4] = f2 * f19 + f3 * f23 + f4 * f27;
        fArray[5] = f6 * f19 + f7 * f23 + f8 * f27;
        fArray[6] = f10 * f19 + f11 * f23 + f12 * f27;
        fArray[7] = f14 * f19 + f15 * f23 + f16 * f27;
        fArray[8] = f2 * f20 + f3 * f24 + f4 * f28;
        fArray[9] = f6 * f20 + f7 * f24 + f8 * f28;
        fArray[10] = f10 * f20 + f11 * f24 + f12 * f28;
        fArray[11] = f14 * f20 + f15 * f24 + f16 * f28;
        fArray[12] = f2 * f21 + f3 * f25 + f4 * f29 + f5;
        fArray[13] = f6 * f21 + f7 * f25 + f8 * f29 + f9;
        fArray[14] = f10 * f21 + f11 * f25 + f12 * f29 + f13;
        fArray[15] = f14 * f21 + f15 * f25 + f16 * f29 + f17;
    }

    public static void rotateM12(float[] fArray, int n2, int n3, int n4, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20;
        float f21;
        float f22;
        float f23 = (float)Math.sin(f2 *= 0.0015339808f);
        float f24 = (float)Math.cos(f2);
        if (4096 == n2 && 0 == n3 && 0 == n4) {
            f22 = 1.0f;
            f21 = 0.0f;
            f20 = 0.0f;
            f19 = 0.0f;
            f18 = f24;
            f17 = f23;
            f16 = 0.0f;
            f15 = -f23;
            f14 = f24;
        } else if (0 == n2 && 4096 == n3 && 0 == n4) {
            f22 = f24;
            f21 = 0.0f;
            f20 = -f23;
            f19 = 0.0f;
            f18 = 1.0f;
            f17 = 0.0f;
            f16 = f23;
            f15 = 0.0f;
            f14 = f24;
        } else if (0 == n2 && 0 == n3 && 4096 == n4) {
            f22 = f24;
            f21 = f23;
            f20 = 0.0f;
            f19 = -f23;
            f18 = f24;
            f17 = 0.0f;
            f16 = 0.0f;
            f15 = 0.0f;
            f14 = 1.0f;
        } else {
            f13 = 1.0f / MathUtil.vectorLength(n2, n3, n4);
            f12 = (float)n2 * f13;
            f11 = (float)n3 * f13;
            f10 = (float)n4 * f13;
            f9 = 1.0f - f24;
            f8 = f12 * f23;
            f7 = f11 * f23;
            f6 = f10 * f23;
            f5 = f12 * f11 * f9;
            f4 = f10 * f12 * f9;
            f3 = f11 * f10 * f9;
            f22 = f12 * f12 * f9 + f24;
            f19 = f5 - f6;
            f16 = f4 + f7;
            f21 = f5 + f6;
            f18 = f11 * f11 * f9 + f24;
            f15 = f3 - f8;
            f20 = f4 - f7;
            f17 = f3 + f8;
            f14 = f10 * f10 * f9 + f24;
        }
        f13 = fArray[0];
        f12 = fArray[3];
        f11 = fArray[6];
        f10 = fArray[9];
        f9 = fArray[1];
        f8 = fArray[4];
        f7 = fArray[7];
        f6 = fArray[10];
        f5 = fArray[2];
        f4 = fArray[5];
        f3 = fArray[8];
        float f25 = fArray[11];
        fArray[0] = f22 * f13 + f19 * f9 + f16 * f5;
        fArray[1] = f21 * f13 + f18 * f9 + f15 * f5;
        fArray[2] = f20 * f13 + f17 * f9 + f14 * f5;
        fArray[3] = f22 * f12 + f19 * f8 + f16 * f4;
        fArray[4] = f21 * f12 + f18 * f8 + f15 * f4;
        fArray[5] = f20 * f12 + f17 * f8 + f14 * f4;
        fArray[6] = f22 * f11 + f19 * f7 + f16 * f3;
        fArray[7] = f21 * f11 + f18 * f7 + f15 * f3;
        fArray[8] = f20 * f11 + f17 * f7 + f14 * f3;
        fArray[9] = f22 * f10 + f19 * f6 + f16 * f25;
        fArray[10] = f21 * f10 + f18 * f6 + f15 * f25;
        fArray[11] = f20 * f10 + f17 * f6 + f14 * f25;
    }

    public static float vectorLength(float f2, float f3, float f4) {
        return (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
    }

    public static int clamp(int n2, int n3, int n4) {
        return n2 < n3 ? n3 : (n2 > n4 ? n4 : n2);
    }
}

