/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.swt;

import java.nio.IntBuffer;
import java.util.HashSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGL;
import org.lwjgl.opengl.swt.AbstractPlatformGLCanvas;
import org.lwjgl.opengl.swt.GLCanvas;
import org.lwjgl.opengl.swt.GLData;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.GDI32;
import org.lwjgl.system.windows.PIXELFORMATDESCRIPTOR;
import org.lwjgl.system.windows.User32;

class PlatformWin32GLCanvas
extends AbstractPlatformGLCanvas {
    private static final String USE_OWNDC_KEY = "org.eclipse.swt.internal.win32.useOwnDC";
    private long wglDelayBeforeSwapNVAddr = 0L;
    private boolean wglDelayBeforeSwapNVAddr_set = false;

    PlatformWin32GLCanvas() {
    }

    private void encodePixelFormatAttribs(IntBuffer ib, GLData attribs) {
        ib.put(8193).put(1);
        ib.put(8208).put(1);
        ib.put(8195).put(8231);
        if (attribs.doubleBuffer) {
            ib.put(8209).put(1);
        }
        if (attribs.pixelFormatFloat) {
            ib.put(8211).put(8608);
        } else {
            ib.put(8211).put(8235);
        }
        if (attribs.redSize > 0) {
            ib.put(8213).put(attribs.redSize);
        }
        if (attribs.greenSize > 0) {
            ib.put(8215).put(attribs.greenSize);
        }
        if (attribs.blueSize > 0) {
            ib.put(8217).put(attribs.blueSize);
        }
        if (attribs.alphaSize > 0) {
            ib.put(8219).put(attribs.alphaSize);
        }
        if (attribs.depthSize > 0) {
            ib.put(8226).put(attribs.depthSize);
        }
        if (attribs.stencilSize > 0) {
            ib.put(8227).put(attribs.stencilSize);
        }
        if (attribs.accumRedSize > 0) {
            ib.put(8222).put(attribs.accumRedSize);
        }
        if (attribs.accumGreenSize > 0) {
            ib.put(8223).put(attribs.accumGreenSize);
        }
        if (attribs.accumBlueSize > 0) {
            ib.put(8224).put(attribs.accumBlueSize);
        }
        if (attribs.accumAlphaSize > 0) {
            ib.put(8225).put(attribs.accumAlphaSize);
        }
        if (attribs.accumRedSize > 0 || attribs.accumGreenSize > 0 || attribs.accumBlueSize > 0 || attribs.accumAlphaSize > 0) {
            ib.put(8221).put(attribs.accumRedSize + attribs.accumGreenSize + attribs.accumBlueSize + attribs.accumAlphaSize);
        }
        if (attribs.sRGB) {
            ib.put(8361).put(1);
        }
        if (attribs.samples > 0) {
            ib.put(8257).put(1);
            ib.put(8258).put(attribs.samples);
            if (attribs.colorSamplesNV > 0) {
                ib.put(8377).put(attribs.colorSamplesNV);
            }
        }
        ib.put(0);
    }

    public int checkStyle(Composite parent, int style) {
        if (parent != null) {
            parent.getDisplay().setData(USE_OWNDC_KEY, (Object)Boolean.TRUE);
        }
        return style;
    }

    public void resetStyle(Composite parent) {
        parent.getDisplay().setData(USE_OWNDC_KEY, (Object)Boolean.FALSE);
    }

    public long create(final GLCanvas canvas, GLData attribs, GLData effective) {
        Canvas dummycanvas = new Canvas(canvas.getParent(), this.checkStyle(canvas.getParent(), canvas.getStyle()));
        long context = 0L;
        MemoryStack stack = MemoryStack.stackGet();
        int ptr = stack.getPointer();
        try {
            context = this.create(canvas.handle, dummycanvas.handle, attribs, effective);
        }
        catch (SWTException e) {
            stack.setPointer(ptr);
            SWT.error((int)38, (Throwable)e);
        }
        final long finalContext = context;
        dummycanvas.dispose();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        PlatformWin32GLCanvas.this.deleteContext(canvas, finalContext);
                    }
                }
            }
        };
        canvas.addListener(12, listener);
        return context;
    }

    private long create(long windowHandle, long dummyWindowHandle, GLData attribs, GLData effective) throws SWTException {
        long str;
        long wglGetExtensionsStringEXTAddr;
        long str2;
        MemoryStack stack = MemoryStack.stackGet();
        long bufferAddr = stack.nmalloc(4, 32);
        PlatformWin32GLCanvas.validateAttributes((GLData)attribs);
        PIXELFORMATDESCRIPTOR pfd = PIXELFORMATDESCRIPTOR.callocStack();
        pfd.nSize((short)PIXELFORMATDESCRIPTOR.SIZEOF);
        pfd.nVersion((short)1);
        pfd.dwLayerMask(0);
        pfd.iPixelType((byte)0);
        int flags = 36;
        if (attribs.doubleBuffer) {
            flags |= 1;
        }
        if (attribs.stereo) {
            flags |= 2;
        }
        pfd.dwFlags(flags);
        pfd.cRedBits((byte)attribs.redSize);
        pfd.cGreenBits((byte)attribs.greenSize);
        pfd.cBlueBits((byte)attribs.blueSize);
        pfd.cAlphaBits((byte)attribs.alphaSize);
        pfd.cDepthBits((byte)attribs.depthSize);
        pfd.cStencilBits((byte)attribs.stencilSize);
        pfd.cAccumRedBits((byte)attribs.accumRedSize);
        pfd.cAccumGreenBits((byte)attribs.accumGreenSize);
        pfd.cAccumBlueBits((byte)attribs.accumBlueSize);
        pfd.cAccumAlphaBits((byte)attribs.accumAlphaSize);
        pfd.cAccumBits((byte)(attribs.accumRedSize + attribs.accumGreenSize + attribs.accumBlueSize + attribs.accumAlphaSize));
        long hDCdummy = User32.GetDC((long)dummyWindowHandle);
        int pixelFormat = GDI32.ChoosePixelFormat(null, (long)hDCdummy, (PIXELFORMATDESCRIPTOR)pfd);
        if (pixelFormat == 0 || !GDI32.SetPixelFormat(null, (long)hDCdummy, (int)pixelFormat, (PIXELFORMATDESCRIPTOR)pfd)) {
            User32.ReleaseDC((long)dummyWindowHandle, (long)hDCdummy);
            throw new SWTException("Unsupported pixel format");
        }
        long dummyContext = WGL.wglCreateContext(null, (long)hDCdummy);
        if (dummyContext == 0L) {
            User32.ReleaseDC((long)dummyWindowHandle, (long)hDCdummy);
            throw new SWTException("Failed to create OpenGL context");
        }
        long currentContext = WGL.wglGetCurrentContext(null);
        long currentDc = WGL.wglGetCurrentDC();
        boolean success = WGL.wglMakeCurrent(null, (long)hDCdummy, (long)dummyContext);
        if (!success) {
            User32.ReleaseDC((long)dummyWindowHandle, (long)hDCdummy);
            WGL.wglDeleteContext(null, (long)dummyContext);
            throw new SWTException("Failed to make OpenGL context current");
        }
        String wglExtensions = null;
        long wglGetExtensionsStringARBAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglGetExtensionsStringARB");
        wglExtensions = wglGetExtensionsStringARBAddr != 0L ? ((str2 = JNI.callPP((long)hDCdummy, (long)wglGetExtensionsStringARBAddr)) != 0L ? MemoryUtil.memASCII((long)str2) : "") : ((wglGetExtensionsStringEXTAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglGetExtensionsStringEXT")) != 0L ? ((str = JNI.callP((long)wglGetExtensionsStringEXTAddr)) != 0L ? MemoryUtil.memASCII((long)str) : "") : "");
        String[] splitted = wglExtensions.split(" ");
        HashSet<String> wglExtensionsList = new HashSet<String>(splitted.length);
        String[] stringArray = splitted;
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String str3 = stringArray[n2];
            wglExtensionsList.add(str3);
            ++n2;
        }
        success = User32.ReleaseDC((long)dummyWindowHandle, (long)hDCdummy);
        if (!success) {
            WGL.wglDeleteContext(null, (long)dummyContext);
            WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
            throw new SWTException("Could not release dummy DC");
        }
        if (!(PlatformWin32GLCanvas.atLeast30((int)attribs.majorVersion, (int)attribs.minorVersion) || attribs.samples != 0 || attribs.sRGB || attribs.pixelFormatFloat || attribs.contextReleaseBehavior != null || attribs.robustness || attribs.api == GLData.API.GLES)) {
            long hDC = User32.GetDC((long)windowHandle);
            GDI32.SetPixelFormat(null, (long)hDC, (int)pixelFormat, (PIXELFORMATDESCRIPTOR)pfd);
            success = WGL.wglDeleteContext(null, (long)dummyContext);
            if (!success) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("Could not delete dummy GL context");
            }
            long context = WGL.wglCreateContext(null, (long)hDC);
            if (attribs.swapInterval != null) {
                boolean has_WGL_EXT_swap_control_tear;
                boolean has_WGL_EXT_swap_control = wglExtensionsList.contains("WGL_EXT_swap_control");
                if (!has_WGL_EXT_swap_control) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    WGL.wglDeleteContext(null, (long)context);
                    throw new SWTException("Swap interval requested but WGL_EXT_swap_control is unavailable");
                }
                if (attribs.swapInterval < 0 && !(has_WGL_EXT_swap_control_tear = wglExtensionsList.contains("WGL_EXT_swap_control_tear"))) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    WGL.wglDeleteContext(null, (long)context);
                    throw new SWTException("Negative swap interval requested but WGL_EXT_swap_control_tear is unavailable");
                }
                success = WGL.wglMakeCurrent(null, (long)hDC, (long)context);
                if (!success) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    WGL.wglDeleteContext(null, (long)context);
                    throw new SWTException("Could not make GL context current");
                }
                long wglSwapIntervalEXTAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglSwapIntervalEXT");
                if (wglSwapIntervalEXTAddr != 0L) {
                    JNI.callI((int)attribs.swapInterval, (long)wglSwapIntervalEXTAddr);
                }
            }
            if (attribs.swapGroupNV > 0 || attribs.swapBarrierNV > 0) {
                boolean has_WGL_NV_swap_group = wglExtensionsList.contains("WGL_NV_swap_group");
                if (!has_WGL_NV_swap_group) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    WGL.wglDeleteContext(null, (long)context);
                    throw new SWTException("Swap group or barrier requested but WGL_NV_swap_group is unavailable");
                }
                success = WGL.wglMakeCurrent(null, (long)hDC, (long)context);
                try {
                    this.wglNvSwapGroupAndBarrier(attribs, stack.getAddress() + (long)stack.getPointer(), hDC);
                }
                catch (SWTException e) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    WGL.wglDeleteContext(null, (long)context);
                    throw e;
                }
            }
            if (attribs.shareContext != null && !(success = WGL.wglShareLists(null, (long)context, (long)attribs.shareContext.context))) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                WGL.wglDeleteContext(null, (long)context);
                throw new SWTException("Failed while configuring context sharing");
            }
            int pixFmtIndex = GDI32.DescribePixelFormat(null, (long)hDC, (int)pixelFormat, (PIXELFORMATDESCRIPTOR)pfd);
            if (pixFmtIndex == 0) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                WGL.wglDeleteContext(null, (long)context);
                throw new SWTException("Failed to describe pixel format");
            }
            success = User32.ReleaseDC((long)windowHandle, (long)hDC);
            if (!success) {
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                WGL.wglDeleteContext(null, (long)context);
                throw new SWTException("Could not release DC");
            }
            effective.redSize = pfd.cRedBits();
            effective.greenSize = pfd.cGreenBits();
            effective.blueSize = pfd.cBlueBits();
            effective.alphaSize = pfd.cAlphaBits();
            effective.depthSize = pfd.cDepthBits();
            effective.stencilSize = pfd.cStencilBits();
            int pixelFormatFlags = pfd.dwFlags();
            effective.doubleBuffer = (pixelFormatFlags & 1) != 0;
            effective.stereo = (pixelFormatFlags & 2) != 0;
            effective.accumRedSize = pfd.cAccumRedBits();
            effective.accumGreenSize = pfd.cAccumGreenBits();
            effective.accumBlueSize = pfd.cAccumBlueBits();
            effective.accumAlphaSize = pfd.cAccumAlphaBits();
            WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
            return context;
        }
        if (!wglExtensionsList.contains("WGL_ARB_create_context")) {
            WGL.wglDeleteContext(null, (long)dummyContext);
            WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
            throw new SWTException("Extended context attributes requested but WGL_ARB_create_context is unavailable");
        }
        long wglCreateContextAttribsARBAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglCreateContextAttribsARB");
        if (wglCreateContextAttribsARBAddr == 0L) {
            WGL.wglDeleteContext(null, (long)dummyContext);
            WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
            throw new SWTException("WGL_ARB_create_context available but wglCreateContextAttribsARB is NULL");
        }
        IntBuffer attribList = BufferUtils.createIntBuffer((int)64);
        long attribListAddr = MemoryUtil.memAddress((IntBuffer)attribList);
        long hDC = User32.GetDC((long)windowHandle);
        if (attribs.samples > 0 || attribs.sRGB || attribs.pixelFormatFloat) {
            boolean has_WGL_ARB_pixel_format_float;
            boolean has_WGL_EXT_framebuffer_sRGB;
            long wglChoosePixelFormatAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglChoosePixelFormatARB");
            if (wglChoosePixelFormatAddr == 0L && (wglChoosePixelFormatAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglChoosePixelFormatEXT")) == 0L) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("No support for wglChoosePixelFormatARB/EXT. Cannot query supported pixel formats.");
            }
            if (attribs.samples > 0) {
                boolean has_WGL_NV_multisample_coverage;
                boolean has_WGL_ARB_multisample = wglExtensionsList.contains("WGL_ARB_multisample");
                boolean has_WGL_EXT_multisample = wglExtensionsList.contains("WGL_EXT_multisample");
                if (!has_WGL_ARB_multisample && !has_WGL_EXT_multisample) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglDeleteContext(null, (long)dummyContext);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    throw new SWTException("Multisampling requested but neither WGL_ARB_multisample nor WGL_EXT_multisample available");
                }
                if (attribs.colorSamplesNV > 0 && !(has_WGL_NV_multisample_coverage = wglExtensionsList.contains("WGL_NV_multisample_coverage"))) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglDeleteContext(null, (long)dummyContext);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    throw new SWTException("Color samples requested but WGL_NV_multisample_coverage is unavailable");
                }
            }
            if (attribs.sRGB && !(has_WGL_EXT_framebuffer_sRGB = wglExtensionsList.contains("WGL_EXT_framebuffer_sRGB"))) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("sRGB color space requested but WGL_EXT_framebuffer_sRGB is unavailable");
            }
            if (attribs.pixelFormatFloat && !(has_WGL_ARB_pixel_format_float = wglExtensionsList.contains("WGL_ARB_pixel_format_float"))) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("Floating-point format requested but WGL_ARB_pixel_format_float is unavailable");
            }
            this.encodePixelFormatAttribs(attribList, attribs);
            success = JNI.callPPPPPI((long)hDC, (long)attribListAddr, (long)0L, (int)1, (long)(bufferAddr + 4L), (long)bufferAddr, (long)wglChoosePixelFormatAddr) == 1;
            int numFormats = MemoryUtil.memGetInt((long)bufferAddr);
            if (!success || numFormats == 0) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("No supported pixel format found.");
            }
            pixelFormat = MemoryUtil.memGetInt((long)(bufferAddr + 4L));
            int pixFmtIndex = GDI32.DescribePixelFormat(null, (long)hDC, (int)pixelFormat, (PIXELFORMATDESCRIPTOR)pfd);
            if (pixFmtIndex == 0) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("Failed to validate supported pixel format.");
            }
            long wglGetPixelFormatAttribivAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglGetPixelFormatAttribivARB");
            if (wglGetPixelFormatAttribivAddr == 0L && (wglGetPixelFormatAttribivAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglGetPixelFormatAttribivEXT")) == 0L) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("No support for wglGetPixelFormatAttribivARB/EXT. Cannot get effective pixel format attributes.");
            }
            attribList.rewind();
            attribList.put(8209);
            attribList.put(8210);
            attribList.put(8211);
            attribList.put(8213);
            attribList.put(8215);
            attribList.put(8217);
            attribList.put(8219);
            attribList.put(8222);
            attribList.put(8223);
            attribList.put(8224);
            attribList.put(8225);
            attribList.put(8226);
            attribList.put(8227);
            IntBuffer attribValues = BufferUtils.createIntBuffer((int)attribList.position());
            long attribValuesAddr = MemoryUtil.memAddress((IntBuffer)attribValues);
            boolean bl = success = JNI.callPPPI((long)hDC, (int)pixelFormat, (int)0, (int)attribList.position(), (long)attribListAddr, (long)attribValuesAddr, (long)wglGetPixelFormatAttribivAddr) == 1;
            if (!success) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("Failed to get pixel format attributes.");
            }
            effective.doubleBuffer = attribValues.get(0) == 1;
            effective.stereo = attribValues.get(1) == 1;
            int pixelType = attribValues.get(2);
            effective.pixelFormatFloat = pixelType == 8608;
            effective.redSize = attribValues.get(3);
            effective.greenSize = attribValues.get(4);
            effective.blueSize = attribValues.get(5);
            effective.alphaSize = attribValues.get(6);
            effective.accumRedSize = attribValues.get(7);
            effective.accumGreenSize = attribValues.get(8);
            effective.accumBlueSize = attribValues.get(9);
            effective.accumAlphaSize = attribValues.get(10);
            effective.depthSize = attribValues.get(11);
            effective.stencilSize = attribValues.get(12);
        }
        attribList.rewind();
        if (attribs.api == GLData.API.GL && PlatformWin32GLCanvas.atLeast30((int)attribs.majorVersion, (int)attribs.minorVersion) || attribs.api == GLData.API.GLES && attribs.majorVersion > 0) {
            attribList.put(8337).put(attribs.majorVersion);
            attribList.put(8338).put(attribs.minorVersion);
        }
        int profile = 0;
        if (attribs.api == GLData.API.GL) {
            if (attribs.profile == GLData.Profile.COMPATIBILITY) {
                profile = 2;
            } else if (attribs.profile == GLData.Profile.CORE) {
                profile = 1;
            }
        } else if (attribs.api == GLData.API.GLES) {
            boolean has_WGL_EXT_create_context_es2_profile = wglExtensionsList.contains("WGL_EXT_create_context_es2_profile");
            if (!has_WGL_EXT_create_context_es2_profile) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("OpenGL ES API requested but WGL_EXT_create_context_es2_profile is unavailable");
            }
            profile = 4;
        }
        if (profile > 0) {
            boolean has_WGL_ARB_create_context_profile = wglExtensionsList.contains("WGL_ARB_create_context_profile");
            if (!has_WGL_ARB_create_context_profile) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("OpenGL profile requested but WGL_ARB_create_context_profile is unavailable");
            }
            attribList.put(37158).put(profile);
        }
        int contextFlags = 0;
        if (attribs.debug) {
            contextFlags |= 1;
        }
        if (attribs.forwardCompatible) {
            contextFlags |= 2;
        }
        if (attribs.noErrorContext) {
            contextFlags |= 8;
            attribList.put(12723).put(1);
        }
        if (attribs.robustness) {
            boolean has_WGL_ARB_create_context_robustness = wglExtensions.contains("WGL_ARB_create_context_robustness");
            if (!has_WGL_ARB_create_context_robustness) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("Context with robust buffer access requested but WGL_ARB_create_context_robustness is unavailable");
            }
            contextFlags |= 4;
            if (attribs.loseContextOnReset) {
                attribList.put(33366).put(33362);
            }
            if (attribs.contextResetIsolation) {
                boolean has_WGL_ARB_robustness_application_isolation = wglExtensions.contains("WGL_ARB_robustness_application_isolation");
                boolean has_WGL_ARB_robustness_share_group_isolation = wglExtensions.contains("WGL_ARB_robustness_share_group_isolation");
                if (!has_WGL_ARB_robustness_application_isolation && !has_WGL_ARB_robustness_share_group_isolation) {
                    User32.ReleaseDC((long)windowHandle, (long)hDC);
                    WGL.wglDeleteContext(null, (long)dummyContext);
                    WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                    throw new SWTException("Robustness isolation requested but neither WGL_ARB_robustness_application_isolation nor WGL_ARB_robustness_share_group_isolation available");
                }
                contextFlags |= 8;
            }
        }
        if (contextFlags > 0) {
            attribList.put(8340).put(contextFlags);
        }
        if (attribs.contextReleaseBehavior != null) {
            boolean has_WGL_ARB_context_flush_control = wglExtensionsList.contains("WGL_ARB_context_flush_control");
            if (!has_WGL_ARB_context_flush_control) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglDeleteContext(null, (long)dummyContext);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                throw new SWTException("Context release behavior requested but WGL_ARB_context_flush_control is unavailable");
            }
            if (attribs.contextReleaseBehavior == GLData.ReleaseBehavior.NONE) {
                attribList.put(8343).put(0);
            } else if (attribs.contextReleaseBehavior == GLData.ReleaseBehavior.FLUSH) {
                attribList.put(8343).put(8344);
            }
        }
        attribList.put(0).put(0);
        success = GDI32.SetPixelFormat(null, (long)hDC, (int)pixelFormat, (PIXELFORMATDESCRIPTOR)pfd);
        if (!success) {
            User32.ReleaseDC((long)windowHandle, (long)hDC);
            WGL.wglDeleteContext(null, (long)dummyContext);
            WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
            throw new SWTException("Failed to set pixel format.");
        }
        long newCtx = JNI.callPPPP((long)hDC, (long)(attribs.shareContext != null ? attribs.shareContext.context : 0L), (long)attribListAddr, (long)wglCreateContextAttribsARBAddr);
        WGL.wglDeleteContext(null, (long)dummyContext);
        if (newCtx == 0L) {
            User32.ReleaseDC((long)windowHandle, (long)hDC);
            WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
            throw new SWTException("Failed to create OpenGL context.");
        }
        WGL.wglMakeCurrent(null, (long)hDC, (long)newCtx);
        if (attribs.swapInterval != null) {
            boolean has_WGL_EXT_swap_control_tear;
            boolean has_WGL_EXT_swap_control = wglExtensionsList.contains("WGL_EXT_swap_control");
            if (!has_WGL_EXT_swap_control) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                WGL.wglDeleteContext(null, (long)newCtx);
                throw new SWTException("Swap interval requested but WGL_EXT_swap_control is unavailable");
            }
            if (attribs.swapInterval < 0 && !(has_WGL_EXT_swap_control_tear = wglExtensionsList.contains("WGL_EXT_swap_control_tear"))) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                WGL.wglDeleteContext(null, (long)newCtx);
                throw new SWTException("Negative swap interval requested but WGL_EXT_swap_control_tear is unavailable");
            }
            long wglSwapIntervalEXTAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglSwapIntervalEXT");
            if (wglSwapIntervalEXTAddr != 0L) {
                JNI.callI((int)attribs.swapInterval, (long)wglSwapIntervalEXTAddr);
            }
        }
        if (attribs.swapGroupNV > 0 || attribs.swapBarrierNV > 0) {
            boolean has_WGL_NV_swap_group = wglExtensionsList.contains("WGL_NV_swap_group");
            if (!has_WGL_NV_swap_group) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                WGL.wglDeleteContext(null, (long)newCtx);
                throw new SWTException("Swap group or barrier requested but WGL_NV_swap_group is unavailable");
            }
            try {
                this.wglNvSwapGroupAndBarrier(attribs, bufferAddr, hDC);
            }
            catch (SWTException e) {
                User32.ReleaseDC((long)windowHandle, (long)hDC);
                WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
                WGL.wglDeleteContext(null, (long)newCtx);
                throw e;
            }
        }
        User32.ReleaseDC((long)windowHandle, (long)hDC);
        long getInteger = GL.getFunctionProvider().getFunctionAddress((CharSequence)"glGetIntegerv");
        long getString = GL.getFunctionProvider().getFunctionAddress((CharSequence)"glGetString");
        effective.api = attribs.api;
        if (PlatformWin32GLCanvas.atLeast30((int)attribs.majorVersion, (int)attribs.minorVersion)) {
            JNI.callPV((int)33307, (long)bufferAddr, (long)getInteger);
            effective.majorVersion = MemoryUtil.memGetInt((long)bufferAddr);
            JNI.callPV((int)33308, (long)bufferAddr, (long)getInteger);
            effective.minorVersion = MemoryUtil.memGetInt((long)bufferAddr);
            JNI.callPV((int)33310, (long)bufferAddr, (long)getInteger);
            int effectiveContextFlags = MemoryUtil.memGetInt((long)bufferAddr);
            effective.debug = (effectiveContextFlags & 2) != 0;
            effective.forwardCompatible = (effectiveContextFlags & 1) != 0;
            effective.robustness = (effectiveContextFlags & 4) != 0;
        } else if (attribs.api == GLData.API.GL) {
            APIUtil.APIVersion version = APIUtil.apiParseVersion((String)MemoryUtil.memUTF8((long)Checks.check((long)JNI.callP((int)7938, (long)getString))));
            effective.majorVersion = version.major;
            effective.minorVersion = version.minor;
        } else if (attribs.api == GLData.API.GLES) {
            APIUtil.APIVersion version = APIUtil.apiParseVersion((String)MemoryUtil.memUTF8((long)Checks.check((long)JNI.callP((int)7938, (long)getString))));
            effective.majorVersion = version.major;
            effective.minorVersion = version.minor;
        }
        if (attribs.api == GLData.API.GL && PlatformWin32GLCanvas.atLeast32((int)effective.majorVersion, (int)effective.minorVersion)) {
            boolean comp;
            JNI.callPV((int)37158, (long)bufferAddr, (long)getInteger);
            int effectiveProfileMask = MemoryUtil.memGetInt((long)bufferAddr);
            boolean core = (effectiveProfileMask & 1) != 0;
            boolean bl = comp = (effectiveProfileMask & 2) != 0;
            effective.profile = comp ? GLData.Profile.COMPATIBILITY : (core ? GLData.Profile.CORE : null);
        }
        if (attribs.samples >= 1) {
            JNI.callPV((int)32937, (long)bufferAddr, (long)getInteger);
            effective.samples = MemoryUtil.memGetInt((long)bufferAddr);
            JNI.callPV((int)32936, (long)bufferAddr, (long)getInteger);
            effective.sampleBuffers = MemoryUtil.memGetInt((long)bufferAddr);
            boolean has_WGL_NV_multisample_coverage = wglExtensionsList.contains("WGL_NV_multisample_coverage");
            if (has_WGL_NV_multisample_coverage) {
                JNI.callPV((int)36384, (long)bufferAddr, (long)getInteger);
                effective.colorSamplesNV = MemoryUtil.memGetInt((long)bufferAddr);
            }
        }
        WGL.wglMakeCurrent(null, (long)currentDc, (long)currentContext);
        return newCtx;
    }

    private void wglNvSwapGroupAndBarrier(GLData attribs, long bufferAddr, long hDC) throws SWTException {
        long wglQueryMaxSwapGroupsNVAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglQueryMaxSwapGroupsNV");
        int success = JNI.callPPPI((long)hDC, (long)bufferAddr, (long)(bufferAddr + 4L), (long)wglQueryMaxSwapGroupsNVAddr);
        int maxGroups = MemoryUtil.memGetInt((long)bufferAddr);
        if (maxGroups < attribs.swapGroupNV) {
            throw new SWTException("Swap group exceeds maximum group index");
        }
        int maxBarriers = MemoryUtil.memGetInt((long)(bufferAddr + 4L));
        if (maxBarriers < attribs.swapBarrierNV) {
            throw new SWTException("Swap barrier exceeds maximum barrier index");
        }
        if (attribs.swapGroupNV > 0) {
            long wglJoinSwapGroupNVAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglJoinSwapGroupNV");
            if (wglJoinSwapGroupNVAddr == 0L) {
                throw new SWTException("WGL_NV_swap_group available but wglJoinSwapGroupNV is NULL");
            }
            success = JNI.callPI((long)hDC, (int)attribs.swapGroupNV, (long)wglJoinSwapGroupNVAddr);
            if (success == 0) {
                throw new SWTException("Failed to join swap group");
            }
            if (attribs.swapBarrierNV > 0) {
                long wglBindSwapBarrierNVAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglBindSwapBarrierNV");
                if (wglBindSwapBarrierNVAddr == 0L) {
                    throw new SWTException("WGL_NV_swap_group available but wglBindSwapBarrierNV is NULL");
                }
                success = JNI.callI((int)attribs.swapGroupNV, (int)attribs.swapBarrierNV, (long)wglBindSwapBarrierNVAddr);
                if (success == 0) {
                    throw new SWTException("Failed to bind swap barrier. Probably no G-Sync card installed.");
                }
            }
        }
    }

    public boolean isCurrent(long context) {
        long ret = WGL.wglGetCurrentContext(null);
        return ret == context;
    }

    public boolean makeCurrent(GLCanvas canvas, long context) {
        long hDC = User32.GetDC((long)canvas.handle);
        boolean ret = WGL.wglMakeCurrent(null, (long)hDC, (long)context);
        User32.ReleaseDC((long)canvas.handle, (long)hDC);
        return ret;
    }

    public boolean deleteContext(GLCanvas canvas, long context) {
        boolean ret = WGL.wglDeleteContext(null, (long)context);
        return ret;
    }

    public boolean swapBuffers(GLCanvas canvas) {
        long hDC = User32.GetDC((long)canvas.handle);
        boolean ret = GDI32.SwapBuffers(null, (long)hDC);
        User32.ReleaseDC((long)canvas.handle, (long)hDC);
        return ret;
    }

    public boolean delayBeforeSwapNV(GLCanvas canvas, float seconds) {
        if (!this.wglDelayBeforeSwapNVAddr_set) {
            this.wglDelayBeforeSwapNVAddr = WGL.wglGetProcAddress(null, (CharSequence)"wglDelayBeforeSwapNV");
            this.wglDelayBeforeSwapNVAddr_set = true;
        }
        if (this.wglDelayBeforeSwapNVAddr == 0L) {
            throw new UnsupportedOperationException("wglDelayBeforeSwapNV is unavailable");
        }
        long hDC = User32.GetDC((long)canvas.handle);
        int ret = JNI.callPI((long)hDC, (float)seconds, (long)this.wglDelayBeforeSwapNVAddr);
        User32.ReleaseDC((long)canvas.handle, (long)hDC);
        return ret == 1;
    }
}

