/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int hBitmap;
    int id;
    int accelerator;
    int userId;
    int index;
    ToolTip itemToolTip;
    static final int MARGIN_WIDTH = OS.IsWin95 ? 2 : 1;
    static final int MARGIN_HEIGHT = OS.IsWin95 ? 2 : 1;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.index = menu.getItemCount();
        menu.createItem(this, this.index);
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.index = n2;
        menu.createItem(this, this.index);
    }

    MenuItem(Menu menu, Menu menu2, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.menu = menu2;
        this.index = n2;
        if (menu2 != null) {
            menu2.cascade = this;
        }
        this.display.addMenuItem(this);
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    boolean fillAccel(ACCEL aCCEL) {
        aCCEL.fVirt = 0;
        aCCEL.cmd = aCCEL.key = (short)0;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return false;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return false;
        }
        boolean bl = true;
        int n = this.accelerator & 0x100FFFF;
        int n2 = Display.untranslateKey(n);
        if (n2 != 0) {
            n = n2;
        } else {
            switch (n) {
                case 27: {
                    n = 27;
                    break;
                }
                case 127: {
                    n = 46;
                    break;
                }
                default: {
                    n = Display.wcsToMbcs((char)n);
                    if (n == 0) {
                        return false;
                    }
                    if (OS.IsWinCE) {
                        n = OS.CharUpper((short)n);
                        break;
                    }
                    n2 = OS.VkKeyScan((short)n);
                    if (n2 == -1) {
                        if (n == OS.CharUpper((short)n)) break;
                        bl = false;
                        break;
                    }
                    n = n2 & 0xFF;
                }
            }
        }
        aCCEL.key = (short)n;
        aCCEL.cmd = (short)this.id;
        aCCEL.fVirt = (byte)(bl ? 1 : 0);
        if ((this.accelerator & 0x10000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 0x10);
        }
        if ((this.accelerator & 0x20000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 4);
        }
        if ((this.accelerator & 0x40000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 8);
        }
        return true;
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        if ((this.parent.style & 2) != 0) {
            Decorations decorations = this.parent.parent;
            if (decorations.menuBar != this.parent) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n2 = decorations.handle;
            MENUBARINFO mENUBARINFO = new MENUBARINFO();
            mENUBARINFO.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(n2, -3, 1, mENUBARINFO)) {
                return new Rectangle(0, 0, 0, 0);
            }
            MENUBARINFO mENUBARINFO2 = new MENUBARINFO();
            mENUBARINFO2.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(n2, -3, n + 1, mENUBARINFO2)) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n3 = mENUBARINFO2.left - mENUBARINFO.left;
            int n4 = mENUBARINFO2.top - mENUBARINFO.top;
            int n5 = mENUBARINFO2.right - mENUBARINFO2.left;
            int n6 = mENUBARINFO2.bottom - mENUBARINFO2.top;
            return new Rectangle(n3, n4, n5, n6);
        }
        int n7 = this.parent.handle;
        RECT rECT = new RECT();
        if (!OS.GetMenuItemRect(0, n7, 0, rECT)) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT2 = new RECT();
        if (!OS.GetMenuItemRect(0, n7, n, rECT2)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n8 = rECT2.left - rECT.left + 2;
        int n9 = rECT2.top - rECT.top + 2;
        int n10 = rECT2.right - rECT2.left;
        int n11 = rECT2.bottom - rECT2.top;
        return new Rectangle(n8, n9, n10, n11);
    }

    public boolean getEnabled() {
        boolean bl;
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            return (tBBUTTONINFO.fsState & 4) != 0;
        }
        if ((this.style & 2) != 0) {
            return (this.state & 8) == 0;
        }
        int n = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        if (OS.IsWinCE) {
            int n2 = this.parent.indexOf(this);
            if (n2 == -1) {
                this.error(31);
            }
            bl = OS.GetMenuItemInfo(n, n2, true, mENUITEMINFO);
        } else {
            bl = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
        }
        if (!bl) {
            this.error(31);
        }
        return (mENUITEMINFO.fState & 3) == 0;
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return false;
        }
        int n = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
        if (!bl) {
            this.error(9);
        }
        return (mENUITEMINFO.fState & 8) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.itemToolTip == null ? null : this.itemToolTip.getMessage();
    }

    void hideToolTip() {
        if (this.itemToolTip == null) {
            return;
        }
        this.itemToolTip.setVisible(false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.hBitmap != 0) {
            OS.DeleteObject(this.hBitmap);
        }
        this.hBitmap = 0;
        if (this.accelerator != 0) {
            this.parent.destroyAccelerators();
        }
        this.accelerator = 0;
        this.display.removeMenuItem(this);
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.menu != null) {
            this.menu.reskin(n);
        }
        super.reskinChildren(n);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i = 0; i < menuItemArray.length && menuItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && menuItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < menuItemArray.length && menuItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        this.accelerator = n;
        this.parent.destroyAccelerators();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB);
            if (bl) {
                tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState | 4);
            }
            OS.SendMessage(n, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        } else {
            if ((this.style & 2) != 0) {
                this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
            }
            int n = this.parent.handle;
            if (OS.IsWinCE) {
                int n2 = this.parent.indexOf(this);
                if (n2 == -1) {
                    return;
                }
                int n3 = 0x400 | (bl ? 0 : 1);
                OS.EnableMenuItem(n, n2, n3);
            } else {
                int n4;
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 1;
                boolean bl2 = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
                if (!bl2) {
                    n4 = OS.GetLastError();
                    SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(n4) + "]");
                }
                n4 = 3;
                if (bl) {
                    if ((mENUITEMINFO.fState & n4) == 0) {
                        return;
                    }
                    mENUITEMINFO.fState &= ~n4;
                } else {
                    if ((mENUITEMINFO.fState & n4) == n4) {
                        return;
                    }
                    mENUITEMINFO.fState |= n4;
                }
                bl2 = OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO);
                if (!bl2) {
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        boolean bl3 = bl2 = this.id == OS.GetMenuDefaultItem(n, 0, 1);
                    }
                    if (!bl2) {
                        int n5 = OS.GetLastError();
                        SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(n5) + "]");
                    }
                }
            }
        }
        this.parent.destroyAccelerators();
        this.parent.redraw();
    }

    public void setID(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        this.userId = n;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
                int n = this.parent.hwndCB;
                TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                tBBUTTONINFO.dwMask = 1;
                tBBUTTONINFO.iImage = this.parent.imageIndex(image);
                OS.SendMessage(n, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
            }
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 128;
        if (this.parent.foreground != -1) {
            mENUITEMINFO.hbmpItem = -1;
        } else if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && OS.IsAppThemed()) {
            if (this.hBitmap != 0) {
                OS.DeleteObject(this.hBitmap);
            }
            this.hBitmap = image != null ? Display.create32bitDIB(image) : 0;
            mENUITEMINFO.hbmpItem = this.hBitmap;
        } else {
            mENUITEMINFO.hbmpItem = image != null ? -1 : 0;
        }
        int n = this.parent.handle;
        OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO);
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        this.setMenu(menu, false);
    }

    void setMenu(Menu menu, boolean bl) {
        Menu menu2 = this.menu;
        if (menu2 == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            if (OS.IsPPC) {
                int n = this.parent.hwndCB;
                int n2 = menu == null ? 0 : menu.handle;
                OS.SendMessage(n, 1424, this.id, n2);
            }
            if (OS.IsSP) {
                this.error(29);
            }
        } else {
            int n;
            int n3 = this.parent.handle;
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 32;
            int n4 = 0;
            while (OS.GetMenuItemInfo(n3, n4, true, mENUITEMINFO) && mENUITEMINFO.dwItemData != this.id) {
                ++n4;
            }
            if (mENUITEMINFO.dwItemData != this.id) {
                return;
            }
            int n5 = 128;
            int n6 = OS.GetProcessHeap();
            int n7 = n5 * TCHAR.sizeof;
            int n8 = OS.HeapAlloc(n6, 8, n7);
            mENUITEMINFO.fMask = 35;
            mENUITEMINFO.fMask = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) ? (mENUITEMINFO.fMask |= 0xC0) : (mENUITEMINFO.fMask |= 0x10);
            mENUITEMINFO.dwTypeData = n8;
            mENUITEMINFO.cch = n5;
            boolean bl2 = OS.GetMenuItemInfo(n3, n4, true, mENUITEMINFO);
            if (menu != null) {
                menu.cascade = this;
                mENUITEMINFO.fMask |= 4;
                mENUITEMINFO.hSubMenu = menu.handle;
            }
            if (OS.IsWinCE) {
                TCHAR tCHAR;
                OS.RemoveMenu(n3, n4, 1024);
                n = this.id;
                int n9 = 1024;
                if (menu != null) {
                    n9 |= 0x10;
                    n = menu.handle;
                }
                if (bl2 = OS.InsertMenu(n3, n4, n9, n, tCHAR = new TCHAR(0, " ", true))) {
                    mENUITEMINFO.fMask = 48;
                    bl2 = OS.SetMenuItemInfo(n3, n4, true, mENUITEMINFO);
                    if ((mENUITEMINFO.fState & 3) != 0) {
                        OS.EnableMenuItem(n3, n4, 1025);
                    }
                    if ((mENUITEMINFO.fState & 8) != 0) {
                        OS.CheckMenuItem(n3, n4, 1032);
                    }
                }
            } else if (bl || menu2 == null) {
                bl2 = OS.SetMenuItemInfo(n3, n4, true, mENUITEMINFO);
            } else {
                OS.RemoveMenu(n3, n4, 1024);
                bl2 = OS.InsertMenuItem(n3, n4, true, mENUITEMINFO);
            }
            if (n8 != 0) {
                OS.HeapFree(n6, 0, n8);
            }
            if (!bl2) {
                n = OS.GetLastError();
                SWT.error(29, null, " [GetLastError=0x" + Integer.toHexString(n) + "]");
            }
        }
        this.parent.destroyAccelerators();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    void setOrientation(int n) {
        int n2 = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 256;
        mENUITEMINFO.fType = this.widgetStyle();
        OS.SetMenuItemInfo(n2, this.id, false, mENUITEMINFO);
        if (this.menu != null) {
            this.menu._setOrientation(n);
        }
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return;
        }
        int n = this.parent.handle;
        if (OS.IsWinCE) {
            int n2 = this.parent.indexOf(this);
            if (n2 == -1) {
                return;
            }
            int n3 = 0x400 | (bl ? 8 : 0);
            OS.CheckMenuItem(n, n2, n3);
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 1;
            boolean bl2 = OS.GetMenuItemInfo(n, this.id, false, mENUITEMINFO);
            if (!bl2) {
                this.error(28);
            }
            mENUITEMINFO.fState &= 0xFFFFFFF7;
            if (bl) {
                mENUITEMINFO.fState |= 8;
            }
            if (!(bl2 = OS.SetMenuItemInfo(n, this.id, false, mENUITEMINFO))) {
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    boolean bl3 = bl2 = this.id == OS.GetMenuDefaultItem(n, 0, 1);
                }
                if (!bl2) {
                    int n4 = OS.GetLastError();
                    SWT.error(28, null, " [GetLastError=0x" + Integer.toHexString(n4) + "]");
                }
            }
        }
        this.parent.redraw();
    }

    @Override
    public void setText(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        int n = OS.GetProcessHeap();
        int n2 = 0;
        boolean bl = false;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n3;
            if (string.indexOf(38) != -1) {
                int n4 = string.length();
                char[] cArray = new char[n4];
                string.getChars(0, n4, cArray, 0);
                n3 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (cArray[n3] == '&') continue;
                    cArray[n5++] = cArray[n3];
                }
                if (n5 < n3) {
                    string = new String(cArray, 0, n5);
                }
            }
            object = new TCHAR(0, string, true);
            int n6 = ((TCHAR)object).length() * TCHAR.sizeof;
            n2 = OS.HeapAlloc(n, 8, n6);
            OS.MoveMemory(n2, (TCHAR)object, n6);
            n3 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 2;
            tBBUTTONINFO.pszText = n2;
            bl = OS.SendMessage(n3, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO) != 0;
        } else {
            object = new MENUITEMINFO();
            ((MENUITEMINFO)object).cbSize = MENUITEMINFO.sizeof;
            int n7 = this.parent.handle;
            TCHAR tCHAR = new TCHAR(0, string, true);
            int n8 = tCHAR.length() * TCHAR.sizeof;
            n2 = OS.HeapAlloc(n, 8, n8);
            OS.MoveMemory(n2, tCHAR, n8);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                ((MENUITEMINFO)object).fMask = 64;
            } else {
                ((MENUITEMINFO)object).fMask = 16;
                ((MENUITEMINFO)object).fType = this.widgetStyle();
            }
            ((MENUITEMINFO)object).dwTypeData = n2;
            bl = OS.SetMenuItemInfo(n7, this.id, false, (MENUITEMINFO)object);
        }
        if (n2 != 0) {
            OS.HeapFree(n, 0, n2);
        }
        if (!bl) {
            int n9 = OS.GetLastError();
            SWT.error(13, null, " [GetLastError=0x" + Integer.toHexString(n9) + "]");
        }
        this.parent.redraw();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string == null && this.itemToolTip != null) {
            this.itemToolTip.setVisible(false);
            this.itemToolTip = null;
        }
        if (string == null || string.trim().length() == 0 || this.itemToolTip != null && string.equals(this.itemToolTip.getMessage())) {
            return;
        }
        this.itemToolTip = new MenuItemToolTip(this.getParent().getShell());
        this.itemToolTip.setMessage(string);
        this.itemToolTip.setVisible(false);
    }

    void showTooltip(int n, int n2) {
        if (this.itemToolTip == null) {
            return;
        }
        this.itemToolTip.setLocationInPixels(n, n2);
        this.itemToolTip.setVisible(true);
    }

    int widgetStyle() {
        int n = 0;
        Decorations decorations = this.parent.parent;
        if ((decorations.style & 0x8000000) != 0) {
            if ((this.parent.style & 0x2000000) != 0) {
                n |= 0x6000;
            }
        } else if ((this.parent.style & 0x4000000) != 0) {
            n |= 0x6000;
        }
        if ((this.style & 2) != 0) {
            return n | 0x800;
        }
        if ((this.style & 0x10) != 0) {
            return n | 0x200;
        }
        return n | 0;
    }

    LRESULT wmCommandChild(int n, int n2) {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        this.sendSelectionEvent(13);
        return null;
    }

    LRESULT wmDrawChild(int n, int n2) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n2, DRAWITEMSTRUCT.sizeof);
        if (this.image != null) {
            GCData gCData = new GCData();
            gCData.device = this.display;
            GC gC = GC.win32_new(dRAWITEMSTRUCT.hDC, gCData);
            int n3 = (this.parent.style & 2) != 0 ? MARGIN_WIDTH * 2 : dRAWITEMSTRUCT.left;
            Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
            gC.drawImage(image, DPIUtil.autoScaleDown(n3), DPIUtil.autoScaleDown(dRAWITEMSTRUCT.top + MARGIN_HEIGHT));
            if (this.image != image) {
                image.dispose();
            }
            gC.dispose();
        }
        if (this.parent.foreground != -1) {
            OS.SetTextColor(dRAWITEMSTRUCT.hDC, this.parent.foreground);
        }
        return null;
    }

    LRESULT wmMeasureChild(int n, int n2) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n2, MEASUREITEMSTRUCT.sizeof);
        int n3 = 0;
        int n4 = 0;
        if (this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            n3 = rectangle.width;
            n4 = rectangle.height;
        } else {
            MENUINFO mENUINFO = new MENUINFO();
            mENUINFO.cbSize = MENUINFO.sizeof;
            mENUINFO.fMask = 16;
            int n5 = this.parent.handle;
            OS.GetMenuInfo(n5, mENUINFO);
            if ((mENUINFO.dwStyle & 0x4000000) == 0) {
                MenuItem[] menuItemArray = this.parent.getItems();
                for (int i = 0; i < menuItemArray.length; ++i) {
                    MenuItem menuItem = menuItemArray[i];
                    if (menuItem.image == null) continue;
                    Rectangle rectangle = menuItem.image.getBoundsInPixels();
                    n3 = Math.max(n3, rectangle.width);
                }
            }
        }
        if (n3 != 0 || n4 != 0) {
            mEASUREITEMSTRUCT.itemWidth = n3 + MARGIN_WIDTH * 2;
            mEASUREITEMSTRUCT.itemHeight = n4 + MARGIN_HEIGHT * 2;
            OS.MoveMemory(n2, mEASUREITEMSTRUCT, MEASUREITEMSTRUCT.sizeof);
        }
        return null;
    }

    private static final class MenuItemToolTip
    extends ToolTip {
        public MenuItemToolTip(Shell shell) {
            super(shell, 0);
        }

        @Override
        int hwndToolTip() {
            return this.parent.menuItemToolTipHandle();
        }
    }
}

