/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

@Deprecated
public class TableTree
extends Composite {
    Table table;
    TableTreeItem[] items = EMPTY_ITEMS;
    Image plusImage;
    Image minusImage;
    Image sizeImage;
    Listener listener;
    boolean inDispose = false;
    static final TableTreeItem[] EMPTY_ITEMS = new TableTreeItem[0];
    static final String[] EMPTY_TEXTS = new String[0];
    static final Image[] EMPTY_IMAGES = new Image[0];
    static final String ITEMID = "TableTreeItemID";

    public TableTree(Composite composite, int n) {
        super(composite, TableTree.checkStyle(n));
        this.table = new Table(this, n);
        Listener listener = event -> {
            switch (event.type) {
                case 3: {
                    this.onMouseDown(event);
                    break;
                }
                case 13: {
                    this.onSelection(event);
                    break;
                }
                case 14: {
                    this.onSelection(event);
                    break;
                }
                case 1: {
                    this.onKeyDown(event);
                }
            }
        };
        int[] nArray = new int[]{3, 13, 14, 1};
        for (int i = 0; i < nArray.length; ++i) {
            this.table.addListener(nArray[i], listener);
        }
        this.listener = event -> {
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 11: {
                    this.onResize(event);
                    break;
                }
                case 15: {
                    this.onFocusIn(event);
                }
            }
        };
        int[] nArray2 = new int[]{12, 11, 15};
        for (int i = 0; i < nArray2.length; ++i) {
            this.addListener(nArray2[i], this.listener);
        }
    }

    int addItem(TableTreeItem tableTreeItem, int n) {
        if (n < 0 || n > this.items.length) {
            SWT.error(5);
        }
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, n);
        tableTreeItemArray[n] = tableTreeItem;
        System.arraycopy(this.items, n, tableTreeItemArray, n + 1, this.items.length - n);
        this.items = tableTreeItemArray;
        if (n == this.items.length - 1) {
            return this.table.getItemCount();
        }
        return this.table.indexOf(this.items[n + 1].tableItem);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    private static int checkStyle(int n) {
        int n2 = 0x6000000;
        return n &= n2;
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        return this.table.computeSize(n, n2, bl);
    }

    @Override
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        return this.table.computeTrim(n, n2, n3, n4);
    }

    public void deselectAll() {
        this.checkWidget();
        this.table.deselectAll();
    }

    void expandItem(TableTreeItem tableTreeItem) {
        if (tableTreeItem == null) {
            return;
        }
        this.expandItem(tableTreeItem.parentItem);
        if (!tableTreeItem.getVisible()) {
            tableTreeItem.setVisible(true);
        }
        if (!tableTreeItem.expanded && tableTreeItem.items.length > 0) {
            tableTreeItem.setExpanded(true);
            Event event = new Event();
            event.item = tableTreeItem;
            this.notifyListeners(17, event);
        }
    }

    @Override
    public Color getBackground() {
        return this.table.getBackground();
    }

    @Override
    public Rectangle getClientArea() {
        return this.table.getClientArea();
    }

    @Override
    public Color getForeground() {
        return this.table.getForeground();
    }

    @Override
    public Font getFont() {
        return this.table.getFont();
    }

    public int getItemCount() {
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public TableTreeItem[] getItems() {
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, this.items.length);
        return tableTreeItemArray;
    }

    public TableTreeItem[] getSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.table.getSelection();
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[tableItemArray.length];
        for (int i = 0; i < tableItemArray.length; ++i) {
            tableTreeItemArray[i] = (TableTreeItem)tableItemArray[i].getData(ITEMID);
        }
        return tableTreeItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.table.getSelectionCount();
    }

    @Override
    public int getStyle() {
        this.checkWidget();
        return this.table.getStyle();
    }

    public Table getTable() {
        return this.table;
    }

    void createImages() {
        int n = this.sizeImage.getBounds().height;
        int n2 = Math.min(6, (n - 9) / 2);
        n2 = Math.max(0, n2);
        int n3 = Math.max(10, n - 2 * n2);
        n3 = (n3 + 1) / 2 * 2;
        int n4 = n2 + n3 / 2;
        Color color = this.getForeground();
        Color color2 = this.getDisplay().getSystemColor(18);
        Color color3 = this.getBackground();
        PaletteData paletteData = new PaletteData(color.getRGB(), color3.getRGB(), color2.getRGB());
        ImageData imageData = new ImageData(n, n, 4, paletteData);
        imageData.transparentPixel = 1;
        this.plusImage = new Image((Device)this.getDisplay(), imageData);
        GC gC = new GC(this.plusImage);
        gC.setBackground(color3);
        gC.fillRectangle(0, 0, n, n);
        gC.setForeground(color2);
        gC.drawRectangle(n2, n2, n3, n3);
        gC.setForeground(color);
        gC.drawLine(n4, n2 + 2, n4, n2 + n3 - 2);
        gC.drawLine(n2 + 2, n4, n2 + n3 - 2, n4);
        gC.dispose();
        paletteData = new PaletteData(color.getRGB(), color3.getRGB(), color2.getRGB());
        imageData = new ImageData(n, n, 4, paletteData);
        imageData.transparentPixel = 1;
        this.minusImage = new Image((Device)this.getDisplay(), imageData);
        gC = new GC(this.minusImage);
        gC.setBackground(color3);
        gC.fillRectangle(0, 0, n, n);
        gC.setForeground(color2);
        gC.drawRectangle(n2, n2, n3, n3);
        gC.setForeground(color);
        gC.drawLine(n2 + 2, n4, n2 + n3 - 2, n4);
        gC.dispose();
    }

    Image getPlusImage() {
        if (this.plusImage == null) {
            this.createImages();
        }
        return this.plusImage;
    }

    Image getMinusImage() {
        if (this.minusImage == null) {
            this.createImages();
        }
        return this.minusImage;
    }

    public int indexOf(TableTreeItem tableTreeItem) {
        for (int i = 0; i < this.items.length; ++i) {
            if (tableTreeItem != this.items[i]) continue;
            return i;
        }
        return -1;
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].dispose();
        }
        this.inDispose = false;
        if (this.plusImage != null) {
            this.plusImage.dispose();
        }
        if (this.minusImage != null) {
            this.minusImage.dispose();
        }
        if (this.sizeImage != null) {
            this.sizeImage.dispose();
        }
        this.sizeImage = null;
        this.minusImage = null;
        this.plusImage = null;
    }

    void onResize(Event event) {
        Point point = this.getSize();
        this.table.setBounds(0, 0, point.x, point.y);
    }

    void onSelection(Event event) {
        Event event2 = new Event();
        TableItem tableItem = (TableItem)event.item;
        TableTreeItem tableTreeItem = this.getItem(tableItem);
        event2.item = tableTreeItem;
        if (event.type == 13 && event.detail == 32 && tableTreeItem != null) {
            event2.detail = 32;
            tableTreeItem.checked = tableItem.getChecked();
        }
        this.notifyListeners(event.type, event2);
    }

    public TableTreeItem getItem(int n) {
        this.checkWidget();
        int n2 = this.items.length;
        if (0 > n || n >= n2) {
            SWT.error(6);
        }
        return this.items[n];
    }

    public TableTreeItem getItem(Point point) {
        this.checkWidget();
        TableItem tableItem = this.table.getItem(point);
        if (tableItem == null) {
            return null;
        }
        return this.getItem(tableItem);
    }

    TableTreeItem getItem(TableItem tableItem) {
        if (tableItem == null) {
            return null;
        }
        for (int i = 0; i < this.items.length; ++i) {
            TableTreeItem tableTreeItem = this.items[i].getItem(tableItem);
            if (tableTreeItem == null) continue;
            return tableTreeItem;
        }
        return null;
    }

    void onFocusIn(Event event) {
        this.table.setFocus();
    }

    void onKeyDown(Event event) {
        TableTreeItem[] tableTreeItemArray = this.getSelection();
        if (tableTreeItemArray.length == 0) {
            return;
        }
        TableTreeItem tableTreeItem = tableTreeItemArray[0];
        int n = 0;
        if (event.keyCode == 0x1000004 || event.keyCode == 0x1000003) {
            int n2;
            int n3 = n2 = (this.getStyle() & 0x8000000) != 0 ? 0x1000003 : 0x1000004;
            if (event.keyCode == n2) {
                if (tableTreeItem.getItemCount() == 0) {
                    return;
                }
                if (tableTreeItem.getExpanded()) {
                    TableTreeItem tableTreeItem2 = tableTreeItem.getItems()[0];
                    this.table.setSelection(new TableItem[]{tableTreeItem2.tableItem});
                    this.showItem(tableTreeItem2);
                    n = 13;
                } else {
                    tableTreeItem.setExpanded(true);
                    n = 17;
                }
            } else if (tableTreeItem.getExpanded()) {
                tableTreeItem.setExpanded(false);
                n = 18;
            } else {
                TableTreeItem tableTreeItem3 = tableTreeItem.getParentItem();
                if (tableTreeItem3 != null) {
                    int n4 = tableTreeItem3.indexOf(tableTreeItem);
                    if (n4 != 0) {
                        return;
                    }
                    this.table.setSelection(new TableItem[]{tableTreeItem3.tableItem});
                    n = 13;
                }
            }
        }
        if (event.character == '*') {
            tableTreeItem.expandAll(true);
        }
        if (event.character == '-' && tableTreeItem.getExpanded()) {
            tableTreeItem.setExpanded(false);
            n = 18;
        }
        if (event.character == '+' && tableTreeItem.getItemCount() > 0 && !tableTreeItem.getExpanded()) {
            tableTreeItem.setExpanded(true);
            n = 17;
        }
        if (n == 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = tableTreeItem;
        this.notifyListeners(n, event2);
    }

    void onMouseDown(Event event) {
        TableItem[] tableItemArray = this.table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            Rectangle rectangle = tableItemArray[i].getImageBounds(0);
            if (!rectangle.contains(event.x, event.y)) continue;
            TableTreeItem tableTreeItem = (TableTreeItem)tableItemArray[i].getData(ITEMID);
            event = new Event();
            event.item = tableTreeItem;
            tableTreeItem.setExpanded(!tableTreeItem.getExpanded());
            if (tableTreeItem.getExpanded()) {
                this.notifyListeners(17, event);
            } else {
                this.notifyListeners(18, event);
            }
            return;
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.setRedraw(false);
        for (int i = this.items.length - 1; i >= 0; --i) {
            this.items[i].dispose();
        }
        this.items = EMPTY_ITEMS;
        this.setRedraw(true);
    }

    void removeItem(TableTreeItem tableTreeItem) {
        int n;
        for (n = 0; n < this.items.length && this.items[n] != tableTreeItem; ++n) {
        }
        if (n == this.items.length) {
            return;
        }
        TableTreeItem[] tableTreeItemArray = new TableTreeItem[this.items.length - 1];
        System.arraycopy(this.items, 0, tableTreeItemArray, 0, n);
        System.arraycopy(this.items, n + 1, tableTreeItemArray, n, this.items.length - n - 1);
        this.items = tableTreeItemArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            SWT.error(4);
        }
        this.removeListener(17, treeListener);
        this.removeListener(18, treeListener);
    }

    public void selectAll() {
        this.checkWidget();
        this.table.selectAll();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.table.setBackground(color);
        if (this.sizeImage != null) {
            GC gC = new GC(this.sizeImage);
            gC.setBackground(this.getBackground());
            Rectangle rectangle = this.sizeImage.getBounds();
            gC.fillRectangle(rectangle);
            gC.dispose();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.table.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.table.setForeground(color);
    }

    @Override
    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.table.setMenu(menu);
    }

    public void setSelection(TableTreeItem[] tableTreeItemArray) {
        int n;
        this.checkWidget();
        if (tableTreeItemArray == null) {
            SWT.error(4);
        }
        if ((n = tableTreeItemArray.length) == 0 || (this.table.getStyle() & 4) != 0 && n > 1) {
            this.deselectAll();
            return;
        }
        TableItem[] tableItemArray = new TableItem[n];
        for (int i = 0; i < n; ++i) {
            if (tableTreeItemArray[i] == null) {
                SWT.error(4);
            }
            if (!tableTreeItemArray[i].getVisible()) {
                this.expandItem(tableTreeItemArray[i]);
            }
            tableItemArray[i] = tableTreeItemArray[i].tableItem;
        }
        this.table.setSelection(tableItemArray);
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.table.setToolTipText(string);
    }

    public void showItem(TableTreeItem tableTreeItem) {
        this.checkWidget();
        if (tableTreeItem == null) {
            SWT.error(4);
        }
        if (!tableTreeItem.getVisible()) {
            this.expandItem(tableTreeItem);
        }
        TableItem tableItem = tableTreeItem.tableItem;
        this.table.showItem(tableItem);
    }

    public void showSelection() {
        this.checkWidget();
        this.table.showSelection();
    }
}

