/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascentInPoints;
    int descentInPoints;
    int indent;
    int wrapIndent;
    int wrapWidth;
    int[] segments;
    char[] segmentsChars;
    int[] tabs;
    StyleItem[] styles;
    int stylesCount;
    int layout;
    int context;
    int attrList;
    int selAttrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        super(device);
        device = this.device;
        this.context = OS.gdk_pango_context_get();
        if (this.context == 0) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0) {
            SWT.error(2);
        }
        OS.pango_layout_set_font_description(this.layout, device.systemFont.handle);
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, device.emptyTab);
        OS.pango_layout_set_auto_dir(this.layout, false);
        this.text = "";
        this.descentInPoints = -1;
        this.ascentInPoints = -1;
        this.wrapWidth = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        int n6;
        int n7;
        int n8;
        if (this.attrList != 0) {
            return;
        }
        String string = this.getSegmentsText();
        byte[] byArray = Converter.wcsToMbcs(string, false);
        OS.pango_layout_set_text(this.layout, byArray, byArray.length);
        if (this.stylesCount == 2 && this.styles[0].style == null && this.ascentInPoints == -1 && this.descentInPoints == -1 && this.segments == null) {
            return;
        }
        int n9 = OS.pango_layout_get_text(this.layout);
        this.attrList = OS.pango_attr_list_new();
        this.selAttrList = OS.pango_attr_list_new();
        PangoAttribute pangoAttribute = new PangoAttribute();
        char[] cArray = null;
        int n10 = string.length();
        int n11 = n8 = n10 - this.text.length();
        int[] nArray = null;
        if ((this.ascentInPoints != -1 || this.descentInPoints != -1) && n10 > 0) {
            PangoRectangle pangoRectangle = new PangoRectangle();
            if (this.ascentInPoints != -1) {
                pangoRectangle.y = -(DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints) * 1024);
            }
            pangoRectangle.height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), Math.max(0, this.ascentInPoints) + Math.max(0, this.descentInPoints)) * 1024;
            n7 = OS.pango_layout_get_line_count(this.layout);
            cArray = new char[n10 + n7 * 2];
            nArray = new int[n7];
            n6 = 0;
            object = new PangoLayoutLine();
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = OS.pango_layout_get_line(this.layout, n5);
                OS.memmove((PangoLayoutLine)object, n4, PangoLayoutLine.sizeof);
                n3 = ((PangoLayoutLine)object).start_index;
                n2 = n5 * 6;
                n = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, n, PangoAttribute.sizeof);
                pangoAttribute.start_index = n3 + n2;
                pangoAttribute.end_index = n3 + n2 + 3;
                OS.memmove(n, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n));
                n = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, n, PangoAttribute.sizeof);
                pangoAttribute.start_index = n3 + n2 + 3;
                pangoAttribute.end_index = n3 + n2 + 6;
                OS.memmove(n, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n));
                int n12 = OS.g_utf16_pointer_to_offset(n9, n9 + n3);
                cArray[n12 + n5 * 2] = 8203;
                cArray[n12 + n5 * 2 + 1] = 65279;
                string.getChars(n6, n12, cArray, n6 + n5 * 2);
                nArray[n5] = n12 + n5 * 2;
                n6 = n12;
            }
            string.getChars(n6, n10, cArray, n6 + n5 * 2);
            byArray = Converter.wcsToMbcs(cArray, false);
            OS.pango_layout_set_text(this.layout, byArray, byArray.length);
            n9 = OS.pango_layout_get_text(this.layout);
            n11 += 2 * n7;
        } else {
            cArray = new char[n10];
            string.getChars(0, n10, cArray, 0);
        }
        this.invalidOffsets = new int[n11];
        if (n11 > 0) {
            n11 = 0;
            int n13 = 0;
            n7 = 0;
            for (n6 = 0; n6 < cArray.length; ++n6) {
                n5 = cArray[n6];
                if (n5 == 8203 && nArray != null && n13 < nArray.length && n6 == nArray[n13]) {
                    this.invalidOffsets[n11++] = n6++;
                    this.invalidOffsets[n11++] = n6;
                    ++n13;
                    continue;
                }
                if (n7 >= n8 || n6 - n11 != this.segments[n7]) continue;
                this.invalidOffsets[n11++] = n6;
                ++n7;
            }
        }
        int n14 = OS.strlen(n9);
        Font font = this.font != null ? this.font : this.device.systemFont;
        for (n6 = 0; n6 < this.stylesCount - 1; ++n6) {
            int n15;
            int n16;
            Color color;
            Color color2;
            Object object2;
            int n17;
            StyleItem styleItem = this.styles[n6];
            object = styleItem.style;
            if (object == null) continue;
            n4 = this.translateOffset(styleItem.start);
            n3 = this.translateOffset(this.styles[n6 + 1].start - 1);
            n2 = OS.g_utf16_offset_to_pointer(n9, n4) - n9;
            n = OS.g_utf16_offset_to_pointer(n9, n3 + 1) - n9;
            n2 = Math.min(n2, n14);
            n = Math.min(n, n14);
            Font font2 = ((TextStyle)object).font;
            if (font2 != null && !font2.isDisposed() && !font.equals(font2)) {
                n17 = OS.pango_attr_font_desc_new(font2.handle);
                OS.memmove(pangoAttribute, n17, PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(n17, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n17);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n17));
            }
            if (((TextStyle)object).underline) {
                int n18;
                n17 = 0;
                switch (((TextStyle)object).underlineStyle) {
                    case 0: {
                        n17 = 1;
                        break;
                    }
                    case 1: {
                        n17 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n17 = 4;
                        break;
                    }
                    case 4: {
                        if (((TextStyle)object).foreground == null) {
                            n18 = OS.pango_attr_foreground_new((short)0, (short)13107, (short)-26215);
                            OS.memmove(pangoAttribute, n18, PangoAttribute.sizeof);
                            pangoAttribute.start_index = n2;
                            pangoAttribute.end_index = n;
                            OS.memmove(n18, pangoAttribute, PangoAttribute.sizeof);
                            OS.pango_attr_list_insert(this.attrList, n18);
                        }
                        n17 = 1;
                    }
                }
                n18 = OS.pango_attr_underline_new(n17);
                OS.memmove(pangoAttribute, n18, PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(n18, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n18);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n18));
                if (((TextStyle)object).underlineColor != null) {
                    object2 = ((TextStyle)object).underlineColor.handle;
                    n18 = OS.pango_attr_underline_color_new(((GdkColor)object2).red, ((GdkColor)object2).green, ((GdkColor)object2).blue);
                    if (n18 != 0) {
                        OS.memmove(pangoAttribute, n18, PangoAttribute.sizeof);
                        pangoAttribute.start_index = n2;
                        pangoAttribute.end_index = n;
                        OS.memmove(n18, pangoAttribute, PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, n18);
                        OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n18));
                    }
                }
            }
            if (((TextStyle)object).strikeout) {
                n17 = OS.pango_attr_strikethrough_new(true);
                OS.memmove(pangoAttribute, n17, PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(n17, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n17);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n17));
                if (((TextStyle)object).strikeoutColor != null) {
                    GdkColor gdkColor = ((TextStyle)object).strikeoutColor.handle;
                    n17 = OS.pango_attr_strikethrough_color_new(gdkColor.red, gdkColor.green, gdkColor.blue);
                    if (n17 != 0) {
                        OS.memmove(pangoAttribute, n17, PangoAttribute.sizeof);
                        pangoAttribute.start_index = n2;
                        pangoAttribute.end_index = n;
                        OS.memmove(n17, pangoAttribute, PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, n17);
                        OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n17));
                    }
                }
            }
            if ((color2 = ((TextStyle)object).foreground) != null && !color2.isDisposed()) {
                GdkColor gdkColor = color2.handle;
                int n19 = OS.pango_attr_foreground_new(gdkColor.red, gdkColor.green, gdkColor.blue);
                OS.memmove(pangoAttribute, n19, PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(n19, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n19);
            }
            if ((color = ((TextStyle)object).background) != null && !color.isDisposed()) {
                object2 = color.handle;
                n16 = OS.pango_attr_background_new(((GdkColor)object2).red, ((GdkColor)object2).green, ((GdkColor)object2).blue);
                OS.memmove(pangoAttribute, n16, PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(n16, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n16);
            }
            if ((object2 = ((TextStyle)object).metrics) != null) {
                PangoRectangle pangoRectangle = new PangoRectangle();
                pangoRectangle.y = -(DPIUtil.autoScaleUp((Drawable)this.getDevice(), ((GlyphMetrics)object2).ascent) * 1024);
                pangoRectangle.height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ((GlyphMetrics)object2).ascent + ((GlyphMetrics)object2).descent) * 1024;
                pangoRectangle.width = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ((GlyphMetrics)object2).width) * 1024;
                n15 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, n15, PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(n15, pangoAttribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, n15);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n15));
            }
            if ((n16 = ((TextStyle)object).rise) == 0) continue;
            n15 = OS.pango_attr_rise_new(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n16) * 1024);
            OS.memmove(pangoAttribute, n15, PangoAttribute.sizeof);
            pangoAttribute.start_index = n2;
            pangoAttribute.end_index = n;
            OS.memmove(n15, pangoAttribute, PangoAttribute.sizeof);
            OS.pango_attr_list_insert(this.attrList, n15);
            OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(n15));
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    int[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n5];
        for (int i = 0; i < n8; ++i) {
            int n9 = 4 * i;
            nArray[n9] = n + n7 * i;
            nArray[n9 + 1] = n4;
            nArray[n9 + 2] = nArray[n9] + n7 / 2;
            nArray[n9 + 3] = n2;
        }
        nArray[n5 - 2] = n + n7 * n8;
        nArray[n5 - 1] = n4;
        return nArray;
    }

    @Override
    void destroy() {
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        this.segments = null;
        this.segmentsChars = null;
        if (this.layout != 0) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0;
        if (this.context != 0) {
            OS.g_object_unref(this.context);
        }
        this.context = 0;
    }

    public void draw(GC gC, int n, int n2) {
        n = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n);
        n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2);
        this.drawInPixels(gC, n, n2);
    }

    void drawInPixels(GC gC, int n, int n2) {
        this.drawInPixels(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.checkLayout();
        n = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n);
        n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2);
        this.drawInPixels(gC, n, n2, n3, n4, color, color2);
    }

    void drawInPixels(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.drawInPixels(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        this.checkLayout();
        n = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n);
        n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2);
        this.drawInPixels(gC, n, n2, n3, n4, color, color2, n5);
    }

    void drawInPixels(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        this.checkLayout();
        this.computeRuns();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        gC.checkGC(1);
        int n8 = this.text.length();
        n += Math.min(this.indent, this.wrapIndent);
        boolean bl = n3 <= n4 && n3 != -1 && n4 != -1;
        GCData gCData = gC.data;
        int n9 = gCData.cairo;
        if ((n5 & 0x30000) != 0 && (bl || (n5 & 0x100000) != 0)) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            PangoLogAttr pangoLogAttr = new PangoLogAttr();
            PangoRectangle pangoRectangle = new PangoRectangle();
            n7 = OS.pango_layout_get_line_count(this.layout);
            int n10 = OS.pango_layout_get_text(this.layout);
            int n11 = OS.pango_layout_get_iter(this.layout);
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            if (n9 != 0) {
                Cairo.cairo_save(n9);
                GdkColor gdkColor = color2.handle;
                Cairo.cairo_set_source_rgba(n9, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, color2.handle);
            }
            n6 = 0;
            do {
                int n12;
                int n13;
                int n14;
                OS.pango_layout_iter_get_line_extents(n11, null, pangoRectangle);
                if (OS.pango_layout_iter_next_line(n11)) {
                    n14 = OS.pango_layout_iter_get_index(n11);
                    n13 = OS.g_utf16_pointer_to_offset(n10, n10 + n14);
                } else {
                    n13 = OS.g_utf16_strlen(n10, -1);
                }
                n14 = 0;
                if (n6 == n7 - 1 && (n5 & 0x100000) != 0) {
                    n14 = 1;
                } else {
                    if (nArray[0] == 0) {
                        OS.pango_layout_get_log_attrs(this.layout, nArray, nArray2);
                    }
                    OS.memmove(pangoLogAttr, nArray[0] + n13 * PangoLogAttr.sizeof, PangoLogAttr.sizeof);
                    if (!pangoLogAttr.is_line_break) {
                        if (n3 <= n13 && n13 <= n4) {
                            n14 = 1;
                        }
                    } else if (n3 <= n13 && n13 < n4 && (n5 & 0x10000) != 0) {
                        n14 = 1;
                    }
                }
                if (n14 == 0) continue;
                int n15 = n + OS.PANGO_PIXELS(pangoRectangle.x) + OS.PANGO_PIXELS(pangoRectangle.width);
                int n16 = n2 + OS.PANGO_PIXELS(pangoRectangle.y);
                int n17 = OS.PANGO_PIXELS(pangoRectangle.height);
                if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
                    n17 = Math.max(n17, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
                }
                int n18 = n12 = (n5 & 0x10000) != 0 ? Short.MAX_VALUE : n17 / 3;
                if (n9 != 0) {
                    Cairo.cairo_rectangle(n9, n15, n16, n12, n17);
                    Cairo.cairo_fill(n9);
                    continue;
                }
                OS.gdk_draw_rectangle(gCData.drawable, gC.handle, 1, n15, n16, n12, n17);
            } while (++n6 < n7);
            OS.pango_layout_iter_free(n11);
            if (nArray[0] != 0) {
                OS.g_free(nArray[0]);
            }
            if (n9 != 0) {
                Cairo.cairo_restore(n9);
            } else {
                OS.gdk_gc_set_foreground(gC.handle, gCData.foreground);
            }
        }
        if (n8 == 0) {
            return;
        }
        if (!bl) {
            if (n9 != 0) {
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_save(n9);
                    Cairo.cairo_scale(n9, -1.0, 1.0);
                    Cairo.cairo_translate(n9, -2 * n - this.width(), 0.0);
                }
                Cairo.cairo_move_to(n9, n, n2);
                OS.pango_cairo_show_layout(n9, this.layout);
                this.drawBorder(gC, n, n2, null);
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(n9);
                }
            } else {
                OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
                this.drawBorder(gC, n, n2, null);
            }
        } else {
            boolean bl2;
            n3 = Math.min(Math.max(0, n3), n8 - 1);
            n4 = Math.min(Math.max(0, n4), n8 - 1);
            n8 = OS.g_utf16_strlen(OS.pango_layout_get_text(this.layout), -1);
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            boolean bl3 = bl2 = n3 == 0 && n4 == n8 - 1;
            if (bl2) {
                if (n9 != 0) {
                    int n19 = OS.pango_layout_get_text(this.layout);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_save(n9);
                        Cairo.cairo_scale(n9, -1.0, 1.0);
                        Cairo.cairo_translate(n9, -2 * n - this.width(), 0.0);
                    }
                    this.drawWithCairo(gC, n, n2, 0, OS.strlen(n19), bl2, color.handle, color2.handle);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(n9);
                    }
                } else {
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                    this.drawBorder(gC, n, n2, color.handle);
                }
            } else {
                int n20 = OS.pango_layout_get_text(this.layout);
                int n21 = OS.g_utf16_offset_to_pointer(n20, n3) - n20;
                int n22 = OS.g_utf16_offset_to_pointer(n20, n4 + 1) - n20;
                n7 = OS.strlen(n20);
                n21 = Math.min(n21, n7);
                n22 = Math.min(n22, n7);
                if (n9 != 0) {
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_save(n9);
                        Cairo.cairo_scale(n9, -1.0, 1.0);
                        Cairo.cairo_translate(n9, -2 * n - this.width(), 0.0);
                    }
                    this.drawWithCairo(gC, n, n2, n21, n22, bl2, color.handle, color2.handle);
                    if ((gCData.style & 0x8000000) != 0) {
                        Cairo.cairo_restore(n9);
                    }
                } else {
                    Region region = new Region();
                    gC.getClipping(region);
                    OS.gdk_draw_layout(gCData.drawable, gC.handle, n, n2, this.layout);
                    this.drawBorder(gC, n, n2, null);
                    int[] nArray = new int[]{n21, n22};
                    n6 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
                    if (n6 != 0) {
                        OS.gdk_gc_set_clip_region(gC.handle, n6);
                        OS.gdk_region_destroy(n6);
                    }
                    OS.gdk_draw_layout_with_colors(gCData.drawable, gC.handle, n, n2, this.layout, color.handle, color2.handle);
                    this.drawBorder(gC, n, n2, color.handle);
                    gC.setClipping(region);
                    region.dispose();
                }
            }
        }
        if (n9 != 0) {
            Cairo.cairo_new_path(n9);
        }
    }

    void drawWithCairo(GC gC, int n, int n2, int n3, int n4, boolean bl, GdkColor gdkColor, GdkColor gdkColor2) {
        int[] nArray;
        int n5;
        GCData gCData = gC.data;
        int n6 = gCData.cairo;
        Cairo.cairo_save(n6);
        if (!bl) {
            Cairo.cairo_move_to(n6, n, n2);
            OS.pango_cairo_show_layout(n6, this.layout);
            this.drawBorder(gC, n, n2, null);
        }
        if ((n5 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray = new int[]{n3, n4}, nArray.length / 2)) != 0) {
            OS.gdk_cairo_region(n6, n5);
            Cairo.cairo_clip(n6);
            Cairo.cairo_set_source_rgba(n6, (float)(gdkColor2.red & 0xFFFF) / 65535.0f, (float)(gdkColor2.green & 0xFFFF) / 65535.0f, (float)(gdkColor2.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
            Cairo.cairo_paint(n6);
            OS.gdk_region_destroy(n5);
        }
        Cairo.cairo_set_source_rgba(n6, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
        Cairo.cairo_move_to(n6, n, n2);
        OS.pango_layout_set_attributes(this.layout, this.selAttrList);
        OS.pango_cairo_show_layout(n6, this.layout);
        OS.pango_layout_set_attributes(this.layout, this.attrList);
        this.drawBorder(gC, n, n2, gdkColor);
        Cairo.cairo_restore(n6);
    }

    void drawBorder(GC gC, int n, int n2, GdkColor gdkColor) {
        int n3;
        GCData gCData = gC.data;
        int n4 = gCData.cairo;
        int n5 = gC.handle;
        int n6 = OS.pango_layout_get_text(this.layout);
        GdkGCValues gdkGCValues = null;
        if (n4 != 0) {
            Cairo.cairo_save(n4);
        }
        for (n3 = 0; n3 < this.stylesCount - 1; ++n3) {
            int n7;
            int n8;
            int n9;
            int n10;
            boolean bl;
            TextStyle textStyle = this.styles[n3].style;
            if (textStyle == null) continue;
            boolean bl2 = bl = textStyle.borderStyle != 0;
            if (!bl || textStyle.isAdherentBorder(this.styles[n3 + 1].style)) continue;
            int n11 = this.styles[n3].start;
            for (n10 = n3; n10 > 0 && textStyle.isAdherentBorder(this.styles[n10 - 1].style); --n10) {
                n11 = this.styles[n10 - 1].start;
            }
            n11 = this.translateOffset(n11);
            n10 = this.translateOffset(this.styles[n3 + 1].start - 1);
            int n12 = OS.g_utf16_offset_to_pointer(n6, n11) - n6;
            int[] nArray = new int[]{n12, n9 = OS.g_utf16_offset_to_pointer(n6, n10 + 1) - n6};
            int n13 = OS.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
            if (n13 == 0) continue;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            Region.gdk_region_get_rectangles(n13, nArray3, nArray2);
            GdkRectangle gdkRectangle = new GdkRectangle();
            GdkColor gdkColor2 = null;
            if (gdkColor2 == null && textStyle.borderColor != null) {
                gdkColor2 = textStyle.borderColor.handle;
            }
            if (gdkColor2 == null && gdkColor != null) {
                gdkColor2 = gdkColor;
            }
            if (gdkColor2 == null && textStyle.foreground != null) {
                gdkColor2 = textStyle.foreground.handle;
            }
            if (gdkColor2 == null) {
                gdkColor2 = gCData.foreground;
            }
            int n14 = 1;
            float[] fArray = null;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    fArray = n14 != 0 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                    break;
                }
                case 4: {
                    float[] fArray2 = fArray = n14 != 0 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                }
            }
            if (n4 != 0) {
                Cairo.cairo_set_source_rgba(n4, (float)(gdkColor2.red & 0xFFFF) / 65535.0f, (float)(gdkColor2.green & 0xFFFF) / 65535.0f, (float)(gdkColor2.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                Cairo.cairo_set_line_width(n4, n14);
                if (fArray != null) {
                    double[] dArray = new double[fArray.length];
                    for (n8 = 0; n8 < dArray.length; ++n8) {
                        dArray[n8] = n14 == 0 || gCData.lineStyle == 6 ? (double)fArray[n8] : (double)(fArray[n8] * (float)n14);
                    }
                    Cairo.cairo_set_dash(n4, dArray, dArray.length, 0.0);
                } else {
                    Cairo.cairo_set_dash(n4, null, 0, 0.0);
                }
                for (n7 = 0; n7 < nArray2[0]; ++n7) {
                    OS.memmove(gdkRectangle, nArray3[0] + n7 * GdkRectangle.sizeof, GdkRectangle.sizeof);
                    Cairo.cairo_rectangle(n4, (double)gdkRectangle.x + 0.5, (double)gdkRectangle.y + 0.5, gdkRectangle.width - 1, gdkRectangle.height - 1);
                }
                Cairo.cairo_stroke(n4);
            } else {
                if (gdkGCValues == null) {
                    gdkGCValues = new GdkGCValues();
                    OS.gdk_gc_get_values(n5, gdkGCValues);
                }
                OS.gdk_gc_set_foreground(n5, gdkColor2);
                n7 = 1;
                n8 = 0;
                int n15 = 0;
                if (fArray != null) {
                    byte[] byArray = new byte[fArray.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)(n14 == 0 || gCData.lineStyle == 6 ? fArray[i] : fArray[i] * (float)n14);
                    }
                    OS.gdk_gc_set_dashes(n5, 0, byArray, byArray.length);
                    n15 = 1;
                } else {
                    n15 = 0;
                }
                OS.gdk_gc_set_line_attributes(n5, n14, n15, n7, n8);
                for (int i = 0; i < nArray2[0]; ++i) {
                    OS.memmove(gdkRectangle, nArray3[0] + i * GdkRectangle.sizeof, GdkRectangle.sizeof);
                    OS.gdk_draw_rectangle(gCData.drawable, n5, 0, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width - 1, gdkRectangle.height - 1);
                }
            }
            if (nArray3[0] != 0) {
                OS.g_free(nArray3[0]);
            }
            OS.gdk_region_destroy(n13);
        }
        if (gdkGCValues != null) {
            n3 = 245761;
            OS.gdk_gc_set_values(n5, gdkGCValues, n3);
            gCData.state &= 0xFFFFFFF7;
        }
        if (n4 != 0) {
            Cairo.cairo_restore(n4);
        }
    }

    void freeRuns() {
        if (this.attrList == 0) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0;
        if (this.selAttrList != 0) {
            OS.pango_attr_list_unref(this.selAttrList);
            this.selAttrList = 0;
        }
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int n = OS.pango_layout_get_alignment(this.layout);
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        switch (n) {
            case 0: {
                return bl ? 131072 : 16384;
            }
            case 2: {
                return bl ? 16384 : 131072;
            }
        }
        return 0x1000000;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascentInPoints;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        Rectangle rectangle = DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels());
        int n = OS.pango_layout_get_line_count(this.layout);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getLineBounds((int)i).height + OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
        }
        rectangle.height = n2;
        return rectangle;
    }

    Rectangle getBoundsInPixels() {
        this.checkLayout();
        this.computeRuns();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(this.layout, nArray, nArray2);
        int n = OS.pango_layout_get_width(this.layout);
        nArray[0] = n != -1 ? n : nArray[0] + OS.pango_layout_get_indent(this.layout);
        int n2 = OS.PANGO_PIXELS(nArray[0]);
        int n3 = OS.PANGO_PIXELS(nArray2[0]);
        if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
            n3 = Math.max(n3, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
        }
        return new Rectangle(0, 0, n2, n3 += OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout)));
    }

    public Rectangle getBounds(int n, int n2) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels(n, n2));
    }

    Rectangle getBoundsInPixels(int n, int n2) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n4 - 1);
        n2 = Math.min(Math.max(0, n2), n4 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        int n5 = OS.pango_layout_get_text(this.layout);
        int n6 = OS.g_utf16_offset_to_pointer(n5, n) - n5;
        int n7 = OS.g_utf16_offset_to_pointer(n5, n2 + 1) - n5;
        int n8 = OS.strlen(n5);
        int[] nArray = new int[]{n6 = Math.min(n6, n8), n7 = Math.min(n7, n8)};
        int n9 = OS.gdk_pango_layout_get_clip_region(this.layout, 0, 0, nArray, 1);
        if (n9 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        PangoRectangle pangoRectangle = new PangoRectangle();
        int n10 = OS.pango_layout_get_iter(this.layout);
        if (n10 == 0) {
            SWT.error(2);
        }
        if ((n3 = OS.gdk_region_new()) == 0) {
            SWT.error(2);
        }
        int n11 = 0;
        do {
            OS.pango_layout_iter_get_line_extents(n10, null, pangoRectangle);
            n11 = OS.pango_layout_iter_next_line(n10) ? OS.pango_layout_iter_get_index(n10) - 1 : n8;
            if (n6 > n11) continue;
            gdkRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            gdkRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            gdkRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            gdkRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            OS.gdk_region_union_with_rect(n3, gdkRectangle);
        } while (n11 + 1 <= n7);
        OS.gdk_region_intersect(n9, n3);
        OS.gdk_region_destroy(n3);
        OS.pango_layout_iter_free(n10);
        OS.gdk_region_get_clipbox(n9, gdkRectangle);
        OS.gdk_region_destroy(n9);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            gdkRectangle.x = this.width() - gdkRectangle.x - gdkRectangle.width;
        }
        gdkRectangle.x += Math.min(this.indent, this.wrapIndent);
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descentInPoints;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getIndentInPixels());
    }

    int getIndentInPixels() {
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = OS.pango_layout_get_iter(this.layout);
        if (n3 == 0) {
            SWT.error(2);
        }
        int n4 = 0;
        PangoItem pangoItem = new PangoItem();
        PangoLayoutRun pangoLayoutRun = new PangoLayoutRun();
        int n5 = OS.pango_layout_get_text(this.layout);
        int n6 = OS.g_utf16_offset_to_pointer(n5, n) - n5;
        int n7 = OS.strlen(n5);
        n6 = Math.min(n6, n7);
        do {
            int n8;
            if ((n8 = OS.pango_layout_iter_get_run(n3)) == 0) continue;
            OS.memmove(pangoLayoutRun, n8, PangoLayoutRun.sizeof);
            OS.memmove(pangoItem, pangoLayoutRun.item, PangoItem.sizeof);
            if (pangoItem.offset > n6 || n6 >= pangoItem.offset + pangoItem.length) continue;
            n4 = pangoItem.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(n3));
        OS.pango_layout_iter_free(n3);
        return n4;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLineBoundsInPixels(n));
    }

    Rectangle getLineBoundsInPixels(int n) {
        int n2;
        this.computeRuns();
        int n3 = OS.pango_layout_get_line_count(this.layout);
        if (0 > n || n >= n3) {
            SWT.error(6);
        }
        if ((n2 = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        for (int i = 0; i < n; ++i) {
            OS.pango_layout_iter_next_line(n2);
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents(n2, null, pangoRectangle);
        OS.pango_layout_iter_free(n2);
        int n4 = OS.PANGO_PIXELS(pangoRectangle.x);
        int n5 = OS.PANGO_PIXELS(pangoRectangle.y);
        int n6 = OS.PANGO_PIXELS(pangoRectangle.width);
        int n7 = OS.PANGO_PIXELS(pangoRectangle.height);
        if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
            n7 = Math.max(n7, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
        }
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n4 = this.width() - n4 - n6;
        }
        return new Rectangle(n4 += Math.min(this.indent, this.wrapIndent), n5, n6, n7);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(5);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        int n4 = OS.pango_layout_get_text(this.layout);
        int n5 = OS.g_utf16_offset_to_pointer(n4, n) - n4;
        int n6 = OS.strlen(n4);
        n5 = Math.min(n5, n6);
        int n7 = OS.pango_layout_get_iter(this.layout);
        if (n7 == 0) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(n7) && OS.pango_layout_iter_get_index(n7) <= n5) {
            ++n3;
        }
        OS.pango_layout_iter_free(n7);
        return n3;
    }

    public FontMetrics getLineMetrics(int n) {
        int n2;
        int n3;
        int n4;
        this.checkLayout();
        this.computeRuns();
        int n5 = OS.pango_layout_get_line_count(this.layout);
        if (0 > n || n >= n5) {
            SWT.error(6);
        }
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        OS.memmove(pangoLayoutLine, OS.pango_layout_get_line(this.layout, n), PangoLayoutLine.sizeof);
        if (pangoLayoutLine.runs == 0) {
            n4 = this.font != null ? this.font.handle : this.device.systemFont.handle;
            int n6 = OS.pango_context_get_language(this.context);
            int n7 = OS.pango_context_get_metrics(this.context, n4, n6);
            int n8 = OS.pango_font_metrics_get_ascent(n7);
            int n9 = OS.pango_font_metrics_get_descent(n7);
            n3 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(n8));
            n2 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(n8 + n9));
            OS.pango_font_metrics_unref(n7);
        } else {
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, n), null, pangoRectangle);
            n3 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(-pangoRectangle.y));
            n2 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(pangoRectangle.height));
        }
        n2 = Math.max(this.ascentInPoints + this.descentInPoints, n2);
        n3 = Math.max(this.ascentInPoints, n3);
        n4 = n2 - n3;
        return FontMetrics.gtk_new(n3, n4, 0);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int n = OS.pango_layout_get_line_count(this.layout);
        int[] nArray = new int[n + 1];
        int n2 = OS.pango_layout_get_text(this.layout);
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        for (int i = 0; i < n; ++i) {
            int n3 = OS.pango_layout_get_line(this.layout, i);
            OS.memmove(pangoLayoutLine, n3, PangoLayoutLine.sizeof);
            int n4 = OS.g_utf16_pointer_to_offset(n2, n2 + pangoLayoutLine.start_index);
            nArray[i] = this.untranslateOffset(n4);
        }
        nArray[n] = this.text.length();
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLocationInPixels(n, bl));
    }

    Point getLocationInPixels(int n, boolean bl) {
        this.computeRuns();
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = OS.pango_layout_get_text(this.layout);
        int n4 = OS.g_utf16_offset_to_pointer(n3, n) - n3;
        int n5 = OS.strlen(n3);
        n4 = Math.min(n4, n5);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, n4, pangoRectangle);
        int n6 = bl ? pangoRectangle.x + pangoRectangle.width : pangoRectangle.x;
        int n7 = pangoRectangle.y;
        n6 = OS.PANGO_PIXELS(n6);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n6 = this.width() - n6;
        }
        return new Point(n6 += Math.min(this.indent, this.wrapIndent), OS.PANGO_PIXELS(n7));
    }

    public int getNextOffset(int n, int n2) {
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (0 > n || n > n4) {
            SWT.error(6);
        }
        if (bl) {
            if (n == n4) {
                return n4;
            }
        } else if (n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, nArray, nArray2);
        if (nArray[0] == 0) {
            return n + n3;
        }
        int n6 = OS.pango_layout_get_text(this.layout);
        int n7 = OS.g_utf16_offset_to_utf8_offset(n6, this.translateOffset(n));
        int n8 = OS.g_utf8_strlen(n6, -1);
        n7 += n3;
        PangoLogAttr pangoLogAttr = new PangoLogAttr();
        while (0 <= n7 && n7 <= n8) {
            OS.memmove(pangoLogAttr, nArray[0] + n7 * PangoLogAttr.sizeof, PangoLogAttr.sizeof);
            boolean bl2 = false;
            boolean bl3 = false;
            if ((n2 & 2) != 0 && pangoLogAttr.is_cursor_position) {
                bl2 = true;
            }
            if ((n2 & 4) != 0) {
                if (bl) {
                    if (pangoLogAttr.is_word_end) {
                        bl2 = true;
                    }
                } else if (pangoLogAttr.is_word_start) {
                    bl2 = true;
                }
            }
            if ((n2 & 0x10) != 0) {
                if (pangoLogAttr.is_word_start) {
                    bl2 = true;
                }
                if (pangoLogAttr.is_sentence_end) {
                    bl2 = true;
                }
            }
            if ((n2 & 8) != 0) {
                if (pangoLogAttr.is_word_end) {
                    bl2 = true;
                }
                if (pangoLogAttr.is_sentence_start) {
                    bl2 = true;
                }
            }
            if (bl) {
                if (n7 == n8) {
                    bl3 = true;
                }
            } else if (n7 == 0) {
                bl3 = true;
            }
            if (bl2 || bl3) {
                int n9 = OS.g_utf8_offset_to_utf16_offset(n6, n7);
                if (bl2 && this.invalidOffsets != null) {
                    for (int i = 0; i < this.invalidOffsets.length; ++i) {
                        if (n9 != this.invalidOffsets[i]) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (bl2 || bl3) {
                    n = this.untranslateOffset(n9);
                    break;
                }
            }
            n7 += n3;
        }
        OS.g_free(nArray[0]);
        return Math.min(Math.max(0, n), n4);
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), point), nArray);
    }

    int getOffsetInPixels(Point point, int[] nArray) {
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffsetInPixels(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        this.checkLayout();
        return this.getOffset(new Point(n, n2), nArray);
    }

    int getOffsetInPixels(int n, int n2, int[] nArray) {
        int n3;
        this.computeRuns();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        n -= Math.min(this.indent, this.wrapIndent);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n = this.width() - n;
        }
        if ((n3 = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents(n3, null, pangoRectangle);
            pangoRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            pangoRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            if (pangoRectangle.y > n2 || n2 >= pangoRectangle.y + pangoRectangle.height) continue;
            pangoRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            pangoRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            if (n >= pangoRectangle.x + pangoRectangle.width) {
                n = pangoRectangle.x + pangoRectangle.width - 1;
            }
            if (n >= pangoRectangle.x) break;
            n = pangoRectangle.x;
            break;
        } while (OS.pango_layout_iter_next_line(n3));
        OS.pango_layout_iter_free(n3);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.pango_layout_xy_to_index(this.layout, n * 1024, n2 * 1024, nArray2, nArray3);
        int n4 = OS.pango_layout_get_text(this.layout);
        int n5 = OS.g_utf16_pointer_to_offset(n4, n4 + nArray2[0]);
        if (nArray != null) {
            nArray[0] = nArray3[0];
            if (nArray3[0] != 0) {
                nArray[0] = OS.g_utf8_offset_to_utf16_offset(n4, OS.g_utf8_pointer_to_offset(n4, n4 + nArray2[0]) + nArray3[0]) - n5;
            }
        }
        return this.untranslateOffset(n5);
    }

    public int getOrientation() {
        this.checkLayout();
        int n = OS.pango_context_get_base_dir(this.context);
        return n == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int n, int n2) {
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            if (this.styles[i].style == null) continue;
            nArray[n++] = this.styles[i].start;
            nArray[n++] = this.styles[i + 1].start - 1;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return this.text;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return this.text;
            }
        }
        char[] cArray = new char[n3];
        this.text.getChars(0, n3, cArray, 0);
        char[] cArray2 = new char[n3 + n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n5 < n3) {
            if (n6 < n4 && n5 == this.segments[n6]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
                cArray2[n5 + n6++] = n;
                continue;
            }
            cArray2[n5 + n6] = cArray[n5++];
        }
        while (n6 < n4) {
            this.segments[n6] = n5;
            n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
            cArray2[n5 + n6++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getSpacingInPixels());
    }

    int getSpacingInPixels() {
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (0 > n || n >= n2) {
            SWT.error(6);
        }
        for (int i = 1; i < this.stylesCount; ++i) {
            StyleItem styleItem = this.styles[i];
            if (styleItem.start <= n) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        for (int i = 0; i < this.stylesCount; ++i) {
            if (this.styles[i].style == null) continue;
            textStyleArray[n++] = this.styles[i].style;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getTabsInPixels());
    }

    int[] getTabsInPixels() {
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        return this.getOrientation();
    }

    public int getWidth() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWidthInPixels());
    }

    int getWidthInPixels() {
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWrapIndentInPixels());
    }

    int getWrapIndentInPixels() {
        return this.wrapIndent;
    }

    @Override
    public boolean isDisposed() {
        return this.layout == 0;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        int n3 = 1;
        switch (n) {
            case 16384: {
                n3 = bl ? 2 : 0;
                break;
            }
            case 131072: {
                n3 = bl ? 0 : 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, n3);
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascentInPoints == n) {
            return;
        }
        this.freeRuns();
        this.ascentInPoints = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descentInPoints == n) {
            return;
        }
        this.freeRuns();
        this.descentInPoints = n;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.freeRuns();
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : this.device.systemFont.handle);
    }

    public void setIndent(int n) {
        this.checkLayout();
        this.setIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setIndentInPixels(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.indent = n;
        OS.pango_layout_set_indent(this.layout, (n - this.wrapIndent) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, bl);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n &= n3) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        int n4 = n2 = n == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == n2) {
            return;
        }
        this.freeRuns();
        OS.pango_context_set_base_dir(this.context, n2);
        OS.pango_layout_context_changed(this.layout);
        int n5 = OS.pango_layout_get_alignment(this.layout);
        if (n5 != 1) {
            n5 = n5 == 0 ? 2 : 0;
            OS.pango_layout_set_alignment(this.layout, n5);
        }
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        this.setSpacingInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setSpacingInPixels(int n) {
        OS.pango_layout_set_spacing(this.layout, n * 1024);
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n;
            for (n = 0; n < nArray.length && this.segments[n] == nArray[n]; ++n) {
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n;
            for (n = 0; n < cArray.length && this.segmentsChars[n] == cArray[n]; ++n) {
            }
            if (n == cArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = cArray;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.checkLayout();
        int n7 = this.text.length();
        if (n7 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n7 - 1);
        n2 = Math.min(Math.max(0, n2), n7 - 1);
        if (n > 0 && TextLayout.isAlef(this.text.charAt(n)) && TextLayout.isLam(this.text.charAt(n - 1))) {
            --n;
        }
        if (n2 < n7 - 1 && TextLayout.isLam(this.text.charAt(n2)) && TextLayout.isAlef(this.text.charAt(n2 + 1))) {
            ++n2;
        }
        int n8 = -1;
        int n9 = this.stylesCount;
        while (n9 - n8 > 1) {
            int n10 = (n9 + n8) / 2;
            if (this.styles[n10 + 1].start > n) {
                n9 = n10;
                continue;
            }
            n8 = n10;
        }
        if (0 <= n9 && n9 < this.stylesCount) {
            StyleItem styleItem = this.styles[n9];
            if (styleItem.start == n && this.styles[n9 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        for (n6 = n5 = n9; n6 < this.stylesCount && this.styles[n6 + 1].start <= n2; ++n6) {
        }
        if (n5 == n6) {
            n4 = this.styles[n5].start;
            n3 = this.styles[n6 + 1].start - 1;
            if (n4 == n && n3 == n2) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n && n3 != n2) {
                int n11 = this.stylesCount + 2;
                if (n11 > this.styles.length) {
                    int n12 = Math.min(n11 + 1024, Math.max(64, n11 * 2));
                    StyleItem[] styleItemArray = new StyleItem[n12];
                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                    this.styles = styleItemArray;
                }
                System.arraycopy(this.styles, n6 + 1, this.styles, n6 + 3, this.stylesCount - n6 - 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                this.styles[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n5].style;
                this.styles[n5 + 2] = styleItem;
                this.stylesCount = n11;
                return;
            }
        }
        if (n == this.styles[n5].start) {
            --n5;
        }
        if (n2 == this.styles[n6 + 1].start - 1) {
            ++n6;
        }
        if ((n4 = this.stylesCount + 1 - (n6 - n5 - 1)) > this.styles.length) {
            n3 = Math.min(n4 + 1024, Math.max(64, n4 * 2));
            StyleItem[] styleItemArray = new StyleItem[n3];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        System.arraycopy(this.styles, n6, this.styles, n5 + 2, this.stylesCount - n6);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        this.styles[n5 + 1] = styleItem;
        this.styles[n5 + 2].start = n2 + 1;
        this.stylesCount = n4;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        this.setTabsInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), nArray));
    }

    void setTabsInPixels(int[] nArray) {
        if (Arrays.equals(this.tabs, nArray)) {
            return;
        }
        this.tabs = nArray;
        if (nArray == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            int n = OS.pango_tab_array_new(nArray.length, true);
            if (n != 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    OS.pango_tab_array_set_tab(n, i, 0, nArray[i]);
                }
                OS.pango_layout_set_tabs(this.layout, n);
                OS.pango_tab_array_free(n);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
        this.stylesCount = 2;
    }

    public void setTextDirection(int n) {
        this.checkLayout();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        this.setWidthInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setWidthInPixels(int n) {
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
        this.setWidth();
    }

    void setWidth() {
        if (this.wrapWidth == -1) {
            OS.pango_layout_set_width(this.layout, -1);
            boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
            OS.pango_layout_set_alignment(this.layout, bl ? 2 : 0);
        } else {
            int n = Math.min(this.indent, this.wrapIndent);
            OS.pango_layout_set_width(this.layout, (this.wrapWidth - n) * 1024);
        }
    }

    public void setWrapIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        this.setWrapIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setWrapIndentInPixels(int n) {
        if (this.wrapIndent == n) {
            return;
        }
        this.wrapIndent = n;
        OS.pango_layout_set_indent(this.layout, (this.indent - n) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    static final boolean isLam(int n) {
        return n == 1604;
    }

    static final boolean isAlef(int n) {
        switch (n) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        for (int i = 0; i < this.invalidOffsets.length && n >= this.invalidOffsets[i]; ++n, ++i) {
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        for (n2 = 0; n2 < this.invalidOffsets.length && n > this.invalidOffsets[n2]; ++n2) {
        }
        return n - n2;
    }

    int width() {
        int n = OS.pango_layout_get_width(this.layout);
        if (n != -1) {
            return OS.PANGO_PIXELS(n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_pixel_size(this.layout, nArray, nArray2);
        return nArray[0];
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

