/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.openintents.tools.sensorsimulator.ISensorSimulator;

public class SensorServerThread
implements Runnable {
    public ISensorSimulator mSensorSimulator;
    public Thread mThread;
    public SensorServerThread nextThread;
    public SensorServerThread previousThread;
    public Socket mClientSocket;
    boolean talking;

    public SensorServerThread(ISensorSimulator newSensorSimulator, Socket newClientSocket) {
        this.mSensorSimulator = newSensorSimulator;
        this.nextThread = null;
        this.previousThread = null;
        this.mClientSocket = newClientSocket;
        this.talking = true;
        this.mThread = new Thread(this);
        this.mThread.start();
    }

    public void run() {
        this.listenThread();
    }

    public void listenThread() {
        block95: {
            try {
                String inputLine;
                PrintWriter out = new PrintWriter(this.mClientSocket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(this.mClientSocket.getInputStream()));
                String outputLine = "SensorSimulator";
                out.println(outputLine);
                this.mSensorSimulator.addMessage("Incoming connection opened.");
                while ((inputLine = in.readLine()) != null) {
                    double updatesPerSecond;
                    if (inputLine.compareTo("getSupportedSensors()") == 0) {
                        String[] supportedSensors = this.getSupportedSensors();
                        out.println("" + supportedSensors.length);
                        for (int i = 0; i < supportedSensors.length; ++i) {
                            out.println(supportedSensors[i]);
                        }
                        continue;
                    }
                    if (inputLine.compareTo("disableSensor()") == 0 || inputLine.compareTo("enableSensor()") == 0) {
                        boolean enable = inputLine.compareTo("enableSensor()") == 0;
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.isSupportedAccelerometer()) {
                            out.println("" + this.mSensorSimulator.isEnabledAccelerometer());
                            this.mSensorSimulator.setEnabledAccelerometer(enable);
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.isSupportedMagneticField()) {
                            out.println("" + this.mSensorSimulator.isEnabledMagneticField());
                            this.mSensorSimulator.setEnabledMagneticField(enable);
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.isSupportedOrientation()) {
                            out.println("" + this.mSensorSimulator.isEnabledOrientation());
                            this.mSensorSimulator.setEnabledOrientation(enable);
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.isSupportedTemperature()) {
                            out.println("" + this.mSensorSimulator.isEnabledTemperature());
                            this.mSensorSimulator.setEnabledTemperature(enable);
                            continue;
                        }
                        if (inputLine.compareTo("barcode reader") == 0 && this.mSensorSimulator.isSupportedBarcodeReader()) {
                            out.println("" + this.mSensorSimulator.isEnabledBarcodeReader());
                            this.mSensorSimulator.setEnabledBarcodeReader(enable);
                            continue;
                        }
                        if (inputLine.compareTo("light") == 0 && this.mSensorSimulator.isSupportedLight()) {
                            out.println("" + this.mSensorSimulator.isEnabledLight());
                            this.mSensorSimulator.setEnabledLight(enable);
                            continue;
                        }
                        if (inputLine.compareTo("proximity") == 0 && this.mSensorSimulator.isSupportedProximity()) {
                            out.println("" + this.mSensorSimulator.isEnabledProximity());
                            this.mSensorSimulator.setEnabledProximity(enable);
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("getNumSensorValues()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.isSupportedAccelerometer()) {
                            out.println("3");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.isSupportedMagneticField()) {
                            out.println("3");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.isSupportedOrientation()) {
                            out.println("3");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.isSupportedTemperature()) {
                            out.println("1");
                            continue;
                        }
                        if (inputLine.compareTo("barcode reader") == 0 && this.mSensorSimulator.isSupportedBarcodeReader()) {
                            out.println("1");
                            continue;
                        }
                        if (inputLine.compareTo("light") == 0 && this.mSensorSimulator.isSupportedLight()) {
                            out.println("1");
                            continue;
                        }
                        if (inputLine.compareTo("proximity") == 0 && this.mSensorSimulator.isSupportedProximity()) {
                            out.println("1");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("readSensor()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.isSupportedAccelerometer()) {
                            if (this.mSensorSimulator.isEnabledAccelerometer()) {
                                String sensorData = "3\n" + this.mSensorSimulator.getMobilePanel().getReadAccelerometerX() + "\n" + this.mSensorSimulator.getMobilePanel().getReadAccelerometerY() + "\n" + this.mSensorSimulator.getMobilePanel().getReadAccelerometerZ();
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorAccelerometerRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.isSupportedMagneticField()) {
                            if (this.mSensorSimulator.isEnabledMagneticField()) {
                                String sensorData = "3\n" + this.mSensorSimulator.getMobilePanel().getReadCompassX() + "\n" + this.mSensorSimulator.getMobilePanel().getReadCompassY() + "\n" + this.mSensorSimulator.getMobilePanel().getReadCompassZ();
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorCompassRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.isSupportedOrientation()) {
                            if (this.mSensorSimulator.isEnabledOrientation()) {
                                String sensorData = "3\n" + this.mSensorSimulator.getMobilePanel().getReadYaw() + "\n" + this.mSensorSimulator.getMobilePanel().getReadPitch() + "\n" + this.mSensorSimulator.getMobilePanel().getReadRoll();
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorOrientationRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.isSupportedTemperature()) {
                            if (this.mSensorSimulator.isEnabledTemperature()) {
                                String sensorData = "1\n" + this.mSensorSimulator.getMobilePanel().getReadTemperature();
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorThermometerRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("barcode reader") == 0 && this.mSensorSimulator.isSupportedBarcodeReader()) {
                            if (this.mSensorSimulator.isEnabledBarcodeReader()) {
                                if (this.mSensorSimulator.getMobilePanel().getBarcode().length() == 13) {
                                    String sensorData = "1\n" + this.mSensorSimulator.getMobilePanel().getBarcode();
                                    out.println(sensorData);
                                    continue;
                                }
                                String sensorData = "1\n1";
                                out.println(sensorData);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("light") == 0 && this.mSensorSimulator.isSupportedLight()) {
                            if (this.mSensorSimulator.isEnabledLight()) {
                                String sensorData = "1\n" + this.mSensorSimulator.getMobilePanel().getReadLight();
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorLightRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("proximity") == 0 && this.mSensorSimulator.isSupportedProximity()) {
                            if (this.mSensorSimulator.isEnabledProximity()) {
                                String sensorData = "1\n" + this.mSensorSimulator.getMobilePanel().getReadProximity();
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorProximityRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("getSensorUpdateRates()") == 0) {
                        int len;
                        double[] updatesList;
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.isSupportedAccelerometer()) {
                            updatesList = this.mSensorSimulator.getUpdateRatesAccelerometer();
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.isSupportedMagneticField()) {
                            updatesList = this.mSensorSimulator.getUpdateRatesCompass();
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.isSupportedOrientation()) {
                            updatesList = this.mSensorSimulator.getUpdateRatesOrientation();
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.isSupportedTemperature()) {
                            updatesList = this.mSensorSimulator.getUpdateRatesThermometer();
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("light") == 0 && this.mSensorSimulator.isSupportedLight()) {
                            updatesList = this.mSensorSimulator.getUpdateRatesLight();
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("proximity") == 0 && this.mSensorSimulator.isSupportedProximity()) {
                            updatesList = this.mSensorSimulator.getUpdateRatesProximity();
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("getSensorUpdateRate()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.isSupportedAccelerometer()) {
                            if (this.mSensorSimulator.isEnabledAccelerometer()) {
                                updatesPerSecond = this.mSensorSimulator.getCurrentUpdateRateAccelerometer();
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.isSupportedMagneticField()) {
                            if (this.mSensorSimulator.isEnabledMagneticField()) {
                                updatesPerSecond = this.mSensorSimulator.getCurrentUpdateRateCompass();
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.isSupportedOrientation()) {
                            if (this.mSensorSimulator.isEnabledOrientation()) {
                                updatesPerSecond = this.mSensorSimulator.getCurrentUpdateRateOrientation();
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.isSupportedTemperature()) {
                            if (this.mSensorSimulator.isEnabledTemperature()) {
                                updatesPerSecond = this.mSensorSimulator.getCurrentUpdateRateThermometer();
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("light") == 0 && this.mSensorSimulator.isSupportedLight()) {
                            if (this.mSensorSimulator.isEnabledLight()) {
                                updatesPerSecond = this.mSensorSimulator.getCurrentUpdateRateLight();
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("proximity") == 0 && this.mSensorSimulator.isSupportedProximity()) {
                            if (this.mSensorSimulator.isEnabledProximity()) {
                                updatesPerSecond = this.mSensorSimulator.getCurrentUpdateRateProximity();
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("setSensorUpdateRate()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.isSupportedAccelerometer()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.setCurrentUpdateRateAccelerometer(updatesPerSecond);
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.isSupportedMagneticField()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.setCurrentUpdateRateCompass(updatesPerSecond);
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.isSupportedOrientation()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.setCurrentUpdateRateOrientation(updatesPerSecond);
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.isSupportedTemperature()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.setCurrentUpdateRateThermometer(updatesPerSecond);
                            continue;
                        }
                        if (inputLine.compareTo("barcode reader") == 0 && this.mSensorSimulator.isSupportedBarcodeReader()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            continue;
                        }
                        if (inputLine.compareTo("light") == 0 && this.mSensorSimulator.isSupportedLight()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.setCurrentUpdateRateLight(updatesPerSecond);
                            continue;
                        }
                        if (inputLine.compareTo("proximity") == 0 && this.mSensorSimulator.isSupportedProximity()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.setCurrentUpdateRateProximity(updatesPerSecond);
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("unsetSensorUpdateRate()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.isSupportedAccelerometer()) {
                            if (this.mSensorSimulator.isEnabledAccelerometer()) {
                                out.println("OK");
                                this.mSensorSimulator.setCurrentUpdateRateAccelerometer(this.mSensorSimulator.getDefaultUpdateRateAccelerometer());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.isSupportedMagneticField()) {
                            if (this.mSensorSimulator.isEnabledMagneticField()) {
                                out.println("OK");
                                this.mSensorSimulator.setCurrentUpdateRateCompass(this.mSensorSimulator.getDefaultUpdateRateCompass());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.isSupportedOrientation()) {
                            if (this.mSensorSimulator.isEnabledOrientation()) {
                                out.println("OK");
                                this.mSensorSimulator.setCurrentUpdateRateOrientation(this.mSensorSimulator.getDefaultUpdateRateOrientation());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.isSupportedTemperature()) {
                            if (this.mSensorSimulator.isEnabledTemperature()) {
                                out.println("OK");
                                this.mSensorSimulator.setCurrentUpdateRateThermometer(this.mSensorSimulator.getDefaultUpdateRateThermometer());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("light") == 0 && this.mSensorSimulator.isSupportedLight()) {
                            if (this.mSensorSimulator.isEnabledLight()) {
                                out.println("OK");
                                this.mSensorSimulator.setCurrentUpdateRateLight(this.mSensorSimulator.getDefaultUpdateRateLight());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("proximity") == 0 && this.mSensorSimulator.isSupportedProximity()) {
                            if (this.mSensorSimulator.isEnabledProximity()) {
                                out.println("OK");
                                this.mSensorSimulator.setCurrentUpdateRateProximity(this.mSensorSimulator.getDefaultUpdateRateProximity());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    this.mSensorSimulator.addMessage("WARNING: Client sent unexpected command: " + inputLine);
                }
                out.close();
                in.close();
                this.mClientSocket.close();
            }
            catch (IOException e) {
                if (!this.talking) break block95;
                System.err.println("IOException in SensorServerThread.");
                try {
                    if (this.mClientSocket != null) {
                        this.mClientSocket.close();
                    }
                }
                catch (IOException e2) {
                    System.err.println("Close failed as well.");
                }
            }
        }
        if (this.previousThread != null) {
            this.previousThread.nextThread = this.nextThread;
        }
        if (this.nextThread != null) {
            this.nextThread.previousThread = this.previousThread;
        }
        this.mSensorSimulator.addMessage("Incoming connection closed.");
    }

    public String[] getSupportedSensors() {
        String[] sensorList = new String[7];
        int sensorMax = 0;
        if (this.mSensorSimulator.isSupportedAccelerometer()) {
            sensorList[sensorMax] = "accelerometer";
            ++sensorMax;
        }
        if (this.mSensorSimulator.isSupportedMagneticField()) {
            sensorList[sensorMax] = "magnetic field";
            ++sensorMax;
        }
        if (this.mSensorSimulator.isSupportedOrientation()) {
            sensorList[sensorMax] = "orientation";
            ++sensorMax;
        }
        if (this.mSensorSimulator.isSupportedTemperature()) {
            sensorList[sensorMax] = "temperature";
            ++sensorMax;
        }
        if (this.mSensorSimulator.isSupportedBarcodeReader()) {
            sensorList[sensorMax] = "barcode reader";
            ++sensorMax;
        }
        if (this.mSensorSimulator.isSupportedLight()) {
            sensorList[sensorMax] = "light";
            ++sensorMax;
        }
        if (this.mSensorSimulator.isSupportedProximity()) {
            sensorList[sensorMax] = "proximity";
            ++sensorMax;
        }
        String[] returnSensorList = new String[sensorMax];
        for (int i = 0; i < sensorMax; ++i) {
            returnSensorList[i] = sensorList[i];
        }
        return returnSensorList;
    }

    public void stop() {
        try {
            this.talking = false;
            this.mClientSocket.close();
        }
        catch (IOException e) {
            System.err.println("Close failed.");
            System.exit(1);
        }
    }
}

