/*
 * Decompiled with CFR 0.152.
 */
package cc.nnproject.json;

import cc.nnproject.json.JSONArray;
import cc.nnproject.json.JSONException;
import cc.nnproject.json.JSONObject;
import cc.nnproject.json.JSONString;
import java.util.Hashtable;
import java.util.Vector;

public final class JSON {
    public static final boolean parse_members = false;
    public static final Object json_null = new Object();
    public static final String FORMAT_TAB = "  ";
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);

    public static JSONObject getObject(String string) throws JSONException {
        if (string == null || string.length() <= 1) {
            throw new JSONException("Empty string");
        }
        if (string.charAt(0) != '{') {
            throw new JSONException("Not JSON object");
        }
        return (JSONObject)JSON.parseJSON(string);
    }

    public static JSONArray getArray(String string) throws JSONException {
        if (string == null || string.length() <= 1) {
            throw new JSONException("Empty string");
        }
        if (string.charAt(0) != '[') {
            throw new JSONException("Not JSON array");
        }
        return (JSONArray)JSON.parseJSON(string);
    }

    static Object getJSON(Object obj) throws JSONException {
        if (obj instanceof Hashtable) {
            return new JSONObject((Hashtable)obj);
        }
        if (obj instanceof Vector) {
            return new JSONArray((Vector)obj);
        }
        if (obj == null) {
            return json_null;
        }
        return obj;
    }

    /*
     * Unable to fully structure code
     */
    static Object parseJSON(String str) throws JSONException {
        if (str == null || (str = str.trim()).length() == 0) {
            throw new JSONException("Empty string");
        }
        first = str.charAt(0);
        length = str.length() - 1;
        last = str.charAt(length);
        if (first == '{' && last != '}' || first == '[' && last != ']' || first == '\"' && last != '\"') {
            throw new JSONException("Unexpected end of text");
        }
        if (first == '\"') {
            str = str.substring(1, str.length() - 1);
            chars = str.toCharArray();
            str = null;
            try {
                l = chars.length;
                sb = new StringBuffer();
                i = 0;
                block25: while (i < l) {
                    c = chars[i];
                    block6 : switch (c) {
                        case '\\': {
                            if (l < i + 1) {
                                sb.append(c);
                                break block25;
                            }
                            c1 = chars[i + 1];
                            switch (c1) {
                                case 'u': {
                                    i += 2;
                                    u = "" + chars[i++] + chars[i++] + chars[i++] + chars[i++];
                                    sb.append((char)Integer.parseInt(u, 16));
                                    break block6;
                                }
                                case 'x': {
                                    i += 2;
                                    x = "" + chars[i++] + chars[i++];
                                    sb.append((char)Integer.parseInt(x, 16));
                                    break block6;
                                }
                                case 'n': {
                                    sb.append('\n');
                                    i += 2;
                                    break block6;
                                }
                                case 'r': {
                                    sb.append('\r');
                                    i += 2;
                                    break block6;
                                }
                                case 't': {
                                    sb.append('\t');
                                    i += 2;
                                    break block6;
                                }
                                case 'f': {
                                    sb.append('\f');
                                    i += 2;
                                    break block6;
                                }
                                case 'b': {
                                    sb.append('\b');
                                    i += 2;
                                    break block6;
                                }
                                case '\"': 
                                case '\'': 
                                case '/': 
                                case '\\': {
                                    i += 2;
                                    sb.append(c1);
                                    break block6;
                                }
                            }
                            sb.append(c);
                            ++i;
                            break;
                        }
                        default: {
                            sb.append(c);
                            ++i;
                        }
                    }
                }
                str = sb.toString();
                sb = null;
            }
            catch (Exception l) {
                // empty catch block
            }
            return str;
        }
        if (first != '{' && first != '[') {
            if (str.equals("null")) {
                return JSON.json_null;
            }
            if (str.equals("true")) {
                return JSON.TRUE;
            }
            if (str.equals("false")) {
                return JSON.FALSE;
            }
            if (str.length() > 2 && str.charAt(0) == '0' && str.charAt(1) == 'x') {
                try {
                    return new Integer(Integer.parseInt(str.substring(2), 16));
                }
                catch (Exception e) {
                    try {
                        return new Long(Long.parseLong(str.substring(2), 16));
                    }
                    catch (Exception l) {
                        // empty catch block
                    }
                }
            }
            try {
                return new Integer(Integer.parseInt(str));
            }
            catch (Exception e) {
                try {
                    return new Long(Long.parseLong(str));
                }
                catch (Exception e2) {
                    try {
                        return new Double(Double.parseDouble(str));
                    }
                    catch (Exception sb) {
                        return str;
                    }
                }
            }
        }
        unclosed = 0;
        object = first == '{';
        i = 1;
        nextDelimiter = object != false ? 58 : 44;
        escape = false;
        key = null;
        res = null;
        res = object ? new Hashtable<K, V>() : new Vector<E>();
        ** GOTO lbl158
        {
            ++i;
            do {
                if (i < length - 1 && str.charAt(i) <= ' ') continue block26;
                splIndex = i;
                quotes = false;
                while (splIndex < length && (quotes || unclosed > 0 || str.charAt(splIndex) != nextDelimiter)) {
                    c = str.charAt(splIndex);
                    if (!escape) {
                        if (c == '\\') {
                            escape = true;
                        } else if (c == '\"') {
                            quotes = quotes == false;
                        }
                    } else {
                        escape = false;
                    }
                    if (!quotes) {
                        if (c == '{' || c == '[') {
                            ++unclosed;
                        } else if (c == '}' || c == ']') {
                            --unclosed;
                        }
                    }
                    ++splIndex;
                }
                if (quotes || unclosed > 0) {
                    throw new JSONException("Corrupted JSON");
                }
                if (object && key == null) {
                    key = str.substring(i, splIndex);
                    key = key.substring(1, key.length() - 1);
                    nextDelimiter = 44;
                } else {
                    value = str.substring(i, splIndex).trim();
                    value = new JSONString(value.toString());
                    if (object) {
                        res.put(key, value);
                        key = null;
                        nextDelimiter = 58;
                    } else if (splIndex > i) {
                        ((Vector)res).addElement(value);
                    }
                }
                i = splIndex + 1;
lbl158:
                // 2 sources

            } while (i < length);
        }
        return JSON.getJSON(res);
    }

    public static boolean isNull(Object obj) {
        return json_null.equals(obj);
    }

    public static String escape_utf8(String s) {
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append("\\" + c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    if (c < ' ' || c > '\u044f') {
                        String u = Integer.toHexString(c);
                        int z = u.length();
                        while (z < 4) {
                            u = "0" + u;
                            ++z;
                        }
                        sb.append("\\u" + u);
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static double getDouble(Object o) throws JSONException {
        try {
            if (o instanceof Integer) {
                return ((Integer)o).intValue();
            }
            if (o instanceof Long) {
                return ((Long)o).longValue();
            }
            if (o instanceof Double) {
                return (Double)o;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new JSONException("Value cast failed: " + o);
    }

    public static long getLong(Object o) throws JSONException {
        try {
            if (o instanceof Integer) {
                return ((Integer)o).longValue();
            }
            if (o instanceof Long) {
                return (Long)o;
            }
            if (o instanceof Double) {
                return ((Double)o).longValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new JSONException("Value cast failed: " + o);
    }
}

