/*
 * Decompiled with CFR 0.152.
 */
package cc.nnproject.json;

import cc.nnproject.json.AbstractJSON;
import cc.nnproject.json.JSON;
import cc.nnproject.json.JSONException;
import cc.nnproject.json.JSONObject;
import cc.nnproject.json.JSONString;
import java.util.Enumeration;
import java.util.Vector;

public class JSONArray
extends AbstractJSON {
    private Vector vector;

    public JSONArray() {
        this.vector = new Vector();
    }

    public JSONArray(Vector vector) {
        this.vector = vector;
    }

    public Object get(int index) throws JSONException {
        try {
            if (index >= 0 && index < this.vector.size()) {
                Object o = this.vector.elementAt(index);
                if (o instanceof JSONString) {
                    o = JSON.parseJSON(o.toString());
                    this.vector.setElementAt(o, index);
                }
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new JSONException("No value at " + index);
    }

    public Object get(int index, Object def) {
        try {
            return this.get(index);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Object getNullable(int index) {
        return this.get(index, null);
    }

    public String getString(int index) throws JSONException {
        return this.get(index).toString();
    }

    public String getString(int index, String def) {
        try {
            return this.get(index).toString();
        }
        catch (Exception e) {
            return def;
        }
    }

    public JSONObject getObject(int index) throws JSONException {
        try {
            return (JSONObject)this.get(index);
        }
        catch (ClassCastException e) {
            throw new JSONException("Not object at " + index);
        }
    }

    public JSONObject getNullableObject(int index) {
        try {
            return this.getObject(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JSONArray getArray(int index) throws JSONException {
        try {
            return (JSONArray)this.get(index);
        }
        catch (ClassCastException e) {
            throw new JSONException("Not array at " + index);
        }
    }

    public JSONArray getNullableArray(int index) {
        try {
            return this.getArray(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getInt(int index) throws JSONException {
        return (int)JSON.getLong(this.get(index));
    }

    public int getInt(int index, int def) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getLong(int index) throws JSONException {
        return JSON.getLong(this.get(index));
    }

    public long getLong(int index, long def) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return def;
        }
    }

    public double getDouble(int index) throws JSONException {
        return JSON.getDouble(this.get(index));
    }

    public double getDouble(int index, double def) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean getBoolean(int index) throws JSONException {
        Object o = this.get(index);
        if (o == JSON.TRUE) {
            return true;
        }
        if (o == JSON.FALSE) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            if ((s = s.toLowerCase()).equals("true")) {
                return true;
            }
            if (s.equals("false")) {
                return false;
            }
        }
        throw new JSONException("Not boolean: " + o + " (" + index + ")");
    }

    public boolean getBoolean(int index, boolean def) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean isNull(int index) {
        return JSON.isNull(this.getNullable(index));
    }

    public void add(String s) {
        this.vector.addElement(s);
    }

    public void add(boolean b) {
        this.vector.addElement(new Boolean(b));
    }

    public void add(double d) {
        this.vector.addElement(Double.toString(d));
    }

    public void add(int i) {
        this.vector.addElement(Integer.toString(i));
    }

    public void add(long l) {
        this.vector.addElement(Long.toString(l));
    }

    public void add(Object obj) {
        this.vector.addElement(JSON.getJSON(obj));
    }

    public void set(int idx, String s) {
        this.vector.setElementAt(s, idx);
    }

    public void set(int idx, boolean b) {
        this.vector.setElementAt(new Boolean(b), idx);
    }

    public void set(int idx, double d) {
        this.vector.setElementAt(Double.toString(d), idx);
    }

    public void set(int idx, int i) {
        this.vector.setElementAt(Integer.toString(i), idx);
    }

    public void set(int idx, long l) {
        this.vector.setElementAt(Long.toString(l), idx);
    }

    public void set(int idx, Object obj) {
        this.vector.setElementAt(JSON.getJSON(obj), idx);
    }

    public void put(int idx, String s) {
        this.vector.insertElementAt(s, idx);
    }

    public void put(int idx, boolean b) {
        this.vector.insertElementAt(new Boolean(b), idx);
    }

    public void put(int idx, double d) {
        this.vector.insertElementAt(Double.toString(d), idx);
    }

    public void put(int idx, int i) {
        this.vector.insertElementAt(Integer.toString(i), idx);
    }

    public void put(int idx, long l) {
        this.vector.insertElementAt(Long.toString(l), idx);
    }

    public void put(int idx, Object obj) {
        this.vector.insertElementAt(JSON.getJSON(obj), idx);
    }

    public void remove(int idx) {
        this.vector.removeElementAt(idx);
    }

    public void clear() {
        this.vector.removeAllElements();
    }

    public int size() {
        return this.vector.size();
    }

    public String toString() {
        return this.build();
    }

    public boolean equals(Object obj) {
        if (this == obj || super.equals(obj)) {
            return true;
        }
        return this.similar(obj);
    }

    public boolean similar(Object obj) {
        if (!(obj instanceof JSONArray)) {
            return false;
        }
        int size = this.size();
        if (size != ((JSONArray)obj).size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            Object b;
            Object a = this.get(i);
            if (a != (b = ((JSONArray)obj).get(i))) {
                if (a == null) {
                    return false;
                }
                if (a instanceof AbstractJSON ? !((AbstractJSON)a).similar(b) : !a.equals(b)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public String build() {
        int size = this.size();
        if (size == 0) {
            return "[]";
        }
        StringBuffer s = new StringBuffer("[");
        int i = 0;
        while (i < size) {
            Object v = this.vector.elementAt(i);
            if (v instanceof AbstractJSON) {
                s.append(((AbstractJSON)v).build());
            } else if (v instanceof String) {
                s.append("\"").append(JSON.escape_utf8((String)v)).append("\"");
            } else if (JSON.json_null.equals(v)) {
                s.append((String)null);
            } else {
                s.append(String.valueOf(v));
            }
            if (++i >= size) continue;
            s.append(",");
        }
        s.append("]");
        return s.toString();
    }

    protected String format(int l) {
        int size = this.size();
        if (size == 0) {
            return "[]";
        }
        String t = "";
        int i = 0;
        while (i < l) {
            t = t.concat("  ");
            ++i;
        }
        String t2 = t.concat("  ");
        StringBuffer s = new StringBuffer("[\n");
        s.append(t2);
        int i2 = 0;
        while (i2 < size) {
            Object v = null;
            try {
                v = this.get(i2);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (v instanceof AbstractJSON) {
                s.append(((AbstractJSON)v).format(l + 1));
            } else if (v instanceof String) {
                s.append("\"").append(JSON.escape_utf8((String)v)).append("\"");
            } else if (v == JSON.json_null) {
                s.append((String)null);
            } else {
                s.append(v);
            }
            if (++i2 >= this.size()) continue;
            s.append(",\n").append(t2);
        }
        if (l > 0) {
            s.append("\n").append(t).append("]");
        } else {
            s.append("\n]");
        }
        return s.toString();
    }

    public Enumeration elements() {
        return new Enumeration(){
            int i = 0;

            public boolean hasMoreElements() {
                return this.i < JSONArray.this.vector.size();
            }

            public Object nextElement() {
                try {
                    return JSONArray.this.get(this.i++);
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }

    public void copyInto(Object[] arr, int offset, int length) {
        int i = offset;
        int j = 0;
        while (i < arr.length && j < length && j < this.size()) {
            Object o;
            if ((o = this.get(j++)) == JSON.json_null) {
                o = null;
            }
            arr[i++] = o;
        }
    }
}

