/*
 * Decompiled with CFR 0.152.
 */
package cc.nnproject.json;

import cc.nnproject.json.AbstractJSON;
import cc.nnproject.json.JSON;
import cc.nnproject.json.JSONArray;
import cc.nnproject.json.JSONException;
import cc.nnproject.json.JSONString;
import java.util.Enumeration;
import java.util.Hashtable;

public class JSONObject
extends AbstractJSON {
    private Hashtable table;

    public JSONObject() {
        this.table = new Hashtable();
    }

    public JSONObject(Hashtable table) {
        this.table = table;
    }

    public boolean has(String name) {
        return this.table.containsKey(name);
    }

    public Object get(String name) throws JSONException {
        try {
            if (this.has(name)) {
                Object o = this.table.get(name);
                if (o instanceof JSONString) {
                    o = JSON.parseJSON(o.toString());
                    this.table.put(name, o);
                }
                return o;
            }
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new JSONException("No value for name: " + name);
    }

    public Object get(String name, Object def) {
        if (!this.has(name)) {
            return def;
        }
        try {
            return this.get(name);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Object getNullable(String name) {
        return this.get(name, null);
    }

    public String getString(String name) throws JSONException {
        return this.get(name).toString();
    }

    public String getString(String name, String def) {
        try {
            Object o = this.get(name, def);
            if (o == null || o instanceof String) {
                return (String)o;
            }
            return o.toString();
        }
        catch (Exception e) {
            return def;
        }
    }

    public String getNullableString(String name) {
        return this.getString(name, null);
    }

    public JSONObject getObject(String name) throws JSONException {
        try {
            return (JSONObject)this.get(name);
        }
        catch (ClassCastException e) {
            throw new JSONException("Not object: " + name);
        }
    }

    public JSONObject getNullableObject(String name) {
        if (!this.has(name)) {
            return null;
        }
        try {
            return this.getObject(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JSONArray getArray(String name) throws JSONException {
        try {
            return (JSONArray)this.get(name);
        }
        catch (ClassCastException e) {
            throw new JSONException("Not array: " + name);
        }
    }

    public JSONArray getNullableArray(String name) {
        if (!this.has(name)) {
            return null;
        }
        try {
            return this.getArray(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getInt(String name) throws JSONException {
        return (int)JSON.getLong(this.get(name));
    }

    public int getInt(String name, int def) {
        if (!this.has(name)) {
            return def;
        }
        try {
            return this.getInt(name);
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getLong(String name) throws JSONException {
        return JSON.getLong(this.get(name));
    }

    public long getLong(String name, long def) {
        if (!this.has(name)) {
            return def;
        }
        try {
            return this.getLong(name);
        }
        catch (Exception e) {
            return def;
        }
    }

    public double getDouble(String name) throws JSONException {
        return JSON.getDouble(this.get(name));
    }

    public double getDouble(String name, double def) {
        if (!this.has(name)) {
            return def;
        }
        try {
            return this.getDouble(name);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean getBoolean(String name) throws JSONException {
        Object o = this.get(name);
        if (o == JSON.TRUE) {
            return true;
        }
        if (o == JSON.FALSE) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            if ((s = s.toLowerCase()).equals("true")) {
                return true;
            }
            if (s.equals("false")) {
                return false;
            }
        }
        throw new JSONException("Not boolean: " + o);
    }

    public boolean getBoolean(String name, boolean def) {
        if (!this.has(name)) {
            return def;
        }
        try {
            return this.getBoolean(name);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean isNull(String name) {
        return JSON.isNull(this.getNullable(name));
    }

    public void put(String name, String s) {
        this.table.put(name, s);
    }

    public void put(String name, boolean b) {
        this.table.put(name, new Boolean(b));
    }

    public void put(String name, double d) {
        this.table.put(name, new Double(d));
    }

    public void put(String name, int i) {
        this.table.put(name, new Integer(i));
    }

    public void put(String name, long l) {
        this.table.put(name, new Long(l));
    }

    public void put(String name, Object obj) {
        this.table.put(name, JSON.getJSON(obj));
    }

    public void remove(String name) {
        this.table.remove(name);
    }

    public void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }

    public String toString() {
        return this.build();
    }

    public boolean equals(Object obj) {
        if (this == obj || super.equals(obj)) {
            return true;
        }
        return this.similar(obj);
    }

    public boolean similar(Object obj) {
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        int size = this.size();
        if (size != ((JSONObject)obj).size()) {
            return false;
        }
        Enumeration keys = this.table.keys();
        while (keys.hasMoreElements()) {
            Object b;
            String key = (String)keys.nextElement();
            Object a = this.get(key);
            if (a == (b = ((JSONObject)obj).get(key))) continue;
            if (a == null) {
                return false;
            }
            if (!(a instanceof AbstractJSON ? !((AbstractJSON)a).similar(b) : !a.equals(b))) continue;
            return false;
        }
        return true;
    }

    public String build() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuffer s = new StringBuffer("{");
        Enumeration keys = this.table.keys();
        while (true) {
            String k = keys.nextElement().toString();
            s.append("\"").append(k).append("\":");
            Object v = this.table.get(k);
            if (v instanceof AbstractJSON) {
                s.append(((AbstractJSON)v).build());
            } else if (v instanceof String) {
                s.append("\"").append(JSON.escape_utf8((String)v)).append("\"");
            } else if (JSON.json_null.equals(v)) {
                s.append((String)null);
            } else {
                s.append(v);
            }
            if (!keys.hasMoreElements()) break;
            s.append(",");
        }
        s.append("}");
        return s.toString();
    }

    protected String format(int l) {
        int size = this.size();
        if (size == 0) {
            return "{}";
        }
        String t = "";
        int i = 0;
        while (i < l) {
            t = t.concat("  ");
            ++i;
        }
        String t2 = t.concat("  ");
        StringBuffer s = new StringBuffer("{\n");
        s.append(t2);
        Enumeration keys = this.table.keys();
        int i2 = 0;
        while (keys.hasMoreElements()) {
            String k = keys.nextElement().toString();
            s.append("\"").append(k).append("\": ");
            Object v = null;
            try {
                v = this.get(k);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (v instanceof AbstractJSON) {
                s.append(((AbstractJSON)v).format(l + 1));
            } else if (v instanceof String) {
                s.append("\"").append(JSON.escape_utf8((String)v)).append("\"");
            } else if (v == JSON.json_null) {
                s.append((String)null);
            } else {
                s.append(v);
            }
            if (++i2 >= size) continue;
            s.append(",\n").append(t2);
        }
        if (l > 0) {
            s.append("\n").append(t).append("}");
        } else {
            s.append("\n}");
        }
        return s.toString();
    }

    public Enumeration keys() {
        return this.table.keys();
    }

    public JSONArray keysAsArray() {
        JSONArray array = new JSONArray();
        Enumeration keys = this.table.keys();
        while (keys.hasMoreElements()) {
            array.add(keys.nextElement());
        }
        return array;
    }
}

