/*
 * Decompiled with CFR 0.152.
 */
package kun;

import javax.microedition.lcdui.Graphics;
import kun.ButtonHandler;
import kun.UIConstants;
import kun.UIItem;

public class Button
extends UIItem
implements UIConstants {
    String text;
    protected boolean hover;
    private ButtonHandler buttonHandler;
    private int h;
    private long lastTime;

    public Button(String text, ButtonHandler buttonHandler) {
        this.text = text;
        this.buttonHandler = buttonHandler;
    }

    public void paint(Graphics g, int w, int x, int y, int sc) {
        g.setFont(UIConstants.mediumfont);
        if (this.hover) {
            g.setColor(0xEEEEEE);
        } else {
            g.setColor(-1);
        }
        int tw = UIConstants.mediumfont.stringWidth(this.text) + 8;
        int tx = w - tw >> 1;
        g.fillRect(tx, y + 1, tw, this.h - 1);
        g.setColor(0);
        g.drawString(this.text, x + (w >> 1), y + (this.h - UIConstants.mediumfont.getHeight() >> 1), 17);
        g.setColor(0);
        g.drawRect(tx, y + 1, tw - 1, this.h - 2);
        if (this.inFocus && UIItem.ui.keyInput) {
            g.setColor(0xADADAD);
            g.drawRect(tx, y + 1, tw - 1, this.h - 2);
        }
    }

    public int getHeight() {
        return this.h;
    }

    protected void layout(int w) {
        this.h = Math.max(24, UIConstants.mediumfontheight + 8);
    }

    private void action() {
        if (System.currentTimeMillis() - this.lastTime < 500L) {
            return;
        }
        this.lastTime = System.currentTimeMillis();
        if (this.buttonHandler != null) {
            this.buttonHandler.handleButton(this);
        }
    }

    protected void press(int x, int y) {
        this.hover();
    }

    protected void release(int x, int y) {
        this.unhover();
    }

    protected void tap(int x, int y, int time) {
        this.unhover();
        if (time <= 200 && time >= 5) {
            this.action();
        }
    }

    protected void keyPress(int i) {
        if (i == -5) {
            this.hover();
            this.action();
        }
    }

    protected void keyRelease(int i) {
        if (i == -5) {
            this.unhover();
        }
    }

    public void defocus() {
        super.defocus();
        this.hover = false;
    }

    protected void hover() {
        this.hover = true;
    }

    protected void unhover() {
        this.hover = false;
    }
}

