/*
 * Decompiled with CFR 0.152.
 */
package kun;

import cc.nnproject.json.AbstractJSON;
import cc.nnproject.json.JSON;
import cc.nnproject.json.JSONArray;
import cc.nnproject.json.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;
import kun.KunMID;
import kun.KunUI;
import kun.Util;

public class Kun {
    static final String CONFIG_RECORD_NAME = "kunconfig";
    static final String kundelikApiUrl = "https://api.kundelik.kz/v2/";
    static final String dnevnikApiUrl = "https://api.dnevnik.ru/v2/";
    static final String proxy = "http://nnp.nnchan.ru/pproxy.php?u=";
    static Kun inst;
    static String version;
    static KunMID midlet;
    static KunUI ui;
    static boolean running;
    static String accessToken;
    static String refreshToken;
    static String user;
    static String personId;
    static String shortName;
    static String groupId;
    static JSONArray schools;
    static JSONArray eduGroups;
    static Hashtable subjectsTable;
    static boolean dnevnik;
    static String api;

    static {
        subjectsTable = new Hashtable();
        dnevnik = false;
        api = dnevnik ? dnevnikApiUrl : kundelikApiUrl;
    }

    protected static void startApp() {
        running = true;
        inst = new Kun();
        if (version == null) {
            version = midlet.getAppProperty("MIDlet-Version");
        }
        Kun.loadConfig();
        ui = new KunUI();
        ui.init();
        ui.postInit();
    }

    static void loadConfig() {
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)CONFIG_RECORD_NAME, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (r != null) {
            try {
                JSONObject j = JSON.getObject(new String(r.getRecord(1), "UTF-8"));
                if (j.has("accessToken")) {
                    accessToken = j.getString("accessToken");
                }
                if (j.has("refreshToken")) {
                    refreshToken = j.getString("refreshToken");
                }
                if (j.has("user")) {
                    user = j.getString("user");
                }
                r.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void saveConfig() {
        try {
            RecordStore.deleteRecordStore((String)CONFIG_RECORD_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore r = RecordStore.openRecordStore((String)CONFIG_RECORD_NAME, (boolean)true);
            JSONObject j = new JSONObject();
            j.put("accessToken", accessToken);
            j.put("refreshToken", refreshToken);
            j.put("user", user);
            byte[] b = j.build().getBytes("UTF-8");
            r.addRecord(b, 0, b.length);
            r.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void loggedInit() {
        if (personId != null) {
            return;
        }
        Kun.saveConfig();
        try {
            Kun.getUserContext();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Get user context failed: " + e.toString());
        }
    }

    static String auth(String login, String password) throws Exception {
        JSONObject params = new JSONObject();
        params.put("client_id", "387D44E3-E0C9-4265-A9E4-A4CAAAD5111C");
        params.put("client_secret", "8A7D709C-FDBB-4047-B0EA-8947AFE89D67");
        params.put("scope", "Schools,Relatives,EduGroups,Lessons,marks,EduWorks,Avatar,EducationalInfo,CommonInfo,ContactInfo,FriendsAndRelatives,Files,Wall,Messages");
        params.put("username", login);
        params.put("password", password);
        String param = params.build();
        JSONObject resJson = (JSONObject)Kun.apiPost("authorizations/bycredentials", param);
        if (!resJson.has("accessToken")) {
            throw new Exception(resJson.build());
        }
        user = resJson.getString("user_str");
        refreshToken = resJson.getString("refreshToken");
        accessToken = resJson.getString("accessToken");
        return accessToken;
    }

    static JSONArray getCurrentWeekSchedule(String personId, String groupId) throws IOException {
        Calendar cal = Calendar.getInstance();
        int weekDay = cal.get(7) - 1;
        if (weekDay == 0) {
            weekDay = 7;
        }
        Util.addDays(cal, -weekDay + 1);
        String startDate = Util.getApiDate(cal);
        Util.addDays(cal, 6);
        String endDate = Util.getApiDate(cal);
        return Kun.getSchedule(personId, groupId, startDate, endDate);
    }

    static JSONArray getNextWeekSchedule(String personId, String groupId) throws IOException {
        Calendar cal = Calendar.getInstance();
        int weekDay = cal.get(7) - 1;
        if (weekDay == 0) {
            weekDay = 7;
        }
        Util.addDays(cal, -weekDay + 1 + 7);
        String startDate = Util.getApiDate(cal);
        Util.addDays(cal, 6);
        String endDate = Util.getApiDate(cal);
        return Kun.getSchedule(personId, groupId, startDate, endDate);
    }

    static JSONArray getSchedule(String personId, String groupId, String date) throws IOException {
        return Kun.getSchedule(personId, groupId, date, date);
    }

    static JSONArray getSchedule(String personId, String groupId, String startDate, String endDate) throws IOException {
        JSONArray res = new JSONArray();
        JSONObject json = (JSONObject)Kun.apiGet("persons/" + personId + "/groups/" + groupId + "/schedules?startDate=" + startDate + "&endDate=" + endDate);
        JSONArray days = json.getArray("days");
        Enumeration e = days.elements();
        while (e.hasMoreElements()) {
            JSONObject resDay = new JSONObject();
            res.add(resDay);
            JSONObject day = (JSONObject)e.nextElement();
            String date = day.getString("date");
            if (date.indexOf(84) != -1) {
                date = date.substring(0, date.indexOf(84));
            }
            resDay.put("date", date);
            JSONArray resLessons = new JSONArray();
            resDay.put("lessons", resLessons);
            JSONArray lessons = day.getArray("lessons");
            if (lessons.size() == 0) continue;
            JSONArray marks = day.getArray("marks");
            JSONArray homeworks = day.getArray("homeworks");
            JSONArray subjects = day.getArray("subjects");
            Enumeration e2 = lessons.elements();
            while (e2.hasMoreElements()) {
                JSONObject resLesson = new JSONObject();
                JSONObject lesson = (JSONObject)e2.nextElement();
                JSONObject subject = null;
                JSONObject mark = null;
                JSONArray resHomeworks = new JSONArray();
                Enumeration e3 = subjects.elements();
                while (e3.hasMoreElements()) {
                    JSONObject tmpSubject = (JSONObject)e3.nextElement();
                    String subjectId = lesson.getString("subjectId");
                    if (!subjectsTable.containsKey(subjectId)) {
                        subjectsTable.put(subjectId, tmpSubject);
                    }
                    if (!tmpSubject.getString("id").equalsIgnoreCase(subjectId)) continue;
                    subject = tmpSubject;
                    break;
                }
                e3 = marks.elements();
                while (e3.hasMoreElements()) {
                    JSONObject tmpMark = (JSONObject)e3.nextElement();
                    if (!tmpMark.getString("lesson").equalsIgnoreCase(lesson.getString("id"))) continue;
                    mark = tmpMark;
                    break;
                }
                e3 = homeworks.elements();
                while (e3.hasMoreElements()) {
                    JSONObject tmpHomework = (JSONObject)e3.nextElement();
                    if (!tmpHomework.getString("lesson").equalsIgnoreCase(lesson.getString("id"))) continue;
                    resHomeworks.add(tmpHomework.getString("text"));
                }
                int num = lesson.getInt("number");
                resLesson.put("number", new Integer(num));
                resLesson.put("lessonId", new Integer(lesson.getInt("id")));
                resLesson.put("subjectId", new Integer(lesson.getInt("subjectId")));
                resLesson.put("name", subject.getString("name"));
                resLesson.put("title", lesson.getString("title"));
                resLesson.put("hours", lesson.getString("hours"));
                if (mark != null) {
                    JSONObject resMark = new JSONObject();
                    resMark.put("type", mark.getString("type"));
                    resMark.put("value", mark.getString("textValue"));
                    resMark.put("mood", mark.getString("mood"));
                    resLesson.put("mark", resMark);
                }
                resLesson.put("homeworks", resHomeworks);
                if (resLessons.size() > 0) {
                    int i = 0;
                    while (i < resLessons.size()) {
                        if (num <= resLessons.getObject(i).getInt("number")) break;
                        ++i;
                    }
                    resLessons.put(i, resLesson);
                    continue;
                }
                resLessons.add(resLesson);
            }
        }
        return res;
    }

    private static JSONObject getUserContext() throws IOException {
        JSONObject json = (JSONObject)Kun.apiGet("users/me/context");
        personId = json.getString("personId");
        shortName = json.getString("shortName");
        groupId = json.getArray("groupIds").getString(0);
        schools = json.getArray("schools");
        eduGroups = json.getArray("eduGroups");
        return json;
    }

    static AbstractJSON apiGet(String url) throws IOException {
        AbstractJSON json;
        String r = Kun.getUtf(proxy + Util.url(String.valueOf(api) + url));
        switch (r.charAt(0)) {
            case '{': {
                AbstractJSON obj = json = JSON.getObject(r);
                if (!((JSONObject)obj).has("type") || ((JSONObject)obj).getString("type").indexOf("invalidToken") == -1) break;
                throw new RuntimeException("Invalid token!");
            }
            case '[': {
                json = JSON.getArray(r);
                break;
            }
            default: {
                throw new RuntimeException("API response not in JSON!\n\n" + r);
            }
        }
        return json;
    }

    static AbstractJSON apiPost(String url, String data) throws IOException {
        AbstractJSON json;
        String r = Kun.postUtf(proxy + Util.url(String.valueOf(api) + url) + "&post", data);
        switch (r.charAt(0)) {
            case '{': {
                json = JSON.getObject(r);
                break;
            }
            case '[': {
                json = JSON.getArray(r);
                break;
            }
            default: {
                throw new RuntimeException("API response not in JSON!\n\n" + r);
            }
        }
        return json;
    }

    static ContentConnection open(String url) throws IOException {
        try {
            ContentConnection con = (ContentConnection)Connector.open((String)url);
            if (con instanceof HttpConnection && accessToken != null && (url.toString().indexOf("api.kundelik.kz") != -1 || url.toString().indexOf("api.dnevnik.ru") != -1)) {
                ((HttpConnection)con).setRequestProperty("Access-Token", accessToken);
            }
            return con;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    static byte[] bytes(String url) throws IOException {
        System.out.println("GET " + url);
        HttpConnection hc = (HttpConnection)Kun.open(url);
        InputStream is = null;
        ByteArrayOutputStream o = null;
        try {
            int len;
            hc.setRequestMethod("GET");
            int r = hc.getResponseCode();
            if (r != 200) {
                throw new IOException(String.valueOf(r) + " " + hc.getResponseMessage());
            }
            is = hc.openInputStream();
            o = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((len = is.read(buf)) != -1) {
                o.write(buf, 0, len);
            }
            byte[] byArray = o.toByteArray();
            return byArray;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (hc != null) {
                hc.close();
            }
            if (o != null) {
                o.close();
            }
        }
    }

    static String getUtf(String url) throws IOException {
        byte[] b = Kun.bytes(url);
        try {
            return new String(b, "UTF-8");
        }
        catch (Throwable e) {
            return new String(b);
        }
    }

    static String postUtf(String url, String data) throws IOException {
        System.out.println("POST " + data);
        return new String(Kun.postBytes(url, data), "UTF-8");
    }

    static byte[] postBytes(String url, String data) throws IOException {
        byte[] b = data.getBytes("UTF-8");
        System.out.println("GET " + url);
        HttpConnection hc = (HttpConnection)Kun.open(url);
        InputStream is = null;
        ByteArrayOutputStream o = null;
        try {
            int len;
            hc.setRequestMethod("POST");
            hc.setRequestProperty("Content-Length", "" + b.length);
            hc.setRequestProperty("Content-Type", "application/json");
            OutputStream os = hc.openOutputStream();
            os.write(b);
            os.close();
            int r = hc.getResponseCode();
            if (r != 200) {
                throw new IOException(String.valueOf(r) + " " + hc.getResponseMessage());
            }
            is = hc.openInputStream();
            o = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((len = is.read(buf)) != -1) {
                o.write(buf, 0, len);
            }
            byte[] byArray = o.toByteArray();
            return byArray;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (hc != null) {
                hc.close();
            }
            if (o != null) {
                o.close();
            }
        }
    }
}

