/*
 * Decompiled with CFR 0.152.
 */
package kun;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import kun.KunUI;
import kun.UIConstants;
import kun.UIScreen;

public class KunCanvas
extends GameCanvas
implements UIConstants {
    private KunUI ui;
    int width;
    int height;
    private boolean pressed;
    private int pressX;
    private int pressY;
    private int lastX;
    private int lastY;
    private long pressTime;
    private long releaseTime;
    private boolean draggedMuch;
    private boolean scrollPreSlide;
    private float scrollSlideMaxTime;
    private float scrollSlideSpeed;
    private boolean scrollSlide;
    private boolean controlBlock;

    KunCanvas(KunUI ui) {
        super(false);
        this.ui = ui;
        super.setFullScreenMode(true);
        this.width = super.getWidth();
        this.height = super.getHeight();
        if (!super.hasPointerEvents()) {
            ui.keyInput = true;
        }
        this.updateScreen();
    }

    public void updateScreen() {
        Graphics g = this.getGraphics();
        g.setColor(-1);
        g.fillRect(0, 0, this.width, this.height);
        UIScreen s = this.ui.current;
        if (s != null) {
            int h = this.height;
            if (!this.ui.keyInput && this.ui.scrolling && !this.scrollPreSlide && this.releaseTime - this.pressTime > 0L) {
                if (this.scrollSlide && Math.abs(this.scrollSlideSpeed) > 0.8f && (float)(System.currentTimeMillis() - this.releaseTime) < this.scrollSlideMaxTime && s.scroll((int)this.scrollSlideSpeed)) {
                    float f = 0.967f;
                    this.scrollSlideSpeed *= 0.967f;
                } else {
                    this.scrollSlideSpeed = 0.0f;
                    this.ui.scrolling = false;
                }
            }
            try {
                s.paint(g, this.width, h);
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        this.flushGraphics();
    }

    public void resetScreen() {
    }

    private void tap(int x, int y, int time) {
        UIScreen s = this.ui.current;
        if (s != null) {
            s.tap(x, y, time);
        }
    }

    public void pointerPressed(int x, int y) {
        this.ui.keyInput = false;
        this.pressed = true;
        this.lastX = this.pressX = x;
        this.lastY = this.pressY = y;
        this.pressTime = System.currentTimeMillis();
        this.draggedMuch = false;
        this.scrollSlide = false;
        this.scrollPreSlide = false;
        this.needRepaint();
    }

    public void pointerReleased(int x, int y) {
        this.lastX = x;
        this.lastY = y;
        if (this.controlBlock) {
            this.needRepaint();
            return;
        }
        this.releaseTime = System.currentTimeMillis();
        int time = (int)(this.releaseTime - this.pressTime);
        int dx = Math.abs(x - this.pressX);
        int dy = y - this.pressY;
        int ady = Math.abs(dy);
        if (this.pressed) {
            UIScreen s = this.ui.current;
            if (s != null) {
                s.release(x, y);
            }
            if (this.draggedMuch) {
                if (time < 200) {
                    this.scrollSlide = this.scrollPreSlide;
                    this.ui.scrolling = true;
                } else {
                    this.scrollSlide = false;
                }
            } else if (dx <= 6 && ady <= 6) {
                this.tap(x, y, time);
            } else if (time < 200 && dx < 12 && s != null) {
                s.scroll(-dy);
            }
            this.scrollPreSlide = false;
            this.pressed = false;
        }
        this.needRepaint();
    }

    public void pointerDragged(int x, int y) {
        if (this.controlBlock) {
            this.needRepaint();
            return;
        }
        UIScreen s = this.ui.current;
        if (s != null && !s.blockScrolling()) {
            int sdX = Math.abs(this.pressX - x);
            int sdY = Math.abs(this.pressY - y);
            int dX = this.lastX - x;
            int dY = this.lastY - y;
            int adX = Math.abs(dX);
            int adY = Math.abs(dY);
            if (adY > 0 && adX < 16) {
                float f1 = 8.0f;
                float f2 = 2.5f;
                this.scrollPreSlide = true;
                this.scrollSlideMaxTime += (float)Math.abs(dY) / f1 * 2400.0f;
                float m = (float)(-dY) / f2;
                if (this.scrollSlideSpeed > 0.0f && m < 0.0f || this.scrollSlideSpeed < 0.0f && m > 0.0f) {
                    this.scrollSlideSpeed = 0.0f;
                }
                if (Math.abs(this.scrollSlideSpeed) > 60.0f) {
                    this.scrollSlideSpeed = (float)((double)this.scrollSlideSpeed * 0.95);
                    m = (float)((double)m * 0.8);
                }
                this.scrollSlideSpeed += m;
                s.scroll(-dY);
            }
            if (sdY > 1 || sdX > 1) {
                this.draggedMuch = true;
                if (!this.ui.scrolling) {
                    this.needRepaint();
                    this.ui.scrolling = true;
                }
            }
        }
        this.lastX = x;
        this.lastY = y;
    }

    public void keyPressed(int i) {
        UIScreen s = this.ui.current;
        if (s != null) {
            s.keyPress(i);
        }
        this.needRepaint();
    }

    public void keyReleased(int i) {
        UIScreen s = this.ui.current;
        if (s != null) {
            s.keyRelease(i);
        }
        this.needRepaint();
    }

    public void keyRepeated(int i) {
        UIScreen s = this.ui.current;
        if (s != null) {
            s.keyRepeat(i);
        }
        this.needRepaint();
    }

    protected void sizeChanged(int w, int h) {
        KunUI.width = this.width = w;
        KunUI.height = this.height = h;
        if (this.ui != null) {
            this.needRepaint();
        }
    }

    private void needRepaint() {
        this.ui.repaint();
    }

    public void hideNotify() {
        if (this.ui.current != null) {
            this.ui.current.hide();
        }
    }

    public void showNotify() {
        if (this.ui.current != null) {
            this.ui.current.show();
        }
    }
}

