/*
 * Decompiled with CFR 0.152.
 */
package kun;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import kun.Kun;
import kun.KunCanvas;
import kun.LoginScreen;
import kun.SplashScreen;
import kun.UIScreen;
import kun.UserfeedScreen;

public class KunUI
implements Runnable {
    public static final Display display = Display.getDisplay((MIDlet)Kun.midlet);
    static KunUI inst;
    static KunCanvas canv;
    static int width;
    static int height;
    protected UIScreen current;
    public boolean scrolling;
    public int repaintTime;
    private Object repaintLock = new Object();
    private boolean repaint;
    private Thread repaintThread = new Thread(this);
    public boolean keyInput;

    public KunUI() {
        inst = this;
    }

    public void init() {
        canv = new KunCanvas(this);
        this.repaintThread.start();
        this.setScreen(new SplashScreen());
    }

    public void postInit() {
        block5: {
            if (Kun.accessToken != null) {
                try {
                    this.loggedIn();
                }
                catch (RuntimeException e) {
                    if ("Invalid token!".equals(e.getMessage())) {
                        Kun.accessToken = null;
                        Kun.user = null;
                        this.setScreen(new LoginScreen());
                        break block5;
                    }
                    e.printStackTrace();
                }
            } else {
                this.setScreen(new LoginScreen());
            }
        }
    }

    public void loggedIn() {
        Kun.loggedInit();
        this.setScreen(new UserfeedScreen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block6: while (true) {
                block11: {
                    if (!Kun.running) {
                        return;
                    }
                    while (true) {
                        if (display.getCurrent() == canv) {
                            if (!this.scrolling) {
                                this.repaint = false;
                                this._repaint();
                                if (!this.repaint) break;
                                continue block6;
                            }
                            break block11;
                        }
                        Thread.sleep(500L);
                    }
                    Object object = this.repaintLock;
                    synchronized (object) {
                        this.repaintLock.wait(2000L);
                    }
                }
                this._repaint();
                this.limitFramerate();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void limitFramerate() throws InterruptedException {
        int i = 30;
        if ((i -= this.repaintTime) > 0) {
            Thread.sleep(i);
        }
    }

    private void _repaint() {
        long time = System.currentTimeMillis();
        canv.updateScreen();
        this.repaintTime = (int)(System.currentTimeMillis() - time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        if (display.getCurrent() != canv) {
            return;
        }
        this.repaint = true;
        Object object = this.repaintLock;
        synchronized (object) {
            this.repaintLock.notify();
        }
    }

    public void setScreen(UIScreen s) {
        this.display(null);
        if (this.current != null) {
            this.current.hide();
        }
        this.current = s;
        canv.resetScreen();
        this.repaint();
        s.show();
    }

    public void display(Displayable d) {
        if (d == null) {
            if (display.getCurrent() == canv) {
                return;
            }
            display.setCurrent((Displayable)canv);
            if (this.current != null) {
                this.current.show();
            }
            return;
        }
        if (!(d instanceof Alert)) {
            display.setCurrent(d);
        } else {
            display.setCurrent((Alert)d, (Displayable)canv);
        }
    }

    public int getWidth() {
        return KunUI.canv.width;
    }

    public int getHeight() {
        return KunUI.canv.height;
    }
}

