/*
 * Decompiled with CFR 0.152.
 */
package kun;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import kun.UIConstants;
import kun.UIItem;
import kun.Util;

public class Label
extends UIItem
implements UIConstants {
    private String[] textArr;
    private int maxLines;
    private String text;
    private Font font;
    private int color;
    private int h;
    private int lineSpaces = 2;
    private int marginLeft;
    private int marginRight;
    private int marginTop = 2;
    private int marginBottom = 2;
    private boolean colorSet;

    public Label(String s) {
        this(s, UIConstants.mediumfont);
    }

    public Label(String s, Font f) {
        this.font = f;
        this.text = s;
    }

    public Label(String s, Font f, int c) {
        this.font = f;
        this.text = s;
        this.color = c;
        this.colorSet = true;
    }

    public void paint(Graphics g, int w, int x, int y, int sc) {
        g.setFont(this.font);
        if (this.textArr == null) {
            return;
        }
        y += this.marginTop;
        int fh = this.lineSpaces + this.font.getHeight();
        g.setColor(this.colorSet ? this.color : 0);
        int i = 0;
        while (i < this.textArr.length) {
            g.drawString(this.textArr[i], x + this.marginLeft, y, 0);
            y += fh;
            ++i;
        }
    }

    public void setMaxLines(int i) {
        this.maxLines = i;
    }

    public void setColor(int c) {
        this.color = c;
        this.colorSet = true;
    }

    public int getHeight() {
        return this.h;
    }

    protected void layout(int w) {
        this.h = this.marginTop + this.marginBottom;
        String[] arr = Util.getStringArray(this.text, w - 4 - (this.marginLeft + this.marginRight), this.font);
        this.textArr = new String[arr.length > this.maxLines && this.maxLines > 0 ? this.maxLines : arr.length];
        int i = 0;
        while (i < this.textArr.length) {
            this.textArr[i] = arr[i];
            if (i == this.textArr.length - 1 && arr.length > this.textArr.length) {
                this.textArr[i] = this.textArr[i].trim().concat("...");
            }
            ++i;
        }
        this.h += this.textArr.length * (this.font.getHeight() + this.lineSpaces);
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void setLineSpaces(int i) {
        this.lineSpaces = i;
        this.relayout();
    }

    public void setMarginLeft(int i) {
        this.marginLeft = i;
        this.relayout();
    }

    public void setMarginRight(int i) {
        this.marginRight = i;
        this.relayout();
    }

    public void setMarginWidth(int i) {
        this.marginRight = this.marginLeft = i;
        this.relayout();
    }

    public void setMarginTop(int i) {
        this.marginTop = i;
        this.relayout();
    }

    public void setMarginBottom(int i) {
        this.marginBottom = i;
        this.relayout();
    }

    public void setMarginHeight(int i) {
        this.marginBottom = this.marginTop = i;
        this.relayout();
    }

    public boolean canBeFocused() {
        return false;
    }
}

