/*
 * Decompiled with CFR 0.152.
 */
package kun;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import kun.UIConstants;
import kun.UIItem;
import kun.UIScreen;
import kun.Util;

public class ListScreen
extends UIScreen
implements UIConstants {
    protected Vector items;
    private UIItem cItem;
    private int screenHeight;
    private int scrollTarget = 0;
    private boolean needLayout;
    private long lastRepeat;
    private int scrollTimer;
    protected boolean bottomBar;
    protected String leftSoftLabel;
    protected String centerSoftLabel;
    protected String rightSoftLabel;

    protected ListScreen(String label, UIScreen parent, Vector v) {
        super(label, parent);
        this.items = v;
    }

    protected ListScreen(String label, UIScreen parent) {
        this(label, parent, new Vector());
    }

    protected ListScreen(Vector v) {
        this(null, null, new Vector());
    }

    protected void paint(Graphics g, int w, int h) {
        int y;
        boolean sizeChanged = this.width != w;
        this.width = w;
        int bottomBarHeight = UIConstants.smallfontheight + 2;
        if (this.bottomBar) {
            h -= bottomBarHeight;
        }
        this.screenHeight = h;
        if (this.height == 0 || this.needLayout || sizeChanged) {
            this.needLayout = false;
            y = 0;
            int i = 0;
            while (i < this.items.size()) {
                UIItem it = (UIItem)this.items.elementAt(i);
                if (it != null) {
                    it.layout(w);
                    it.setY(y);
                    it.setIndex(i);
                    y += it.getHeight();
                }
                ++i;
            }
            this.height = y;
        }
        if (sizeChanged) {
            this.scrollToFocusedItem();
        }
        if (this.cItem == null && this.size() > 0 && UIScreen.ui.keyInput) {
            this.selectItem();
        }
        if (Math.abs(this.scroll) > 65535.0f) {
            return;
        }
        if (this.scroll < (float)(-this.height + this.screenHeight) && this.scroll != 0.0f && !UIScreen.ui.scrolling) {
            this.scroll = -this.height + this.screenHeight;
        }
        if (this.scroll > 0.0f) {
            this.scroll = 0.0f;
        }
        if (this.bottomBar) {
            g.setColor(-1);
            g.fillRect(0, h, w, bottomBarHeight);
            g.setColor(0);
            g.drawLine(0, h, w, h);
            g.setColor(0);
            g.setFont(UIConstants.smallfont);
            if (this.leftSoftLabel != null) {
                g.drawString(this.leftSoftLabel, 2, h + bottomBarHeight - 2, 36);
            }
            if (this.rightSoftLabel != null) {
                g.drawString(this.rightSoftLabel, w - 2, h + bottomBarHeight - 2, 40);
            }
            if (this.centerSoftLabel != null) {
                g.drawString(this.centerSoftLabel, w >> 1, h + bottomBarHeight - 2, 33);
            }
            g.setClip(0, 0, w, h);
        }
        y = 0;
        int s = (int)this.scroll;
        try {
            int i = 0;
            while (i < this.items.size()) {
                UIItem it = (UIItem)this.items.elementAt(i);
                if (it != null) {
                    int sy = s + y;
                    int ih = it.getHeight();
                    if (sy + ih > 0 && sy < h) {
                        if (it.hidden) {
                            it.onShow();
                        }
                        it.paint(g, w, 0, s + y, (int)this.scroll);
                    } else if (!it.hidden) {
                        it.onHide();
                    }
                    y += ih;
                }
                ++i;
            }
            this.height = y;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.scrollTimer < 2 && this.height > 0 && this.height > this.screenHeight) {
            ++this.scrollTimer;
            g.setColor(0xADADAD);
            int sw = 4;
            int hh = this.height;
            if (hh <= 0) {
                hh = 1;
            }
            int sby = (int)(-this.scroll / (float)hh * (float)h);
            int sbh = (int)((float)h / (float)hh * (float)h);
            g.fillRect(w - sw, sby, sw - 2, sbh);
        }
        if (this.scrollTarget <= 0) {
            this.scrollTimer = 0;
            UIScreen.ui.scrolling = true;
            if (Math.abs(this.scroll - (float)this.scrollTarget) < 1.0f) {
                this.scroll = this.scrollTarget;
                this.scrollTarget = 1;
                UIScreen.ui.scrolling = false;
            } else {
                this.scroll = Util.lerp(this.scroll, this.scrollTarget, 4.0f, 20.0f);
            }
            if (this.scroll > 0.0f) {
                this.scroll = 0.0f;
                this.scrollTarget = 1;
                UIScreen.ui.scrolling = false;
            }
            if (this.scroll < (float)(-this.height + this.screenHeight)) {
                this.scroll = -this.height + this.screenHeight;
                this.scrollTarget = 1;
                UIScreen.ui.scrolling = false;
            }
        }
    }

    protected boolean scroll(int units) {
        if (this.height == 0 || this.height <= this.screenHeight) {
            this.scroll = 0.0f;
            return false;
        }
        if (this.scroll + (float)units < (float)(-this.height + this.screenHeight)) {
            this.scroll = -this.height + this.screenHeight;
            return false;
        }
        if (units == 0) {
            return false;
        }
        this.scroll += (float)units;
        if (this.scroll > 0.0f) {
            this.scroll = 0.0f;
            return false;
        }
        this.scrollTimer = 0;
        this.scrollTarget = 1;
        return true;
    }

    public void repaint(UIItem i) {
        if (this.isItemSeenOnScreen(i)) {
            super.repaint(i);
        }
    }

    protected void press(int x, int y) {
        int yy = 0;
        int sy = (int)this.scroll;
        int i = 0;
        while (i < this.items.size()) {
            UIItem it = (UIItem)this.items.elementAt(i);
            if (it != null) {
                int ih = it.getHeight();
                if (y > sy + yy && y < sy + yy + ih) {
                    this.focusItem(it);
                    it.press(x, (int)this.scroll + y - yy);
                }
                yy += ih;
            }
            ++i;
        }
    }

    protected void release(int x, int y) {
        int yy = 0;
        int sy = (int)this.scroll;
        int i = 0;
        while (i < this.items.size()) {
            UIItem it = (UIItem)this.items.elementAt(i);
            if (it != null) {
                int ih = it.getHeight();
                if (y > sy + yy && y < sy + yy + ih) {
                    this.focusItem(it);
                    it.release(x, (int)this.scroll + y - yy);
                }
                yy += ih;
            }
            ++i;
        }
    }

    protected void tap(int x, int y, int time) {
        int yy = 0;
        int sy = (int)this.scroll;
        int i = 0;
        while (i < this.items.size()) {
            UIItem it = (UIItem)this.items.elementAt(i);
            if (it != null) {
                int ih = it.getHeight();
                if (y > sy + yy && y < sy + yy + ih) {
                    this.focusItem(it);
                    it.tap(x, (int)this.scroll + y - yy, time);
                }
                yy += ih;
            }
            ++i;
        }
    }

    protected void keyPress(int i) {
        if ((!UIScreen.ui.keyInput || this.cItem == null) && (i >= -7 && i <= -1 || i >= 1 && i <= 57)) {
            boolean b = this.cItem == null;
            UIScreen.ui.keyInput = true;
            this.selectItem();
            if (b && (i == -1 || i == -2)) {
                return;
            }
        }
        if (i == -1) {
            if ((float)this.cItem.getY() < -this.scroll) {
                this.smoothlyScrollTo((int)this.scroll + this.screenHeight / 3);
            } else {
                if (this.cItem.getListPosition() == 0) {
                    if (-this.scroll < (float)(this.screenHeight / 4)) {
                        this.smoothlyScrollTo(0);
                    }
                    return;
                }
                if (this.cItem != this.getFirstFocusableItem()) {
                    this.focusItem((UIItem)this.items.elementAt(this.cItem.getListPosition() - 1));
                    if (!this.cItem.canBeFocused() && this.cItem.getListPosition() != 0) {
                        this.focusItem((UIItem)this.items.elementAt(this.cItem.getListPosition() - 1));
                    }
                }
                if (!this.isItemSeenOnScreen(this.cItem, 24)) {
                    this.smoothlyScrollTo(-this.cItem.getY());
                }
            }
        } else if (i == -2) {
            if ((float)(this.cItem.getY() + this.cItem.getHeight()) > -(this.scroll - (float)this.screenHeight)) {
                this.smoothlyScrollTo((int)this.scroll - this.screenHeight / 3);
            } else {
                if (this.cItem.getListPosition() == this.items.size() - 1) {
                    return;
                }
                this.focusItem((UIItem)this.items.elementAt(this.cItem.getListPosition() + 1));
                if (!this.cItem.canBeFocused() && this.cItem.getListPosition() != this.items.size() - 1) {
                    this.focusItem((UIItem)this.items.elementAt(this.cItem.getListPosition() + 1));
                }
                if (!this.isItemSeenOnScreen(this.cItem, 24)) {
                    this.smoothlyScrollTo(-this.cItem.getY());
                }
            }
            if (this.scroll < (float)(-this.height + this.screenHeight)) {
                this.scroll = -this.height + this.screenHeight;
            }
        }
        if (i <= -3 && i >= -7 && this.selectItem()) {
            this.cItem.keyPress(i);
        }
    }

    protected void keyRelease(int i) {
        if (i <= -3 && i >= -7 && this.selectItem()) {
            this.cItem.keyRelease(i);
        }
    }

    protected void keyRepeat(int i) {
        if (System.currentTimeMillis() - this.lastRepeat < 200L) {
            return;
        }
        if (i == -1 || i == -2) {
            if (i == -1) {
                if (this.cItem.getListPosition() == 0 || this.cItem == this.getFirstFocusableItem()) {
                    if (-this.scroll < (float)(this.screenHeight / 4)) {
                        this.smoothlyScrollTo(0);
                    }
                    return;
                }
                this.focusItem((UIItem)this.items.elementAt(this.cItem.getListPosition() - 1));
            } else if (i == -2) {
                if (this.cItem.getListPosition() == this.items.size() - 1) {
                    if ((float)(this.cItem.getY() + this.cItem.getHeight()) > -(this.scroll - (float)this.screenHeight)) {
                        this.smoothlyScrollTo((int)this.scroll - this.screenHeight / 3);
                    }
                    return;
                }
                this.focusItem((UIItem)this.items.elementAt(this.cItem.getListPosition() + 1));
            }
            this.smoothlyScrollTo(-this.cItem.getY());
            if (this.scroll < (float)(-this.height + this.screenHeight)) {
                this.scroll = -this.height + this.screenHeight;
            }
        }
        this.lastRepeat = System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean selectItem() {
        if (this.items.size() == 0) {
            this.cItem = null;
            return false;
        }
        try {
            if (this.cItem == null) {
                int i = 0;
                while (true) {
                    if (i >= this.items.size()) {
                        UIItem item;
                        if (this.cItem != null || (item = this.getFirstFocusableItem()) == null || !this.isItemSeenOnScreen(item)) break;
                        this.cItem = item;
                        this.cItem.focus();
                        return true;
                    }
                    UIItem it = (UIItem)this.items.elementAt(i);
                    if (it != null && this.isItemSeenOnScreen(this.cItem) && this.cItem.canBeFocused()) {
                        this.cItem = it;
                        this.cItem.focus();
                        return true;
                    }
                    ++i;
                }
            }
            if (!this.isItemSeenOnScreen(this.cItem)) {
                this.smoothlyScrollTo(-this.cItem.getY());
            }
            this.cItem.focus();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private UIItem getFirstFocusableItem() {
        int size = this.items.size();
        if (size == 0) {
            return null;
        }
        int i = 0;
        while (i < size) {
            UIItem item = (UIItem)this.items.elementAt(i);
            if (item != null && item.canBeFocused()) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void scrollToFocusedItem() {
        if (this.cItem == null || this.items.size() == 0) {
            return;
        }
        if (!this.isItemSeenOnScreen(this.cItem)) {
            this.smoothlyScrollTo(-this.cItem.getY());
        }
    }

    private void smoothlyScrollTo(int i) {
        if (i > 0) {
            i = 0;
        }
        this.scroll = i;
        this.repaint();
    }

    protected boolean isItemSeenOnScreen(UIItem i) {
        return this.isItemSeenOnScreen(i, 0, this.scroll);
    }

    protected boolean isItemSeenOnScreen(UIItem i, int offset) {
        return this.isItemSeenOnScreen(i, offset, this.scroll);
    }

    protected boolean isItemSeenOnScreen(UIItem i, int offset, double scroll) {
        if (!this.items.contains(i)) {
            return false;
        }
        int ih = i.getHeight();
        int y = i.getY();
        int sy = (int)scroll + y;
        int h = this.screenHeight;
        return sy + ih - offset > 0 && sy < h - offset;
    }

    public void add(UIItem i) {
        if (i == null) {
            throw new NullPointerException("item");
        }
        this.items.addElement(i);
        i.setScreen(this);
        this.relayout();
    }

    public void remove(UIItem i) {
        if (i == null) {
            throw new NullPointerException("item");
        }
        this.items.removeElement(i);
        i.setScreen(null);
        this.relayout();
    }

    public void remove(int i) {
        UIItem it = (UIItem)this.items.elementAt(i);
        it.setScreen(null);
        this.items.removeElementAt(i);
        this.relayout();
    }

    protected void clear() {
        int i = 0;
        while (i < this.items.size()) {
            UIItem it = (UIItem)this.items.elementAt(i);
            it.setScreen(null);
            ++i;
        }
        this.items.removeAllElements();
        this.height = 0;
        this.scroll = 0.0f;
    }

    protected void relayout() {
        this.needLayout = true;
        if (this.width != 0) {
            this.repaint();
        }
    }

    protected UIItem get(int i) {
        return (UIItem)this.items.elementAt(i);
    }

    public boolean hasScrollBar() {
        return false;
    }

    public void setScrollBarY(int y) {
        int hh = this.height;
        int h = this.screenHeight;
        float sbh = (float)h / (float)hh * (float)h;
        this.scroll = -((int)((float)hh / (float)h * ((float)y - sbh / 2.0f)));
        if (this.scroll > 0.0f) {
            this.scroll = 0.0f;
        }
        if (this.scroll < (float)(-this.height + this.screenHeight)) {
            this.scroll = -this.height + this.screenHeight;
        }
    }

    private void focusItem(UIItem it) {
        if (this.cItem == it) {
            return;
        }
        if (this.cItem != null) {
            this.cItem.defocus();
        }
        this.cItem = it;
        it.focus();
    }

    public int size() {
        return this.items.size();
    }

    public UIItem getCurrentItem() {
        return this.cItem;
    }
}

