/*
 * Decompiled with CFR 0.152.
 */
package kun;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import kun.UIConstants;
import kun.UIItem;

public class TextInput
extends UIItem
implements UIConstants,
CommandListener {
    private static final Command okCmd = new Command("OK", 4, 1);
    private int h;
    private String text = "";
    private String hint = "";

    public TextInput() {
    }

    public TextInput(String hint) {
        this.hint = hint;
    }

    public void paint(Graphics g, int w, int x, int y, int sc) {
        g.setFont(UIConstants.mediumfont);
        g.setColor(-1);
        g.fillRect(x, y, w, this.h);
        g.setColor(this.text.length() > 0 ? 0 : 0x555555);
        String s = this.text.length() > 0 ? this.text : this.hint;
        g.drawString(s, x + 1, y + (this.h - UIConstants.mediumfontheight >> 1), 0);
        g.setColor(0);
        g.drawRect(x, y, w - 1, this.h - 2);
        if (this.inFocus && UIItem.ui.keyInput) {
            g.setColor(0xADADAD);
            g.drawRect(x, y, w - 1, this.h - 2);
        }
    }

    public int getHeight() {
        return this.h;
    }

    protected void layout(int w) {
        this.h = Math.max(24, UIConstants.mediumfontheight + 8);
    }

    public String getText() {
        return this.text;
    }

    private void open() {
        TextBox t = new TextBox("", "", 1000, 0);
        t.setString(this.text);
        t.setCommandListener((CommandListener)this);
        t.addCommand(okCmd);
        UIItem.ui.display((Displayable)t);
    }

    protected void tap(int x, int y, int time) {
        this.open();
    }

    protected void keyPress(int i) {
        if (i == -5 || i == 53) {
            this.open();
        }
    }

    public void commandAction(Command c, Displayable d) {
        this.text = ((TextBox)d).getString();
        UIItem.ui.display(null);
    }
}

