/*
 * Decompiled with CFR 0.152.
 */
package kun;

import javax.microedition.lcdui.Graphics;
import kun.KunUI;
import kun.UIScreen;

public abstract class UIItem {
    protected static KunUI ui = KunUI.inst;
    private UIScreen screen;
    protected boolean inFocus;
    private int y;
    protected int index;
    boolean hidden = true;

    public UIItem(UIScreen screen) {
        this.screen = screen;
    }

    public UIItem() {
    }

    public abstract void paint(Graphics var1, int var2, int var3, int var4, int var5);

    public abstract int getHeight();

    protected abstract void layout(int var1);

    protected void press(int x, int y) {
    }

    protected void release(int x, int y) {
    }

    protected void tap(int x, int y, int time) {
    }

    protected void keyPress(int i) {
    }

    protected void keyRelease(int i) {
    }

    public void focus() {
        this.inFocus = true;
    }

    public void defocus() {
        this.inFocus = false;
    }

    public void setScreen(UIScreen screen) {
        this.screen = screen;
    }

    public UIScreen getScreen() {
        return this.screen;
    }

    public final int getWidth() {
        return this.screen.getWidth();
    }

    protected final void repaint() {
        if (this.screen != null) {
            this.screen.repaint(this);
        }
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getListPosition() {
        return this.index;
    }

    public void relayout() {
        if (this.screen == null) {
            return;
        }
        this.screen.relayout();
    }

    public boolean isSeenOnScreen() {
        if (this.screen == null) {
            return false;
        }
        return this.screen.isItemSeenOnScreen(this);
    }

    protected boolean isHidden() {
        return this.hidden;
    }

    protected void onHide() {
        this.hidden = true;
    }

    protected void onShow() {
        this.hidden = false;
    }

    public boolean canBeFocused() {
        return true;
    }

    public String getOKLabel() {
        return null;
    }
}

