/*
 * Decompiled with CFR 0.152.
 */
package kun;

import cc.nnproject.json.JSONArray;
import cc.nnproject.json.JSONObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kun.Kun;
import kun.KunUI;
import kun.UIConstants;
import kun.UIScreen;
import kun.Util;

public class UserfeedScreen
extends UIScreen {
    private Image kunImg;
    private Image goodImg;
    private Image avgImg;
    private Image badImg;
    private Image leftArrowImg;
    private Image rightArrowImg;
    private int screenHeight;
    private int scrollTarget;
    private int scrollTimer;
    private String className;
    private String schoolName;
    private String scheduleDate;
    private int dayOffset;
    private int arrowY;
    private Object[][] lessons;
    private Object[][] marks;

    UserfeedScreen() {
        super(null, null);
        try {
            this.kunImg = Image.createImage((String)"/kz36.png");
            this.goodImg = Image.createImage((String)"/good.png");
            this.avgImg = Image.createImage((String)"/avg.png");
            this.badImg = Image.createImage((String)"/bad.png");
            this.leftArrowImg = Image.createImage((String)"/leftarrow.png");
            this.rightArrowImg = Image.createImage((String)"/rightarrow.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadSchedule();
        try {
            JSONObject recentMarks = (JSONObject)Kun.apiGet("persons/" + Kun.personId + "/group/" + Kun.groupId + "/recentmarks?limit=10");
            Enumeration e3 = recentMarks.getArray("subjects").elements();
            while (e3.hasMoreElements()) {
                JSONObject tmpSubject = (JSONObject)e3.nextElement();
                String subjectId = tmpSubject.getString("id");
                if (Kun.subjectsTable.containsKey(subjectId)) continue;
                Kun.subjectsTable.put(subjectId, tmpSubject);
            }
            JSONArray marks = recentMarks.getArray("marks");
            Date lastDate = null;
            this.marks = new Object[marks.size()][];
            int i = 0;
            while (i < marks.size()) {
                JSONObject mark = marks.getObject(i);
                this.marks[i] = new Object[4];
                Date date = Util.parseApiDate(mark.getString("date")).getTime();
                if (lastDate == null || !Util.isDateEqual(date, lastDate)) {
                    lastDate = date;
                    this.marks[i][0] = Util.localizeDate(date);
                }
                String mood = mark.getString("mood");
                this.marks[i][1] = "good".equalsIgnoreCase(mood) ? this.goodImg : ("bad".equalsIgnoreCase(mood) ? this.badImg : this.avgImg);
                this.marks[i][2] = mark.getString("value");
                JSONObject subj = (JSONObject)Kun.subjectsTable.get(mark.getString("lesson_str"));
                if (subj != null) {
                    this.marks[i][3] = subj.getString("name");
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.className = Kun.eduGroups.getObject(0).getString("name");
        this.schoolName = Kun.schools.getObject(0).getString("name");
    }

    private void loadSchedule() {
        try {
            Calendar cal = Calendar.getInstance();
            Util.addDays(cal, this.dayOffset);
            this.scheduleDate = Util.localizeDateWithWeek(cal.getTime());
            JSONArray lessons = Kun.getSchedule(Kun.personId, Kun.groupId, Util.getApiDate(cal)).getObject(0).getArray("lessons");
            this.lessons = new Object[lessons.size()][];
            int i = 0;
            while (i < lessons.size()) {
                JSONObject lesson = lessons.getObject(i);
                JSONArray homeworks = lesson.getArray("homeworks");
                this.lessons[i] = new Object[7];
                this.lessons[i][0] = String.valueOf(lesson.getInt("number"));
                this.lessons[i][1] = lesson.getString("hours");
                this.lessons[i][2] = lesson.getString("name");
                if (lesson.has("mark")) {
                    JSONObject mark = lesson.getObject("mark");
                    this.lessons[i][3] = "good".equalsIgnoreCase(mark.getString("mood")) ? Boolean.TRUE : Boolean.FALSE;
                    this.lessons[i][4] = mark.getString("value");
                }
                this.lessons[i][5] = lesson.getString("title");
                if (homeworks.size() > 0) {
                    this.lessons[i][6] = homeworks.getString(0);
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void tap(int x, int y, int time) {
        if (y < 44 && x > KunUI.width - 60) {
            Kun.midlet.notifyDestroyed();
        } else if ((float)y > (float)this.arrowY + this.scroll && (float)y < (float)this.arrowY + this.scroll + 50.0f) {
            if (x < 50) {
                --this.dayOffset;
                this.loadSchedule();
            } else if (x > KunUI.width - 50) {
                ++this.dayOffset;
                this.loadSchedule();
            }
        }
    }

    protected void paint(Graphics g, int w, int h) {
        g.setColor(-1);
        g.fillRect(0, 0, w, h);
        g.setClip(0, 0, w, 44);
        g.drawImage(this.kunImg, 4, 4, 0);
        if (!UIScreen.ui.keyInput) {
            g.setFont(UIConstants.smallfont);
            g.setColor(0x5F5F5F);
            g.drawString("\u0412\u044b\u0445\u043e\u0434", w - 8, 44 - UIConstants.smallfontheight >> 1, 24);
        }
        this.screenHeight = h;
        if (this.scroll < (float)(-this.height + this.screenHeight) && this.scroll != 0.0f && !UIScreen.ui.scrolling) {
            this.scroll = -this.height + this.screenHeight;
        }
        if (this.scroll > 0.0f) {
            this.scroll = 0.0f;
        }
        g.setClip(0, 44, w, h - 44);
        g.translate(0, (int)this.scroll);
        g.setColor(16186108);
        int nameh = Math.max(48, 10 + UIConstants.mediumboldfontheight + UIConstants.smallfontheight);
        g.fillRect(0, 44, w, nameh);
        g.setColor(160690);
        g.setFont(UIConstants.mediumboldfont);
        g.drawString(Kun.shortName, 4, 48, 0);
        g.setColor(0x7F7F7F);
        g.setFont(UIConstants.smallfont);
        g.drawString(String.valueOf(this.className) + ", " + this.schoolName, 4, 50 + UIConstants.mediumboldfontheight, 0);
        g.setColor(15462902);
        int yy = 44 + nameh;
        int markh = Math.min(100, 51 + UIConstants.smallfontheight * 3 + 8);
        g.fillRect(0, yy, w, markh);
        if (this.marks.length == 0) {
            g.setColor(0);
            g.drawString("\u041d\u0435\u0442 \u043e\u0446\u0435\u043d\u043e\u043a", w >> 1, yy + (64 - UIConstants.mediumfontheight >> 1), 17);
        } else {
            int xx = 5;
            int i = 0;
            while (i < this.marks.length) {
                Object[] mark = this.marks[i];
                if (mark[0] != null) {
                    g.setColor(0x2C2C2C);
                    g.setFont(UIConstants.smallfont);
                    g.drawString((String)mark[0], xx, yy + 2, 0);
                }
                g.drawImage((Image)mark[1], xx, yy + UIConstants.smallfontheight + 4, 0);
                g.setColor(-1);
                g.setFont(UIConstants.largefont);
                g.drawString((String)mark[2], xx + 47, yy + UIConstants.smallfontheight + 4 + (50 - UIConstants.largefontheight >> 1), 17);
                g.setColor(0);
                g.setFont(UIConstants.smallfont);
                if (mark[3] != null) {
                    g.drawString((String)mark[3], xx, yy + UIConstants.smallfontheight + UIConstants.largefontheight + 8, 0);
                }
                xx += 100;
                ++i;
            }
        }
        g.setColor(0xD8D8D8);
        g.drawLine(0, yy += markh, w, yy);
        g.setColor(0);
        g.setFont(UIConstants.mediumfont);
        g.drawString(this.scheduleDate, w >> 1, ++yy + (48 - UIConstants.mediumfontheight >> 1), 17);
        this.arrowY = yy;
        g.drawImage(this.leftArrowImg, 8, yy + 24, 6);
        g.drawImage(this.rightArrowImg, w - 8, yy + 24, 10);
        g.setColor(0xD8D8D8);
        g.drawLine(0, yy += 48, w, yy);
        if (this.lessons.length == 0) {
            g.drawRect(0, yy, w, 64);
            g.setColor(0);
            g.drawString("\u0412 \u044d\u0442\u043e\u0442 \u0434\u0435\u043d\u044c \u043d\u0435\u0442 \u0443\u0440\u043e\u043a\u043e\u0432", w >> 1, yy + (64 - UIConstants.mediumfontheight >> 1), 17);
            yy += 64;
        } else {
            int i = 0;
            while (i < this.lessons.length) {
                Object[] lesson = this.lessons[i];
                g.setFont(UIConstants.smallfont);
                g.setColor(0x7F7F7F);
                g.drawString(((String)lesson[0]).concat(" \u0423\u0420\u041e\u041a"), 8, yy + 8, 0);
                g.setColor(160690);
                g.drawString((String)lesson[1], w - 12, yy + 8, 24);
                g.setFont(UIConstants.mediumboldfont);
                g.setColor(0);
                g.drawString((String)lesson[2], 8, (yy += 8 + UIConstants.smallfontheight) + 8, 0);
                if (lesson[3] != null) {
                    g.setColor(Boolean.TRUE.equals(lesson[3]) ? 12767802 : 16359995);
                    g.fillRect(w - 42, yy, 30, 30);
                    g.setColor(-1);
                    g.setFont(UIConstants.smallfont);
                    g.drawString((String)lesson[4], w - 42 + 15, yy + (30 - UIConstants.smallfontheight >> 1), 17);
                }
                g.setColor(0x7F7F7F);
                g.setFont(UIConstants.smallfont);
                g.drawString(Util.oneLine((String)lesson[5], UIConstants.smallfont, w - 16), 8, (yy += 8 + UIConstants.mediumboldfontheight) + 4, 0);
                yy += 4 + UIConstants.smallfontheight;
                g.setColor(0);
                if (lesson[6] != null) {
                    g.drawString(Util.oneLine((String)lesson[6], UIConstants.smallfont, w - 16), 8, yy + 8, 0);
                }
                g.setColor(0xD8D8D8);
                g.drawLine(0, yy += 16 + UIConstants.smallfontheight, w, yy);
                ++i;
            }
        }
        this.height = yy;
        g.translate(0, -g.getTranslateY());
        if (this.scrollTimer < 2 && this.height > 0 && this.height > this.screenHeight) {
            ++this.scrollTimer;
            g.setColor(0xADADAD);
            int sw = 4;
            int hh = this.height;
            if (hh <= 0) {
                hh = 1;
            }
            int sby = (int)(-this.scroll / (float)hh * (float)h);
            int sbh = (int)((float)h / (float)hh * (float)h);
            g.fillRect(w - sw, sby, sw - 2, sbh);
        }
        if (this.scrollTarget <= 0) {
            this.scrollTimer = 0;
            UIScreen.ui.scrolling = true;
            if (Math.abs(this.scroll - (float)this.scrollTarget) < 1.0f) {
                this.scroll = this.scrollTarget;
                this.scrollTarget = 1;
                UIScreen.ui.scrolling = false;
            } else {
                this.scroll = Util.lerp(this.scroll, this.scrollTarget, 4.0f, 20.0f);
            }
            if (this.scroll > 0.0f) {
                this.scroll = 0.0f;
                this.scrollTarget = 1;
                UIScreen.ui.scrolling = false;
            }
            if (this.scroll < (float)(-this.height + this.screenHeight)) {
                this.scroll = -this.height + this.screenHeight;
                this.scrollTarget = 1;
                UIScreen.ui.scrolling = false;
            }
        }
    }

    protected boolean scroll(int units) {
        if (this.height == 0 || this.height <= this.screenHeight) {
            this.scroll = 0.0f;
            return false;
        }
        if (this.scroll + (float)units < (float)(-this.height + this.screenHeight)) {
            this.scroll = -this.height + this.screenHeight;
            return false;
        }
        if (units == 0) {
            return false;
        }
        this.scroll += (float)units;
        if (this.scroll > 0.0f) {
            this.scroll = 0.0f;
            return false;
        }
        this.scrollTimer = 0;
        this.scrollTarget = 1;
        return true;
    }
}

