/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Contact;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Body {
    protected FXVector mPositionFX = new FXVector();
    protected FXVector mVelocityFX = new FXVector();
    protected FXVector mVirtualVelocityFX = new FXVector();
    protected int mRotation2FX = 0;
    protected int mAngularVelocity2FX = 0;
    protected int mVirtualAngularVelocity2FX = 0;
    private FXMatrix j = FXMatrix.createRotationMatrix(0);
    private boolean k = true;
    boolean a = true;
    boolean b = true;
    boolean c = true;
    protected Shape mShape;
    private FXVector[] l;
    FXVector[] d;
    private boolean m = false;
    private FXVector[] n;
    private boolean o = false;
    int e = 0;
    int f = 0;
    int g = 0;
    int h = 0;
    int i = 0;
    private int p = 0;
    private Contact[] q = new Contact[8];
    private boolean r = false;
    protected int mId = -1;
    protected UserData mUserData = null;
    private static FXVector s = new FXVector();
    private static FXMatrix t = new FXMatrix();

    public Body(int n, int n2, Shape shape, boolean bl) {
        this.mPositionFX = new FXVector(n << 12, n2 << 12);
        this.mShape = shape;
        this.initShapeInternals();
        this.a = bl;
        this.r = !bl;
    }

    public Body(FXVector fXVector, Shape shape, boolean bl) {
        this.mPositionFX = new FXVector(fXVector);
        this.mShape = shape;
        this.initShapeInternals();
        this.a = bl;
        this.r = !bl;
    }

    public Body(Body body) {
        this.mShape = body.mShape;
        this.initShapeInternals();
        this.mPositionFX = new FXVector(body.mPositionFX);
        this.mVelocityFX = new FXVector(body.mVelocityFX);
        this.setRotation2FX(body.mRotation2FX);
        this.mAngularVelocity2FX = body.mAngularVelocity2FX;
        this.i = body.i;
        this.a = body.a;
        this.k = body.k;
        this.c = body.c;
        this.b = body.b;
        if (body.mUserData != null) {
            this.mUserData = body.mUserData.copy();
        }
    }

    private Body() {
    }

    public Body copy() {
        return new Body(this);
    }

    public static Body loadBody(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        Body body = new Body();
        if (physicsFileReader.getVersion() < 1280) {
            physicsFileReader.nextIntFX();
        }
        body.mPositionFX = physicsFileReader.nextVector();
        body.mVelocityFX = physicsFileReader.nextVector();
        body.setRotation2FX(physicsFileReader.nextInt2FX());
        body.mAngularVelocity2FX = physicsFileReader.nextInt2FX();
        body.mShape = (Shape)vector.elementAt(physicsFileReader.next());
        int n = physicsFileReader.next();
        body.a = (n & 1) != 0;
        body.k = (n & 2) != 0;
        body.b = (n & 4) == 0;
        body.c = (n & 8) == 0;
        body.i = physicsFileReader.nextInt();
        if (physicsFileReader.getVersion() > 1536) {
            String string = physicsFileReader.nextString();
            if (userData != null) {
                body.mUserData = userData.createNewUserData(string, 1);
            }
        }
        body.initShapeInternals();
        return body;
    }

    public boolean equals(Body body) {
        return body.mId == this.mId && this.mId != -1;
    }

    protected void initShapeInternals() {
        this.l = new FXVector[this.mShape.mVertices.length];
        this.d = new FXVector[this.mShape.mVertices.length];
        int n = 0;
        while (n < this.l.length) {
            this.l[n] = new FXVector();
            this.d[n] = new FXVector();
            ++n;
        }
        this.n = new FXVector[this.mShape.b / 2];
        n = 0;
        while (n < this.n.length) {
            this.n[n] = new FXVector();
            ++n;
        }
        this.m = false;
        this.o = false;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isDynamic() {
        return this.a;
    }

    public boolean isResting() {
        return this.r;
    }

    public boolean canRotate() {
        return this.k;
    }

    public void setRotatable(boolean bl) {
        this.k = bl;
    }

    public boolean isInteracting() {
        return this.b;
    }

    public void setInteracting(boolean bl) {
        this.b = bl;
    }

    public boolean isAffectedByGravity() {
        return this.c;
    }

    public void setGravityAffected(boolean bl) {
        this.c = bl;
    }

    public void addCollisionLayer(int n) {
        this.i |= 1 << n;
    }

    public void removeCollisionLayer(int n) {
        this.i &= ~(1 << n);
    }

    public final long getInvMass2FX() {
        return this.a ? this.mShape.g : 0L;
    }

    public final long getInvInertia2FX() {
        return this.a ? this.mShape.i : 0L;
    }

    public void translate(FXVector fXVector, int n) {
        FXVector fXVector2 = this.mPositionFX;
        fXVector2.xFX += fXVector.xFX;
        fXVector2 = this.mPositionFX;
        fXVector2.yFX += fXVector.yFX;
        this.m = false;
        this.o = false;
        this.calculateAABB(n);
    }

    public void forceUpdate(int n) {
        this.m = false;
        this.o = false;
        this.calculateAABB(n);
    }

    public final FXVector getAbsoluePoint(FXVector fXVector) {
        FXVector fXVector2 = this.j.mult(fXVector);
        fXVector2.xFX += this.mPositionFX.xFX;
        fXVector2.yFX += this.mPositionFX.yFX;
        return fXVector2;
    }

    public final void getAbsoluePoint(FXVector fXVector, FXVector fXVector2) {
        this.j.mult(fXVector, fXVector2);
        fXVector2.xFX += this.mPositionFX.xFX;
        fXVector2.yFX += this.mPositionFX.yFX;
    }

    public final FXVector getRelativePoint(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.subtract(this.mPositionFX);
        FXMatrix fXMatrix = FXMatrix.createRotationMatrix(this.mRotation2FX);
        fXMatrix.invert();
        return fXMatrix.mult(fXVector);
    }

    public final FXVector getVelocity(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.crossScalar2FX(this.mAngularVelocity2FX);
        fXVector.xFX += this.mVelocityFX.xFX;
        fXVector.yFX += this.mVelocityFX.yFX;
        return fXVector;
    }

    protected final FXVector getVirtualVelocity(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.crossScalar2FX(this.mVirtualAngularVelocity2FX);
        fXVector.xFX += this.mVirtualVelocityFX.xFX;
        fXVector.yFX += this.mVirtualVelocityFX.yFX;
        return fXVector;
    }

    public final void getVelocity(FXVector fXVector, FXVector fXVector2) {
        fXVector2.xFX = fXVector.xFX;
        fXVector2.yFX = fXVector.yFX;
        fXVector2.crossScalar2FX(this.mAngularVelocity2FX);
        fXVector2.xFX += this.mVelocityFX.xFX;
        fXVector2.yFX += this.mVelocityFX.yFX;
    }

    protected final void getVirtualVelocity(FXVector fXVector, FXVector fXVector2) {
        fXVector2.xFX = fXVector.xFX;
        fXVector2.yFX = fXVector.yFX;
        fXVector2.crossScalar2FX(this.mVirtualAngularVelocity2FX);
        fXVector2.xFX += this.mVirtualVelocityFX.xFX;
        fXVector2.yFX += this.mVirtualVelocityFX.yFX;
    }

    public Shape shape() {
        return this.mShape;
    }

    public void setShape(Shape shape) {
        this.mShape = shape;
        this.initShapeInternals();
    }

    public final FXVector[] getVertices() {
        if (!this.m) {
            this.mShape.getVerticesFX(this.mPositionFX, this.j, this.l);
            this.m = true;
        }
        return this.l;
    }

    public final FXVector[] getAxes() {
        if (!this.o) {
            if (!this.m) {
                this.getVertices();
            }
            int n = 0;
            while (n < this.n.length && this.mShape.a[n << 1] >= 0) {
                this.n[n].assignDiff(this.l[this.mShape.a[n << 1]], this.l[this.mShape.a[(n << 1) + 1]]);
                this.n[n].normalize();
                this.n[n].turnRight();
                ++n;
            }
            this.o = true;
        }
        return this.n;
    }

    public int rotation2FX() {
        return this.mRotation2FX;
    }

    public int angularVelocity2FX() {
        return this.mAngularVelocity2FX;
    }

    public FXMatrix getRotationMatrix() {
        return this.j;
    }

    public FXVector positionFX() {
        return this.mPositionFX;
    }

    public FXVector velocityFX() {
        return this.mVelocityFX;
    }

    public int rotationVelocity2FX() {
        return this.mAngularVelocity2FX;
    }

    public void setRotation2FX(int n) {
        this.mRotation2FX = FXUtil.wrapAngleFX(n);
        this.j.setRotationMatrix(this.mRotation2FX);
        this.m = false;
        this.o = false;
        this.r = false;
    }

    public void setRotationDeg(int n) {
        this.mRotation2FX = (int)((long)n * 52707178L / 180L);
        while (this.mRotation2FX < 0) {
            this.mRotation2FX += 105414356;
        }
        while (this.mRotation2FX > 105414356) {
            this.mRotation2FX -= 105414356;
        }
        this.j.setRotationMatrix(this.mRotation2FX);
        this.m = false;
        this.o = false;
    }

    public void setPositionFX(FXVector fXVector) {
        this.mPositionFX.xFX = fXVector.xFX;
        this.mPositionFX.yFX = fXVector.yFX;
    }

    public void angularVelocity2FX(int n) {
        this.mAngularVelocity2FX = n;
    }

    public void applyAcceleration(FXVector fXVector, int n) {
        if (this.a && !this.r) {
            this.mVelocityFX.add(fXVector, n);
        }
    }

    public void applyForce(FXVector fXVector, int n) {
        if (this.a && !this.r) {
            FXVector fXVector2 = this.mVelocityFX;
            fXVector2.xFX += (int)(this.mShape.g * (long)n >> (int)(12L * (long)fXVector.xFX) >> 24);
            fXVector2 = this.mVelocityFX;
            fXVector2.yFX += (int)(this.mShape.g * (long)n >> (int)(12L * (long)fXVector.yFX) >> 24);
        }
    }

    public final void applyMomentumAt(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mAngularVelocity2FX -= (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            FXVector fXVector3 = this.mVelocityFX;
            fXVector3.xFX += (int)(this.mShape.g * (long)fXVector.xFX >> 24);
            fXVector3 = this.mVelocityFX;
            fXVector3.yFX += (int)(this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    final void a(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mAngularVelocity2FX += (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            FXVector fXVector3 = this.mVelocityFX;
            fXVector3.xFX += (int)(-this.mShape.g * (long)fXVector.xFX >> 24);
            fXVector3 = this.mVelocityFX;
            fXVector3.yFX += (int)(-this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyVirtualMomentumAt(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mVirtualAngularVelocity2FX -= (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            FXVector fXVector3 = this.mVirtualVelocityFX;
            fXVector3.xFX += (int)(this.mShape.g * (long)fXVector.xFX >> 24);
            fXVector3 = this.mVirtualVelocityFX;
            fXVector3.yFX += (int)(this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    final void b(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mVirtualAngularVelocity2FX += (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            FXVector fXVector3 = this.mVirtualVelocityFX;
            fXVector3.xFX += (int)(-this.mShape.g * (long)fXVector.xFX >> 24);
            fXVector3 = this.mVirtualVelocityFX;
            fXVector3.yFX += (int)(-this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyMomentum(FXVector fXVector) {
        if (this.a && !this.r) {
            FXVector fXVector2 = this.mVelocityFX;
            fXVector2.xFX += (int)(this.mShape.g * (long)fXVector.xFX >> 24);
            fXVector2 = this.mVelocityFX;
            fXVector2.yFX += (int)(this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyTorque(int n) {
        if (this.a && this.k && !this.r) {
            this.mAngularVelocity2FX -= (int)(this.mShape.i * (long)n >> 12);
        }
    }

    public final void integrateVelocity(int n) {
        if (this.a && !this.r) {
            this.mPositionFX.add(this.mVelocityFX, n);
            this.setRotation2FX(this.mRotation2FX - (int)((long)this.mAngularVelocity2FX * (long)n >> 12));
        }
    }

    public final void integrateVirtualVelocity(int n, FXVector fXVector) {
        if (this.a && !this.r) {
            Body.s.xFX = this.mVirtualVelocityFX.xFX;
            Body.s.yFX = this.mVirtualVelocityFX.yFX;
            s.multFX(n);
            FXVector fXVector2 = this.mPositionFX;
            fXVector2.xFX += Body.s.xFX;
            fXVector2 = this.mPositionFX;
            fXVector2.yFX += Body.s.yFX;
            this.setRotation2FX(this.mRotation2FX - (int)((long)this.mVirtualAngularVelocity2FX * (long)n >> 12));
            this.mVirtualAngularVelocity2FX = 0;
            this.mVirtualVelocityFX.assignFX(0, 0);
        }
    }

    protected final void calculateAABB(int n) {
        FXVector[] fXVectorArray = this.getVertices();
        this.e = this.f = fXVectorArray[0].xFX;
        this.g = this.h = fXVectorArray[0].yFX;
        if (!(this.mShape instanceof MultiShape)) {
            this.a(this.mShape, 0, n);
        } else {
            MultiShape multiShape = (MultiShape)this.mShape;
            int n2 = 0;
            while (n2 < multiShape.mShapes.length) {
                this.a(multiShape.mShapes[n2], multiShape.mVertexStartIndices[n2], n);
                ++n2;
            }
        }
    }

    private final void a(Shape shape, int n, int n2) {
        FXVector[] fXVectorArray = this.getVertices();
        if (shape.mVertices.length <= 1) {
            int n3 = (int)((long)this.mVelocityFX.xFX * (long)n2) >> 12;
            int n4 = (int)((long)this.mVelocityFX.yFX * (long)n2) >> 12;
            if (this.e > this.mPositionFX.xFX - shape.c) {
                this.e = this.mPositionFX.xFX - shape.c;
            }
            if (this.f < this.mPositionFX.xFX + shape.c) {
                this.f = this.mPositionFX.xFX + shape.c;
            }
            if (this.g > this.mPositionFX.yFX - shape.c) {
                this.g = this.mPositionFX.yFX - shape.c;
            }
            if (this.h < this.mPositionFX.yFX + shape.c) {
                this.h = this.mPositionFX.yFX + shape.c;
            }
            if (this.e > this.mPositionFX.xFX - shape.c + n3) {
                this.e = this.mPositionFX.xFX - shape.c + n3;
            }
            if (this.f < this.mPositionFX.xFX + shape.c + n3) {
                this.f = this.mPositionFX.xFX + shape.c + n3;
            }
            if (this.g > this.mPositionFX.yFX - shape.c + n4) {
                this.g = this.mPositionFX.yFX - shape.c + n4;
            }
            if (this.h < this.mPositionFX.yFX + shape.c + n4) {
                this.h = this.mPositionFX.yFX + shape.c + n4;
            }
            this.d[n].xFX = this.mVelocityFX.xFX;
            this.d[n].yFX = this.mVelocityFX.yFX;
            this.d[n].multFX(n2);
        } else {
            int n5 = FXUtil.wrapAngleFX(this.mRotation2FX - (int)((long)this.mAngularVelocity2FX * (long)n2 >> 12));
            t.setRotationMatrix(n5);
            FXVector[] fXVectorArray2 = shape.mVertices;
            FXVector fXVector = s;
            s.xFX = this.mPositionFX.xFX;
            fXVector.yFX = this.mPositionFX.yFX;
            fXVector.add(this.mVelocityFX, n2);
            n2 = 0;
            while (n2 < shape.mVertices.length) {
                t.mult(fXVectorArray2[n2], this.d[n + n2]);
                FXVector fXVector2 = this.d[n + n2];
                fXVector2.xFX += fXVector.xFX;
                fXVector2 = this.d[n + n2];
                fXVector2.yFX += fXVector.yFX;
                this.d[n + n2].subtract(fXVectorArray[n + n2]);
                ++n2;
            }
            n2 = n + shape.mVertices.length;
            int n6 = n;
            while (n6 < n2) {
                if (this.e > fXVectorArray[n6].xFX) {
                    this.e = fXVectorArray[n6].xFX;
                }
                if (this.f < fXVectorArray[n6].xFX) {
                    this.f = fXVectorArray[n6].xFX;
                }
                if (this.g > fXVectorArray[n6].yFX) {
                    this.g = fXVectorArray[n6].yFX;
                }
                if (this.h < fXVectorArray[n6].yFX) {
                    this.h = fXVectorArray[n6].yFX;
                }
                if (this.e > fXVectorArray[n6].xFX + this.d[n6].xFX) {
                    this.e = fXVectorArray[n6].xFX + this.d[n6].xFX;
                }
                if (this.f < fXVectorArray[n6].xFX + this.d[n6].xFX) {
                    this.f = fXVectorArray[n6].xFX + this.d[n6].xFX;
                }
                if (this.g > fXVectorArray[n6].yFX + this.d[n6].yFX) {
                    this.g = fXVectorArray[n6].yFX + this.d[n6].yFX;
                }
                if (this.h < fXVectorArray[n6].yFX + this.d[n6].yFX) {
                    this.h = fXVectorArray[n6].yFX + this.d[n6].yFX;
                }
                ++n6;
            }
        }
    }

    protected final void updateVelocity(int n, int n2) {
        if (n < 4096) {
            this.mVelocityFX.multFX(n);
        }
        if (n2 < 4096) {
            this.mAngularVelocity2FX = (int)((long)this.mAngularVelocity2FX * (long)n2) >> 12;
        }
    }

    protected void resetContacts() {
        int n = 0;
        while (n < this.p) {
            if (!this.q[n].g && World.e < World.f.length) {
                World.f[World.e++] = this.q[n];
                this.q[n].g = true;
            }
            this.q[n] = null;
            ++n;
        }
        this.p = 0;
    }

    protected void addContact(Contact contact) {
        if (this.p < 8) {
            this.q[this.p++] = contact;
        }
    }

    public Contact[] getContacts() {
        return this.q;
    }

    protected Contact getContact(Body body) {
        for (int i = 0; i < this.q.length && this.q[i] != null; ++i) {
            if (this.q[i].c != body && this.q[i].a != body) {
                continue;
            }
            return this.q[i];
        }
        return null;
    }

    protected Contact getContact(int n, Body body, int n2) {
        for (int i = 0; i < this.q.length && this.q[i] != null; ++i) {
            if (!(this.q[i].c == body && this.q[i].d == n2 && this.q[i].b == n || this.q[i].a == body && this.q[i].b == n2 && this.q[i].d == n)) {
                continue;
            }
            return this.q[i];
        }
        return null;
    }

    public void setDynamic(boolean bl) {
        this.a = bl;
    }

    public int getAABBMinXFX() {
        return this.e;
    }

    public int getAABBMaxXFX() {
        return this.f;
    }

    public int getAABBMinYFX() {
        return this.g;
    }

    public int getAABBMaxYFX() {
        return this.h;
    }

    public int getColissionBitFlag() {
        return this.i;
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

