/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Contact;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.Shape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;

public class Landscape {
    private Body a;
    private Shape b = new Shape(new FXVector[0]);
    protected int mSegmentCount = 0;
    protected FXVector[] mStartpoints = new FXVector[128];
    protected FXVector[] mEndpoints = new FXVector[128];
    protected short[] mFaces = new short[128];
    private int c = 0;
    private int[] d = new int[32];
    private int e = 0;
    private int f = 0;
    public static final short FACE_NONE = 0;
    public static final short FACE_LEFT = 1;
    public static final short FACE_RIGHT = 2;
    private int g = 0;
    private Contact[] h = new Contact[32];

    public Landscape() {
        this.a = new Body(0, 0, this.b, false);
    }

    public Landscape(Landscape landscape) {
        this.a = new Body(0, 0, this.b, false);
        if (landscape != null) {
            this.b.mFrictionFX = landscape.b.mFrictionFX;
            this.b.mElasticityFX = landscape.b.mElasticityFX;
            this.mSegmentCount = landscape.mSegmentCount;
            this.mStartpoints = new FXVector[Math.max(128, this.mSegmentCount)];
            this.mEndpoints = new FXVector[Math.max(128, this.mSegmentCount)];
            this.mFaces = new short[Math.max(128, this.mSegmentCount)];
            int n = 0;
            while (n < this.mSegmentCount) {
                this.mStartpoints[n] = new FXVector(landscape.mStartpoints[n]);
                this.mEndpoints[n] = new FXVector(landscape.mEndpoints[n]);
                this.mFaces[n] = landscape.mFaces[n];
                ++n;
            }
        }
    }

    public static Landscape loadLandscape(PhysicsFileReader physicsFileReader) {
        Landscape landscape = new Landscape();
        int n = physicsFileReader.nextInt();
        int n2 = 0;
        while (n2 < n) {
            landscape.addSegment(physicsFileReader.nextVector(), physicsFileReader.nextVector(), (short)physicsFileReader.next());
            ++n2;
        }
        landscape.b = Shape.loadShape(physicsFileReader, null);
        landscape.a = new Body(0, 0, landscape.b, false);
        return landscape;
    }

    public Landscape copy() {
        return new Landscape(this);
    }

    public void addSegment(FXVector fXVector, FXVector fXVector2, short s) {
        FXVector fXVector3 = fXVector.xFX < fXVector2.xFX ? fXVector : fXVector2;
        FXVector fXVector4 = fXVector.xFX < fXVector2.xFX ? fXVector2 : fXVector;
        if (fXVector2.xFX <= fXVector.xFX & s != 0) {
            s = (short)(s == 2 ? 1 : 2);
        }
        this.mStartpoints = World.a(this.mStartpoints, this.mSegmentCount);
        this.mEndpoints = World.a(this.mEndpoints, this.mSegmentCount);
        this.mFaces = World.a(this.mFaces, this.mSegmentCount);
        this.mStartpoints[this.mSegmentCount] = fXVector3;
        this.mEndpoints[this.mSegmentCount] = fXVector4;
        this.mFaces[this.mSegmentCount] = s;
        ++this.mSegmentCount;
        this.sortArrays();
    }

    public void removeSegment(int n) {
        if (n < this.mSegmentCount) {
            this.mStartpoints[n] = this.mStartpoints[this.mSegmentCount - 1];
            this.mEndpoints[n] = this.mEndpoints[this.mSegmentCount - 1];
            this.mFaces[n] = this.mFaces[this.mSegmentCount - 1];
            --this.mSegmentCount;
            this.sortArrays();
        }
    }

    protected final void sortArrays() {
        int n = 1;
        while (n < this.mSegmentCount) {
            FXVector fXVector = this.mStartpoints[n];
            FXVector fXVector2 = this.mEndpoints[n];
            short s = this.mFaces[n];
            int n2 = n - 1;
            while (n2 >= 0 && this.mStartpoints[n2].xFX > fXVector.xFX) {
                this.mStartpoints[n2 + 1] = this.mStartpoints[n2];
                this.mEndpoints[n2 + 1] = this.mEndpoints[n2];
                this.mFaces[n2 + 1] = this.mFaces[n2];
                --n2;
            }
            this.mStartpoints[n2 + 1] = fXVector;
            this.mEndpoints[n2 + 1] = fXVector2;
            this.mFaces[n2 + 1] = s;
            ++n;
        }
    }

    protected final void initCollision() {
        this.c = 0;
        this.d = new int[32];
        this.e = 0;
        this.f = 0;
    }

    protected final void collisionCheckBody(World world, Body body) {
        if (body.a && (body.i & this.a.i) == 0) {
            int n;
            int n2 = 0;
            while (n2 < this.e) {
                if (this.d[n2] != -1 && this.mEndpoints[this.d[n2]].xFX < body.e) {
                    --this.f;
                    this.d[n2] = -1;
                }
                ++n2;
            }
            n2 = 0;
            while (this.c < this.mSegmentCount && this.mStartpoints[this.c].xFX < body.f) {
                if (this.mEndpoints[this.c].xFX >= body.e) {
                    n = 1;
                    while (n2 < this.e) {
                        if (this.d[n2] == -1) {
                            this.d[n2] = this.c;
                            ++this.f;
                            n = 0;
                            break;
                        }
                        ++n2;
                    }
                    if (n != 0) {
                        this.d = World.a(this.d, this.e);
                        this.d[this.e++] = this.c;
                        ++this.f;
                    }
                    if (this.e > this.f << 1) {
                        this.e = World.b(this.d, this.e);
                    }
                }
                ++this.c;
            }
            n = 0;
            while (n < this.e) {
                int n3 = this.d[n];
                if (n3 >= 0 && body.g <= Math.max(this.mEndpoints[n3].yFX, this.mStartpoints[n3].yFX) && Math.min(this.mStartpoints[n3].yFX, this.mEndpoints[n3].yFX) <= body.h) {
                    if (body.mShape instanceof MultiShape) {
                        int n4 = 0;
                        while (n4 < ((MultiShape)body.mShape).getShapeCount()) {
                            Contact contact = Collision.detectCollision(body, n4, this, n3);
                            if (contact != null) {
                                world.d = World.a(world.d, world.c);
                                world.d[world.c] = contact;
                                ++world.c;
                            }
                            ++n4;
                        }
                    } else {
                        Contact contact = Collision.detectCollision(body, this, n3);
                        if (contact != null) {
                            world.d = World.a(world.d, world.c);
                            world.d[world.c] = contact;
                            ++world.c;
                        }
                    }
                }
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void resetContacts() {
        var1_1 = 0;
        while (var1_1 < this.g) {
            if (this.h[var1_1] != null && !this.h[var1_1].g) {
                if (World.e < World.f.length) {
                    World.f[World.e++] = this.h[var1_1];
                    this.h[var1_1].g = true;
                }
                this.h[var1_1] = null;
            }
            ++var1_1;
        }
        var1_2 = this;
        var2_3 = this.g;
        var3_4 = 0;
        var4_5 = this.g - 1;
        ** GOTO lbl26
        {
            ++var3_4;
            do {
                if (var1_2.h[var3_4] != null && var3_4 < var4_5) continue block1;
                while (var1_2.h[var4_5] == null && var3_4 < var4_5) {
                    --var4_5;
                }
                if (var3_4 < var4_5) {
                    var1_2.h[var3_4] = var1_2.h[var4_5];
                    var1_2.h[var4_5] = null;
                    var2_3 = var4_5;
                }
                --var4_5;
lbl26:
                // 2 sources

            } while (var3_4 < var4_5);
        }
        while (var2_3 > 0 && var1_2.h[var2_3 - 1] == null) {
            --var2_3;
        }
        var1_2.g = var2_3;
    }

    protected void addContact(Contact contact) {
        this.h = World.a(this.h, this.g);
        this.h[this.g++] = contact;
    }

    public Contact[] getContacts() {
        return this.h;
    }

    public final void fillVertices(FXVector[] fXVectorArray, Contact contact, int n) {
        int n2 = contact.a == this.a ? contact.b : contact.d;
        fXVectorArray[0] = this.mStartpoints[n2];
        fXVectorArray[1] = this.mEndpoints[n2];
    }

    protected Contact getContact(Body body, int n, int n2) {
        int n3 = 0;
        while (n3 < this.g) {
            Contact contact = this.h[n3];
            if (contact != null && (contact.a == body && n == contact.b && n2 == contact.d || contact.c == body && n == contact.d && n2 == contact.b)) {
                return this.h[n3];
            }
            ++n3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void collideParticles(ParticleEmitter var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        ** GOTO lbl14
        {
            ++var2_2;
            do {
                if (var2_2 < var1_1.mMaxParticleCount && (var1_1.mLife[var2_2] <= 0 || this.mStartpoints[var3_3].xFX > var1_1.mXFX[var2_2] && this.mStartpoints[var3_3].xFX > var1_1.mXPrevFX[var2_2])) continue block0;
                var4_4 = var2_2;
                while (var4_4 < var1_1.mMaxParticleCount && (var1_1.mLife[var4_4] <= 0 || this.mEndpoints[var3_3].xFX > var1_1.mXFX[var4_4] || this.mEndpoints[var3_3].xFX > var1_1.mXPrevFX[var4_4])) {
                    if (var1_1.mLife[var4_4] > 0 && (var5_5 = Collision.detectCollision(this, var3_3, var1_1.mXFX[var4_4], var1_1.mYFX[var4_4], var1_1.mXPrevFX[var4_4], var1_1.mYPrevFX[var4_4])) != null) {
                        var1_1.collide(var5_5, var4_4);
                    }
                    ++var4_4;
                }
                ++var3_3;
lbl14:
                // 2 sources

            } while (var3_3 < this.mSegmentCount);
        }
    }

    public Body getBody() {
        return this.a;
    }

    public Shape getShape() {
        return this.b;
    }

    public int segmentCount() {
        return this.mSegmentCount;
    }

    public FXVector[] elementStartPoints() {
        return this.mStartpoints;
    }

    public FXVector[] elementEndPoints() {
        return this.mEndpoints;
    }

    public FXVector startPoint(int n) {
        return this.mStartpoints[n];
    }

    public FXVector endPoint(int n) {
        return this.mEndpoints[n];
    }
}

