/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class MultiShape
extends Shape {
    protected Shape[] mShapes;
    protected int[] mVertexStartIndices;
    protected int[] mAxesStartIndices;

    public MultiShape(Vector vector) {
        this.initShapeMembers(vector);
    }

    protected void initShapeMembers(Vector vector) {
        this.mShapes = new Shape[vector.size()];
        this.mVertexStartIndices = new int[vector.size() + 1];
        this.mAxesStartIndices = new int[vector.size() + 1];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            this.mShapes[n3] = (Shape)vector.elementAt(n3);
            this.mVertexStartIndices[n3] = n;
            n += this.mShapes[n3].mVertices.length;
            n2 += this.mShapes[n3].f;
            ++n3;
        }
        this.mVertexStartIndices[vector.size()] = n;
        this.mVertices = new FXVector[n];
        n3 = 0;
        n = 0;
        while (n < vector.size()) {
            int n4 = 0;
            while (n4 < this.mShapes[n].mVertices.length) {
                this.mVertices[n3++] = this.mShapes[n].mVertices[n4];
                ++n4;
            }
            ++n;
        }
        this.updateInternals();
        this.setMassFX(n2);
    }

    public MultiShape(MultiShape multiShape) {
        this.mVertices = new FXVector[multiShape.mVertices.length];
        System.arraycopy(multiShape.mVertices, 0, this.mVertices, 0, this.mVertices.length);
        this.mShapes = new Shape[multiShape.mShapes.length];
        System.arraycopy(multiShape.mShapes, 0, this.mShapes, 0, this.mShapes.length);
        this.mVertexStartIndices = new int[multiShape.mVertexStartIndices.length];
        System.arraycopy(multiShape.mVertexStartIndices, 0, this.mVertexStartIndices, 0, this.mVertexStartIndices.length);
        this.mAxesStartIndices = new int[multiShape.mAxesStartIndices.length];
        System.arraycopy(multiShape.mAxesStartIndices, 0, this.mAxesStartIndices, 0, this.mAxesStartIndices.length);
        this.setElasticityFX(multiShape.mElasticityFX);
        this.setFrictionFX(multiShape.mFrictionFX);
        this.updateInternals();
        this.setMassFX(multiShape.f);
        if (multiShape.mUserData != null) {
            this.mUserData = multiShape.mUserData.copy();
        }
    }

    public Shape getShape(int n) {
        return this.mShapes[n];
    }

    public int getShapeCount() {
        return this.mShapes.length;
    }

    final void a() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.mShapes.length) {
            n += this.mShapes[n2].b;
            ++n2;
        }
        this.b = n;
        this.a = new int[n];
        n2 = 0;
        n = 0;
        while (n < this.mShapes.length) {
            this.mAxesStartIndices[n] = n2 / 2;
            int n3 = 0;
            while (n3 < this.mShapes[n].b) {
                this.a[n2++] = this.mVertexStartIndices[n] + this.mShapes[n].a[n3];
                ++n3;
            }
            ++n;
        }
        this.mAxesStartIndices[this.mShapes.length] = n2 / 2;
    }

    final void b() {
        this.e = 0L;
        this.h = 0L;
        int n = 0;
        while (n < this.mShapes.length) {
            this.e += this.mShapes[n].e;
            this.h += this.mShapes[n].h;
            ++n;
        }
        this.i = this.h == 0L ? Integer.MAX_VALUE : 0x1000000000L / this.h;
    }

    public static MultiShape loadShape(PhysicsFileReader physicsFileReader, UserData userData, Vector vector) {
        physicsFileReader.getVersion();
        int n = physicsFileReader.next();
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(vector.elementAt(physicsFileReader.next()));
            ++n2;
        }
        MultiShape multiShape = new MultiShape(vector2);
        String string = physicsFileReader.nextString();
        if (userData != null) {
            multiShape.mUserData = userData.createNewUserData(string, 2);
        }
        return multiShape;
    }
}

