/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Random;

public class ParticleEmitter {
    private int b = 4096;
    private int c = 0;
    private int d;
    private int e;
    private int f = 0;
    private int g = 0;
    private int h = 0;
    protected int mMaxParticleCount = 0;
    private int i = 2048;
    private int j = 4096;
    private int k = 0;
    private Body l;
    private FXVector m;
    private FXVector n;
    private boolean o;
    private int p = 4096;
    private int q = 0;
    private int r = 0;
    private int s = 0;
    boolean a = true;
    protected int[] mXFX;
    protected int[] mYFX;
    protected int[] mXPrevFX;
    protected int[] mYPrevFX;
    protected short[] mLife;
    private Random t = new Random();
    private static FXMatrix u = new FXMatrix();
    private static FXVector v = new FXVector();
    private static FXVector w = new FXVector();
    protected UserData mUserData = null;

    private ParticleEmitter(int n) {
        this.setMaxParticleCount(n);
    }

    public ParticleEmitter(int n, int n2, int n3, int n4, int n5, Body body, FXVector fXVector, FXVector fXVector2, int n6, int n7, int n8, int n9, boolean bl, int n10, int n11, int n12, int n13) {
        this(n);
        this.b = n2;
        this.c = n3;
        this.d = (int)((long)n13 * (long)n2) >> 12;
        this.e = (int)((long)n13 * (long)n3) >> 12;
        this.g = n4;
        this.h = n5;
        this.d = (int)((long)n13 * (long)this.b) >> 12;
        this.e = (int)((long)n13 * (long)this.c) >> 12;
        this.l = body;
        this.m = fXVector;
        this.n = fXVector2;
        this.o = bl;
        this.p = n6;
        this.q = n7;
        this.r = n8;
        this.s = n9;
        this.i = n10;
        this.j = n11;
        this.k = n12;
    }

    public ParticleEmitter(ParticleEmitter particleEmitter) {
        this(particleEmitter.mMaxParticleCount);
        this.b = particleEmitter.b;
        this.d = particleEmitter.d;
        this.c = particleEmitter.c;
        this.e = particleEmitter.e;
        this.g = particleEmitter.g;
        this.h = particleEmitter.h;
        this.l = particleEmitter.l;
        this.m = particleEmitter.m;
        this.n = particleEmitter.n;
        this.o = particleEmitter.o;
        this.p = particleEmitter.p;
        this.q = particleEmitter.q;
        this.r = particleEmitter.r;
        this.s = particleEmitter.s;
        this.i = particleEmitter.i;
        this.j = particleEmitter.j;
        this.k = particleEmitter.k;
        if (particleEmitter.mUserData != null) {
            this.mUserData = particleEmitter.mUserData.copy();
        }
    }

    private ParticleEmitter() {
    }

    public ParticleEmitter copy(Body[] bodyArray) {
        ParticleEmitter particleEmitter = new ParticleEmitter(this);
        if (this.l != null) {
            particleEmitter.l = bodyArray == null ? this.l : bodyArray[this.l.mId];
        }
        return particleEmitter;
    }

    protected final void createParticle(int n, int n2) {
        long l = this.t.nextInt() & 0xFFF;
        if (this.l == null) {
            this.mXFX[n] = this.m.xFX + (int)(l * (long)(this.n.xFX - this.m.xFX) >> 12);
            this.mYFX[n] = this.m.yFX + (int)(l * (long)(this.n.yFX - this.m.yFX) >> 12);
        } else if (this.o) {
            this.mXFX[n] = this.l.mPositionFX.xFX + this.m.xFX + ((int)(l * (long)(this.n.xFX - this.m.xFX)) >> 12);
            this.mYFX[n] = this.l.mPositionFX.yFX + this.m.yFX + ((int)(l * (long)(this.n.yFX - this.m.yFX)) >> 12);
        } else {
            v.assignFX(this.m.xFX + (int)(l * (long)(this.n.xFX - this.m.xFX) >> 12), this.m.yFX + (int)(l * (long)(this.n.yFX - this.m.yFX) >> 12));
            this.l.getRotationMatrix().mult(v, w);
            this.mXFX[n] = ParticleEmitter.w.xFX + this.l.mPositionFX.xFX;
            this.mYFX[n] = ParticleEmitter.w.yFX + this.l.mPositionFX.yFX;
        }
        int n3 = (this.t.nextInt() & 0xFFF) - 2048;
        n3 = this.r + (int)((long)this.s * (long)n3 >> 12);
        if (!this.o && this.l != null) {
            n3 += this.l.mRotation2FX;
        }
        n3 = FXUtil.wrapAngleFX(n3);
        u.setRotationMatrix(n3);
        long l2 = (this.t.nextInt() & 0xFFF) - 2048;
        u.mult(this.p + (int)((long)this.q * l2 >> 12), 0, v);
        FXVector fXVector = v;
        if (this.l != null) {
            fXVector.xFX += this.l.mVelocityFX.xFX;
            fXVector.yFX += this.l.mVelocityFX.yFX;
        }
        fXVector.multFX(n2);
        this.mXPrevFX[n] = this.mXFX[n] - fXVector.xFX;
        this.mYPrevFX[n] = this.mYFX[n] - fXVector.yFX;
    }

    protected void createParticles(int n) {
        int n2 = this.a(0);
        while (this.f < this.d && n2 != -1) {
            int n3 = this.g + ((int)((long)((this.t.nextInt() & 0xFFF) - 2048) * (long)this.h) >> 12);
            this.mLife[n2] = (short)(FXUtil.divideFX(n3, n) >> 12);
            this.createParticle(n2, n);
            this.f += 4096;
            n2 = this.a(n2);
        }
        n = (this.t.nextInt() & 0xFFF) - 2048;
        this.f = Math.max(0, this.f - this.d - (int)((long)n * (long)this.e) >> 12);
    }

    private final int a(int n) {
        while (n < this.mMaxParticleCount) {
            if (this.mLife[n] <= 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void integrateParticles(int n) {
        int n2;
        int n3;
        this.createParticles(n);
        n = 4096 - this.k;
        int n4 = 0;
        while (n4 < this.mMaxParticleCount) {
            if (this.mLife[n4] > 0) {
                int[] nArray;
                n3 = this.mXFX[n4];
                n2 = this.mYFX[n4];
                if (n != 4096) {
                    nArray = this.mXFX;
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + ((int)((long)n * (long)(this.mXFX[n4] - this.mXPrevFX[n4])) >> 12);
                    nArray = this.mYFX;
                    int n6 = n4;
                    nArray[n6] = nArray[n6] + ((int)((long)n * (long)(this.mYFX[n4] - this.mYPrevFX[n4])) >> 12);
                } else {
                    nArray = this.mXFX;
                    int n7 = n4;
                    nArray[n7] = nArray[n7] + (this.mXFX[n4] - this.mXPrevFX[n4]);
                    nArray = this.mYFX;
                    int n8 = n4;
                    nArray[n8] = nArray[n8] + (this.mYFX[n4] - this.mYPrevFX[n4]);
                }
                this.mXPrevFX[n4] = n3;
                this.mYPrevFX[n4] = n2;
                int n9 = n4;
                this.mLife[n9] = (short)(this.mLife[n9] - 1);
            }
            ++n4;
        }
        ParticleEmitter particleEmitter = this;
        int n10 = 1;
        while (n10 < particleEmitter.mMaxParticleCount) {
            if (particleEmitter.mLife[n10] > 0) {
                n3 = particleEmitter.mXFX[n10];
                n2 = particleEmitter.mYFX[n10];
                short s = particleEmitter.mLife[n10];
                int n11 = particleEmitter.mXPrevFX[n10];
                int n12 = particleEmitter.mYPrevFX[n10];
                int n13 = n10 - 1;
                while (n13 >= 0 && (particleEmitter.mXFX[n13] > n3 || particleEmitter.mLife[n13] <= 0)) {
                    particleEmitter.mXFX[n13 + 1] = particleEmitter.mXFX[n13];
                    particleEmitter.mYFX[n13 + 1] = particleEmitter.mYFX[n13];
                    particleEmitter.mLife[n13 + 1] = particleEmitter.mLife[n13];
                    particleEmitter.mXPrevFX[n13 + 1] = particleEmitter.mXPrevFX[n13];
                    particleEmitter.mYPrevFX[n13 + 1] = particleEmitter.mYPrevFX[n13];
                    --n13;
                }
                particleEmitter.mXFX[n13 + 1] = n3;
                particleEmitter.mYFX[n13 + 1] = n2;
                particleEmitter.mLife[n13 + 1] = s;
                particleEmitter.mXPrevFX[n13 + 1] = n11;
                particleEmitter.mYPrevFX[n13 + 1] = n12;
            }
            ++n10;
        }
    }

    public void applyAcceleration(FXVector fXVector, int n) {
        n = (int)((long)n * (long)n * (long)this.j >> 24);
        int n2 = 0;
        while (n2 < this.mMaxParticleCount) {
            if (this.mLife[n2] > 0) {
                int[] nArray = this.mXFX;
                int n3 = n2;
                nArray[n3] = nArray[n3] + ((int)((long)n * (long)fXVector.xFX) >> 12);
                nArray = this.mYFX;
                int n4 = n2;
                nArray[n4] = nArray[n4] + ((int)((long)n * (long)fXVector.yFX) >> 12);
            }
            ++n2;
        }
    }

    protected void collide(FXVector fXVector, int n) {
        int[] nArray = this.mXFX;
        int n2 = n;
        nArray[n2] = nArray[n2] - fXVector.xFX;
        nArray = this.mYFX;
        int n3 = n;
        nArray[n3] = nArray[n3] - fXVector.yFX;
        nArray = this.mXPrevFX;
        int n4 = n;
        nArray[n4] = nArray[n4] - fXVector.xFX;
        nArray = this.mYPrevFX;
        int n5 = n;
        nArray[n5] = nArray[n5] - fXVector.yFX;
        fXVector.normalizeFast();
        w.assignFX(this.mXFX[n] - this.mXPrevFX[n], this.mYFX[n] - this.mYPrevFX[n]);
        v.assign(fXVector);
        v.multFX((long)ParticleEmitter.w.xFX * (long)fXVector.xFX + (long)ParticleEmitter.w.yFX * (long)fXVector.yFX >> 12);
        nArray = this.mXPrevFX;
        int n6 = n;
        nArray[n6] = nArray[n6] + ParticleEmitter.v.xFX;
        nArray = this.mYPrevFX;
        int n7 = n;
        nArray[n7] = nArray[n7] + ParticleEmitter.v.yFX;
        v.multFX(this.i);
        nArray = this.mXFX;
        int n8 = n;
        nArray[n8] = nArray[n8] - ParticleEmitter.v.xFX;
        nArray = this.mYFX;
        int n9 = n;
        nArray[n9] = nArray[n9] - ParticleEmitter.v.yFX;
    }

    public int getCreationRateFX() {
        return this.b;
    }

    public int getCreationRateDeviationFX() {
        return this.c;
    }

    public int getAvgLifeTimeFX() {
        return this.g;
    }

    public int getAvgLifeTimeDeviationFX() {
        return this.h;
    }

    public int getMaxParticleCount() {
        return this.mMaxParticleCount;
    }

    public int getElasticityFX() {
        return this.i;
    }

    public int getGravityEffectFX() {
        return this.j;
    }

    public Body getEmitter() {
        return this.l;
    }

    public FXVector getRelEmitterPos1() {
        return this.m;
    }

    public FXVector getRelEmitterPos2() {
        return this.n;
    }

    public boolean emitAxesFixed() {
        return this.o;
    }

    public int getEmitSpeedFX() {
        return this.p;
    }

    public int getEmitSpeedDeviationFX() {
        return this.q;
    }

    public int getEmitAngle2FX() {
        return this.r;
    }

    public int getEmitAngleDeviation2FX() {
        return this.s;
    }

    public int getDampingFX() {
        return this.k;
    }

    public boolean canCollide() {
        return this.a;
    }

    public void setCreationRateFX(int n, int n2, int n3) {
        this.b = n;
        this.d = (int)((long)n3 * (long)n) >> 12;
        this.c = n2;
        this.e = (int)((long)n3 * (long)n2) >> 12;
    }

    public void setAvgLifeTime(int n, int n2) {
        this.g = n;
        this.h = n2;
    }

    public void setElasticityFX(int n) {
        this.i = n;
    }

    public void setGravityEffectFX(int n) {
        this.j = n;
    }

    public void setEmitter(Body body) {
        this.l = body;
    }

    public void setRelEmitterPos1(FXVector fXVector) {
        this.m = fXVector;
    }

    public void setRelEmitterPos2(FXVector fXVector) {
        this.n = fXVector;
    }

    public void setEmitAxesFixed(boolean bl) {
        this.o = bl;
    }

    public void setEmitSpeedFX(int n, int n2) {
        this.p = n;
        this.q = n2;
    }

    public void setEmitAngle2FX(int n, int n2) {
        this.r = n;
        this.s = n2;
    }

    public void setMaxParticleCount(int n) {
        if (this.mMaxParticleCount != n) {
            this.mMaxParticleCount = n;
            this.mXFX = new int[n];
            this.mYFX = new int[n];
            this.mXPrevFX = new int[n];
            this.mYPrevFX = new int[n];
            this.mLife = new short[n];
        }
    }

    public void setDampingFX(int n) {
        this.k = n;
    }

    public void setCanCollide(boolean bl) {
        this.a = bl;
    }

    public int[] getXPosFX() {
        return this.mXFX;
    }

    public int[] getYPosFX() {
        return this.mYFX;
    }

    public int[] getXPrevPosFX() {
        return this.mXPrevFX;
    }

    public int[] getYPrevPosFX() {
        return this.mYPrevFX;
    }

    public short[] getLifeTimes() {
        return this.mLife;
    }

    public static ParticleEmitter loadParticleEmitter(PhysicsFileReader physicsFileReader, World world, UserData userData) {
        ParticleEmitter particleEmitter = new ParticleEmitter();
        new ParticleEmitter().l = world.findBodyById(physicsFileReader.next());
        particleEmitter.o = physicsFileReader.next() != 0;
        particleEmitter.m = physicsFileReader.nextVector();
        particleEmitter.n = physicsFileReader.nextVector();
        particleEmitter.setEmitAngle2FX(physicsFileReader.nextIntFX(), physicsFileReader.nextIntFX());
        particleEmitter.setEmitSpeedFX(physicsFileReader.nextIntFX(), physicsFileReader.nextIntFX());
        particleEmitter.setCreationRateFX(physicsFileReader.nextIntFX(), physicsFileReader.nextIntFX(), world.getTimestepFX());
        particleEmitter.setAvgLifeTime(physicsFileReader.nextIntFX(), physicsFileReader.nextIntFX());
        particleEmitter.setMaxParticleCount(physicsFileReader.nextInt());
        particleEmitter.setElasticityFX(physicsFileReader.nextIntFX());
        particleEmitter.setGravityEffectFX(physicsFileReader.nextIntFX());
        particleEmitter.setDampingFX(physicsFileReader.nextIntFX());
        if (physicsFileReader.getVersion() > 1792) {
            String string = physicsFileReader.nextString();
            if (userData != null) {
                particleEmitter.mUserData = userData.createNewUserData(string, 5);
            }
        }
        return particleEmitter;
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

