/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Spring
implements Constraint {
    private Body a;
    private Body b;
    private FXVector c;
    private FXVector d;
    private int e;
    protected int mCoefficientFX = 0;
    protected UserData mUserData = null;
    private long f;
    private long g;
    private FXVector h = new FXVector();
    private int i;
    private FXVector j = new FXVector();
    private FXVector k = new FXVector();
    private long l;
    private int m = 0;
    private static FXVector n = new FXVector();
    private static FXVector o = new FXVector();
    private static FXVector p = new FXVector();

    public Spring(Body body, Body body2, FXVector fXVector, FXVector fXVector2, int n) {
        this.a = body;
        this.b = body2;
        this.c = fXVector;
        this.d = fXVector2;
        if (n < 0) {
            this.calcDistance();
        } else {
            this.e = n << 12;
        }
    }

    protected Spring(Spring spring, Body[] bodyArray) {
        if (bodyArray == null) {
            this.a = spring.a;
            this.b = spring.b;
        } else {
            this.a = bodyArray[spring.a.mId];
            this.b = bodyArray[spring.b.mId];
        }
        this.c = new FXVector(spring.c);
        this.d = new FXVector(spring.d);
        this.e = spring.e;
        this.mCoefficientFX = spring.mCoefficientFX;
        if (spring.mUserData != null) {
            this.mUserData = spring.mUserData.copy();
        }
    }

    public Constraint copy(Body[] bodyArray) {
        return new Spring(this, bodyArray);
    }

    private Spring() {
    }

    public static Spring loadSpring(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        Spring spring = new Spring();
        new Spring().a = (Body)vector.elementAt(physicsFileReader.next());
        spring.c = physicsFileReader.nextVector();
        spring.b = (Body)vector.elementAt(physicsFileReader.next());
        spring.d = physicsFileReader.nextVector();
        spring.e = physicsFileReader.nextIntFX();
        spring.mCoefficientFX = physicsFileReader.nextIntFX();
        if (physicsFileReader.getVersion() > 1792) {
            String string = physicsFileReader.nextString();
            if (userData != null) {
                spring.mUserData = userData.createNewUserData(string, 4);
            }
        }
        return spring;
    }

    protected void calcDistance() {
        if (this.a != null && this.b != null) {
            this.a.getAbsoluePoint(this.c, o);
            this.b.getAbsoluePoint(this.d, p);
            FXVector fXVector = new FXVector(p);
            fXVector.subtract(o);
            this.e = fXVector.lengthFX();
        }
    }

    public void setCoefficient(int n) {
        this.mCoefficientFX = n * 4096;
    }

    public void setCoefficientFX(int n) {
        this.mCoefficientFX = n;
    }

    public int getCoefficientFX() {
        return this.mCoefficientFX;
    }

    public void setCollisionLayer(int n) {
        this.a.addCollisionLayer(n);
        this.b.addCollisionLayer(n);
    }

    public FXVector getPoint1() {
        return this.a.getAbsoluePoint(this.c);
    }

    public void getPoint1(FXVector fXVector) {
        this.a.getAbsoluePoint(this.c, fXVector);
    }

    public FXVector getPoint2() {
        return this.b.getAbsoluePoint(this.d);
    }

    public void getPoint2(FXVector fXVector) {
        this.b.getAbsoluePoint(this.d, fXVector);
    }

    public FXVector getRawPoint1() {
        return this.c;
    }

    public FXVector getRawPoint2() {
        return this.d;
    }

    public Body getBody1() {
        return this.a;
    }

    public Body getBody2() {
        return this.b;
    }

    public void precalculate(long l) {
        this.a.getAbsoluePoint(this.c, o);
        this.b.getAbsoluePoint(this.d, p);
        this.h.assignDiff(p, o);
        this.i = this.h.lengthFX();
        if (this.i != 0) {
            this.a.getRotationMatrix().mult(this.c, this.j);
            this.b.getRotationMatrix().mult(this.d, this.k);
            this.h.divideByFX(this.i);
            this.f = -((long)this.h.xFX * (long)this.j.yFX - (long)this.h.yFX * (long)this.j.xFX >> 12);
            this.g = -((long)this.h.xFX * (long)this.k.yFX - (long)this.h.yFX * (long)this.k.xFX >> 12);
            int n = (int)(this.a.getInvInertia2FX() * (this.f * this.f >> 12) >> 12);
            int n2 = (int)(this.b.getInvInertia2FX() * (this.g * this.g >> 12) >> 12);
            this.l = this.a.getInvMass2FX() + (long)n + this.b.getInvMass2FX() + (long)n2;
            if (this.mCoefficientFX > 0) {
                int n3 = -((int)(((long)this.mCoefficientFX * (long)(this.e - this.i) << 12) / l >> 12));
                Spring.n.xFX = this.h.xFX;
                Spring.n.yFX = this.h.yFX;
                Spring.n.multFX(n3);
                this.a.applyMomentumAt(Spring.n, this.j);
                Spring.n.mult(-1);
                this.b.applyMomentumAt(Spring.n, this.k);
            }
        }
    }

    public boolean applyMomentum(long l) {
        if (this.mCoefficientFX <= 0 && this.l != 0L) {
            int n = -((int)((((long)this.a.mVelocityFX.xFX * (long)this.h.xFX + (long)this.a.mVelocityFX.yFX * (long)this.h.yFX >> 12) - ((long)this.a.mAngularVelocity2FX * this.f >> 24) - ((long)this.b.mVelocityFX.xFX * (long)this.h.xFX + (long)this.b.mVelocityFX.yFX * (long)this.h.yFX >> 12) + ((long)this.b.mAngularVelocity2FX * this.g >> 24) + ((1024L * (long)(this.e - this.i) >> 12) * l >> 12) << 24) / this.l));
            Spring.n.xFX = this.h.xFX;
            Spring.n.yFX = this.h.yFX;
            Spring.n.multFX(n);
            this.a.applyMomentumAt(Spring.n, this.j);
            Spring.n.mult(-1);
            this.b.applyMomentumAt(Spring.n, this.k);
            this.m += n;
            return Math.abs(n) < 16;
        }
        return true;
    }

    public void postStep() {
    }

    public int getDistance() {
        return this.e >> 12;
    }

    public int getDistanceFX() {
        return this.e;
    }

    public void setDistanceFX(int n) {
        if (n < 0) {
            this.calcDistance();
        } else {
            this.e = n;
        }
    }

    public int getImpulseFX() {
        return this.m;
    }

    public boolean concernsBody(Body body) {
        return this.a == body || this.b == body;
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Spring && ((Spring)constraint).a.equals(this.a) && ((Spring)constraint).b.equals(this.b) && ((Spring)constraint).c.xFX == this.c.xFX && ((Spring)constraint).c.yFX == this.c.yFX && ((Spring)constraint).d.xFX == this.d.xFX && ((Spring)constraint).d.yFX == this.d.yFX;
    }

    protected void setBody1(Body body) {
        this.a = body;
    }

    protected void setBody2(Body body) {
        this.b = body;
    }

    protected void setAbsolutePoint1(FXVector fXVector) {
        this.c = this.a.getRelativePoint(fXVector);
    }

    protected void setAbsolutePoint2(FXVector fXVector) {
        this.d = this.b.getRelativePoint(fXVector);
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

