/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.EventSet;
import at.emini.physics2D.ExternalForce;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Motor;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class World {
    private PhysicsEventListener q;
    private FXVector r = new FXVector(0, 409600);
    private int s = 0;
    private int t = 0;
    private int u = 204;
    private long v = 0x1000000 / this.u;
    private int w = 10;
    private int x = 5;
    private boolean y = false;
    public static final int M_SHAPE_MAX_VERTICES = 12;
    protected ShapeSet mShapeSet = new ShapeSet();
    protected EventSet mEventSet = new EventSet();
    private Body[] z = new Body[128];
    private int A = Integer.MIN_VALUE;
    private int B = Integer.MAX_VALUE;
    int a = 0;
    Body[] b = new Body[128];
    private int C = 0;
    private int D = 0;
    private int E = this.a;
    private Landscape F = new Landscape();
    int c = 0;
    Contact[] d = new Contact[128];
    static int e = 0;
    static Contact[] f = new Contact[32];
    int g = 0;
    Constraint[] h = new Constraint[32];
    protected Vector mParticles = new Vector();
    protected Vector mForces = new Vector();
    Script[] i = new Script[32];
    int j = 0;
    Body[] k = new Body[32];
    int[] l = new int[32];
    int[] m = new int[32];
    int[] n = new int[32];
    int o = 0;
    static int p = 0;
    protected UserData mUserData = null;

    public World() {
    }

    protected World(ShapeSet shapeSet) {
        this.mShapeSet = shapeSet;
    }

    public World(World world) {
        if (world != null) {
            this.mShapeSet = world.mShapeSet.copy();
            this.r.assign(world.r);
            this.s = world.s;
            this.t = world.t;
            this.A = world.A;
            this.B = world.B;
            this.u = world.u;
            this.v = world.v;
            this.w = world.w;
            this.x = world.x;
            this.addWorld(world);
            this.mEventSet = world.mEventSet.copy();
            if (world.F != null) {
                this.setLandscape(world.F.copy());
            }
            if (world.mUserData != null) {
                this.mUserData = world.mUserData.copy();
            }
        }
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader) {
        return World.loadWorld(physicsFileReader, null);
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader, UserData userData) {
        int n = physicsFileReader.getVersion();
        if ((n & 0xFF00) >= 256 && (n & 0xFF00) <= 2560) {
            World world = new World();
            Vector<Shape> vector = new Vector<Shape>();
            Vector<Body> vector2 = new Vector<Body>();
            int n2 = 0;
            while (n2 != -1) {
                switch (n2) {
                    case 1: {
                        int n3;
                        int n4 = physicsFileReader.next();
                        int n5 = 0;
                        while (n5 < n4) {
                            vector.addElement(Shape.loadShape(physicsFileReader, userData));
                            ++n5;
                        }
                        if (n > 2048) {
                            n5 = physicsFileReader.next();
                            n3 = 0;
                            while (n3 < n5) {
                                vector.addElement(MultiShape.loadShape(physicsFileReader, userData, vector));
                                ++n3;
                            }
                        }
                        world.mShapeSet.registerShapes(vector);
                        break;
                    }
                    case 2: {
                        Object object;
                        int n5;
                        int n4 = physicsFileReader.next();
                        for (n5 = 0; n5 < n4; ++n5) {
                            object = Body.loadBody(physicsFileReader, vector, userData);
                            vector2.addElement((Body)object);
                            world.addBody((Body)object);
                        }
                        break;
                    }
                    case 3: {
                        int n5;
                        int n4 = physicsFileReader.next();
                        for (n5 = 0; n5 < n4; ++n5) {
                            world.addConstraint(World.loadConstraint(physicsFileReader, vector2, userData));
                        }
                        break;
                    }
                    case 4: {
                        int n3;
                        int n4 = physicsFileReader.next();
                        int n5 = 0;
                        while (n5 < n4) {
                            world.addScript(Script.loadScript(physicsFileReader));
                            ++n5;
                        }
                        world.o = physicsFileReader.next();
                        for (n5 = 0; n5 < world.o; ++n5) {
                            n3 = physicsFileReader.next();
                            int n6 = physicsFileReader.next();
                            if (n6 < 0 || n6 >= vector2.size() || n3 >= n4) continue;
                            world.l[n5] = physicsFileReader.next();
                            world.k[n5] = (Body)vector2.elementAt(physicsFileReader.next());
                        }
                        break;
                    }
                    case 5: {
                        int n5;
                        int n4 = physicsFileReader.next();
                        for (n5 = 0; n5 < n4; ++n5) {
                            world.addEvent(Event.loadEvent(physicsFileReader, world, userData));
                        }
                        break;
                    }
                    case 6: {
                        world.setLandscape(Landscape.loadLandscape(physicsFileReader));
                        break;
                    }
                    case 7: {
                        int n4;
                        world.setGravity(physicsFileReader.nextVector());
                        if (physicsFileReader.getVersion() > 2304) {
                            world.setDampingLateralFX(physicsFileReader.nextInt());
                            world.setDampingRotationalFX(physicsFileReader.nextInt());
                        } else {
                            n4 = 4096 - physicsFileReader.nextInt();
                            world.setDampingLateralFX(n4);
                            world.setDampingRotationalFX(n4);
                        }
                        if (physicsFileReader.getVersion() <= 1792) break;
                        Object object = physicsFileReader.nextString();
                        if (userData == null) break;
                        world.mUserData = userData.createNewUserData((String)object, 6);
                        break;
                    }
                    case 8: {
                        int n4 = physicsFileReader.next();
                        int n5 = 0;
                        while (n5 < n4) {
                            world.addParticleEmitter(ParticleEmitter.loadParticleEmitter(physicsFileReader, world, userData));
                            ++n5;
                        }
                        break;
                    }
                }
                if ((n & 0xFF00) == 256) {
                    if (++n2 == 4) {
                        ++n2;
                    }
                    if (n2 <= 5) continue;
                    break;
                }
                n2 = physicsFileReader.next();
            }
            physicsFileReader.close();
            return world;
        }
        return null;
    }

    public int getTimestepFX() {
        return this.u;
    }

    public long getInverseTimestepFX() {
        return this.v;
    }

    public void setTimestepFX(int n) {
        this.u = n;
        this.v = 0x1000000 / this.u;
    }

    public void setConstraintIterations(int n) {
        this.w = n;
    }

    public void setPositionConstraintIterations(int n) {
        this.x = n;
    }

    public int getConstraintIterations() {
        return this.w;
    }

    public int getPositionConstraintIterations() {
        return this.x;
    }

    public void setConstraintIterationDynamic(boolean bl) {
        this.y = bl;
    }

    public void setPhysicsEventListener(PhysicsEventListener physicsEventListener) {
        this.q = physicsEventListener;
    }

    public void setSimulationArea(int n, int n2) {
        this.A = n << 12;
        this.B = n2 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.mShapeSet;
    }

    public Body[] addWorld(World world) {
        Body body;
        Body[] bodyArray = new Body[world.C];
        int n = 0;
        while (n < world.a) {
            body = world.b[n].copy();
            this.addBody(body);
            body.calculateAABB(0);
            bodyArray[world.b[n].mId] = body;
            ++n;
        }
        n = 0;
        while (n < world.g) {
            this.addConstraint(world.h[n].copy(bodyArray));
            ++n;
        }
        n = 0;
        while (n < world.j) {
            this.addScript(world.i[n].copy());
            ++n;
        }
        n = 0;
        while (n < world.o) {
            body = bodyArray[world.k[n].mId];
            this.i[world.l[n]].applyToBody(body, this);
            this.m[n] = world.m[n];
            this.n[n] = world.n[n];
            ++n;
        }
        n = 0;
        while (n < world.mParticles.size()) {
            this.addParticleEmitter(((ParticleEmitter)world.mParticles.elementAt(n)).copy(bodyArray));
            ++n;
        }
        n = 0;
        while (n < world.mForces.size()) {
            this.addExternalForce(((ExternalForce)world.mForces.elementAt(n)).copy(bodyArray));
            ++n;
        }
        Vector vector = world.mEventSet.getEvents();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            this.addEvent(((Event)vector.elementAt(n3)).copy(bodyArray));
            ++n3;
        }
        Landscape landscape = world.getLandscape();
        int n4 = 0;
        while (n4 < landscape.mSegmentCount) {
            this.F.addSegment(new FXVector(landscape.mStartpoints[n4]), new FXVector(landscape.mEndpoints[n4]), landscape.mFaces[n4]);
            ++n4;
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.mId = this.C++;
            this.b = World.a(this.b, this.a);
            this.b[this.a++] = body;
            this.mShapeSet.registerShape(body.mShape);
            this.a();
            body.forceUpdate(this.u);
        }
    }

    public void setLandscape(Landscape landscape) {
        this.F = landscape;
    }

    public Landscape getLandscape() {
        return this.F;
    }

    public void addParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.mParticles.addElement(particleEmitter);
        }
    }

    public void addExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.mForces.addElement(externalForce);
        }
    }

    public void removeBody(Body body) {
        if (body.mId >= 0) {
            int n = 0;
            while (n < this.a) {
                if (this.b[n] == body) {
                    this.b[n] = null;
                    break;
                }
                ++n;
            }
            this.a = World.a((Object[])this.b, this.a);
            this.a();
            n = 0;
            while (n < this.o) {
                if (this.k[n] == body) {
                    this.m[n] = -1;
                    this.n[n] = -1;
                    this.l[n] = -1;
                    this.k[n] = null;
                    World.b(this.m, this.o);
                    World.b(this.n, this.o);
                    World.b(this.l, this.o);
                    this.o = World.a((Object[])this.k, this.o);
                }
                ++n;
            }
            n = this.g;
            int n2 = 0;
            while (n2 < n) {
                if (this.h[n2].concernsBody(body)) {
                    this.h[n2] = null;
                }
                ++n2;
            }
            this.g = World.a(this.h, this.g);
            n = this.mParticles.size() - 1;
            while (n >= 0) {
                if (((ParticleEmitter)this.mParticles.elementAt(n)).getEmitter() == body) {
                    this.mParticles.removeElementAt(n);
                }
                --n;
            }
            n = this.c;
            n2 = 0;
            while (n2 < n) {
                if (this.d[n2].concernsBody(body)) {
                    this.d[n2] = null;
                }
                ++n2;
            }
            this.c = World.a((Object[])this.d, this.c);
        }
    }

    public void removeConstraint(Constraint constraint) {
        int n = this.g;
        int n2 = 0;
        while (n2 < n) {
            if (this.h[n2] == constraint) {
                this.h[n2] = null;
            }
            ++n2;
        }
        this.g = World.a(this.h, this.g);
    }

    public void removeScript(Script script) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.j) {
            if (this.i[n2] == script) {
                this.i[n2] = null;
                n = n2;
                --this.j;
                for (int i = n2; i < this.j; ++i) {
                    this.i[i] = this.i[i + 1];
                }
                break;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.o) {
            if (this.m[n2] == n) {
                this.m[n2] = -1;
                this.n[n2] = -1;
                this.l[n2] = -1;
                this.k[n2] = null;
                World.b(this.m, this.o);
                World.b(this.n, this.o);
                World.b(this.l, this.o);
                this.o = World.a((Object[])this.k, this.o);
                return;
            }
            ++n2;
        }
    }

    public void removeEvent(Event event) {
        this.mEventSet.removeEvent(event);
    }

    public void removeParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.mParticles.removeElement(particleEmitter);
        }
    }

    public void removeExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.mForces.removeElement(externalForce);
        }
    }

    static final int[] a(int[] nArray, int n) {
        if (nArray.length <= n) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n) {
        if (sArray.length <= n) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n) {
        if (bodyArray.length <= n) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n) {
        if (contactArray.length <= n) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n) {
        if (fXVectorArray.length <= n) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n) {
        return (n = this.bodyIndexOf(n)) < 0 ? null : this.b[n];
    }

    protected Body findBody(Body body) {
        if (body == null) {
            return null;
        }
        int n = this.bodyIndexOf(body.mId);
        return n < 0 ? null : this.b[n];
    }

    public Body findBodyAt(int n, int n2) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        int n3 = 0;
        while (n3 < this.getBodyCount()) {
            Body body = bodyArray[n3];
            fXVector.assignFX(n, n2);
            if (n >= body.getAABBMinXFX() && n <= body.getAABBMaxXFX() && n2 >= body.getAABBMinYFX() && n2 <= body.getAABBMaxYFX()) {
                FXVector[] fXVectorArray = body.getAxes();
                FXVector[] fXVectorArray2 = body.getVertices();
                boolean bl = true;
                int n4 = 0;
                while (n4 < fXVectorArray.length) {
                    long l;
                    long l2 = (long)fXVector.xFX * (long)fXVectorArray[n4].xFX + (long)fXVector.yFX * (long)fXVectorArray[n4].yFX >> 12;
                    long l3 = l = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[n4].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[n4].yFX >> 12;
                    int n5 = 1;
                    while (n5 < fXVectorArray2.length) {
                        long l4 = (long)fXVectorArray2[n5].xFX * (long)fXVectorArray[n4].xFX + (long)fXVectorArray2[n5].yFX * (long)fXVectorArray[n4].yFX >> 12;
                        if (l > l4) {
                            l = l4;
                        }
                        if (l3 < l4) {
                            l3 = l4;
                        }
                        ++n5;
                    }
                    if (l > l2 || l3 < l2) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    return body;
                }
            }
            ++n3;
        }
        return null;
    }

    public int bodyIndexOf(int n) {
        int n2 = 0;
        while (n2 < this.a) {
            if (this.b[n2].mId == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected Constraint findConstraint(Constraint constraint) {
        int n = this.indexOf(constraint);
        return n < 0 ? null : this.h[n];
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        int n = 0;
        while (n < this.g) {
            if (this.h[n].equals(constraint)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray = this.h;
            if (constraintArray.length <= this.g) {
                Constraint[] constraintArray2 = new Constraint[constraintArray.length + 32];
                System.arraycopy(constraintArray, 0, constraintArray2, 0, constraintArray.length);
                this.h = constraintArray2;
            }
            this.h[this.g++] = constraint;
        }
    }

    public void addScript(Script script) {
        if (script != null) {
            Script[] scriptArray = this.i;
            if (scriptArray.length <= this.j) {
                Script[] scriptArray2 = new Script[scriptArray.length + 32];
                System.arraycopy(scriptArray, 0, scriptArray2, 0, scriptArray.length);
                this.i = scriptArray2;
            }
            this.i[this.j++] = script;
        }
    }

    protected void addScriptBody(int n, Body body) {
        this.l[this.o] = n;
        this.k[this.o++] = body;
    }

    public void addEvent(Event event) {
        this.mEventSet.registerEvent(event);
    }

    public void setGravity(int n) {
        this.r = new FXVector(0, n << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.r = fXVector;
    }

    public void setDampingLateralFX(int n) {
        this.s = n;
    }

    public void setDampingRotationalFX(int n) {
        this.t = n;
    }

    public void tick() {
        int n;
        Body[] bodyArray = this.b;
        Constraint[] constraintArray = this.h;
        int n2 = 0;
        while (n2 < this.o) {
            if (this.k[n2] != null) {
                this.i[this.l[n2]].executeScript(n2, this);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.mForces.size()) {
            ((ExternalForce)this.mForces.elementAt(n2)).applyForce(bodyArray, this.a, this.u);
            ++n2;
        }
        n2 = this.D;
        while (n2 < this.E) {
            Body body = bodyArray[n2];
            if (body.a && body.c) {
                body.applyAcceleration(this.r, this.u);
            }
            body.calculateAABB(this.u);
            ++n2;
        }
        this.checkCollisions();
        Contact.a(this.d, this.c);
        Contact.a(this.d, this.c, this.F);
        n2 = 0;
        while (n2 < this.mParticles.size()) {
            ((ParticleEmitter)this.mParticles.elementAt(n2)).applyAcceleration(this.r, this.u);
            ++n2;
        }
        this.collideParticles();
        n2 = 0;
        while (n2 < this.c) {
            this.d[n2].precalculate(this.v);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.g) {
            constraintArray[n2].precalculate(this.v);
            ++n2;
        }
        boolean bl = false;
        p = 0;
        while (!(p >= this.w || bl && this.y)) {
            bl = true;
            n = 0;
            while (n < this.g) {
                bl &= constraintArray[n].applyMomentum(this.v);
                ++n;
            }
            n = 0;
            while (n < this.c) {
                bl &= this.d[n].applyMomentum();
                ++n;
            }
            ++p;
        }
        n = 0;
        while (n < this.g) {
            constraintArray[n].postStep();
            ++n;
        }
        n = 4096 - this.s;
        int n3 = 4096 - this.t;
        int n4 = this.D;
        while (n4 < this.E) {
            bodyArray[n4].integrateVelocity(this.u);
            bodyArray[n4].updateVelocity(n, n3);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.c) {
            this.d[n4].precalculatePositionCorrection(this.u, this.v);
            ++n4;
        }
        long l = 0L;
        p = 0;
        while (p < this.x) {
            n3 = 0;
            while (n3 < this.c) {
                long l2 = this.d[n3].applyMomentumPositionCorrectionFX();
                l = l < l2 ? l2 : l;
                ++n3;
            }
            if (l < 32L) break;
            ++p;
        }
        n3 = this.D;
        while (n3 < this.E) {
            bodyArray[n3].integrateVirtualVelocity(this.u, this.r);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.mParticles.size()) {
            ((ParticleEmitter)this.mParticles.elementAt(n3)).integrateParticles(this.u);
            ++n3;
        }
        if (this.q != null) {
            this.mEventSet.checkEvents(this, this.q);
        }
    }

    protected void checkCollisions() {
        int n = 0;
        while (n < this.c) {
            this.d[n] = null;
            ++n;
        }
        this.c = 0;
        this.a();
        n = 0;
        int n2 = 0;
        int n3 = this.D;
        while (n3 < this.E) {
            this.F.initCollision();
            int n4 = this.b[n3].e;
            this.F.collisionCheckBody(this, this.b[n3]);
            int n5 = 0;
            while (n5 < n2) {
                if (this.z[n5] != null) {
                    if (this.z[n5].f < n4) {
                        --n;
                        this.z[n5] = null;
                    } else if (this.b[n3].g <= this.z[n5].h && this.z[n5].g <= this.b[n3].h) {
                        Body body = this.b[n3];
                        Body body2 = this.z[n5];
                        Body body3 = body;
                        World world = this;
                        if ((body3.a || body2.a) && (body3.i & body2.i) == 0 && body3.b && body2.b) {
                            if (!(body3.mShape instanceof MultiShape) && !(body2.mShape instanceof MultiShape)) {
                                Contact contact = Collision.detectCollision(body3, body2);
                                if (contact != null) {
                                    this.d = World.a(this.d, this.c);
                                    this.d[this.c] = contact;
                                    ++this.c;
                                }
                            } else {
                                int n6 = 1;
                                int n7 = 1;
                                if (body3.mShape instanceof MultiShape) {
                                    n6 = ((MultiShape)body3.mShape).getShapeCount();
                                }
                                if (body2.mShape instanceof MultiShape) {
                                    n7 = ((MultiShape)body2.mShape).getShapeCount();
                                }
                                int n8 = 0;
                                while (n8 < n6) {
                                    int n9 = 0;
                                    while (n9 < n7) {
                                        Contact contact = Collision.detectCollision(body3, n8, body2, n9);
                                        if (contact != null) {
                                            world.d = World.a(world.d, world.c);
                                            world.d[world.c] = contact;
                                            ++world.c;
                                        }
                                        ++n9;
                                    }
                                    ++n8;
                                }
                            }
                        }
                    }
                }
                ++n5;
            }
            this.z = World.a(this.z, n2);
            this.z[n2++] = this.b[n3];
            if (n2 > ++n << 1) {
                n2 = World.a((Object[])this.z, n2);
            }
            ++n3;
        }
        this.F.resetContacts();
        n3 = this.D;
        while (n3 < this.E) {
            this.b[n3].resetContacts();
            ++n3;
        }
        this.F.getBody();
        n3 = 0;
        while (n3 < this.c) {
            Contact contact = this.d[n3];
            contact.g = false;
            contact.a.addContact(contact);
            contact.c.addContact(contact);
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void collideParticles() {
        var1_1 = 0;
        while (var1_1 < this.mParticles.size()) {
            block5: {
                var2_2 = (ParticleEmitter)this.mParticles.elementAt(var1_1);
                if (!var2_2.a) break block5;
                var3_3 = 0;
                var4_4 = this.D;
                ** GOTO lbl18
                {
                    ++var3_3;
                    do {
                        if (var3_3 < var2_2.mMaxParticleCount && (var2_2.mLife[var3_3] <= 0 || this.b[var4_4].e > var2_2.mXFX[var3_3])) continue block1;
                        var5_5 = var3_3;
                        while (var5_5 < var2_2.mMaxParticleCount && (var2_2.mLife[var5_5] <= 0 || this.b[var4_4].f > var2_2.mXFX[var5_5])) {
                            if (var2_2.mLife[var5_5] > 0 && this.b[var4_4].g < var2_2.mYFX[var5_5] && this.b[var4_4].h > var2_2.mYFX[var5_5] && this.b[var4_4].b && (var6_6 = Collision.detectCollision(this.b[var4_4], var2_2.mXFX[var5_5], var2_2.mYFX[var5_5])) != null) {
                                var2_2.collide(var6_6, var5_5);
                            }
                            ++var5_5;
                        }
                        ++var4_4;
lbl18:
                        // 2 sources

                    } while (var4_4 < this.E);
                }
                this.F.collideParticles(var2_2);
            }
            ++var1_1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int a(Object[] var0, int var1_1) {
        var2_2 = var1_1--;
        var3_3 = 0;
        ** GOTO lbl16
        {
            ++var3_3;
            do {
                if (var0[var3_3] != null && var3_3 < var1_1) continue block0;
                while (var0[var1_1] == null && var3_3 < var1_1) {
                    --var1_1;
                }
                if (var3_3 < var1_1) {
                    var0[var3_3] = var0[var1_1];
                    var0[var1_1] = null;
                }
                if (var0[var1_1] == null) {
                    var2_2 = var1_1;
                }
                --var1_1;
lbl16:
                // 2 sources

            } while (var3_3 < var1_1);
        }
        while (var2_2 > 0 && var0[var2_2 - 1] == null) {
            --var2_2;
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    static final int b(int[] var0, int var1_1) {
        var2_2 = var1_1--;
        var3_3 = 0;
        ** GOTO lbl15
        {
            ++var3_3;
            do {
                if (var0[var3_3] != -1 && var3_3 < var1_1) continue block0;
                while (var0[var1_1] == -1 && var3_3 < var1_1) {
                    --var1_1;
                }
                if (var3_3 < var1_1) {
                    var0[var3_3] = var0[var1_1];
                    var0[var1_1] = -1;
                    var2_2 = var1_1;
                }
                --var1_1;
lbl15:
                // 2 sources

            } while (var3_3 < var1_1);
        }
        return var2_2;
    }

    private final void a() {
        int n = 1;
        while (n < this.a) {
            Body body = this.b[n];
            int n2 = n - 1;
            while (n2 >= 0 && this.b[n2].e > body.e) {
                this.b[n2 + 1] = this.b[n2];
                --n2;
            }
            this.b[n2 + 1] = body;
            ++n;
        }
        this.D = -1;
        this.E = this.a;
        n = 0;
        while (n < this.a) {
            if (this.D < 0 && this.b[n].f > this.A) {
                this.D = n;
            }
            if (this.b[n].e < this.B) {
                this.E = n + 1;
            }
            ++n;
        }
        if (this.D < 0) {
            this.D = 0;
        }
    }

    public FXVector getGravity() {
        return this.r;
    }

    public int getDampingLateralFX() {
        return this.s;
    }

    public int getDampingRotationalFX() {
        return this.t;
    }

    public static Constraint loadConstraint(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        switch (physicsFileReader.next()) {
            case 0: {
                return Joint.loadJoint(physicsFileReader, vector, userData);
            }
            case 1: {
                return Spring.loadSpring(physicsFileReader, vector, userData);
            }
            default: {
                return null;
            }
            case 3: 
        }
        return Motor.loadMotor(physicsFileReader, vector, userData);
    }

    public Vector getEvents() {
        return this.mEventSet.getEvents();
    }

    public Vector getParticleEmitters() {
        return this.mParticles;
    }

    protected int getAreaStartFX() {
        return this.A;
    }

    protected int getAreaEndFX() {
        return this.B;
    }

    public int getBodyCount() {
        return this.a;
    }

    public Body[] getBodies() {
        return this.b;
    }

    public int getBodyStartIndex() {
        return this.D;
    }

    public int getBodyEndIndex() {
        return this.E;
    }

    public int getConstraintCount() {
        return this.g;
    }

    public Constraint[] getConstraints() {
        return this.h;
    }

    public int getContactCount() {
        return this.c;
    }

    public Contact[] getContacts() {
        return this.d;
    }

    public int getScriptCount() {
        return this.j;
    }

    public Script[] getScripts() {
        return this.i;
    }

    public Script getScript(int n) {
        return this.i[n];
    }

    protected int getScriptBodyCount() {
        return this.o;
    }

    protected Body[] getScriptBodies() {
        return this.k;
    }

    protected int[] getScriptIndices() {
        return this.l;
    }

    public Contact[] getContactsForBody(Body body) {
        Contact[] contactArray = new Contact[8];
        int n = 0;
        Contact[] contactArray2 = body.getContacts();
        int n2 = 0;
        while (n2 < contactArray2.length && contactArray2[n2] != null) {
            contactArray[n++] = contactArray2[n2];
            ++n2;
        }
        return contactArray;
    }

    public void translate(FXVector fXVector) {
        int n = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        int n2 = 0;
        while (n2 < n) {
            FXVector fXVector2 = bodyArray[n2].positionFX();
            fXVector2.xFX += fXVector.xFX;
            fXVector2 = bodyArray[n2].positionFX();
            fXVector2.yFX += fXVector.yFX;
            bodyArray[n2].calculateAABB(0);
            ++n2;
        }
    }

    public long getBodyTotalEnergyFX(Body body) {
        long l = body.velocityFX().lengthSquareFX() / 2;
        long l2 = (long)(-((int)((long)body.positionFX().yFX * (long)this.r.yFX) >> 12)) + (long)(-((int)((long)body.positionFX().xFX * (long)this.r.xFX) >> 12));
        return l + l2;
    }
}

