/*
 * Decompiled with CFR 0.152.
 */
package com.vipaol;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.EditorUI;
import mobileapplication3.editor.MGStructs;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.game.DebugMenu;
import mobileapplication3.game.MenuCanvas;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Logger;
import mobileapplication3.platform.MobappDesktopMain;
import mobileapplication3.platform.PlatformSettings;
import mobileapplication3.platform.ui.RootContainer;
import mobileapplication3.ui.IUIComponent;

public class MobappGameDesktopMain
extends MobappDesktopMain {
    private IUIComponent root = new MenuCanvas();

    public static void main(String[] args) {
        new MobappGameDesktopMain(args);
    }

    private void parseArgs(String[] args) {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder debug = parser.acceptsAll(Arrays.asList("debug", "d"), "Enable debug mode");
        OptionSpecBuilder verbose = parser.acceptsAll(Arrays.asList("verbose", "v"), "Print logs to stdout");
        ArgumentAcceptingOptionSpec<String> workdirOpt = parser.accepts("workdir", "Directory for game settings, records and custom content").withRequiredArg().describedAs("directory").defaultsTo(FileUtils.getStoragePath(), (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> fontSize = parser.accepts("font-size", "Override the default font size").withRequiredArg().ofType(Integer.class).defaultsTo(PlatformSettings.getFontSize(), (Integer[])new Integer[0]);
        OptionSpecBuilder fullscreenMode = parser.accepts("fullscreen", "Enable fullscreen mode");
        OptionSpecBuilder disableFullscreenMode = parser.accepts("no-fullscreen", "Disable fullscreen mode");
        parser.acceptsAll(Arrays.asList("help", "h", "?"), "Show help").forHelp();
        parser.nonOptions("Path to level or structure to open in view mode").ofType(File.class).describedAs("*.mgstruct or *.mglvl");
        try {
            List<?> nonOptions;
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn(System.out);
                System.exit(0);
            }
            DebugMenu.isDebugEnabled = options.has(debug);
            Logger.logToStdout(options.has(verbose) || DebugMenu.isDebugEnabled);
            FileUtils.setStoragePath(options.valueOf(workdirOpt));
            if (options.has(fullscreenMode)) {
                PlatformSettings.setFullscreenModeOverride(true);
            } else if (options.has(disableFullscreenMode)) {
                PlatformSettings.setFullscreenModeOverride(false);
            }
            if (options.has(fontSize)) {
                PlatformSettings.setFontSizeOverride(options.valueOf(fontSize));
            }
            if ((nonOptions = options.nonOptionArguments()) != null && !nonOptions.isEmpty()) {
                if (nonOptions.size() > 1) {
                    throw new IllegalArgumentException("Too many arguments");
                }
                this.root = MobappGameDesktopMain.openFile((File)nonOptions.get(0));
            }
        }
        catch (Exception e) {
            Logger.log(e);
            System.err.println("Error: " + e.getMessage());
            System.out.println();
            try {
                parser.printHelpOn(System.out);
            }
            catch (IOException ex) {
                System.err.println("Use --help for usage information.");
            }
            System.exit(1);
        }
    }

    private static IUIComponent openFile(File file) {
        String name;
        Element[] elements = MGStructs.readMGStruct(file.getPath());
        if (elements == null) {
            elements = new Element[]{};
        }
        int mode = (name = file.getName()).endsWith(".mgstruct") ? 1 : 2;
        String newPath = (mode == 1 ? EditorSettings.getStructsFolderPath() : EditorSettings.getLevelsFolderPath()) + '/' + name;
        return new EditorUI(mode, elements, newPath).setViewMode(true);
    }

    public MobappGameDesktopMain(String[] args) {
        super(args);
        this.parseArgs(args);
        RootContainer.setRootUIComponent(this.root);
    }
}

