/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import java.io.IOException;
import mobileapplication3.editor.EditorSettings;
import mobileapplication3.editor.MGStructs;
import mobileapplication3.editor.StructureViewerComponent;
import mobileapplication3.platform.FileUtils;
import mobileapplication3.platform.Mathh;
import mobileapplication3.platform.Utils;
import mobileapplication3.platform.ui.Font;
import mobileapplication3.ui.AbstractPopupWindow;
import mobileapplication3.ui.BackButton;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonCol;
import mobileapplication3.ui.ButtonComponent;
import mobileapplication3.ui.ButtonRow;
import mobileapplication3.ui.ButtonStub;
import mobileapplication3.ui.Container;
import mobileapplication3.ui.Grid;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.Switch;
import mobileapplication3.ui.TextComponent;

public abstract class AbstractEditorMenu
extends AbstractPopupWindow {
    private static final int LAYOUT_MINIMIZED = 1;
    private static final int LAYOUT_LIST_OF_NAMES = 2;
    private static final int LAYOUT_GRID = 3;
    private final TextComponent title;
    private final ButtonCol buttons;
    private Grid grid = null;
    private ButtonRow backButtonComponent;
    private String[] files = null;
    private final IPopupFeedback parent;
    private int layout = 1;

    public AbstractEditorMenu(IPopupFeedback parent, String titleStr) {
        super(parent);
        this.parent = parent;
        this.title = new TextComponent(titleStr);
        this.buttons = new ButtonCol();
        switch (EditorSettings.getWhatToLoadAutomatically()) {
            case 0: {
                this.setLayout(1);
                break;
            }
            case 1: {
                this.setLayout(2);
                break;
            }
            case 2: {
                this.setLayout(3);
            }
        }
    }

    public void setLayout(int layout) {
        this.layout = layout;
        Button createButton = new Button("Create new"){

            @Override
            public void buttonPressed() {
                AbstractEditorMenu.this.createNew();
            }
        }.setBindedKeyCode(49);
        Button alwaysShowListSwitch = new Switch("Always show list"){

            @Override
            public void setValue(boolean value) {
                EditorSettings.setWhatToLoadAutomatically(value ? 1 : 0);
            }

            @Override
            public boolean getValue() {
                return EditorSettings.getWhatToLoadAutomatically() >= 1;
            }
        }.setBindedKeyCode(50);
        Switch alwaysShowGridSwitch = new Switch("Always show thumbnails"){

            @Override
            public void setValue(boolean value) {
                EditorSettings.setWhatToLoadAutomatically(value ? 2 : 1);
            }

            @Override
            public boolean getValue() {
                return EditorSettings.getWhatToLoadAutomatically() >= 2;
            }
        };
        Button showGridButton = new Button("Show thumbnails"){

            @Override
            public void buttonPressed() {
                AbstractEditorMenu.this.setLayout(3);
            }
        }.setBindedKeyCode(51);
        BackButton backButton = new BackButton(this.parent);
        this.backButtonComponent = new ButtonRow(new Button[]{backButton}).bindToSoftButtons();
        switch (layout) {
            case 1: {
                this.buttons.setButtons(new Button[]{createButton, new Button("Open"){

                    @Override
                    public void buttonPressed() {
                        AbstractEditorMenu.this.setLayout(2);
                    }
                }.setBindedKeyCode(50), new ButtonStub(), new BackButton(this.parent).setBindedKeyCodes(new int[]{-6, -7, 48})});
                this.setComponents(new IUIComponent[]{this.title, this.buttons});
                break;
            }
            case 2: {
                Button[] fileButtons = this.getList();
                int topExtraButtons = 3;
                int bottomExtraButtons = 0;
                Button[] btns = new Button[topExtraButtons + fileButtons.length + bottomExtraButtons];
                btns[0] = createButton;
                btns[1] = alwaysShowListSwitch;
                btns[2] = showGridButton;
                System.arraycopy(fileButtons, 0, btns, topExtraButtons, fileButtons.length);
                this.buttons.setButtons(btns);
                this.setComponents(new IUIComponent[]{this.title, this.buttons, this.backButtonComponent});
                break;
            }
            case 3: {
                IUIComponent[] thumbnails = this.getGridContent();
                int topExtraCells = 2;
                IUIComponent[] cells = new IUIComponent[topExtraCells + thumbnails.length];
                cells[0] = new ButtonComponent(createButton);
                cells[1] = new ButtonComponent(alwaysShowGridSwitch);
                for (int i = 0; i < thumbnails.length; ++i) {
                    cells[topExtraCells + i] = thumbnails[i];
                }
                this.grid = new Grid(cells);
                this.setComponents(new IUIComponent[]{this.title, this.grid, this.backButtonComponent});
            }
        }
    }

    @Override
    protected void onSetBounds(int x0, int y0, int w, int h) {
        this.title.setSize(w, -1).setPos(x0, y0, 20);
        switch (this.layout) {
            case 1: {
                this.buttons.setButtonsBgPadding(w / 128).setSize(w / 2, y0 + h - this.title.getBottomY()).setPos(x0 + w / 2, y0 + h, 33);
                break;
            }
            case 2: {
                this.backButtonComponent.setSize(w, -1).setPos(x0 + w / 2, y0 + h, 33);
                this.buttons.setButtonsBgPadding(w / 128).setSize(w, this.backButtonComponent.getTopY() - this.title.getBottomY()).setPos(x0 + w / 2, this.backButtonComponent.getTopY(), 33);
                break;
            }
            case 3: {
                this.backButtonComponent.setSize(w, -1).setPos(x0 + w / 2, y0 + h, 33);
                this.grid.setCols(Mathh.constrain(1, w / Font.getDefaultFontHeight() / 5, 3)).setElementsPadding(w / 128).setSize(w, this.backButtonComponent.getTopY() - this.title.getBottomY()).setPos(x0 + w / 2, this.backButtonComponent.getTopY(), 33);
            }
        }
    }

    protected String[] listFiles(String path) throws IOException {
        if (this.files == null) {
            this.files = FileUtils.list(path);
        }
        return this.files;
    }

    protected abstract Button[] getList();

    protected abstract IUIComponent[] getGridContent();

    protected abstract void createNew();

    protected abstract class EditorFileListCell
    extends Container {
        protected String path;
        private StructureViewerComponent structureViewer;
        private TextComponent fileNameLabel;

        public EditorFileListCell(String path) {
            this.path = path;
            this.structureViewer = new StructureViewerComponent(MGStructs.readMGStruct(path));
            String[] tmp = Utils.split(path, String.valueOf('/'));
            this.fileNameLabel = new TextComponent(tmp[tmp.length - 1]);
            this.setComponents(new IUIComponent[]{this.structureViewer, this.fileNameLabel});
        }

        @Override
        protected void onSetBounds(int x0, int y0, int w, int h) {
            this.fileNameLabel.setSize(w, -1).setPos(x0, y0 + h, 36);
            this.structureViewer.setSize(w, this.fileNameLabel.getTopY() - y0).setPos(x0, y0, 20);
        }

        @Override
        public boolean canBeFocused() {
            return true;
        }

        @Override
        public boolean pointerClicked(int x, int y) {
            this.openInEditor();
            return true;
        }

        @Override
        public boolean keyPressed(int keyCode, int count) {
            this.openInEditor();
            return true;
        }

        protected abstract void openInEditor();
    }
}

