/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.StructureBuilder;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.ui.AbstractPopupPage;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.ButtonComponent;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;
import mobileapplication3.ui.List;
import mobileapplication3.ui.Property;
import mobileapplication3.ui.Slider;

public class AdvancedElementEditUI
extends AbstractPopupPage {
    private final Element element;
    private List list;
    private final StructureBuilder sb;

    public AdvancedElementEditUI(Element element, StructureBuilder sb, IPopupFeedback parent) {
        super("Advanced edit: " + element.getName(), parent);
        this.element = element;
        this.sb = sb;
    }

    @Override
    protected Button[] getActionButtons() {
        final short[] argsUnmodified = this.element.getArgsValues();
        return new Button[]{new Button("OK"){

            @Override
            public void buttonPressed() {
                AdvancedElementEditUI.this.element.recalcCalculatedArgs();
                if (AdvancedElementEditUI.this.element.getID() != 1) {
                    AdvancedElementEditUI.this.sb.recalculateEndPoint();
                }
                AdvancedElementEditUI.this.sb.onUpdate();
                AdvancedElementEditUI.this.close();
            }
        }, new Button("Cancel"){

            @Override
            public void buttonPressed() {
                AdvancedElementEditUI.this.element.setArgs(argsUnmodified);
                AdvancedElementEditUI.this.close();
            }
        }.setBindedKeyCode(48)};
    }

    @Override
    protected IUIComponent initAndGetPageContent() {
        this.list = new List(){

            @Override
            public final void onSetBounds(int x0, int y0, int w, int h) {
                this.setElementsPadding(this.getElemH() / 16);
                super.onSetBounds(x0, y0, w, h);
            }
        };
        this.refreshList();
        return this.list;
    }

    private void refreshList() {
        Property[] args = this.element.getArgs();
        IUIComponent[] rows = new IUIComponent[args.length + 1];
        for (int i = 0; i < args.length; ++i) {
            rows[i] = new Slider(args[i]);
        }
        rows[args.length] = new ButtonComponent(new Button("Refresh this list"){

            @Override
            public void buttonPressed() {
                AdvancedElementEditUI.this.element.recalcCalculatedArgs();
                AdvancedElementEditUI.this.refreshList();
            }
        });
        this.list.setElements(rows);
    }
}

