/*
 * Decompiled with CFR 0.152.
 */
package mobileapplication3.editor;

import mobileapplication3.editor.MGStructs;
import mobileapplication3.editor.StructureBuilder;
import mobileapplication3.editor.StructureViewerComponent;
import mobileapplication3.editor.elements.Element;
import mobileapplication3.platform.Platform;
import mobileapplication3.ui.AbstractPopupPage;
import mobileapplication3.ui.Button;
import mobileapplication3.ui.IPopupFeedback;
import mobileapplication3.ui.IUIComponent;

public abstract class AutoSaveUI
extends AbstractPopupPage {
    private static final String STORE_NAME_STRUCTURE_AUTOSAVE = "StructureAutoSave";
    private static final String STORE_NAME_LEVEL_AUTOSAVE = "LevelAutoSave";
    private static final String STORE_NAME_SUFFIX_FILE_PATH = "FilePath";
    public static final int STRUCTURE = 1;
    public static final int LEVEL = 2;
    private final Element[] elements;

    public AutoSaveUI(IPopupFeedback parent, Element[] elements) {
        super("Some unsaved data can be recovered", parent);
        this.elements = elements;
    }

    @Override
    public void init() {
        super.init();
        this.actionButtons.setIsSelectionEnabled(true);
        this.actionButtons.setIsSelectionVisible(false);
    }

    @Override
    protected Button[] getActionButtons() {
        return new Button[]{new Button("Restore"){

            @Override
            public void buttonPressed() {
                AutoSaveUI.this.onRestore();
            }
        }, new Button("Delete"){

            @Override
            public void buttonPressed() {
                AutoSaveUI.this.onDelete();
            }
        }.setBgColor(0x550000)};
    }

    @Override
    protected IUIComponent initAndGetPageContent() {
        return new StructureViewerComponent(this.elements);
    }

    public abstract void onRestore();

    public abstract void onDelete();

    public static void autoSaveWrite(StructureBuilder data, String filePath, int storeID) throws Exception {
        switch (storeID) {
            case 1: {
                String storeName = STORE_NAME_STRUCTURE_AUTOSAVE;
                Platform.storeShorts(data.asShortArray(), storeName);
                Platform.storeString(filePath, storeName + STORE_NAME_SUFFIX_FILE_PATH);
                break;
            }
            case 2: {
                String storeName = STORE_NAME_LEVEL_AUTOSAVE;
                Platform.storeShorts(data.asShortArray(), storeName);
                Platform.storeString(filePath, storeName + STORE_NAME_SUFFIX_FILE_PATH);
            }
        }
    }

    public static AutoSaveData autoSaveRead(int autoSaveID) {
        String storeName = null;
        String path = null;
        switch (autoSaveID) {
            case 1: {
                storeName = STORE_NAME_STRUCTURE_AUTOSAVE;
                path = Platform.readStoreAsString(storeName + STORE_NAME_SUFFIX_FILE_PATH);
                break;
            }
            case 2: {
                storeName = STORE_NAME_LEVEL_AUTOSAVE;
                path = Platform.readStoreAsString(storeName + STORE_NAME_SUFFIX_FILE_PATH);
            }
        }
        Element[] elements = MGStructs.readMGStruct(Platform.readStore(storeName));
        if (elements != null) {
            return new AutoSaveData(elements, path);
        }
        return null;
    }

    public static void deleteAutoSave(int autoSaveID) {
        switch (autoSaveID) {
            case 1: {
                Platform.clearStore(STORE_NAME_STRUCTURE_AUTOSAVE);
                break;
            }
            case 2: {
                Platform.clearStore(STORE_NAME_LEVEL_AUTOSAVE);
            }
        }
    }

    public static class AutoSaveData {
        private final Element[] elements;
        private final String filePath;

        public AutoSaveData(Element[] data, String filePath) {
            this.elements = data;
            if ("".equals(filePath)) {
                filePath = null;
            }
            this.filePath = filePath;
        }

        public Element[] getElements() {
            return this.elements;
        }

        public String getPath() {
            return this.filePath;
        }
    }
}

